/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.xcs;

import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.character.CharacterAILevel;
import com.daxie.xops.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.character.CharacterData;
import com.daxie.xops.character.CharacterModelType;
import com.daxie.xops.character.CharacterTextureType;
import com.daxie.xops.character.CharacterType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

class XCSParser {
    private CharacterData[] character_data_array;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XCSParser(String xcs_filename) throws FileNotFoundException {
        ArrayList<Byte> bin;
        block18: {
            String str;
            this.character_data_array = null;
            bin = new ArrayList<Byte>();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(xcs_filename)));
            this.character_data_array = new CharacterData[43];
            for (int i = 0; i < 43; ++i) {
                this.character_data_array[i] = new CharacterData();
            }
            try {
                while (true) {
                    byte read_byte = dis.readByte();
                    bin.add(read_byte);
                }
            }
            catch (EOFException read_byte) {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e) {
                    str = ExceptionFunctions.GetPrintStackTraceString(e);
                    LogFile.WriteFatal("[XCSParser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
            }
            catch (IOException e) {
                try {
                    str = ExceptionFunctions.GetPrintStackTraceString(e);
                    LogFile.WriteFatal("[XCSParser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (dis != null) {
                            dis.close();
                        }
                    }
                    catch (IOException e2) {
                        str = ExceptionFunctions.GetPrintStackTraceString(e2);
                        LogFile.WriteFatal("[XCSParser-<init>] Below is the stack trace.");
                        LogFile.WriteLine(str);
                        LogFile.CloseLogFile();
                        System.exit(1);
                    }
                }
            }
            if (bin.size() == 614) break block18;
            LogFile.WriteWarn("[XCSParser-<init>] Invalid file size. filename:" + xcs_filename);
            return;
        }
        byte[] b = new byte[2];
        int count = 12;
        for (int i = 0; i < 43; ++i) {
            b[0] = (Byte)bin.get(count);
            b[1] = (Byte)bin.get(count + 1);
            int itemp = ByteFunctions.byte_to_short_le(b);
            CharacterTextureType texture_type = CharacterBinSpecifierAndEnumConverter.GetCharacterTextureTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetTextureType(texture_type);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            CharacterModelType model_type = CharacterBinSpecifierAndEnumConverter.GetCharacterModelTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetModelType(model_type);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_ushort_le(b);
            this.character_data_array[i].SetHP(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            CharacterAILevel ai_level = CharacterBinSpecifierAndEnumConverter.GetCharacterAILevelFromBinSpecifier(itemp);
            this.character_data_array[i].SetAILevel(ai_level);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.character_data_array[i].SetWeaponID(0, itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.character_data_array[i].SetWeaponID(1, itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            count += 2;
            CharacterType type = CharacterBinSpecifierAndEnumConverter.GetCharacterTypeFromBinSpecifier(itemp);
            this.character_data_array[i].SetType(type);
        }
    }

    public CharacterData[] GetCharacterDataArray() {
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < this.character_data_array.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }
}

