/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.bd1;

import com.daxie.basis.matrix.Matrix;
import com.daxie.basis.matrix.MatrixFunctions;
import com.daxie.basis.vector.Vector;
import com.daxie.basis.vector.VectorFunctions;
import com.daxie.log.LogFile;
import com.daxie.xops.bd1.BD1Block;
import com.daxie.xops.bd1.BD1Manipulator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BD1Creator {
    private int block_count = 0;
    private Map<Integer, String> texture_filenames_map = new HashMap<Integer, String>();
    private Map<Integer, BD1Block> blocks_map = new HashMap<Integer, BD1Block>();

    public BD1Creator() {
        for (int i = 0; i < 10; ++i) {
            this.texture_filenames_map.put(i, "");
        }
    }

    public int SetTextureFilename(int texture_id, String texture_filename) {
        if (0 > texture_id || texture_id >= 10) {
            LogFile.WriteError("[BD1Creator-SetTextureFilename] Texture ID out of bounds. texture_id:" + texture_id);
            return -1;
        }
        this.texture_filenames_map.put(texture_id, texture_filename);
        return 0;
    }

    public Set<Integer> GetBlockHandles() {
        return new HashSet<Integer>(this.blocks_map.keySet());
    }

    public int AddBlock(BD1Block block) {
        if (block == null) {
            LogFile.WriteError("[BD1Creator-AddBlock] Null argument where non-null required.");
            return -1;
        }
        int block_handle = this.block_count++;
        this.blocks_map.put(block_handle, block);
        return block_handle;
    }

    public int DuplicateBlock(int block_handle) {
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-DuplicateBlock] No such block. handle:" + block_handle);
            return -1;
        }
        BD1Block orig_block = this.blocks_map.get(block_handle);
        BD1Block duplicated_block = new BD1Block(orig_block);
        int duplicated_block_handle = this.block_count++;
        this.blocks_map.put(duplicated_block_handle, duplicated_block);
        return duplicated_block_handle;
    }

    public int CreateCube(Vector center, float edge_length) {
        int i;
        BD1Block block = new BD1Block();
        float edge_half_length = edge_length / 2.0f;
        Vector[] vertex_positions = new Vector[8];
        float x = center.GetX();
        float y = center.GetY();
        float z = center.GetZ();
        vertex_positions[0] = VectorFunctions.VGet(x - edge_half_length, y + edge_half_length, z + edge_half_length);
        vertex_positions[1] = VectorFunctions.VGet(x - edge_half_length, y + edge_half_length, z - edge_half_length);
        vertex_positions[2] = VectorFunctions.VGet(x + edge_half_length, y + edge_half_length, z - edge_half_length);
        vertex_positions[3] = VectorFunctions.VGet(x + edge_half_length, y + edge_half_length, z + edge_half_length);
        vertex_positions[4] = VectorFunctions.VGet(x - edge_half_length, y - edge_half_length, z + edge_half_length);
        vertex_positions[5] = VectorFunctions.VGet(x - edge_half_length, y - edge_half_length, z - edge_half_length);
        vertex_positions[6] = VectorFunctions.VGet(x + edge_half_length, y - edge_half_length, z - edge_half_length);
        vertex_positions[7] = VectorFunctions.VGet(x + edge_half_length, y - edge_half_length, z + edge_half_length);
        for (i = 0; i < 8; ++i) {
            block.SetVertexPosition(i, vertex_positions[i]);
        }
        for (i = 0; i < 24; ++i) {
            if (i % 4 == 0) {
                block.SetUVs(i, 0.0f, 0.0f);
                continue;
            }
            if (i % 4 == 1) {
                block.SetUVs(i, 1.0f, 0.0f);
                continue;
            }
            if (i % 4 == 2) {
                block.SetUVs(i, 1.0f, 1.0f);
                continue;
            }
            block.SetUVs(i, 0.0f, 1.0f);
        }
        for (i = 0; i < 6; ++i) {
            block.SetTextureID(i, 0);
        }
        int block_handle = this.block_count++;
        this.blocks_map.put(block_handle, block);
        return block_handle;
    }

    public int CreateBlock(Vector[] vertex_positions) {
        int i;
        if (vertex_positions == null) {
            LogFile.WriteError("[BD1Creator-CreateBlock] Null argument where non-null required.");
            return -1;
        }
        if (vertex_positions.length != 8) {
            String str = "[BD1Creator-CreateBlock] Invalid number of vertices in the argument array. vertex_num:" + vertex_positions.length;
            LogFile.WriteError(str);
            return -1;
        }
        BD1Block block = new BD1Block();
        for (i = 0; i < 8; ++i) {
            block.SetVertexPosition(i, vertex_positions[i]);
        }
        for (i = 0; i < 24; ++i) {
            if (i % 4 == 0) {
                block.SetUVs(i, 0.0f, 0.0f);
                continue;
            }
            if (i % 4 == 1) {
                block.SetUVs(i, 1.0f, 0.0f);
                continue;
            }
            if (i % 4 == 2) {
                block.SetUVs(i, 1.0f, 1.0f);
                continue;
            }
            block.SetUVs(i, 0.0f, 1.0f);
        }
        for (i = 0; i < 6; ++i) {
            block.SetTextureID(i, 0);
        }
        int block_handle = this.block_count++;
        this.blocks_map.put(block_handle, block);
        return block_handle;
    }

    public int TranslateBlock(int block_handle, Vector translate) {
        int i;
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-TranslateBlock] No such block. handle:" + block_handle);
            return -1;
        }
        BD1Block block = this.blocks_map.get(block_handle);
        Vector[] vertex_positions = block.GetVertexPositions();
        for (i = 0; i < 8; ++i) {
            vertex_positions[i] = VectorFunctions.VAdd(vertex_positions[i], translate);
        }
        for (i = 0; i < 8; ++i) {
            block.SetVertexPosition(i, vertex_positions[i]);
        }
        return 0;
    }

    public int RotateBlock(int block_handle, Vector rotate) {
        int i;
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-RotateBlock] No such block. handle:" + block_handle);
            return -1;
        }
        Matrix rot_x = MatrixFunctions.MGetRotX(rotate.GetX());
        Matrix rot_y = MatrixFunctions.MGetRotY(rotate.GetY());
        Matrix rot_z = MatrixFunctions.MGetRotZ(rotate.GetZ());
        BD1Block block = this.blocks_map.get(block_handle);
        Vector[] vertex_positions = block.GetVertexPositions();
        Vector center = VectorFunctions.VGet(0.0f, 0.0f, 0.0f);
        for (int i2 = 0; i2 < 8; ++i2) {
            center = VectorFunctions.VAdd(center, vertex_positions[i2]);
        }
        center = VectorFunctions.VScale(center, 0.125f);
        Vector to_orig_vec = VectorFunctions.VScale(center, -1.0f);
        for (i = 0; i < 8; ++i) {
            vertex_positions[i] = VectorFunctions.VAdd(vertex_positions[i], to_orig_vec);
        }
        for (i = 0; i < 8; ++i) {
            vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], rot_x);
            vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], rot_y);
            vertex_positions[i] = VectorFunctions.VTransform(vertex_positions[i], rot_z);
        }
        for (i = 0; i < 8; ++i) {
            vertex_positions[i] = VectorFunctions.VAdd(vertex_positions[i], center);
        }
        for (i = 0; i < 8; ++i) {
            block.SetVertexPosition(i, vertex_positions[i]);
        }
        return 0;
    }

    public int RescaleBlock(int block_handle, Vector scale) {
        int i;
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-RescaleBlock] No such block. handle:" + block_handle);
            return -1;
        }
        float scale_x = scale.GetX();
        float scale_y = scale.GetY();
        float scale_z = scale.GetZ();
        BD1Block block = this.blocks_map.get(block_handle);
        Vector[] vertex_positions = block.GetVertexPositions();
        for (i = 0; i < 8; ++i) {
            float pos_x = vertex_positions[i].GetX();
            float pos_y = vertex_positions[i].GetY();
            float pos_z = vertex_positions[i].GetZ();
            vertex_positions[i].SetVector(pos_x *= scale_x, pos_y *= scale_y, pos_z *= scale_z);
        }
        for (i = 0; i < 8; ++i) {
            block.SetVertexPosition(i, vertex_positions[i]);
        }
        return 0;
    }

    public int SetBlockUVs(int block_handle, int face_index, float u, float v) {
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-SetBlockUVs] No such block. handle:" + block_handle);
            return -1;
        }
        if (0 >= face_index || face_index >= 6) {
            LogFile.WriteError("[BD1Creator-SetBlockUVs] Face index out of bounds. face_index:" + face_index);
            return -1;
        }
        BD1Block block = this.blocks_map.get(block_handle);
        block.SetUVs(face_index, u, v);
        return 0;
    }

    public int SetBlockTextureID(int block_handle, int face_index, int texture_id) {
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-SetBlockTextureID] No such block. handle:" + block_handle);
            return -1;
        }
        if (0 > face_index || face_index >= 6) {
            LogFile.WriteError("[BD1Creator-SetBlockTextureID] Face index out of bounds. face_index:" + face_index);
            return -1;
        }
        BD1Block block = this.blocks_map.get(block_handle);
        block.SetTextureID(face_index, texture_id);
        return 0;
    }

    public int RemoveBlock(int block_handle) {
        if (!this.blocks_map.containsKey(block_handle)) {
            LogFile.WriteError("[BD1Creator-SetBlockTextureID] No such block. handle:" + block_handle);
            return -1;
        }
        this.blocks_map.remove(block_handle);
        return 0;
    }

    public int WriteAsBD1(String bd1_filename, float offset_y) {
        BD1Manipulator bd1_manipulator = new BD1Manipulator();
        ArrayList<BD1Block> blocks = new ArrayList<BD1Block>();
        for (BD1Block block : this.blocks_map.values()) {
            blocks.add(block);
        }
        bd1_manipulator.SetTextureFilenamesMap(this.texture_filenames_map);
        bd1_manipulator.SetBlocks(blocks);
        bd1_manipulator.Translate(VectorFunctions.VGet(0.0f, offset_y, 0.0f));
        int ret = bd1_manipulator.WriteAsBD1(bd1_filename);
        return ret;
    }
}

