/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.tool;

import com.daxie.tool.FileFunctions;
import java.io.FileNotFoundException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class HashFunctions {
    public static String GetHash(String value, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(value.getBytes());
        byte[] cipher_bytes = md.digest();
        StringBuilder sb = new StringBuilder(2 * cipher_bytes.length);
        for (byte b : cipher_bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static String GetHash(List<Byte> value, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        byte[] bytes = new byte[value.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = value.get(i);
        }
        md.update(bytes);
        byte[] cipher_bytes = md.digest();
        StringBuilder sb = new StringBuilder(2 * cipher_bytes.length);
        for (byte b : cipher_bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public static String GetFileHash(String filename, String algorithm) throws FileNotFoundException, NoSuchAlgorithmException {
        List<Byte> bin = FileFunctions.GetFileAllBin(filename);
        String hash = HashFunctions.GetHash(bin, algorithm);
        return hash;
    }
}

