/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.pd1;

import com.daxie.basis.matrix.Matrix;
import com.daxie.basis.matrix.MatrixFunctions;
import com.daxie.basis.vector.Vector;
import com.daxie.basis.vector.VectorFunctions;
import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.pd1.PD1Parser;
import com.daxie.xops.pd1.PD1Point;
import com.daxie.xops.pd1.PD1Writer;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;

public class PD1Manipulator {
    private List<PD1Point> points;

    public PD1Manipulator(String pd1_filename) throws FileNotFoundException {
        PD1Parser pd1_parser = new PD1Parser(pd1_filename);
        this.points = pd1_parser.GetPoints();
    }

    public PD1Manipulator() {
        this.points = new ArrayList<PD1Point>();
    }

    public List<PD1Point> GetPoints() {
        return new ArrayList<PD1Point>(this.points);
    }

    public void SetPoints(List<PD1Point> points) {
        if (points == null) {
            LogFile.WriteError("[PD1Manipulator-SetPoints] Null argument where non-null required.");
            return;
        }
        this.points = points;
    }

    public int GetPointNum() {
        return this.points.size();
    }

    public int GetPointNum(int param_1) {
        int point_num = 0;
        for (PD1Point point : this.points) {
            int p = point.GetParameter(0);
            if (p != param_1) continue;
            ++point_num;
        }
        return point_num;
    }

    public void Translate(Vector translate) {
        for (PD1Point point : this.points) {
            Vector position = point.GetPosition();
            position = VectorFunctions.VAdd(position, translate);
            point.SetPosition(position);
        }
    }

    public void Rotate(Vector rotate) {
        Matrix rot_x = MatrixFunctions.MGetRotX(rotate.GetX());
        Matrix rot_y = MatrixFunctions.MGetRotY(rotate.GetY());
        Matrix rot_z = MatrixFunctions.MGetRotZ(rotate.GetZ());
        for (PD1Point point : this.points) {
            Vector position = point.GetPosition();
            position = VectorFunctions.VTransform(position, rot_x);
            position = VectorFunctions.VTransform(position, rot_y);
            position = VectorFunctions.VTransform(position, rot_z);
            point.SetPosition(position);
        }
    }

    public void Rescale(Vector scale) {
        for (PD1Point point : this.points) {
            Vector position = point.GetPosition();
            float x = position.GetX();
            float y = position.GetY();
            float z = position.GetZ();
            position.SetX(x * scale.GetX());
            position.SetY(y * scale.GetY());
            position.SetZ(z * scale.GetZ());
            point.SetPosition(position);
        }
    }

    public void SetMatrix(Matrix m) {
        for (PD1Point point : this.points) {
            Vector position = point.GetPosition();
            position = VectorFunctions.VTransform(position, m);
            point.SetPosition(position);
        }
    }

    public void RotateDirection(float rotate) {
        for (PD1Point point : this.points) {
            float rotation = point.GetRotation();
            point.SetRotation(rotation += rotate);
        }
    }

    public void InvertZ() {
        for (PD1Point point : this.points) {
            Vector position = point.GetPosition();
            position.SetZ(position.GetZ() * -1.0f);
            point.SetPosition(position);
            float rotation = point.GetRotation();
            rotation *= -1.0f;
            point.SetRotation(rotation += (float)Math.PI);
        }
    }

    public int Write(String pd1_filename) {
        PD1Writer pd1_writer = new PD1Writer(this.points);
        try {
            pd1_writer.Write(pd1_filename);
        }
        catch (FileNotFoundException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteError("[PD1Manipulator-Write] Failed to write data.");
            LogFile.WriteLine("Below is the stack trace.");
            LogFile.WriteLine(str);
            return -1;
        }
        return 0;
    }
}

