/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.mif;

import com.daxie.log.LogFile;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.mif.MissionInfo;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;

class MIFParser {
    private MissionInfo mission_info = new MissionInfo();

    public MIFParser(String mif_filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException, NumberFormatException {
        String[] lines = FileFunctions.GetFileAllLines(mif_filename, encoding);
        if (lines.length < 10) {
            LogFile.WriteError("[MIFParser-<init>] Too few lines in the MIF file.");
            return;
        }
        this.mission_info.SetMissionName(lines[0]);
        this.mission_info.SetMissionFormalName(lines[1]);
        this.mission_info.SetBD1Filename(lines[2]);
        this.mission_info.SetPD1Filename(lines[3]);
        this.mission_info.SetSkyType(Integer.parseInt(lines[4]));
        int flags = Integer.parseInt(lines[5]);
        if ((flags & 2) != 0) {
            this.mission_info.SetDarkenScreenFlag(true);
        } else {
            this.mission_info.SetDarkenScreenFlag(false);
        }
        if ((flags & 1) != 0) {
            this.mission_info.SetExtraHitcheckFlag(true);
        } else {
            this.mission_info.SetExtraHitcheckFlag(false);
        }
        this.mission_info.SetArticleInfoFilename(lines[6]);
        this.mission_info.SetImage1Filename(lines[7]);
        this.mission_info.SetImage2Filename(lines[8]);
        for (int i = 9; i < lines.length; ++i) {
            this.mission_info.AddBriefingTextLine(lines[i]);
        }
    }

    public MissionInfo GetMissionInfo() {
        return new MissionInfo(this.mission_info);
    }
}

