/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.character;

import com.daxie.log.LogFile;
import com.daxie.xops.character.CharacterAILevel;
import com.daxie.xops.character.CharacterModelType;
import com.daxie.xops.character.CharacterTextureType;
import com.daxie.xops.character.CharacterType;

public class CharacterBinSpecifierAndEnumConverter {
    public static CharacterTextureType GetCharacterTextureTypeFromBinSpecifier(int spc) {
        CharacterTextureType texture_type;
        switch (spc) {
            case 0: {
                texture_type = CharacterTextureType.SOLDIER_BLACK;
                break;
            }
            case 1: {
                texture_type = CharacterTextureType.SOLDIER_GREEN;
                break;
            }
            case 2: {
                texture_type = CharacterTextureType.SOLDIER_WHITE;
                break;
            }
            case 3: {
                texture_type = CharacterTextureType.HAGE;
                break;
            }
            case 4: {
                texture_type = CharacterTextureType.SOLDIER_VIOLET;
                break;
            }
            case 5: {
                texture_type = CharacterTextureType.SOLDIER_BLUE;
                break;
            }
            case 6: {
                texture_type = CharacterTextureType.ROBOT;
                break;
            }
            case 7: {
                texture_type = CharacterTextureType.GS;
                break;
            }
            case 8: {
                texture_type = CharacterTextureType.SOLDIER0;
                break;
            }
            case 9: {
                texture_type = CharacterTextureType.POLICE;
                break;
            }
            case 10: {
                texture_type = CharacterTextureType.RIIMAN;
                break;
            }
            case 11: {
                texture_type = CharacterTextureType.SYATU;
                break;
            }
            case 12: {
                texture_type = CharacterTextureType.ISLAM;
                break;
            }
            case 13: {
                texture_type = CharacterTextureType.WOMAN;
                break;
            }
            case 14: {
                texture_type = CharacterTextureType.CIV1;
                break;
            }
            case 15: {
                texture_type = CharacterTextureType.CIV2;
                break;
            }
            case 16: {
                texture_type = CharacterTextureType.CIV3;
                break;
            }
            case 17: {
                texture_type = CharacterTextureType.SOLDIER1;
                break;
            }
            case 18: {
                texture_type = CharacterTextureType.SOLDIER2;
                break;
            }
            case 19: {
                texture_type = CharacterTextureType.ZOMBIE1;
                break;
            }
            case 20: {
                texture_type = CharacterTextureType.ZOMBIE2;
                break;
            }
            case 21: {
                texture_type = CharacterTextureType.ZOMBIE3;
                break;
            }
            case 22: {
                texture_type = CharacterTextureType.ZOMBIE4;
                break;
            }
            case 23: {
                texture_type = CharacterTextureType.RIIMAN_G;
                break;
            }
            case 24: {
                texture_type = CharacterTextureType.RIIMAN_K;
                break;
            }
            case 25: {
                texture_type = CharacterTextureType.ISLAM2;
                break;
            }
            case 26: {
                texture_type = CharacterTextureType.RIIMAN_B;
                break;
            }
            case 27: {
                texture_type = CharacterTextureType.SYATU2;
                break;
            }
            case 28: {
                texture_type = CharacterTextureType.SOLDIER3;
                break;
            }
            case 29: {
                texture_type = CharacterTextureType.GATES;
                break;
            }
            default: {
                LogFile.WriteWarn("[CharacterBinSpecifierAndEnumConverter-GetCharacterTextureTypeFromBinSpecifier]");
                LogFile.WriteLine("Unknown texture type specifier. specifier:" + spc);
                texture_type = CharacterTextureType.SOLDIER_BLACK;
            }
        }
        return texture_type;
    }

    public static int GetBinSpecifierFromCharacterTextureType(CharacterTextureType texture_type) {
        int spc = texture_type.ordinal();
        return spc;
    }

    public static CharacterModelType GetCharacterModelTypeFromBinSpecifier(int spc) {
        CharacterModelType model_type;
        switch (spc) {
            case 0: {
                model_type = CharacterModelType.MALE;
                break;
            }
            case 31: {
                model_type = CharacterModelType.SUN_GLASSES;
                break;
            }
            case 33: {
                model_type = CharacterModelType.POLICEMAN;
                break;
            }
            case 35: {
                model_type = CharacterModelType.FEMALE;
                break;
            }
            case 36: {
                model_type = CharacterModelType.BACK_PACK;
                break;
            }
            case 38: {
                model_type = CharacterModelType.HELMET;
                break;
            }
            default: {
                LogFile.WriteWarn("[CharacterBinSpecifierAndEnumConverter-GetCharacterModelTypeFromBinSpecifier]");
                LogFile.WriteLine("Unknown model type specifier. specifier:" + spc);
                model_type = CharacterModelType.MALE;
            }
        }
        return model_type;
    }

    public static int GetBinSpecifierFromCharacterModelType(CharacterModelType model_type) {
        int spc = 0;
        switch (model_type) {
            case MALE: {
                spc = 0;
                break;
            }
            case SUN_GLASSES: {
                spc = 31;
                break;
            }
            case POLICEMAN: {
                spc = 33;
                break;
            }
            case FEMALE: {
                spc = 35;
                break;
            }
            case BACK_PACK: {
                spc = 36;
                break;
            }
            case HELMET: {
                spc = 38;
            }
        }
        return spc;
    }

    public static CharacterAILevel GetCharacterAILevelFromBinSpecifier(int spc) {
        CharacterAILevel ai_level;
        switch (spc) {
            case 0: {
                ai_level = CharacterAILevel.NONE;
                break;
            }
            case 1: {
                ai_level = CharacterAILevel.D;
                break;
            }
            case 2: {
                ai_level = CharacterAILevel.C;
                break;
            }
            case 3: {
                ai_level = CharacterAILevel.B;
                break;
            }
            case 4: {
                ai_level = CharacterAILevel.A;
                break;
            }
            case 5: {
                ai_level = CharacterAILevel.S;
                break;
            }
            case 6: {
                ai_level = CharacterAILevel.SS;
                break;
            }
            case 7: {
                ai_level = CharacterAILevel.NO_WEAPON;
                break;
            }
            default: {
                LogFile.WriteWarn("[CharacterBinSpecifierAndEnumConverter-GetCharacterAILevelFromBinSpecifier]");
                LogFile.WriteLine("Unknown AI level specifier. specifier:" + spc);
                ai_level = CharacterAILevel.D;
            }
        }
        return ai_level;
    }

    public static int GetBinSpecifierFromCharacterAILevel(CharacterAILevel ai_level) {
        int spc = ai_level.ordinal();
        return spc;
    }

    public static CharacterType GetCharacterTypeFromBinSpecifier(int spc) {
        CharacterType type;
        switch (spc) {
            case 0: {
                type = CharacterType.HUMAN;
                break;
            }
            case 1: {
                type = CharacterType.CYBORG;
                break;
            }
            case 2: {
                type = CharacterType.ZOMBIE;
                break;
            }
            default: {
                LogFile.WriteWarn("[CharacterBinSpecifierAndEnumConverter-GetCharacterTypeFromBinSpecifier]");
                LogFile.WriteLine("Unknown type specifier. specifier:" + spc);
                type = CharacterType.HUMAN;
            }
        }
        return type;
    }

    public static int GetBinSpecifierFromCharacterType(CharacterType type) {
        int spc = type.ordinal();
        return spc;
    }
}

