/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.xcs;

import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.character.CharacterAILevel;
import com.daxie.xops.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.character.CharacterData;
import com.daxie.xops.character.CharacterModelType;
import com.daxie.xops.character.CharacterTextureType;
import com.daxie.xops.character.CharacterType;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

class XCSWriter {
    private CharacterData[] character_data_array = null;

    public XCSWriter(CharacterData[] character_data_array) {
        this.character_data_array = character_data_array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Write(String xcs_filename) throws FileNotFoundException {
        String str;
        if (this.character_data_array == null) {
            LogFile.WriteError("[XCSWriter-Write] Data is null.");
            return;
        }
        if (this.character_data_array.length != 43) {
            LogFile.WriteError("[XCSWriter-Write] Invalid number of data. data_num:" + this.character_data_array.length);
            return;
        }
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(xcs_filename)));
        try {
            dos.write(88);
            dos.write(67);
            dos.write(83);
            dos.write(0);
            dos.write(1);
            dos.write(0);
            dos.write(12);
            dos.write(0);
            dos.write(43);
            dos.write(0);
            dos.write(7);
            dos.write(0);
            for (int i = 0; i < 43; ++i) {
                CharacterTextureType texture_type = this.character_data_array[i].GetTextureType();
                int itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterTextureType(texture_type);
                byte[] b = ByteFunctions.short_to_byte_le((short)itemp);
                dos.write(b);
                CharacterModelType model_type = this.character_data_array[i].GetModelType();
                itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterModelType(model_type);
                b = ByteFunctions.short_to_byte_le((short)itemp);
                dos.write(b);
                itemp = this.character_data_array[i].GetHP();
                b = ByteFunctions.ushort_to_byte_le((short)itemp);
                dos.write(b);
                CharacterAILevel ai_level = this.character_data_array[i].GetAILevel();
                itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterAILevel(ai_level);
                b = ByteFunctions.short_to_byte_le((short)itemp);
                dos.write(b);
                itemp = this.character_data_array[i].GetWeaponID(0);
                b = ByteFunctions.short_to_byte_le((short)itemp);
                dos.write(b);
                itemp = this.character_data_array[i].GetWeaponID(1);
                b = ByteFunctions.short_to_byte_le((short)itemp);
                dos.write(b);
                CharacterType type = this.character_data_array[i].GetType();
                itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterType(type);
                b = ByteFunctions.short_to_byte_le((short)itemp);
                dos.write(b);
            }
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[XCSWriter-Write] Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException e) {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[XCSWriter-Write] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
    }
}

