/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.log;

import com.daxie.tool.DateFunctions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class LogFile {
    private static String directory = "./";
    private static String filename = "log.txt";
    public static final int LOG_LEVEL_FATAL = 1;
    public static final int LOG_LEVEL_ERROR = 2;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_INFO = 8;
    public static final int LOG_LEVEL_DEBUG = 16;
    public static final int LOG_LEVEL_TRACE = 32;
    public static final int LOG_LEVEL_NONE = 0;
    public static final int LOG_LEVEL_ALL = 63;
    private static int log_level_flags = 3;
    private static boolean output_log_flag = true;
    private static BufferedWriter bw = null;

    public static void SetLogDirectory(String a_directory) {
        directory = a_directory;
    }

    public static void SetLogFilename(String a_filename) {
        filename = a_filename;
    }

    public static void SetLogLevelFlags(int flags) {
        log_level_flags = flags;
    }

    public static void SetOutputLogFlag(boolean a_output_log_flag) {
        output_log_flag = a_output_log_flag;
    }

    public static void OpenLogFile() {
        File log_directory;
        if (bw != null) {
            LogFile.CloseLogFile();
        }
        if (!(log_directory = new File(directory)).exists()) {
            log_directory.mkdirs();
        }
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(directory + "/" + filename)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void CloseLogFile() {
        if (bw != null) {
            try {
                bw.flush();
                bw.close();
                bw = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void Flush() {
        if (bw != null) {
            try {
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void WriteString(String str) {
        if (!output_log_flag) {
            return;
        }
        if (bw != null) {
            try {
                bw.write(str);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.print(str);
        }
    }

    public static void WriteLine(String str) {
        if (!output_log_flag) {
            return;
        }
        if (bw != null) {
            try {
                bw.write(str);
                bw.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(str);
        }
    }

    public static void WriteTrace(String str) {
        int op = log_level_flags & 0x20;
        if (op == 0) {
            return;
        }
        String message = "";
        message = message + "TRACE ";
        message = message + DateFunctions.GetDateStringToMilliseconds();
        message = message + " ";
        message = message + str;
        LogFile.WriteLine(message);
    }

    public static void WriteDebug(String str) {
        int op = log_level_flags & 0x10;
        if (op == 0) {
            return;
        }
        String message = "";
        message = message + "DEBUG ";
        message = message + DateFunctions.GetDateStringToMilliseconds();
        message = message + " ";
        message = message + str;
        LogFile.WriteLine(message);
    }

    public static void WriteInfo(String str) {
        int op = log_level_flags & 8;
        if (op == 0) {
            return;
        }
        String message = "";
        message = message + "INFO ";
        message = message + DateFunctions.GetDateStringToMilliseconds();
        message = message + " ";
        message = message + str;
        LogFile.WriteLine(message);
    }

    public static void WriteWarn(String str) {
        int op = log_level_flags & 4;
        if (op == 0) {
            return;
        }
        String message = "";
        message = message + "WARN ";
        message = message + DateFunctions.GetDateStringToMilliseconds();
        message = message + " ";
        message = message + str;
        LogFile.WriteLine(message);
    }

    public static void WriteError(String str) {
        int op = log_level_flags & 2;
        if (op == 0) {
            return;
        }
        String message = "";
        message = message + "ERROR ";
        message = message + DateFunctions.GetDateStringToMilliseconds();
        message = message + " ";
        message = message + str;
        LogFile.WriteLine(message);
    }

    public static void WriteFatal(String str) {
        int op = log_level_flags & 1;
        if (op == 0) {
            return;
        }
        String message = "";
        message = message + "FATAL ";
        message = message + DateFunctions.GetDateStringToMilliseconds();
        message = message + " ";
        message = message + str;
        LogFile.WriteLine(message);
    }
}

