/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.basis.vector;

import com.daxie.basis.matrix.Matrix;
import com.daxie.basis.vector.Vector;

public class VectorFunctions {
    public static Vector VGet(float x, float y, float z) {
        return new Vector(x, y, z);
    }

    public static Vector VAdd(Vector lhs, Vector rhs) {
        Vector res = new Vector();
        res.SetVector(lhs.GetX() + rhs.GetX(), lhs.GetY() + rhs.GetY(), lhs.GetZ() + rhs.GetZ());
        return res;
    }

    public static Vector VSub(Vector lhs, Vector rhs) {
        Vector res = new Vector();
        res.SetVector(lhs.GetX() - rhs.GetX(), lhs.GetY() - rhs.GetY(), lhs.GetZ() - rhs.GetZ());
        return res;
    }

    public static float VSize(Vector v) {
        float x = v.GetX();
        float y = v.GetY();
        float z = v.GetZ();
        float size = (float)Math.sqrt(x * x + y * y + z * z);
        return size;
    }

    public static float VSquareSize(Vector v) {
        float x = v.GetX();
        float y = v.GetY();
        float z = v.GetZ();
        float size = x * x + y * y + z * z;
        return size;
    }

    public static Vector VNorm(Vector v) {
        Vector res = new Vector();
        float size = VectorFunctions.VSize(v);
        res.SetVector(v.GetX() / size, v.GetY() / size, v.GetZ() / size);
        return res;
    }

    public static Vector VScale(Vector v, float scale) {
        Vector res = new Vector();
        res.SetVector(v.GetX() * scale, v.GetY() * scale, v.GetZ() * scale);
        return res;
    }

    public static float VDot(Vector lhs, Vector rhs) {
        float res = lhs.GetX() * rhs.GetX() + lhs.GetY() * rhs.GetY() + lhs.GetZ() * rhs.GetZ();
        return res;
    }

    public static Vector VCross(Vector lhs, Vector rhs) {
        Vector res = new Vector();
        res.SetX(lhs.GetY() * rhs.GetZ() - lhs.GetZ() * rhs.GetY());
        res.SetY(lhs.GetZ() * rhs.GetX() - lhs.GetX() * rhs.GetZ());
        res.SetZ(lhs.GetX() * rhs.GetY() - lhs.GetY() * rhs.GetX());
        return res;
    }

    public static Vector VTransform(Vector v, Matrix m) {
        Vector ret = new Vector();
        float[] ex_v = new float[]{v.GetX(), v.GetY(), v.GetZ(), 1.0f};
        float m00 = m.GetValue(0, 0);
        float m01 = m.GetValue(0, 1);
        float m02 = m.GetValue(0, 2);
        float m03 = m.GetValue(0, 3);
        float m10 = m.GetValue(1, 0);
        float m11 = m.GetValue(1, 1);
        float m12 = m.GetValue(1, 2);
        float m13 = m.GetValue(1, 3);
        float m20 = m.GetValue(2, 0);
        float m21 = m.GetValue(2, 1);
        float m22 = m.GetValue(2, 2);
        float m23 = m.GetValue(2, 3);
        ret.SetX(m00 * ex_v[0] + m01 * ex_v[1] + m02 * ex_v[2] + m03 * ex_v[3]);
        ret.SetY(m10 * ex_v[0] + m11 * ex_v[1] + m12 * ex_v[2] + m13 * ex_v[3]);
        ret.SetZ(m20 * ex_v[0] + m21 * ex_v[1] + m22 * ex_v[2] + m23 * ex_v[3]);
        return ret;
    }
}

