/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.xml;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.tool.XMLFunctions;
import com.daxie.xops.character.CharacterAILevel;
import com.daxie.xops.character.CharacterData;
import com.daxie.xops.character.CharacterTextureType;
import com.daxie.xops.openxops.CharacterSpecifierConverter;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CharacterDataXMLOutputter {
    private List<CharacterData> character_data_list;
    private boolean openxops_compatible_flag;

    public CharacterDataXMLOutputter(List<CharacterData> character_data_list) {
        this.character_data_list = character_data_list;
        this.openxops_compatible_flag = true;
    }

    public void SetOpenXOPSCompatibleFlag(boolean openxops_compatible_flag) {
        this.openxops_compatible_flag = openxops_compatible_flag;
    }

    public int WriteXML(String xml_filename) {
        if (this.character_data_list == null) {
            LogFile.WriteError("[CharacterDataXMLOutputter-WriteXML] Data is null.");
            return -1;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteError("[CharacterDataXMLOutputter-WriteXML] Below is the stack trace.");
            LogFile.WriteLine(str);
            return -1;
        }
        Document document = builder.newDocument();
        Element el_character_list = document.createElement("character_list");
        document.appendChild(el_character_list);
        int id = 0;
        for (CharacterData character_data : this.character_data_list) {
            Element el_character = document.createElement("character");
            el_character.setAttribute("id", "" + id);
            CharacterTextureType texture_type = character_data.GetTextureType();
            int texture_type_specifier = this.openxops_compatible_flag ? CharacterSpecifierConverter.GetOpenXOPSTextureIDFromXOPSTextureType(texture_type) : texture_type.ordinal();
            Element el_texture_type = document.createElement("texture");
            el_texture_type.setTextContent("" + texture_type_specifier);
            el_character.appendChild(el_texture_type);
            Element el_model_type = document.createElement("model");
            el_model_type.setTextContent("" + character_data.GetModelType().ordinal());
            el_character.appendChild(el_model_type);
            Element el_hp = document.createElement("hp");
            el_hp.setTextContent("" + character_data.GetHP());
            el_character.appendChild(el_hp);
            CharacterAILevel ai_level = character_data.GetAILevel();
            int ai_level_specifier = this.openxops_compatible_flag ? CharacterSpecifierConverter.GetOpenXOPSAILevelFromXOPSAILevel(ai_level) : ai_level.ordinal();
            Element el_ai_level = document.createElement("AIlevel");
            el_ai_level.setTextContent("" + ai_level_specifier);
            el_character.appendChild(el_ai_level);
            Element el_weapon_a = document.createElement("WeaponA");
            el_weapon_a.setTextContent("" + character_data.GetWeaponID(0));
            el_character.appendChild(el_weapon_a);
            Element el_weapon_b = document.createElement("WeaponB");
            el_weapon_b.setTextContent("" + character_data.GetWeaponID(1));
            el_character.appendChild(el_weapon_b);
            Element el_type = document.createElement("type");
            el_type.setTextContent("" + character_data.GetType().ordinal());
            el_character.appendChild(el_type);
            el_character_list.appendChild(el_character);
            ++id;
        }
        File file = new File(xml_filename);
        int res = XMLFunctions.WriteXML(file, document);
        if (res < 0) {
            return -1;
        }
        return 0;
    }
}

