/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.mif;

import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.mif.MissionInfo;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

class MIFWriter {
    private MissionInfo mission_info;

    public MIFWriter(MissionInfo mission_info) {
        this.mission_info = mission_info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Write(String mif_filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        String str;
        if (this.mission_info == null) {
            LogFile.WriteError("[MIFWriter-Write] Data is null.");
            return;
        }
        BufferedWriter br = null;
        br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mif_filename), encoding));
        String windows_separator = "\r\n";
        try {
            br.write(this.mission_info.GetMissionName() + windows_separator);
            br.write(this.mission_info.GetMissionFormalName() + windows_separator);
            br.write(this.mission_info.GetBD1Filename() + windows_separator);
            br.write(this.mission_info.GetPD1Filename() + windows_separator);
            String sky_type = "" + this.mission_info.GetSkyType();
            br.write(sky_type + windows_separator);
            int flags = 0;
            boolean extra_hitcheck_flag = this.mission_info.GetExtraHitcheckFlag();
            boolean darken_screen_flag = this.mission_info.GetDarkenScreenFlag();
            if (extra_hitcheck_flag) {
                flags |= 1;
            }
            if (darken_screen_flag) {
                flags |= 2;
            }
            String str_flags = "" + flags;
            br.write(str_flags + windows_separator);
            br.write(this.mission_info.GetArticleInfoFilename() + windows_separator);
            br.write(this.mission_info.GetImage1Filename() + windows_separator);
            br.write(this.mission_info.GetImage2Filename() + windows_separator);
            List<String> briefing_text = this.mission_info.GetBriefingText();
            for (String line : briefing_text) {
                br.write(line + windows_separator);
            }
            br.flush();
        }
        catch (IOException e) {
            str = ExceptionFunctions.GetPrintStackTraceString(e);
            LogFile.WriteFatal("[MIFWriter-Write] Below is the stack trace.");
            LogFile.WriteLine(str);
            LogFile.CloseLogFile();
            System.exit(1);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                str = ExceptionFunctions.GetPrintStackTraceString(e);
                LogFile.WriteFatal("[MIFWriter-Write] Below is the stack trace.");
                LogFile.WriteLine(str);
                LogFile.CloseLogFile();
                System.exit(1);
            }
        }
    }
}

