/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.bd1;

import com.daxie.basis.vector.Vector;
import com.daxie.basis.vector.VectorFunctions;

public class BD1Block {
    private Vector[] vertex_positions = new Vector[8];
    private float[] us = new float[24];
    private float[] vs = new float[24];
    private int[] texture_ids = new int[6];
    private boolean enabled_flag;

    public BD1Block() {
        int i;
        for (i = 0; i < this.vertex_positions.length; ++i) {
            this.vertex_positions[i] = VectorFunctions.VGet(0.0f, 0.0f, 0.0f);
        }
        for (i = 0; i < this.us.length; ++i) {
            this.us[i] = 0.0f;
        }
        for (i = 0; i < this.vs.length; ++i) {
            this.vs[i] = 0.0f;
        }
        for (i = 0; i < this.texture_ids.length; ++i) {
            this.texture_ids[i] = 0;
        }
        this.enabled_flag = false;
    }

    public void SetVertexPositionX(int index, float x) {
        this.vertex_positions[index].SetX(x);
    }

    public void SetVertexPositionY(int index, float y) {
        this.vertex_positions[index].SetY(y);
    }

    public void SetVertexPositionZ(int index, float z) {
        this.vertex_positions[index].SetZ(z);
    }

    public void SetU(int index, float u) {
        this.us[index] = u;
    }

    public void SetV(int index, float v) {
        this.vs[index] = v;
    }

    public void SetTextureID(int index, int texture_id) {
        this.texture_ids[index] = texture_id;
    }

    public void SetEnabledFlag(boolean enabled_flag) {
        this.enabled_flag = enabled_flag;
    }

    public void SetVertexPosition(int index, Vector pos) {
        this.vertex_positions[index] = pos;
    }

    public void SetUVs(int index, float u, float v) {
        this.us[index] = u;
        this.vs[index] = v;
    }

    public Vector[] GetVertexPositions() {
        Vector[] ret = new Vector[8];
        for (int i = 0; i < 8; ++i) {
            ret[i] = new Vector(this.vertex_positions[i]);
        }
        return ret;
    }

    public float[] GetUs() {
        return (float[])this.us.clone();
    }

    public float[] GetVs() {
        return (float[])this.vs.clone();
    }

    public int[] GetTextureIDs() {
        return (int[])this.texture_ids.clone();
    }

    public boolean GetEnabledFlag() {
        return this.enabled_flag;
    }
}

