/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.tool;

import java.nio.ByteBuffer;

public class ByteFunctions {
    public static float byte_to_float(byte[] b) {
        int i;
        if (b.length != 4) {
            return 0.0f;
        }
        int s = 0;
        int e = 0;
        float m = 0.0f;
        int bit_op_res = b[0] & 0x80;
        s = bit_op_res == 0 ? 1 : -1;
        bit_op_res = b[1] & 0x80;
        if (bit_op_res != 0) {
            ++e;
        }
        int rhs = 1;
        for (i = 1; i <= 7; ++i) {
            bit_op_res = b[0] & rhs;
            if (bit_op_res != 0) {
                e = (int)((double)e + Math.pow(2.0, i));
            }
            rhs <<= 1;
        }
        rhs = 64;
        for (i = 1; i <= 7; ++i) {
            bit_op_res = b[1] & rhs;
            if (bit_op_res != 0) {
                m = (float)((double)m + Math.pow(2.0, -i));
            }
            rhs >>= 1;
        }
        rhs = 128;
        for (i = 8; i <= 15; ++i) {
            bit_op_res = b[2] & rhs;
            if (bit_op_res != 0) {
                m = (float)((double)m + Math.pow(2.0, -i));
            }
            rhs >>= 1;
        }
        rhs = 128;
        for (i = 16; i <= 23; ++i) {
            bit_op_res = b[3] & rhs;
            if (bit_op_res != 0) {
                m = (float)((double)m + Math.pow(2.0, -i));
            }
            rhs >>= 1;
        }
        float res = e == 0 && (double)Math.abs(m) < 1.0E-16 ? 0.0f : (float)s * (1.0f + m) * (float)Math.pow(2.0, e - 127);
        return res;
    }

    public static float byte_to_float_le(byte[] b) {
        if (b.length != 4) {
            return 0.0f;
        }
        byte[] buffer = new byte[]{b[3], b[2], b[1], b[0]};
        float res = ByteFunctions.byte_to_float(buffer);
        return res;
    }

    public static byte[] float_to_byte(float f) {
        return ByteBuffer.allocate(4).putFloat(f).array();
    }

    public static byte[] float_to_byte_le(float f) {
        byte[] b = ByteFunctions.float_to_byte(f);
        byte[] res = new byte[]{b[3], b[2], b[1], b[0]};
        return res;
    }

    public static short byte_to_short(byte[] b) {
        short ret;
        if (b.length != 2) {
            return 0;
        }
        byte temp = (byte)(b[0] >> 7);
        if ((temp & 1) == 0) {
            ret = (short)((b[0] << 8) + Byte.toUnsignedInt(b[1]));
        } else {
            byte[] bcopy = (byte[])b.clone();
            bcopy[0] = ~bcopy[0];
            bcopy[1] = ~bcopy[1];
            bcopy[1] = (byte)(bcopy[1] + 1);
            short abs = (short)((bcopy[0] << 8) + Byte.toUnsignedInt(bcopy[1]));
            ret = (short)(abs * -1);
        }
        return ret;
    }

    public static short byte_to_short_le(byte[] b) {
        if (b.length != 2) {
            return 0;
        }
        byte[] buffer = new byte[]{b[1], b[0]};
        short ret = ByteFunctions.byte_to_short(buffer);
        return ret;
    }

    public static byte[] short_to_byte(short s) {
        byte[] b = new byte[2];
        if (s >= 0) {
            b[0] = (byte)(s >> 8);
            b[1] = (byte)s;
        } else {
            short abs = (short)(s * -1);
            abs = (short)(abs - 1);
            b[0] = (byte)(abs >> 8);
            b[1] = (byte)abs;
            b[0] = ~b[0];
            b[1] = ~b[1];
        }
        return b;
    }

    public static byte[] short_to_byte_le(short s) {
        byte[] b = new byte[2];
        if (s >= 0) {
            b[1] = (byte)(s >> 8);
            b[0] = (byte)s;
        } else {
            short abs = (short)(s * -1);
            abs = (short)(abs - 1);
            b[1] = (byte)(abs >> 8);
            b[0] = (byte)abs;
            b[1] = ~b[1];
            b[0] = ~b[0];
        }
        return b;
    }

    public static int byte_to_ushort(byte[] b) {
        if (b.length != 2) {
            return 0;
        }
        int first = Byte.toUnsignedInt(b[0]);
        int second = Byte.toUnsignedInt(b[1]);
        int ret = (first << 8) + second;
        return ret;
    }

    public static int byte_to_ushort_le(byte[] b) {
        if (b.length != 2) {
            return 0;
        }
        byte[] buffer = new byte[]{b[1], b[0]};
        int ret = ByteFunctions.byte_to_ushort(buffer);
        return ret;
    }

    public static byte[] ushort_to_byte(int s) {
        byte[] b = new byte[]{(byte)(s >> 8), (byte)s};
        return b;
    }

    public static byte[] ushort_to_byte_le(int s) {
        byte[] b = new byte[2];
        b[1] = (byte)(s >> 8);
        b[0] = (byte)s;
        return b;
    }
}

