/*
 * Decompiled with CFR 0.152.
 */
package dmax.dialog;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.widget.TextView;
import dmax.dialog.AnimatedView;
import dmax.dialog.AnimatorPlayer;
import dmax.dialog.HesitateInterpolator;
import dmax.dialog.ProgressLayout;
import dmax.dialog.R;

public class SpotsDialog
extends AlertDialog {
    private static final int DELAY = 150;
    private static final int DURATION = 1500;
    private int size;
    private AnimatedView[] spots;
    private AnimatorPlayer animator;
    private CharSequence message;

    private SpotsDialog(Context context, String message, int theme, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        super(context, theme);
        this.message = message;
        this.setCancelable(cancelable);
        if (cancelListener != null) {
            this.setOnCancelListener(cancelListener);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dmax_spots_dialog);
        this.setCanceledOnTouchOutside(false);
        this.initMessage();
        this.initProgress();
    }

    protected void onStart() {
        super.onStart();
        for (AnimatedView view : this.spots) {
            view.setVisibility(0);
        }
        this.animator = new AnimatorPlayer(this.createAnimations());
        this.animator.play();
    }

    protected void onStop() {
        super.onStop();
        this.animator.stop();
    }

    public void setMessage(CharSequence message) {
        this.message = message;
        if (this.isShowing()) {
            this.initMessage();
        }
    }

    private void initMessage() {
        if (this.message != null && this.message.length() > 0) {
            ((TextView)this.findViewById(R.id.dmax_spots_title)).setText(this.message);
        }
    }

    private void initProgress() {
        ProgressLayout progress = (ProgressLayout)this.findViewById(R.id.dmax_spots_progress);
        this.size = progress.getSpotsCount();
        this.spots = new AnimatedView[this.size];
        int size = this.getContext().getResources().getDimensionPixelSize(R.dimen.spot_size);
        int progressWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.progress_width);
        for (int i = 0; i < this.spots.length; ++i) {
            AnimatedView v = new AnimatedView(this.getContext());
            v.setBackgroundResource(R.drawable.dmax_spots_spot);
            v.setTarget(progressWidth);
            v.setXFactor(-1.0f);
            v.setVisibility(4);
            progress.addView(v, size, size);
            this.spots[i] = v;
        }
    }

    private Animator[] createAnimations() {
        Animator[] animators = new Animator[this.size];
        for (int i = 0; i < this.spots.length; ++i) {
            final AnimatedView animatedView = this.spots[i];
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)((Object)animatedView), (String)"xFactor", (float[])new float[]{0.0f, 1.0f});
            move.setDuration(1500L);
            move.setInterpolator((TimeInterpolator)new HesitateInterpolator());
            move.setStartDelay((long)(150 * i));
            move.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    animatedView.setVisibility(4);
                }

                public void onAnimationStart(Animator animation) {
                    animatedView.setVisibility(0);
                }
            });
            animators[i] = move;
        }
        return animators;
    }

    public static class Builder {
        private Context context;
        private String message;
        private int messageId;
        private int themeId;
        private boolean cancelable = true;
        private DialogInterface.OnCancelListener cancelListener;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder setTheme(@StyleRes int themeId) {
            this.themeId = themeId;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setCancelListener(DialogInterface.OnCancelListener cancelListener) {
            this.cancelListener = cancelListener;
            return this;
        }

        public AlertDialog build() {
            return new SpotsDialog(this.context, this.messageId != 0 ? this.context.getString(this.messageId) : this.message, this.themeId != 0 ? this.themeId : R.style.SpotsDialogDefault, this.cancelable, this.cancelListener);
        }
    }
}

