/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.xml.generator;

import java.util.Enumeration;
import java.util.Hashtable;
import org.cyclades.xml.generator.XMLGeneratorException;

public class XMLGen {
    private StringBuilder mXmlBuffer;
    private String mDocRoot = null;
    public static final String ENCODING_SCHEME_UTF8 = "UTF-8";
    public static final String ENCODING_SCHEME_US_ASCII = "US-ASCII";

    public XMLGen(String encoding, String docRoot, Hashtable attributes) throws XMLGeneratorException {
        String eLabel = "XMLGen.XMLGen: ";
        try {
            if (encoding == null) {
                this.mXmlBuffer = new StringBuilder();
            } else {
                this.mXmlBuffer = new StringBuilder("<?xml version=\"1.0\" encoding=\"");
                this.mXmlBuffer.append(encoding);
                this.mXmlBuffer.append("\"?>");
            }
            if (docRoot != null) {
                this.mDocRoot = docRoot;
                this.addBeginningTag(docRoot, attributes);
            }
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.XMLGen: " + e);
        }
    }

    public void addElement(String name, Hashtable attributes, String data, boolean isCdata) throws XMLGeneratorException {
        String eLabel = "XMLGen.addElement: ";
        try {
            this.addBeginningTag(name, attributes);
            this.addDataSection(data, isCdata);
            this.addEndingTag(name);
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.addElement: " + e);
        }
    }

    public void addBeginningTag(String name, Hashtable attributes) throws XMLGeneratorException {
        String eLabel = "XMLGen.addTag: ";
        try {
            this.mXmlBuffer.append("<");
            this.mXmlBuffer.append(name);
            if (attributes != null) {
                Enumeration keyEnum = attributes.keys();
                while (keyEnum.hasMoreElements()) {
                    Object key = keyEnum.nextElement();
                    Object value = attributes.get(key);
                    this.mXmlBuffer.append(" ");
                    this.mXmlBuffer.append(key.toString());
                    this.mXmlBuffer.append("=\"");
                    this.mXmlBuffer.append(value.toString());
                    this.mXmlBuffer.append("\"");
                }
            }
            this.mXmlBuffer.append(">");
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.addTag: " + e);
        }
    }

    public void addDataSection(String data, boolean isCdata) throws XMLGeneratorException {
        String eLabel = "XMLGen.addDataSection: ";
        try {
            if (isCdata) {
                this.mXmlBuffer.append("<![CDATA[");
                this.mXmlBuffer.append(data);
                this.mXmlBuffer.append("]]>");
            } else {
                this.mXmlBuffer.append(data);
            }
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.addDataSection: " + e);
        }
    }

    public void addEndingTag(String name) throws XMLGeneratorException {
        String eLabel = "XMLGen.addTag: ";
        try {
            this.mXmlBuffer.append("</");
            this.mXmlBuffer.append(name);
            this.mXmlBuffer.append(">");
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.addTag: " + e);
        }
    }

    public void addRaw(String rawString) throws XMLGeneratorException {
        String eLabel = "XMLGen.addRaw: ";
        try {
            this.mXmlBuffer.append(rawString);
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.addRaw: " + e);
        }
    }

    public void done() throws XMLGeneratorException {
        String eLabel = "XMLGen.done: ";
        try {
            if (this.mDocRoot != null) {
                this.addEndingTag(this.mDocRoot);
            }
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLGen.done: " + e);
        }
    }

    public String toString() {
        return this.mXmlBuffer.toString();
    }
}

