/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.io;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.cyclades.io.ResourceRequestUtils;

public class FileUtils {
    public static void writeToFile(String fromURI, String toURI) throws Exception {
        FileUtils.writeToFile(fromURI, toURI, 1024);
    }

    public static void writeToFile(String fromURI, String toURI, int bufferSize) throws Exception {
        String eLabel = "FileUtils.writeToFile(String, String): ";
        InputStream is = null;
        OutputStream os = null;
        try {
            if (bufferSize < 1) {
                throw new Exception("Invalid buffer size: " + bufferSize);
            }
            is = ResourceRequestUtils.getInputStream(fromURI, null);
            os = new FileOutputStream(new File(toURI));
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            throw new Exception("FileUtils.writeToFile(String, String): " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public static void writeToFile(byte[] data, String URI2) throws Exception {
        FileUtils.writeToFile(data, URI2, 1024);
    }

    public static void writeToFile(byte[] data, String URI2, int bufferSize) throws Exception {
        String eLabel = "FileUtils.writeToFile(byte[], String): ";
        InputStream is = null;
        OutputStream os = null;
        try {
            if (bufferSize < 1) {
                throw new Exception("Invalid buffer size: " + bufferSize);
            }
            is = new ByteArrayInputStream(data);
            os = new FileOutputStream(new File(URI2));
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (Exception e) {
            throw new Exception("FileUtils.writeToFile(byte[], String): " + e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
            try {
                os.close();
            }
            catch (Exception e) {}
        }
    }

    public static void verifyOutputDirectory(String path) throws Exception {
        String eLabel = "FileUtils.verifyOutputDirectory: ";
        try {
            File outDirectory = new File(path);
            if (!outDirectory.exists()) {
                if (!outDirectory.mkdirs()) {
                    throw new Exception("Failed to create directory: " + path);
                }
            } else if (!outDirectory.isDirectory()) {
                throw new Exception("Path is to file, not directory: " + path);
            }
        }
        catch (Exception e) {
            throw new Exception("FileUtils.verifyOutputDirectory: " + e);
        }
    }

    public static void verifyFileOutputDirectory(String path) throws Exception {
        String eLabel = "FileUtils.verifyFileOutputDirectory: ";
        try {
            int index = path.lastIndexOf("/");
            String directoryPath = null;
            if (index > -1) {
                directoryPath = path.substring(0, index);
            }
            if (directoryPath != null && !directoryPath.trim().equals("")) {
                FileUtils.verifyOutputDirectory(directoryPath);
            }
        }
        catch (Exception e) {
            throw new Exception("FileUtils.verifyFileOutputDirectory: " + e);
        }
    }

    public static boolean deleteDirectoryContents(String directoryPath, boolean deleteChildDirectories) throws Exception {
        String eLabel = "FileUtils.deleteDirectoryContents: ";
        try {
            File directory = new File(directoryPath);
            if (!directory.exists()) {
                return false;
            }
            if (!directory.isDirectory()) {
                throw new Exception("Not a directory!!!");
            }
            File[] children = directory.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isFile()) {
                    if (children[i].delete()) continue;
                    throw new Exception("Could not delete file: " + children[i].getName());
                }
                if (deleteChildDirectories) {
                    FileUtils.deleteDirectoryContents(children[i].getPath(), true);
                }
                if (children[i].delete()) continue;
                throw new Exception("Could not delete directory: " + children[i].getName());
            }
            return true;
        }
        catch (Exception e) {
            throw new Exception("FileUtils.deleteDirectoryContents: " + e);
        }
    }

    public static void copyDirectoryContents(String sourceDirectory, String destinationDirectory, boolean moveChildDirectories) throws Exception {
        String eLabel = "FileUtils.copyDirectoryContents: ";
        try {
            File directory = new File(sourceDirectory);
            if (!directory.exists() || !directory.isDirectory()) {
                throw new Exception("Not a valid directory: " + sourceDirectory);
            }
            FileUtils.verifyOutputDirectory(destinationDirectory);
            File targetDirectory = new File(destinationDirectory);
            File[] sourceChildren = directory.listFiles();
            for (int i = 0; i < sourceChildren.length; ++i) {
                if (sourceChildren[i].isFile()) {
                    File newFile = new File(targetDirectory, sourceChildren[i].getName());
                    FileUtils.copyFile(sourceChildren[i].getPath(), newFile.getPath());
                    continue;
                }
                if (!moveChildDirectories) continue;
                File newDirectory = new File(targetDirectory, sourceChildren[i].getName());
                FileUtils.deleteDirectoryContents(newDirectory.getPath(), true);
                FileUtils.verifyOutputDirectory(newDirectory.getPath());
                FileUtils.copyDirectoryContents(sourceChildren[i].getPath(), newDirectory.getPath(), true);
            }
        }
        catch (Exception e) {
            throw new Exception("FileUtils.copyDirectoryContents: " + e);
        }
    }

    public static void copyFile(String sourceURI, String destinationFileURI) throws Exception {
        String eLabel = "FileUtils.copyFile: ";
        try {
            FileUtils.writeToFile(sourceURI, destinationFileURI);
        }
        catch (Exception e) {
            throw new Exception("FileUtils.copyFile: " + e);
        }
    }
}

