/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.cyclades.engine.validator.ParameterHasValue;
import org.cyclades.engine.validator.ValidationFaultElement;

public class ParametersRegexValidator
extends ParameterHasValue {
    private Pattern pattern = null;

    public ParametersRegexValidator(String key) {
        super(key);
    }

    public ParametersRegexValidator(String key, boolean terminal) {
        super(key, terminal);
    }

    public ParametersRegexValidator setPattern(String regex) throws PatternSyntaxException {
        this.pattern = Pattern.compile(regex);
        return this;
    }

    public ParametersRegexValidator setPattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @Override
    public ValidationFaultElement validate(List<String> values) throws Exception {
        ValidationFaultElement vfe = super.validate(values);
        if (vfe != null) {
            return vfe;
        }
        for (String v : values) {
            if (this.pattern.matcher(v).matches()) continue;
            StringBuilder sb = new StringBuilder("Parameter does not match regex: ").append(this.pattern.toString()).append(": ").append(v);
            return new ValidationFaultElement(sb.toString());
        }
        return null;
    }
}

