/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.util.List;
import org.cyclades.engine.validator.ParameterHasValue;
import org.cyclades.engine.validator.ValidationFaultElement;

public class ParameterHasIntegerValue
extends ParameterHasValue {
    private Integer min = null;
    private Integer max = null;

    public ParameterHasIntegerValue(String key) {
        super(key);
    }

    public ParameterHasIntegerValue(String key, boolean terminal) {
        super(key, terminal);
    }

    public ParameterHasIntegerValue setMin(int min) {
        this.min = min;
        return this;
    }

    public ParameterHasIntegerValue setMax(int max) {
        this.max = max;
        return this;
    }

    @Override
    public ValidationFaultElement validate(List<String> values) throws Exception {
        int value;
        ValidationFaultElement vfe = super.validate(values);
        if (vfe != null) {
            return vfe;
        }
        try {
            value = Integer.parseInt(values.get(0));
        }
        catch (Exception e) {
            return new ValidationFaultElement("Invalid integer format: " + values.get(0));
        }
        if (this.min != null && value < this.min || this.max != null && value > this.max) {
            StringBuilder sb = new StringBuilder("Invalid integer value for parameter \"");
            sb.append(this.getKey()).append("\". Expected value between (inclusive) ");
            sb.append(this.min != null ? this.min : Integer.MIN_VALUE).append(" and ").append(this.max != null ? this.max : Integer.MAX_VALUE).append(", but got ").append(value);
            return new ValidationFaultElement(sb.toString());
        }
        return null;
    }
}

