/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.validator;

import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.validator.AllOf;
import org.cyclades.engine.validator.IfThen;
import org.cyclades.engine.validator.JSONValidator;
import org.cyclades.engine.validator.OneOf;
import org.cyclades.engine.validator.ParameterListValidator;
import org.cyclades.engine.validator.ParametersValidator;
import org.cyclades.engine.validator.ValidationFaultElement;
import org.cyclades.engine.validator.XMLValidator;
import org.json.JSONObject;
import org.w3c.dom.Node;

public abstract class FieldValidator {
    private boolean terminal = false;

    public abstract ValidationEnum getValidationType();

    public FieldValidator() {
    }

    public FieldValidator(boolean terminal) {
        this.terminal = terminal;
    }

    public ValidationFaultElement validate(NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
        String eLabel = "FieldValidator.validate: ";
        try {
            return this.getValidationType().validate(this, nyxletSession, parameters);
        }
        catch (Exception e) {
            throw new Exception("FieldValidator.validate: " + e);
        }
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    static enum ValidationEnum {
        ONE_OF{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.ONE_OF.validate: ";
                try {
                    return ((OneOf)validator).validate(nyxletSession, parameters);
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.ONE_OF.validate: " + e);
                }
            }
        }
        ,
        ALL_OF{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.ALL_OF.validate: ";
                try {
                    return ((AllOf)validator).validate(nyxletSession, parameters);
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.ALL_OF.validate: " + e);
                }
            }
        }
        ,
        IF_THEN{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.IF_THEN.validate: ";
                try {
                    return ((IfThen)validator).validate(nyxletSession, parameters);
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.IF_THEN.validate: " + e);
                }
            }
        }
        ,
        PARAMETERS{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.PARAMETER_LIST.validate: ";
                try {
                    return ((ParametersValidator)validator).validate(parameters);
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.PARAMETER_LIST.validate: " + e);
                }
            }
        }
        ,
        PARAMETER_LIST{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.PARAMETER_LIST.validate: ";
                try {
                    ParameterListValidator plv = (ParameterListValidator)validator;
                    return plv.validate(parameters.get(plv.getKey()));
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.PARAMETER_LIST.validate: " + e);
                }
            }
        }
        ,
        JSON{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.JSON.validate: ";
                try {
                    if (!nyxletSession.getMetaTypeEnum().equals((Object)MetaTypeEnum.JSON)) {
                        return null;
                    }
                    Object dataObject = nyxletSession.getDataObject();
                    return ((JSONValidator)validator).validate(dataObject == null ? null : (JSONObject)dataObject);
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.JSON.validate: " + e);
                }
            }
        }
        ,
        XML{

            @Override
            public ValidationFaultElement validate(FieldValidator validator, NyxletSession nyxletSession, Map<String, List<String>> parameters) throws Exception {
                String eLabel = "FieldValidator.ValidationEnum.XML.validate: ";
                try {
                    if (!nyxletSession.getMetaTypeEnum().equals((Object)MetaTypeEnum.XML)) {
                        return null;
                    }
                    Object dataObject = nyxletSession.getDataObject();
                    return ((XMLValidator)validator).validate(dataObject == null ? null : (Node)dataObject);
                }
                catch (Exception e) {
                    throw new Exception("FieldValidator.ValidationEnum.XML.validate: " + e);
                }
            }
        };


        public abstract ValidationFaultElement validate(FieldValidator var1, NyxletSession var2, Map<String, List<String>> var3) throws Exception;
    }
}

