/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.cyclades.xml.generator.XMLWriter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapHelper {
    public static Map mapFromMeta(Node node, String[] keys) throws Exception {
        String eLabel = "MapHelper.mapFromMeta(Node, String[]): ";
        try {
            if (keys == null) {
                return MapHelper.mapFromMetaObject(node);
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            for (int i = 0; i < keys.length; ++i) {
                try {
                    String temp = XMLComparitor.getAttribute(node, keys[i]);
                    if (temp == null) continue;
                    returnMap.put(keys[i], temp);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return returnMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapFromMeta(Node, String[]): " + e);
        }
    }

    public static Map mapFromMeta(Node node) throws Exception {
        return MapHelper.mapFromMeta(node, null);
    }

    public static Map mapFromMetaObject(Node node) throws Exception {
        String eLabel = "MapHelper.mapFromMetaObject(Node): ";
        try {
            NamedNodeMap nodeMap = node.getAttributes();
            if (nodeMap == null) {
                throw new Exception("Node passed in is not an element!");
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            for (int i = 0; i < nodeMap.getLength(); ++i) {
                returnMap.put(nodeMap.item(i).getNodeName(), nodeMap.item(i).getNodeValue());
            }
            return returnMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapFromMetaObject(Node): " + e);
        }
    }

    public static Map<String, List<String>> parameterMapFromURI(String URI2, int offset, String[] keys) throws Exception {
        String eLabel = "MapHelper.parameterMapFromURI: ";
        try {
            return MapHelper.parameterMapFromArray(URI2.split("[/]"), offset, keys);
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapFromURI: " + e);
        }
    }

    public static Map<String, List<String>> parameterMapFromArray(String[] values, int offset, String[] keys) throws Exception {
        String eLabel = "MapHelper.parameterMapFromArray: ";
        try {
            HashMap<String, List<String>> listMap = new HashMap<String, List<String>>();
            for (int i = offset; i < values.length && i - offset <= keys.length - 1; ++i) {
                MapHelper.addParameterToParameterMap(listMap, keys[i - offset], values[i]);
            }
            return listMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapFromArray: " + e);
        }
    }

    public static Map<String, List<String>> parameterMapFromMetaObject(NodeList nodeList) throws Exception {
        String eLabel = "MapHelper.parameterMapFromMetaObject: ";
        try {
            HashMap<String, List<String>> listMap = new HashMap<String, List<String>>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                MapHelper.addParameterToParameterMap(listMap, XMLComparitor.getAttribute(nodeList.item(i), "name"), XMLComparitor.getAttribute(nodeList.item(i), "value"));
            }
            return listMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapFromMetaObject: " + e);
        }
    }

    public static Map<String, List<String>> parameterMapFromMetaObject(JSONArray jsonArray) throws Exception {
        String eLabel = "MapHelper.parameterMapFromMetaObject: ";
        try {
            HashMap<String, List<String>> listMap = new HashMap<String, List<String>>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject parameter = jsonArray.getJSONObject(i);
                MapHelper.addParameterToParameterMap(listMap, parameter.getString("name"), parameter.getString("value"));
            }
            return listMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapFromMetaObject: " + e);
        }
    }

    public static Map<String, Map<String, List<String>>> indexedParameterMapFromMetaObject(NodeList nodeList) throws Exception {
        String eLabel = "MapHelper.indexedParameterMapFromMetaObject: ";
        try {
            HashMap<String, Map<String, List<String>>> indexedParameterMap = new HashMap<String, Map<String, List<String>>>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node entry = nodeList.item(i);
                Vector<Node> vector = XMLComparitor.getMatchingChildNodes(entry, "parameters");
                if (vector == null || vector.size() < 1) {
                    throw new Exception("No parameters declared!");
                }
                Map<String, List<String>> parameterMap = MapHelper.parameterMapFromMetaObject(vector.firstElement().getChildNodes());
                vector = XMLComparitor.getMatchingChildNodes(entry, "keys");
                if (vector == null || vector.size() < 1) {
                    throw new Exception("No keys declared!");
                }
                NodeList keys = vector.firstElement().getChildNodes();
                for (int j = 0; j < keys.getLength(); ++j) {
                    indexedParameterMap.put(XMLComparitor.getAttribute(keys.item(j), "value"), parameterMap);
                }
            }
            return indexedParameterMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.indexedParameterMapFromMetaObject: " + e);
        }
    }

    public static Map<String, Map<String, List<String>>> indexedParameterMapFromMetaObject(JSONArray jsonArray) throws Exception {
        String eLabel = "MapHelper.indexedParameterMapFromMetaObject: ";
        try {
            HashMap<String, Map<String, List<String>>> indexedParameterMap = new HashMap<String, Map<String, List<String>>>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject entry = jsonArray.getJSONObject(i);
                Map<String, List<String>> parameterMap = MapHelper.parameterMapFromMetaObject(entry.getJSONArray("parameters"));
                JSONArray keys = entry.getJSONArray("keys");
                for (int j = 0; j < keys.length(); ++j) {
                    indexedParameterMap.put(keys.getString(j), parameterMap);
                }
            }
            return indexedParameterMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.indexedParameterMapFromMetaObject: " + e);
        }
    }

    private static void addParameterToParameterMap(Map<String, List<String>> parameterMap, String key, String value) {
        List<String> values = parameterMap.get(key);
        if (values == null) {
            values = new ArrayList<String>();
            parameterMap.put(key, values);
        }
        values.add(value);
    }

    public static Map<String, List<String>> immutableParameterMap(Map<String, List<String>> map) {
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String[]> arrayParameterMapFromParameterMap(Map<String, List<String>> map) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            parameterMap.put(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        return parameterMap;
    }

    public static Map mapFromMeta(JSONObject JSONDeliverable, String[] keys) throws Exception {
        String eLabel = "MapHelper.mapFromMeta(JSON): ";
        try {
            if (keys == null) {
                return MapHelper.mapFromMetaObject(JSONDeliverable);
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            for (int i = 0; i < keys.length; ++i) {
                try {
                    String temp = JSONDeliverable.getString(keys[i]);
                    if (temp == null) continue;
                    returnMap.put(keys[i], temp);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return returnMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapFromMeta(JSON): " + e);
        }
    }

    public static Map mapFromMeta(JSONObject JSONDeliverable) throws Exception {
        return MapHelper.mapFromMeta(JSONDeliverable, null);
    }

    public static Map mapFromMetaObject(JSONObject jsonObject) throws Exception {
        String eLabel = "MapHelper.mapFromMetaObject(JSONObject): ";
        try {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = jsonObject.get(key);
                if (!(value instanceof String) && !(value instanceof Boolean) && !(value instanceof Integer)) continue;
                returnMap.put(key, value.toString());
            }
            return returnMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapFromMetaObject(JSONObject): " + e);
        }
    }

    public static Map mergeMaps(Map mainMap, Map defaultMap, String[] keys, boolean enforceValues) throws Exception {
        String eLabel = "MapHelper.MergeMaps: ";
        HashMap returnMap = new HashMap();
        if (defaultMap == null) {
            defaultMap = new HashMap();
        }
        try {
            for (int i = 0; i < keys.length; ++i) {
                if (!mainMap.containsKey(keys[i]) && !defaultMap.containsKey(keys[i])) {
                    if (!enforceValues) continue;
                    throw new Exception("Required value does not exist for key: " + keys[i]);
                }
                returnMap.put(keys[i], mainMap.get(keys[i]) != null ? mainMap.get(keys[i]) : defaultMap.get(keys[i]));
            }
            return returnMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.MergeMaps: " + e);
        }
    }

    public static HashMap mergeMaps(Map toMergePrimary, Map toMergeSecondary, Object[] verifyKeys) throws Exception {
        String eLabel = "MapHelper.mergeMaps: ";
        try {
            return (HashMap)MapHelper.mergeMaps(toMergePrimary, toMergeSecondary, new HashMap(), verifyKeys);
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mergeMaps: " + e);
        }
    }

    public static Map mergeMaps(Map toMergePrimary, Map toMergeSecondary, Map mergedMap, Object[] verifyKeys) throws Exception {
        String eLabel = "MapHelper.mergeMaps: ";
        try {
            if (toMergePrimary == null) {
                throw new Exception("toMergePrimary parameter must not be null!");
            }
            if (mergedMap == null) {
                throw new Exception("mergedMap parameter must not be null!");
            }
            if (toMergeSecondary != null) {
                mergedMap.putAll(toMergeSecondary);
            }
            mergedMap.putAll(toMergePrimary);
            if (verifyKeys != null) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (Object key : verifyKeys) {
                    if (mergedMap.containsKey(key)) continue;
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append("Key does not exist: ").append(key);
                }
                if (sb.length() > 0) {
                    throw new Exception(sb.toString());
                }
            }
            return mergedMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mergeMaps: " + e);
        }
    }

    public static Map<String, String> parameterMapToMap(Map<String, String[]> parameterMap) throws Exception {
        String eLabel = "MapHelper.parameterMapToMap: ";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue() == null || entry.getValue().length < 1 ? null : entry.getValue()[0];
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapToMap: " + e);
        }
    }

    public static Map<String, String[]> mapToParameterMap(Map<String, String> map) throws Exception {
        String eLabel = "MapHelper.mapToParameterMap: ";
        try {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                parameterMap.put(entry.getKey(), new String[]{entry.getValue()});
            }
            return parameterMap;
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapToParameterMap: " + e);
        }
    }

    public static String mapToJSON(Map<String, String> map, boolean omitNullOrEmptyValues) throws Exception {
        String eLabel = "MapHelper.mapToJSON: ";
        try {
            StringBuilder sb = new StringBuilder("{");
            int count = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (omitNullOrEmptyValues && (entry.getValue() == null || entry.getValue().trim().equals(""))) continue;
                if (count++ > 0) {
                    sb.append(",");
                }
                sb.append("\"").append(entry.getKey()).append("\":").append(JSONObject.quote((String)entry.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapToJSON: " + e);
        }
    }

    public static String mapToXML(Map<String, String> map, String rootName, boolean omitNullOrEmptyValues) throws Exception {
        String eLabel = "MapHelper.mapToXML: ";
        try {
            Hashtable<String, String> atts = new Hashtable<String, String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (omitNullOrEmptyValues && (entry.getValue() == null || entry.getValue().trim().equals(""))) continue;
                atts.put(entry.getKey(), StringEscapeUtils.escapeXml((String)(entry.getValue() == null ? "" : entry.getValue())));
            }
            XMLWriter writer = new XMLWriter(null, rootName, atts);
            writer.done();
            return writer.toString();
        }
        catch (Exception e) {
            throw new Exception("MapHelper.mapToXML: " + e);
        }
    }

    public static String parameterMapToJSON(Map<String, List<String>> map) throws Exception {
        String eLabel = "MapHelper.parameterMapToJSON: ";
        try {
            StringBuilder sb = new StringBuilder("[");
            int count = 0;
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) {
                    if (count++ > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"name\":\"").append(entry.getKey()).append("\",\"value\":\"\"}");
                    continue;
                }
                for (String value : entry.getValue()) {
                    if (count++ > 0) {
                        sb.append(",");
                    }
                    sb.append("{\"name\":\"").append(entry.getKey()).append("\",\"value\":");
                    sb.append(JSONObject.quote((String)value)).append("}");
                }
            }
            sb.append("]");
            return sb.toString();
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapToJSON: " + e);
        }
    }

    public static String parameterMapToXML(Map<String, List<String>> map, String elementName) throws Exception {
        String eLabel = "MapHelper.parameterMapToXML: ";
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) {
                    sb.append("<").append(elementName).append(" name=\"").append(entry.getKey()).append("\" value=\"\"/>");
                    continue;
                }
                for (String value : entry.getValue()) {
                    sb.append("<").append(elementName).append(" name=\"").append(entry.getKey()).append("\" value=\"");
                    sb.append(StringEscapeUtils.escapeXml((String)value)).append("\"/>");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new Exception("MapHelper.parameterMapToXML: " + e);
        }
    }
}

