/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma.xstroma;

import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.util.MapHelper;
import org.json.JSONObject;

public class XSTROMAResponseWriter {
    private boolean omitPrefix = false;
    private boolean omitSuffix = false;
    private String serviceName;
    private String transactionData;
    private String serviceAgent;
    private OutputStream outputStream;
    private boolean isXML = false;
    private boolean responseInFlight = false;
    private boolean done = false;
    private boolean writeOrchestrationFault = false;
    private Map<String, List<String>> responseParameterMap = null;
    private boolean durationRequested = false;
    private long durationStart;
    private static final String ERROR_CODE_ATTRIBUTE = "error-code";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String DATA_ATTRIBUTE = "data";
    private static final String RESPONSES_ATTRIBUTE = "responses";
    public static final String RESPONSE_ATTRIBUTE = "response";
    public static final String ORCHESTRATION_FAULT_ENCOUNTERED_ATTRIBUTE = "orchestration-fault";
    private static final String PARAMETERS_ATTRIBUTE = "parameters";
    private static final String DURATION_ATTRIBUTE = "duration";
    private static final String TRANSACTION_DATA_ATTRIBUTE = "transaction-data";

    public XSTROMAResponseWriter(String serviceName, NyxletSession nyxletSession) throws Exception {
        this(serviceName, nyxletSession, null);
    }

    public XSTROMAResponseWriter(String serviceName, NyxletSession nyxletSession, Nyxlet nyxlet) throws Exception {
        String eLabel = "XSTROMAResponseWriter.XSTROMAResponseWriter: ";
        try {
            if (nyxlet != null && nyxletSession.serviceAgentRequested()) {
                this.serviceAgent = nyxlet.getServiceAgentAttribute();
            }
            this.outputStream = nyxletSession.getOutputStream();
            this.serviceName = serviceName;
            this.transactionData = nyxletSession.getTransactionDataString();
            this.durationRequested = nyxletSession.durationRequested();
            this.durationStart = nyxletSession.getDurationStart();
            switch (nyxletSession.getResponseMetaTypeEnum()) {
                case JSON: {
                    this.isXML = false;
                    break;
                }
                case XML: {
                    this.isXML = true;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("XSTROMAResponseWriter.XSTROMAResponseWriter: " + e);
        }
    }

    public void setResponseParameters(Map<String, List<String>> responseParameterMap) throws Exception {
        if (this.done) {
            throw new Exception("Response already done");
        }
        this.responseParameterMap = responseParameterMap;
    }

    public XSTROMAResponseWriter addResponseParameter(String key, String value) throws Exception {
        List<String> values;
        if (this.responseParameterMap == null) {
            this.responseParameterMap = new LinkedHashMap<String, List<String>>();
        }
        if ((values = this.responseParameterMap.get(key)) == null) {
            values = new LinkedList<String>();
            this.responseParameterMap.put(key, values);
        }
        values.add(value);
        return this;
    }

    public OutputStream getOutputStream() throws Exception {
        String eLabel = "STROMAResponseWriter.getOutputStream: ";
        try {
            this.checkAndSetResponseInFlight();
            if (this.isXML) {
                this.writeXMLResponsePreMeta(null, 0);
            } else {
                this.writeJSONResponsePreMeta(null, 0);
            }
            return this.outputStream;
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.getOutputStream: " + e);
        }
    }

    public void done() throws Exception {
        String eLabel = "STROMAResponseWriter.done: ";
        try {
            if (!this.responseInFlight) {
                throw new Exception("getOutputStream was never called");
            }
            if (this.done) {
                throw new Exception("Response already done");
            }
            if (this.isXML) {
                this.writeXMLResponsePostMeta();
            } else {
                this.writeJSONResponsePostMeta();
            }
            this.done = true;
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.done: " + e);
        }
    }

    public void writeResponse(String content) throws Exception {
        this.writeAsString(content, 0);
        this.done = true;
    }

    public void writeErrorResponse(int errorCode, String errorMessage) throws Exception {
        this.writeAsString(errorMessage, errorCode);
        this.done = true;
    }

    private void writeAsString(String content, int error) throws Exception {
        String eLabel = "STROMAResponse.writeAsString: ";
        try {
            this.checkAndSetResponseInFlight();
            if (this.isXML) {
                this.writeXMLResponsePreMeta(content, error);
                if (error < 1) {
                    this.write(content);
                }
                this.writeXMLResponsePostMeta();
            } else {
                this.writeJSONResponsePreMeta(content, error);
                if (error < 1) {
                    this.write(content);
                }
                this.writeJSONResponsePostMeta();
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponse.writeAsString: " + e);
        }
    }

    private void checkAndSetResponseInFlight() throws Exception {
        this.checkResponseInFlight();
        this.responseInFlight = true;
    }

    private void checkResponseInFlight() throws Exception {
        if (this.done) {
            throw new Exception("Response already done");
        }
        if (this.responseInFlight) {
            throw new Exception("Response already in flight, no turning back now...you should be building your meta data with the OutputStream");
        }
    }

    private void writeJSONResponsePreMeta(String content, int error) throws Exception {
        String eLabel = "XSTROMAResponseWriter.writeJSONResponsePreMeta: ";
        if (this.omitPrefix) {
            return;
        }
        try {
            this.write("{\"");
            this.write(ERROR_CODE_ATTRIBUTE);
            this.write("\":\"0\",\"");
            this.write(SERVICE_ATTRIBUTE);
            this.write("\":\"");
            this.write(this.serviceName);
            this.write("\",\"");
            if (this.serviceAgent != null) {
                this.write("service-agent");
                this.write("\":");
                this.write(JSONObject.quote((String)this.serviceAgent));
                this.write(",\"");
            }
            if (this.transactionData != null) {
                this.write(TRANSACTION_DATA_ATTRIBUTE);
                this.write("\":");
                this.write(JSONObject.quote((String)this.transactionData));
                this.write(",\"");
            }
            this.write(DATA_ATTRIBUTE);
            this.write("\":{\"");
            this.write(RESPONSES_ATTRIBUTE);
            this.write("\":[");
        }
        catch (Exception e) {
            throw new Exception("XSTROMAResponseWriter.writeJSONResponsePreMeta: " + e);
        }
    }

    private void writeJSONResponsePostMeta() throws Exception {
        String eLabel = "STROMAResponseWriter.writeJSONResponsePostMeta: ";
        if (this.omitSuffix) {
            return;
        }
        try {
            this.write("]}");
            if (this.writeOrchestrationFault) {
                this.write(",\"");
                this.write(ORCHESTRATION_FAULT_ENCOUNTERED_ATTRIBUTE);
                this.write("\":\"true\"");
            }
            if (this.responseParameterMap != null) {
                this.write(",\"");
                this.write(PARAMETERS_ATTRIBUTE);
                this.write("\":");
                this.write(MapHelper.parameterMapToJSON(this.responseParameterMap));
            }
            if (this.durationRequested) {
                this.write(",\"");
                this.write(DURATION_ATTRIBUTE);
                this.write("\":\"");
                this.write(String.valueOf(System.currentTimeMillis() - this.durationStart));
                this.write("\"");
            }
            this.write("}");
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeJSONResponsePostMeta: " + e);
        }
    }

    private void writeXMLResponsePreMeta(String content, int error) throws Exception {
        String eLabel = "XSTROMAResponseWriter.writeXMLResponsePreMeta: ";
        if (this.omitPrefix) {
            return;
        }
        try {
            this.write("<");
            this.write(RESPONSE_ATTRIBUTE);
            this.write(" ");
            this.writeXMLAttribute(SERVICE_ATTRIBUTE, this.serviceName, true);
            if (this.serviceAgent != null) {
                this.writeXMLAttribute("service-agent", StringEscapeUtils.escapeXml((String)this.serviceAgent), true);
            }
            if (this.transactionData != null) {
                this.writeXMLAttribute(TRANSACTION_DATA_ATTRIBUTE, StringEscapeUtils.escapeXml((String)this.transactionData), true);
            }
            this.writeXMLAttribute(ERROR_CODE_ATTRIBUTE, "0", false);
            this.write(">");
        }
        catch (Exception e) {
            throw new Exception("XSTROMAResponseWriter.writeXMLResponsePreMeta: " + e);
        }
    }

    private void writeXMLResponsePostMeta() throws Exception {
        String eLabel = "STROMAResponseWriter.writeXMLResponsePostMeta: ";
        if (this.omitSuffix) {
            return;
        }
        try {
            if (this.writeOrchestrationFault) {
                this.write("<");
                this.write(ORCHESTRATION_FAULT_ENCOUNTERED_ATTRIBUTE);
                this.write("/>");
            }
            if (this.responseParameterMap != null) {
                this.write("<");
                this.write(PARAMETERS_ATTRIBUTE);
                this.write(">");
                this.write(MapHelper.parameterMapToXML(this.responseParameterMap, "parameter"));
                this.write("</");
                this.write(PARAMETERS_ATTRIBUTE);
                this.write(">");
            }
            if (this.durationRequested) {
                this.write("<");
                this.write(DURATION_ATTRIBUTE);
                this.write(" ");
                this.writeXMLAttribute("val", String.valueOf(System.currentTimeMillis() - this.durationStart), false);
                this.write("/>");
            }
            this.write("</");
            this.write(RESPONSE_ATTRIBUTE);
            this.write(">");
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeXMLResponsePostMeta: " + e);
        }
    }

    private void writeXMLAttribute(String name, String value, boolean withSpaceAfter) throws Exception {
        String eLabel = "STROMAResponseWriter.writeXMLAttribute: ";
        try {
            this.write(name);
            this.write("=\"");
            this.write(StringEscapeUtils.escapeXml((String)value));
            this.write("\"");
            if (withSpaceAfter) {
                this.write(" ");
            }
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.writeXMLAttribute: " + e);
        }
    }

    private void write(String toWrite) throws Exception {
        String eLabel = "STROMAResponseWriter.write: ";
        try {
            this.outputStream.write(toWrite.getBytes());
        }
        catch (Exception e) {
            throw new Exception("STROMAResponseWriter.write: " + e);
        }
    }

    public void writeOrchestrationFault(boolean writeOrchestrationFault) {
        this.writeOrchestrationFault = writeOrchestrationFault;
    }

    public void setOmitPrefix(boolean omitPrefix) {
        this.omitPrefix = omitPrefix;
    }

    public void setOmitSuffix(boolean omitSuffix) {
        this.omitSuffix = omitSuffix;
    }
}

