/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.stroma.xstroma;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.stroma.STROMAServiceRequest;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.json.JSONObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class STROMARequest
extends STROMAServiceRequest {
    private static final String BASE_PARAMETERS = "parameters";

    public STROMARequest(String serviceName, MetaTypeEnum metaTypeEnum, Map<String, List<String>> params, String data) throws Exception {
        super(serviceName, metaTypeEnum, params, data);
    }

    public STROMARequest(String serviceName, Map<String, List<String>> params, String data) throws Exception {
        super(serviceName, MetaTypeEnum.JSON, params, data);
    }

    public STROMARequest(Node stromaRequest) throws Exception {
        this.serviceName = XMLComparitor.getAttribute(stromaRequest, "service");
        Vector<Node> parametersNodeVector = XMLComparitor.getMatchingChildNodes(stromaRequest, BASE_PARAMETERS);
        if (parametersNodeVector.size() > 0) {
            this.parameters = MapHelper.parameterMapFromMetaObject(parametersNodeVector.firstElement().getChildNodes());
        }
        StringBuilder dataBuilder = new StringBuilder();
        NodeList dataNodes = stromaRequest.getChildNodes();
        for (int i = 0; i < dataNodes.getLength(); ++i) {
            if (dataNodes.item(i).getNodeName().equals(BASE_PARAMETERS)) continue;
            dataBuilder.append(XMLComparitor.nodeToString(dataNodes.item(i), false, false));
        }
        this.data = dataBuilder.toString();
    }

    public STROMARequest(JSONObject stromaRequest) throws Exception {
        this.serviceName = stromaRequest.getString("service");
        JSONObject dataSection = stromaRequest.getJSONObject("data");
        this.parameters = MapHelper.parameterMapFromMetaObject(dataSection.getJSONArray(BASE_PARAMETERS));
        dataSection.remove(BASE_PARAMETERS);
        StringBuilder dataBuilder = new StringBuilder(dataSection.toString());
        dataBuilder.deleteCharAt(0);
        dataBuilder.deleteCharAt(dataBuilder.length() - 1);
        this.data = dataBuilder.length() > 0 ? dataBuilder.toString() : null;
    }

    public static STROMARequest parse(Node stromaRequest) throws Exception {
        return new STROMARequest(stromaRequest);
    }

    public static STROMARequest parse(JSONObject stromaRequest) throws Exception {
        return new STROMARequest(stromaRequest);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, List<String>> parameters) {
        this.parameters = parameters;
    }

    public String toJSONString() throws Exception {
        String eLabel = "STROMARequest.toRequestString: ";
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("{\"service\":\"").append(this.serviceName);
            builder.append("\",\"data\":");
            this.generateJSONData(builder);
            builder.append("}");
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("STROMARequest.toRequestString: " + e);
        }
    }

    public String toXMLString() throws Exception {
        String eLabel = "STROMARequest.toRequestString: ";
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("<request ");
            builder.append("service=\"").append(this.serviceName).append("\">");
            this.generateXMLData(builder);
            builder.append("</request>");
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("STROMARequest.toRequestString: " + e);
        }
    }

    public String generateData() throws Exception {
        StringBuilder sb = new StringBuilder();
        if (this.metaTypeEnum.equals((Object)MetaTypeEnum.XML)) {
            sb.append("<data>");
            this.generateXMLData(sb);
            sb.append("</data>");
        } else {
            this.generateJSONData(sb);
        }
        return sb.toString();
    }

    private String generateJSONData(StringBuilder builder) throws Exception {
        String eLabel = "STROMARequest.generateJSONData: ";
        try {
            builder.append("{\"").append(BASE_PARAMETERS).append("\":");
            builder.append(MapHelper.parameterMapToJSON(this.parameters));
            if (this.data != null) {
                builder.append(",");
                builder.append(this.data);
            }
            builder.append("}");
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("STROMARequest.generateJSONData: " + e);
        }
    }

    private String generateXMLData(StringBuilder builder) throws Exception {
        String eLabel = "STROMARequest.generateXMLData: ";
        try {
            builder.append("<").append(BASE_PARAMETERS).append(">");
            builder.append(MapHelper.parameterMapToXML(this.parameters, "parameter"));
            builder.append("</").append(BASE_PARAMETERS).append(">");
            if (this.data != null) {
                builder.append(this.data);
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new Exception("STROMARequest.generateXMLData: " + e);
        }
    }
}

