/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.nyxlet.NyxletRepository;
import org.cyclades.engine.nyxlet.templates.stroma.STROMANyxlet;
import org.cyclades.engine.nyxlet.templates.xstroma.OrchestrationTypeEnum;
import org.cyclades.engine.stroma.STROMAResponseWriter;
import org.cyclades.engine.stroma.xstroma.XSTROMAResponseWriter;
import org.cyclades.engine.util.SendMail;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Node;

public class XSTROMANyxlet
extends STROMANyxlet {
    private boolean emailDisabled;
    private String emailSMTPHost;
    private String emailFrom;
    private String emailSubject;
    private static final String EMAIL_DISABLED = "emailDisabled";
    private static final String EMAIL_SMTP_HOST = "emailSMTPHost";
    private static final String EMAIL_FROM = "emailFrom";
    private static final String EMAIL_SUBJECT = "emailSubject";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String META_ATTRIBUTE = "data";
    private static final String REQUESTS_ATTRIBUTE = "requests";
    private static final String REQUEST_ATTRIBUTE = "request";
    public static final String RESPECT_ORCHESTRATION_FAULT_ATTRIBUTE = "enable-orchestration-fault";
    private static final String CHAINING_MODE = "chain";
    private static final String ASYNC = "asynchronous";
    private static final String NOTIFICATION_LIST = "notify";
    public static final String MERGE_COUNT = "merge-count";
    public static final String MERGE_TOTAL = "merge-total";

    @Override
    public void loadActionHandlers(Set<Map.Entry<Object, Object>> actionHandlerEntrySet) throws Exception {
    }

    @Override
    public byte[] process(NyxletSession sessionDelegate) throws CycladesException {
        String eLabel = "XSTROMANyxlet.process: ";
        try {
            this.processXSTROMARequest(sessionDelegate);
            return null;
        }
        catch (Exception e) {
            this.logError("XSTROMANyxlet.process: " + e, new Throwable[0]);
            try {
                return this.handleError(ResponseCodeEnum.GENERAL_ERROR.getCode(), e);
            }
            catch (Exception ex) {
                throw new CycladesException("XSTROMANyxlet.process: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processXSTROMARequest(NyxletSession sessionDelegate) throws Exception {
        boolean respectOrchestrationFault;
        boolean chainServiceRequests;
        int statusCode;
        String transData;
        String notificationList;
        boolean async;
        ByteArrayOutputStream baos;
        XSTROMAResponseWriter xstromaResponseWriter;
        OutputStream liveOutputStream;
        block51: {
            JSONArray requests;
            boolean moreToMerge;
            OutputStream workingOutputStream;
            block50: {
                String eLabel = "XSTROMANyxlet.processXSTROMARequest: ";
                sessionDelegate.setRawResponseRequested(false);
                liveOutputStream = sessionDelegate.getOutputStream();
                workingOutputStream = null;
                xstromaResponseWriter = new XSTROMAResponseWriter(this.getName(), sessionDelegate, this);
                baos = new ByteArrayOutputStream();
                async = false;
                notificationList = null;
                transData = sessionDelegate.getTransactionDataString();
                statusCode = 200;
                int mergeCount = -1;
                int mergeTotal = -1;
                moreToMerge = false;
                try {
                    String mergeCountString = sessionDelegate.getParameter(MERGE_COUNT);
                    String mergeTotalString = sessionDelegate.getParameter(MERGE_TOTAL);
                    if (mergeCountString != null && mergeTotalString != null) {
                        mergeCount = Integer.parseInt(mergeCountString);
                        mergeTotal = Integer.parseInt(mergeTotalString);
                        if (mergeCount == 0) {
                            if (mergeTotal > 0) {
                                moreToMerge = true;
                                xstromaResponseWriter.setOmitSuffix(true);
                            }
                        } else if (mergeCount >= mergeTotal) {
                            xstromaResponseWriter.setOmitPrefix(true);
                        } else if (mergeCount > 0) {
                            moreToMerge = true;
                            xstromaResponseWriter.setOmitPrefix(true);
                            xstromaResponseWriter.setOmitSuffix(true);
                        }
                    }
                    sessionDelegate.setResponseContentType(sessionDelegate.getDataContentType());
                    if (sessionDelegate.getDataObject() == null) {
                        throw new Exception("Error, no data detected");
                    }
                    Object metaObject = sessionDelegate.getDataObject();
                    String chainingMode = sessionDelegate.getParameter(CHAINING_MODE);
                    chainServiceRequests = chainingMode != null && chainingMode.equalsIgnoreCase("true");
                    sessionDelegate.setOrchestrationTypeEnum(chainServiceRequests ? OrchestrationTypeEnum.CHAINED_ORCHESTRATION : OrchestrationTypeEnum.COMPOSED_ORCHESTRATION);
                    respectOrchestrationFault = false;
                    String respestOrchestrationFaultString = sessionDelegate.getParameter(RESPECT_ORCHESTRATION_FAULT_ATTRIBUTE);
                    if (respestOrchestrationFaultString != null && respestOrchestrationFaultString.equalsIgnoreCase("true") || chainServiceRequests) {
                        respectOrchestrationFault = true;
                    }
                    boolean bl = async = sessionDelegate.getParameter(ASYNC) != null && sessionDelegate.getParameter(ASYNC).equalsIgnoreCase("true");
                    if (!async && !chainServiceRequests) {
                        liveOutputStream = xstromaResponseWriter.getOutputStream();
                    }
                    if (async) {
                        liveOutputStream.close();
                        liveOutputStream = new OutputStream(){

                            @Override
                            public void write(int b) {
                            }
                        };
                        notificationList = sessionDelegate.getParameter(NOTIFICATION_LIST);
                    }
                    OutputStream outputStream = workingOutputStream = chainServiceRequests ? baos : liveOutputStream;
                    if (sessionDelegate.getMetaTypeEnum().equals((Object)MetaTypeEnum.JSON)) {
                        requests = ((JSONObject)metaObject).getJSONArray(REQUESTS_ATTRIBUTE);
                        break block50;
                    }
                    if (!sessionDelegate.getMetaTypeEnum().equals((Object)MetaTypeEnum.XML)) throw new Exception("Undefined meta type: " + metaObject.getClass().getName());
                    Vector<Node> requestsElements = XMLComparitor.getMatchingChildNodes((Node)metaObject, REQUESTS_ATTRIBUTE);
                    if (requestsElements.size() < 1) {
                        throw new Exception("No \"requests\" element found");
                    }
                    Vector<Node> requestElements = XMLComparitor.getMatchingChildNodes(requestsElements.firstElement(), REQUEST_ATTRIBUTE);
                    String malformedRequestError = "Malformed service request...field missing: ";
                    for (int i = 0; i < requestElements.size(); ++i) {
                        Node requestElement = requestElements.get(i);
                        String serviceName = XMLComparitor.getAttribute(requestElement, SERVICE_ATTRIBUTE);
                        if (serviceName == null) throw new Exception("Malformed service request...field missing: service");
                        if (serviceName.isEmpty()) {
                            throw new Exception("Malformed service request...field missing: service");
                        }
                        if (chainServiceRequests) {
                            sessionDelegate.setChainsForward(true);
                            sessionDelegate.setPortData(baos.toByteArray());
                            baos.reset();
                            if (i == requestElements.size() - 1 && !moreToMerge) {
                                sessionDelegate.setChainsForward(false);
                                workingOutputStream = liveOutputStream;
                            }
                        }
                        if (i < requestElements.size() - 1 || moreToMerge) {
                            sessionDelegate.setIsLast(false);
                        } else {
                            sessionDelegate.setIsLast(true);
                        }
                        if (this.dispatchNyxletRequest(serviceName, requestElement, sessionDelegate.setOutputStream(workingOutputStream)) && respectOrchestrationFault) {
                            if (chainServiceRequests) {
                                statusCode = 500;
                                sessionDelegate.setResponseStatus(500);
                            }
                            break block51;
                        }
                        if (!sessionDelegate.getResponseMetaTypeEnum().equals((Object)MetaTypeEnum.JSON) || chainServiceRequests || i >= requestElements.size() - 1 && !moreToMerge) continue;
                        workingOutputStream.write(",".getBytes());
                    }
                    break block51;
                }
                catch (Exception e) {
                    try {
                        this.logError("XSTROMANyxlet.processXSTROMARequest: " + e, new Throwable[0]);
                        sessionDelegate.setActionObject(null);
                        sessionDelegate.setTransactionDataObject(null);
                        sessionDelegate.setUserLoggingLevel(null);
                        sessionDelegate.raiseOrchestrationFault("XSTROMANyxlet.processXSTROMARequest: " + e);
                        new STROMAResponseWriter(this.getName(), sessionDelegate, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "XSTROMANyxlet.processXSTROMARequest: " + e);
                    }
                    catch (Throwable throwable) {
                        try {
                            baos.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        try {
                            sessionDelegate.setOutputStream(liveOutputStream);
                        }
                        catch (Exception e3) {
                            // empty catch block
                        }
                        try {
                            if (this.emailDisabled) throw throwable;
                            if (notificationList == null) throw throwable;
                            StringBuilder sb = new StringBuilder("transaction-data");
                            sb.append(":[").append(transData).append("] statuscode:[").append(statusCode).append("]");
                            SendMail.sendMessage(notificationList, this.emailFrom, this.emailSMTPHost, this.emailSubject, sb.toString());
                            throw throwable;
                        }
                        catch (Exception e4) {
                            this.logError("XSTROMANyxlet.processXSTROMARequest: " + e4, new Throwable[0]);
                        }
                        throw throwable;
                    }
                    try {
                        baos.close();
                    }
                    catch (Exception e5) {
                        // empty catch block
                    }
                    try {
                        sessionDelegate.setOutputStream(liveOutputStream);
                    }
                    catch (Exception e6) {
                        // empty catch block
                    }
                    try {
                        if (this.emailDisabled) return;
                        if (notificationList == null) return;
                        StringBuilder sb = new StringBuilder("transaction-data");
                        sb.append(":[").append(transData).append("] statuscode:[").append(statusCode).append("]");
                        SendMail.sendMessage(notificationList, this.emailFrom, this.emailSMTPHost, this.emailSubject, sb.toString());
                        return;
                    }
                    catch (Exception e7) {
                        this.logError("XSTROMANyxlet.processXSTROMARequest: " + e7, new Throwable[0]);
                        return;
                    }
                }
            }
            for (int i = 0; i < requests.length(); ++i) {
                String serviceName = requests.getJSONObject(i).getString(SERVICE_ATTRIBUTE);
                JSONObject requestMeta = requests.getJSONObject(i).getJSONObject(META_ATTRIBUTE);
                if (chainServiceRequests) {
                    sessionDelegate.setChainsForward(true);
                    sessionDelegate.setPortData(baos.toByteArray());
                    baos.reset();
                    if (i == requests.length() - 1 && !moreToMerge) {
                        sessionDelegate.setChainsForward(false);
                        workingOutputStream = liveOutputStream;
                    }
                }
                if (i < requests.length() - 1 || moreToMerge) {
                    sessionDelegate.setIsLast(false);
                } else {
                    sessionDelegate.setIsLast(true);
                }
                if (this.dispatchNyxletRequest(serviceName, requestMeta, sessionDelegate.setOutputStream(workingOutputStream)) && respectOrchestrationFault) {
                    if (!chainServiceRequests) break;
                    statusCode = 500;
                    sessionDelegate.setResponseStatus(500);
                    break;
                }
                if (!sessionDelegate.getResponseMetaTypeEnum().equals((Object)MetaTypeEnum.JSON) || chainServiceRequests || i >= requests.length() - 1 && !moreToMerge) continue;
                workingOutputStream.write(",".getBytes());
            }
        }
        if (!async && !chainServiceRequests) {
            xstromaResponseWriter.writeOrchestrationFault(sessionDelegate.orchestrationFaultRaised() && respectOrchestrationFault);
            xstromaResponseWriter.done();
        }
        try {
            baos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sessionDelegate.setOutputStream(liveOutputStream);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.emailDisabled) return;
            if (notificationList == null) return;
            StringBuilder sb = new StringBuilder("transaction-data");
            sb.append(":[").append(transData).append("] statuscode:[").append(statusCode).append("]");
            SendMail.sendMessage(notificationList, this.emailFrom, this.emailSMTPHost, this.emailSubject, sb.toString());
            return;
        }
        catch (Exception e) {
            this.logError("XSTROMANyxlet.processXSTROMARequest: " + e, new Throwable[0]);
            return;
        }
    }

    private boolean dispatchNyxletRequest(String requestName, Object requestMeta, NyxletSession nyxletSession) throws Exception {
        String eLabel = "XSTROMANyxlet.dispatchNxletRequest: ";
        try {
            nyxletSession.setActionObject(null);
            nyxletSession.setTransactionDataObject(null);
            nyxletSession.setUserLoggingLevel(null);
            nyxletSession.clearOrchestrationFault();
            nyxletSession.setDurationRequested(null);
            nyxletSession.resetDuration();
            nyxletSession.setServiceAgentRequested(null);
            nyxletSession.setDataObject(requestMeta);
            Nyxlet mod = NyxletRepository.getStaticInstance().getNyxlet(requestName);
            if (mod == null) {
                StringBuilder sb = new StringBuilder("XSTROMANyxlet.dispatchNxletRequest: ");
                sb.append("Nyxlet not found: ");
                sb.append(requestName);
                throw new CycladesException(sb.toString(), ResponseCodeEnum.SERVICE_NOT_FOUND.getCode(), "Nyxlet not found: ", requestName);
            }
            mod.process(nyxletSession);
        }
        catch (Exception e) {
            this.logError("XSTROMANyxlet.dispatchNxletRequest: " + e, new Throwable[0]);
            nyxletSession.raiseOrchestrationFault("XSTROMANyxlet.dispatchNxletRequest: " + e);
            new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "XSTROMANyxlet.dispatchNxletRequest: " + e);
        }
        return nyxletSession.orchestrationFaultRaised();
    }

    @Override
    public void init() throws CycladesException {
        String eLabel = "XSTROMANyxlet.init: ";
        try {
            super.init();
            this.emailDisabled = this.getExternalProperties().containsKey(EMAIL_DISABLED) ? this.getExternalProperties().getProperty(EMAIL_DISABLED).equalsIgnoreCase("true") : false;
            this.emailSMTPHost = this.getExternalProperties().containsKey(EMAIL_SMTP_HOST) ? this.getExternalProperties().getProperty(EMAIL_SMTP_HOST) : "localhost";
            this.emailFrom = this.getExternalProperties().containsKey(EMAIL_FROM) ? this.getExternalProperties().getProperty(EMAIL_FROM) : "cyclades@" + InetAddress.getLocalHost().getHostName();
            this.emailSubject = this.getExternalProperties().containsKey(EMAIL_SUBJECT) ? this.getExternalProperties().getProperty(EMAIL_SUBJECT) : "Cyclades X-STROMA Response Status: " + InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new CycladesException("XSTROMANyxlet.init: " + e);
        }
    }

    @Override
    public void destroy() throws CycladesException {
        super.destroy();
    }
}

