/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet.templates.xstroma;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.adapter.HttpServletRequestAdapter;
import org.cyclades.engine.adapter.HttpServletResponseAdapter;
import org.cyclades.engine.exception.AuthException;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.nyxlet.templates.xstroma.XSTROMANyxlet;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.RawMessageProducer;
import org.cyclades.engine.nyxlet.templates.xstroma.message.api.StreamingMessageProducer;
import org.cyclades.engine.nyxlet.templates.xstroma.target.ConsumerTarget;
import org.cyclades.engine.nyxlet.templates.xstroma.target.ProducerTarget;
import org.cyclades.engine.stroma.STROMAResponseWriter;
import org.cyclades.engine.stroma.xstroma.XSTROMAResponseWriter;
import org.cyclades.engine.util.GenericXMLObject;
import org.cyclades.engine.util.JSON;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.json.JSONObject;

public class ServiceBrokerNyxletImpl
extends XSTROMANyxlet {
    protected Map<String, ProducerTarget> producerTargetMap = new HashMap<String, ProducerTarget>();
    protected List<ConsumerTarget> consumerTargetList = new ArrayList<ConsumerTarget>();
    private boolean allowXSTROMAMessageTargets = false;
    public static final String PRODUCER_TARGETS = "serviceProducerTargets";
    public static final String PRODUCER_TARGET_ALIASES = "serviceProducerTargetAliases";
    public static final String CONSUMER_TARGETS = "serviceConsumerTargets";
    public static final String TARGET = "target";
    public static final String XSTROMA_MESSAGE = "x-stroma-message";
    public static final String BASE_PARAMETERS = "parameters";
    public static final String DATA_PARAMETER = "data";

    public ServiceBrokerNyxletImpl() throws Exception {
    }

    public ServiceBrokerNyxletImpl(int dummy) throws Exception {
        this.setName("ServiceBrokerNyxlet-JUNIT");
    }

    @Override
    public byte[] process(NyxletSession nyxletSession) throws CycladesException {
        String eLabel = "ServiceBrokerNyxlet.process: ";
        try {
            nyxletSession.setRawResponseRequested(false);
            nyxletSession.setResponseContentType(nyxletSession.getDataContentType());
            String temp = nyxletSession.getParameter(XSTROMA_MESSAGE);
            if (temp != null) {
                this.processXSTROMAMessagePayload(nyxletSession.getOutputStream(), temp.isEmpty() ? new String(ByteStreams.toByteArray((InputStream)nyxletSession.getInputStream())) : temp);
                return null;
            }
            temp = nyxletSession.getParameter(TARGET);
            if (temp != null && !this.producerTargetMap.containsKey(temp)) {
                throw new Exception("Target not found: " + temp);
            }
            if (temp == null || this.producerTargetMap.get(temp).isLocal()) {
                ProducerTarget theTargetQueue;
                if (temp != null && (theTargetQueue = this.producerTargetMap.get(temp)) != null && !theTargetQueue.auth(nyxletSession)) {
                    throw new AuthException("ServiceBrokerNyxlet.process: User authorization invalid ", ResponseCodeEnum.AUTHORIZATION_FAILED.getCode(), "User authorization invalid ", null);
                }
                this.processXSTROMARequest(nyxletSession);
            } else if (this.producerTargetMap.get(temp).getMessageProducer() instanceof RawMessageProducer) {
                this.sendRawMessage(nyxletSession, temp);
            } else {
                this.sendXSTROMAMessage(nyxletSession, temp);
            }
            return null;
        }
        catch (Exception e) {
            this.logStackTrace(e);
            try {
                nyxletSession.raiseOrchestrationFault("ServiceBrokerNyxlet.process: " + e);
                new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "ServiceBrokerNyxlet.process: " + e);
                return null;
            }
            catch (Exception ex) {
                throw new CycladesException("ServiceBrokerNyxlet.process: " + ex);
            }
        }
    }

    private void sendRawMessage(NyxletSession nyxletSession, String target) throws Exception {
        String eLabel = "ServiceBrokerNyxlet.sendRawMessage: ";
        try {
            byte[] incomingMessage;
            String metaString = nyxletSession.getParameter(DATA_PARAMETER);
            byte[] byArray = metaString != null && !metaString.isEmpty() ? metaString.getBytes() : (incomingMessage = nyxletSession.getInputStream() != null ? ByteStreams.toByteArray((InputStream)nyxletSession.getInputStream()) : null);
            if (incomingMessage == null) {
                throw new Exception("Error, parameter \"data\" not detected");
            }
            ProducerTarget producerTarget = this.validateAndGetProducerTarget(nyxletSession, target);
            Map<String, List<String>> requestParameters = nyxletSession.getParameterMap();
            if (producerTarget.forwardAuthData()) {
                requestParameters.putAll(producerTarget.getAuthDataMap(nyxletSession));
            }
            this.engageProducerTarget(nyxletSession, producerTarget, incomingMessage, requestParameters);
        }
        catch (Exception e) {
            this.logStackTrace(e);
            nyxletSession.setActionObject(null);
            nyxletSession.setTransactionDataObject(null);
            nyxletSession.raiseOrchestrationFault("ServiceBrokerNyxlet.sendRawMessage: " + e);
            new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "ServiceBrokerNyxlet.sendRawMessage: " + e);
        }
    }

    private void engageProducerTarget(NyxletSession nyxletSession, ProducerTarget producerTarget, byte[] messagePayload, Map<String, List<String>> requestParameters) throws Exception {
        String eLabel = "ServiceBrokerNyxlet.engageProducerTarget(Raw Message): ";
        try {
            byte[] messageResponse = ((RawMessageProducer)producerTarget.getMessageProducer()).sendMessage(messagePayload, requestParameters);
            if (messageResponse == null) {
                new XSTROMAResponseWriter(this.getName(), nyxletSession, this).writeResponse("");
            } else {
                nyxletSession.setResponseContentType("application/octet-stream");
                nyxletSession.getOutputStream().write(messageResponse);
            }
        }
        catch (Exception e) {
            throw new Exception("ServiceBrokerNyxlet.engageProducerTarget(Raw Message): " + e);
        }
    }

    private void sendXSTROMAMessage(NyxletSession nyxletSession, String target) throws Exception {
        String eLabel = "ServiceBrokerNyxlet.sendXSTROMAMessage: ";
        try {
            nyxletSession.setResponseContentType(nyxletSession.getDataContentType());
            String metaString = nyxletSession.getParameter(DATA_PARAMETER);
            if (metaString == null && nyxletSession.getInputStream() != null) {
                metaString = new String(ByteStreams.toByteArray((InputStream)nyxletSession.getInputStream()));
            }
            if (metaString == null || metaString.isEmpty()) {
                throw new Exception("Error, parameter \"data\" not detected");
            }
            ProducerTarget producerTarget = this.validateAndGetProducerTarget(nyxletSession, target);
            StringBuilder messagePayload = new StringBuilder();
            Map<String, List<String>> requestParameters = nyxletSession.getParameterMap();
            if (!this.allowXSTROMAMessageTargets) {
                requestParameters.remove(TARGET);
            }
            if (producerTarget.forwardAuthData()) {
                requestParameters.putAll(producerTarget.getAuthDataMap(nyxletSession));
            }
            if (nyxletSession.getMetaTypeEnum().equals((Object)MetaTypeEnum.JSON)) {
                requestParameters.remove(DATA_PARAMETER);
                messagePayload.append("{\"").append(BASE_PARAMETERS).append("\":");
                messagePayload.append(MapHelper.parameterMapToJSON(requestParameters));
                messagePayload.append(",\"").append(DATA_PARAMETER).append("\":");
                messagePayload.append(metaString);
                messagePayload.append("}");
            } else {
                messagePayload.append("<x-stroma>");
                messagePayload.append(metaString);
                messagePayload.append("<").append(BASE_PARAMETERS).append(">");
                requestParameters.remove(DATA_PARAMETER);
                messagePayload.append(MapHelper.parameterMapToXML(requestParameters, BASE_PARAMETERS));
                messagePayload.append("</").append(BASE_PARAMETERS).append("></x-stroma>");
            }
            this.engageProducerTarget(nyxletSession, producerTarget, messagePayload.toString(), requestParameters);
        }
        catch (Exception e) {
            this.logStackTrace(e);
            nyxletSession.setActionObject(null);
            nyxletSession.setTransactionDataObject(null);
            nyxletSession.raiseOrchestrationFault("ServiceBrokerNyxlet.sendXSTROMAMessage: " + e);
            new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "ServiceBrokerNyxlet.sendXSTROMAMessage: " + e);
        }
    }

    private ProducerTarget validateAndGetProducerTarget(NyxletSession nyxletSession, String target) throws Exception {
        ProducerTarget producerTarget = this.producerTargetMap.get(target);
        if (producerTarget == null) {
            throw new Exception("Target not found: " + target);
        }
        if (!producerTarget.auth(nyxletSession)) {
            throw new AuthException("Target authorization invalid " + target, ResponseCodeEnum.AUTHORIZATION_FAILED.getCode(), "Target authorization invalid " + target, target);
        }
        return producerTarget;
    }

    private void engageProducerTarget(NyxletSession nyxletSession, ProducerTarget producerTarget, String messagePayload, Map<String, List<String>> requestParameters) throws Exception {
        String eLabel = "ServiceBrokerNyxlet.engageProducerTarget: ";
        try {
            if (producerTarget.getMessageProducer() instanceof StreamingMessageProducer) {
                ((StreamingMessageProducer)producerTarget.getMessageProducer()).sendMessage(messagePayload, requestParameters, nyxletSession.getOutputStream());
            } else {
                String messageResponse = producerTarget.getMessageProducer().sendMessage(messagePayload, requestParameters);
                if (messageResponse == null) {
                    new XSTROMAResponseWriter(this.getName(), nyxletSession, this).writeResponse("");
                } else {
                    nyxletSession.getOutputStream().write(messageResponse.getBytes());
                }
            }
        }
        catch (Exception e) {
            throw new Exception("ServiceBrokerNyxlet.engageProducerTarget: " + e);
        }
    }

    public NyxletSession processXSTROMAMessagePayload(OutputStream out, String messageString) throws Exception {
        String eLabel = "ServiceBrokerNyxlet.processXSTROMAMessagePayload: ";
        NyxletSession nyxletSession = null;
        try {
            Map<String, List<String>> requestParameters;
            HttpServletRequestAdapter request = null;
            HttpServletResponseAdapter response = new HttpServletResponseAdapter(out);
            if (messageString.charAt(0) == '<') {
                GenericXMLObject xmlObject = new GenericXMLObject(messageString);
                requestParameters = MapHelper.parameterMapFromMetaObject(XMLComparitor.getMatchingChildNodes(xmlObject.getRootElement(), BASE_PARAMETERS).firstElement().getChildNodes());
                requestParameters.put(DATA_PARAMETER, new ArrayList<String>(Arrays.asList("")));
                request = new HttpServletRequestAdapter(new HashMap<String, String>(), MapHelper.arrayParameterMapFromParameterMap(requestParameters), new HashMap<String, Object>(), null);
                nyxletSession = new NyxletSession(request, response, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
                nyxletSession.setDataObject(XMLComparitor.getMatchingChildNodes(xmlObject.getRootElement(), DATA_PARAMETER).firstElement());
            } else {
                JSONObject jsonObject = new JSONObject(messageString);
                requestParameters = MapHelper.parameterMapFromMetaObject(jsonObject.getJSONArray(BASE_PARAMETERS));
                requestParameters.put(DATA_PARAMETER, new ArrayList<String>(Arrays.asList("")));
                request = new HttpServletRequestAdapter(new HashMap<String, String>(), MapHelper.arrayParameterMapFromParameterMap(requestParameters), new HashMap<String, Object>(), null);
                nyxletSession = new NyxletSession(request, response, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
                nyxletSession.setDataObject(jsonObject.getJSONObject(DATA_PARAMETER));
            }
            ProducerTarget producerTarget = null;
            if (requestParameters.containsKey(TARGET)) {
                if (!this.allowXSTROMAMessageTargets) {
                    throw new Exception("This broker has not been configured to allow targets embedded in X-STROMA messages");
                }
                producerTarget = this.validateAndGetProducerTarget(nyxletSession, requestParameters.get(TARGET).get(0));
            }
            if (producerTarget == null || producerTarget.isLocal()) {
                this.processXSTROMARequest(nyxletSession);
            } else {
                this.engageProducerTarget(nyxletSession, producerTarget, messageString, requestParameters);
            }
        }
        catch (Exception e) {
            this.logWarn("ServiceBrokerNyxlet.processXSTROMAMessagePayload: " + e + " Possibly a malformed X-STROMA request:[" + messageString + "]", new Throwable[0]);
            if (nyxletSession == null) {
                nyxletSession = new NyxletSession(new HttpServletRequestAdapter(new HashMap<String, String>(), new HashMap<String, String[]>(), new HashMap<String, Object>(), null), new HttpServletResponseAdapter(out), null, out);
            }
            nyxletSession.raiseOrchestrationFault("ServiceBrokerNyxlet.processXSTROMAMessagePayload: " + e);
            new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "ServiceBrokerNyxlet.processXSTROMAMessagePayload: " + e);
        }
        return nyxletSession;
    }

    public NyxletSession processXSTROMAMessagePayloads(OutputStream out, List<String> messageList, MetaTypeEnum metaTypeEnum) throws Exception {
        String eLabel = "ServiceBrokerNyxlet.processXSTROMAMessagePayloads: ";
        NyxletSession nyxletSession = null;
        try {
            HttpServletRequestAdapter request = new HttpServletRequestAdapter(new HashMap<String, String>(), null, new HashMap<String, Object>(), null);
            HttpServletResponseAdapter response = new HttpServletResponseAdapter(out);
            nyxletSession = new NyxletSession(request, response, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream());
            int currentMessageCount = 0;
            int messageTotal = messageList.size() - 1;
            for (String messageString : messageList) {
                Map<String, List<String>> requestParameters;
                if (metaTypeEnum.equals((Object)MetaTypeEnum.XML)) {
                    GenericXMLObject xmlObject = new GenericXMLObject(messageString);
                    requestParameters = MapHelper.parameterMapFromMetaObject(XMLComparitor.getMatchingChildNodes(xmlObject.getRootElement(), BASE_PARAMETERS).firstElement().getChildNodes());
                    requestParameters.put(DATA_PARAMETER, new ArrayList<String>(Arrays.asList("")));
                    requestParameters.put("merge-count", new ArrayList<String>(Arrays.asList(String.valueOf(currentMessageCount++))));
                    requestParameters.put("merge-total", new ArrayList<String>(Arrays.asList(String.valueOf(messageTotal))));
                    request.setParameterMap(MapHelper.arrayParameterMapFromParameterMap(requestParameters));
                    nyxletSession.setDataObject(XMLComparitor.getMatchingChildNodes(xmlObject.getRootElement(), DATA_PARAMETER).firstElement());
                } else {
                    JSONObject jsonObject = new JSONObject(messageString);
                    requestParameters = MapHelper.parameterMapFromMetaObject(jsonObject.getJSONArray(BASE_PARAMETERS));
                    requestParameters.put(DATA_PARAMETER, new ArrayList<String>(Arrays.asList("")));
                    requestParameters.put("merge-count", new ArrayList<String>(Arrays.asList(String.valueOf(currentMessageCount++))));
                    requestParameters.put("merge-total", new ArrayList<String>(Arrays.asList(String.valueOf(messageTotal))));
                    request.setParameterMap(MapHelper.arrayParameterMapFromParameterMap(requestParameters));
                    nyxletSession.setDataObject(jsonObject.getJSONObject(DATA_PARAMETER));
                }
                ProducerTarget producerTarget = null;
                if (requestParameters.containsKey(TARGET)) {
                    if (!this.allowXSTROMAMessageTargets) {
                        throw new Exception("This broker has not been configured to allow targets embedded in X-STROMA messages");
                    }
                    producerTarget = this.validateAndGetProducerTarget(nyxletSession, requestParameters.get(TARGET).get(0));
                }
                if (producerTarget == null || producerTarget.isLocal()) {
                    this.processXSTROMARequest(nyxletSession);
                    continue;
                }
                this.engageProducerTarget(nyxletSession, producerTarget, messageString, requestParameters);
            }
        }
        catch (Exception e) {
            this.logDebug("ServiceBrokerNyxlet.processXSTROMAMessagePayloads: " + e, new Throwable[0]);
            if (nyxletSession == null) {
                nyxletSession = new NyxletSession(new HttpServletRequestAdapter(new HashMap<String, String>(), new HashMap<String, String[]>(), new HashMap<String, Object>(), null), new HttpServletResponseAdapter(out), null, out);
            }
            nyxletSession.raiseOrchestrationFault("ServiceBrokerNyxlet.processXSTROMAMessagePayloads: " + e);
            new STROMAResponseWriter(this.getName(), nyxletSession, this).writeErrorResponse(e instanceof CycladesException ? ((CycladesException)e).getCode() : ResponseCodeEnum.GENERAL_ERROR.getCode(), "ServiceBrokerNyxlet.processXSTROMAMessagePayloads: " + e);
        }
        return nyxletSession;
    }

    @Override
    public void init() throws CycladesException {
        String eLabel = "ServiceBrokerNyxlet.init: ";
        try {
            super.init();
            this.producerTargetMap = ProducerTarget.loadTargets(JSON.resolveLinkedJSONObjects(this.getExternalProperties().getProperty(PRODUCER_TARGETS, "[]")), JSON.resolveLinkedJSONObjects(this.getExternalProperties().getProperty(PRODUCER_TARGET_ALIASES, "[]")), this);
            for (Map.Entry<String, ProducerTarget> entry : this.producerTargetMap.entrySet()) {
                this.logInfo("Service Producer Target Loaded: " + entry.getKey().toString() + " " + entry.getValue(), new Throwable[0]);
            }
            this.consumerTargetList = ConsumerTarget.loadTargets(JSON.resolveLinkedJSONObjects(this.getExternalProperties().getProperty(CONSUMER_TARGETS, "[]")), this);
            for (ConsumerTarget consumerTarget : this.consumerTargetList) {
                this.logInfo("Service Consumer Target Loaded: " + consumerTarget.toString(), new Throwable[0]);
            }
            String propertyVal = this.getExternalProperties().getProperty("allowXSTROMAMessageTargets");
            if (propertyVal != null) {
                this.allowXSTROMAMessageTargets = propertyVal.equalsIgnoreCase("true");
            }
        }
        catch (Exception e) {
            this.logStackTrace(e);
            throw new CycladesException("ServiceBrokerNyxlet.init: " + e);
        }
    }

    @Override
    public void destroy() throws CycladesException {
        String eLabel = "ServiceBrokerNyxlet.destroy: ";
        for (Map.Entry<String, ProducerTarget> entry : this.producerTargetMap.entrySet()) {
            this.logInfo("ServiceBrokerNyxlet.destroy: Destroying producer target: " + entry.getKey() + " " + entry.getValue(), new Throwable[0]);
            try {
                entry.getValue().destroy();
            }
            catch (Exception e) {
                this.logError("ServiceBrokerNyxlet.destroy: " + e, new Throwable[0]);
            }
        }
        for (ConsumerTarget consumerTarget : this.consumerTargetList) {
            this.logInfo("ServiceBrokerNyxlet.destroy: Destroying consumer target: " + consumerTarget, new Throwable[0]);
            try {
                consumerTarget.destroy();
            }
            catch (Exception e) {
                this.logError("ServiceBrokerNyxlet.destroy: " + e, new Throwable[0]);
            }
        }
        super.destroy();
    }

    @Override
    public boolean isHealthy() throws CycladesException {
        boolean failed = false;
        for (Map.Entry<String, ProducerTarget> entry : this.producerTargetMap.entrySet()) {
            try {
                if (entry.getValue().isHealthy()) continue;
                failed = true;
            }
            catch (Exception e) {
                this.logStackTrace(e);
                failed = true;
            }
        }
        for (ConsumerTarget consumerTarget : this.consumerTargetList) {
            try {
                if (consumerTarget.isHealthy()) continue;
                failed = true;
            }
            catch (Exception e) {
                this.logStackTrace(e);
                failed = true;
            }
        }
        return !failed;
    }
}

