/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.nyxlet;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.nyxlet.DeferredDelegationURLClassLoader;
import org.cyclades.engine.nyxlet.RESTfulDispatchServiceDelegateStrategy;
import org.cyclades.engine.util.GenericXMLObject;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.cyclades.xml.parser.XMLParserException;
import org.cyclades.xml.parser.api.XMLGeneratedObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NyxletRepository {
    static Logger logger = Logger.getLogger(NyxletRepository.class);
    private static AtomicReference<NyxletRepository> nyxletRepository = new AtomicReference<Object>(null);
    private ConcurrentHashMap<String, Nyxlet> nyxletRepositoryMap = new ConcurrentHashMap();
    private RESTfulDispatchServiceDelegateStrategy RRDStore = new RESTfulDispatchServiceDelegateStrategy();
    private ClassLoader globalClassLoader = null;
    private static final String NYXLET_MANIFEST = "nyxlet_manifest.xml";
    private static final String JAR_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String NYXLET_SUFFIX = ".nyxlet";

    public static NyxletRepository getStaticInstance() throws Exception {
        nyxletRepository.compareAndSet(null, new NyxletRepository());
        return nyxletRepository.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadNyxletFile(File nyxlet) throws Exception {
        String implied_nyxlet_name;
        String jarPath = nyxlet.getAbsolutePath();
        String nyxlet_file_name = Strings.nullToEmpty((String)nyxlet.getName()).trim();
        try {
            implied_nyxlet_name = nyxlet_file_name.substring(0, nyxlet_file_name.length() - 7);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new Exception("Invalid nyxlet file name '" + jarPath + "'");
        }
        XMLGeneratedObject xmlo = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            xmlo = new GenericXMLObject(this.getManifestXMLString(jarFile));
            Element rootElement = xmlo.getRootElement();
            if (rootElement == null) {
                throw new XMLParserException("Root element is null");
            }
            NodeList nyxletList = rootElement.getElementsByTagName("nyxlet");
            if (nyxletList.getLength() < 1) {
                throw new Exception("\"nyxlet\" element is not defined in manifest!");
            }
            Node nyxletXMLNode = nyxletList.item(0);
            String name = XMLComparitor.getAttributeOrError(nyxletXMLNode, "name");
            if (name == null) {
                throw new Exception("Invalid nyxlet_manifest.xml in '" + jarPath + "'");
            }
            if (!name.equals(implied_nyxlet_name)) {
                throw new Exception("In '" + jarPath + "' declared nyxlet name '" + name + "' does not match with nyxlet file name.");
            }
            Properties properties = this.getJarManifestProperties(jarFile);
            jarFile.close();
            jarFile = null;
            this.addNyxlet(Nyxlet.valueOf(nyxletXMLNode, this.loadLibrary(jarPath), properties));
        }
        finally {
            if (xmlo != null) {
                xmlo.cleanUp();
            }
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    private ClassLoader loadLibrary(String jarPath) throws Exception {
        File file = new File(jarPath);
        if (!file.exists()) {
            throw new Exception("File " + file.getName() + " does not exist.");
        }
        URL[] URLArray = new URL[]{new URL("file", null, jarPath)};
        if (this.globalClassLoader == null) {
            return new DeferredDelegationURLClassLoader(URLArray, this.getClass().getClassLoader());
        }
        this.globalClassLoader = new URLClassLoader(URLArray, this.globalClassLoader);
        return this.globalClassLoader;
    }

    private void addNyxlet(Nyxlet nyxlet) throws Exception {
        this.nyxletRepositoryMap.put(nyxlet.getName(), nyxlet);
        if (nyxlet.getRRDString() != null) {
            this.RRDStore.addServiceModule(nyxlet);
        }
    }

    private String getManifestXMLString(JarFile jarFile) throws Exception {
        String eLabel = "NyxletRepository.getManifestXMLString: ";
        FilterInputStream dis = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JarEntry jarEntry = (JarEntry)jarFile.getEntry(NYXLET_MANIFEST);
            if (jarEntry == null) {
                throw new Exception("Could not locate nyxlet_manifest.xml in jar file");
            }
            String string = new String(ByteStreams.toByteArray((InputStream)jarFile.getInputStream(jarEntry)));
            return string;
        }
        catch (Exception e) {
            throw new Exception("NyxletRepository.getManifestXMLString: " + e);
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception e) {}
            try {
                baos.close();
            }
            catch (Exception e) {}
        }
    }

    private Properties getJarManifestProperties(JarFile jarFile) throws Exception {
        String eLabel = "NyxletRepository.getJarManifestProperties: ";
        Properties jarManifestProperties = new Properties();
        try {
            JarEntry jarEntry = (JarEntry)jarFile.getEntry(JAR_MANIFEST);
            if (jarEntry != null) {
                jarManifestProperties.load(jarFile.getInputStream(jarEntry));
            }
            return jarManifestProperties;
        }
        catch (Exception e) {
            throw new Exception("NyxletRepository.getJarManifestProperties: " + e);
        }
    }

    public synchronized Set<String> keys() {
        return this.nyxletRepositoryMap.keySet();
    }

    public synchronized Nyxlet getNyxlet(Object key) {
        return this.nyxletRepositoryMap.get(key);
    }

    public Nyxlet getNyxletRRD(String RRDCategory, NyxletSession sessionDelegate) throws Exception {
        String eLabel = "NyxletRepository.getNyxletRRD: ";
        try {
            RESTfulDispatchServiceDelegateStrategy RRDStorePointer = this.getRRDStore();
            return RRDStorePointer.getServiceModuleMatch(RRDCategory, sessionDelegate);
        }
        catch (Exception e) {
            throw new Exception("NyxletRepository.getNyxletRRD: " + e);
        }
    }

    private synchronized RESTfulDispatchServiceDelegateStrategy getRRDStore() {
        return this.RRDStore;
    }

    public synchronized int reloadNyxletFiles(String[] nyxletDirectories, boolean failOnError, boolean isolatedClassLoader) throws Exception {
        this.destroy();
        return this.loadNyxletFiles(nyxletDirectories, failOnError, isolatedClassLoader);
    }

    public synchronized int loadNyxletFiles(String[] nyxletDirectories, boolean failOnError, boolean isolatedClassLoader) throws Exception {
        try {
            this.nyxletRepositoryMap = new ConcurrentHashMap();
            this.RRDStore = new RESTfulDispatchServiceDelegateStrategy();
            this.globalClassLoader = null;
            if (!isolatedClassLoader) {
                this.globalClassLoader = this.getClass().getClassLoader();
            }
            int loadedLibraryCount = 0;
            for (String nyxletDirectory : nyxletDirectories) {
                if (nyxletDirectory.startsWith("http")) {
                    logger.info((Object)("Skipping Nyxlet load of http URL (used to load properties only): " + nyxletDirectory));
                    continue;
                }
                File libDirectory = new File(nyxletDirectory);
                if (!libDirectory.exists()) {
                    throw new Exception("Directory " + nyxletDirectories + " does not exist!");
                }
                if (!libDirectory.isDirectory()) {
                    throw new Exception("Path " + nyxletDirectories + " is a file and not a directory!");
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Loading nyxlets from " + libDirectory.getAbsolutePath()));
                }
                File[] fileList = libDirectory.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    try {
                        if (!fileList[i].getName().endsWith(NYXLET_SUFFIX)) continue;
                        this.loadNyxletFile(fileList[i]);
                        ++loadedLibraryCount;
                        continue;
                    }
                    catch (Exception ex) {
                        if (failOnError) {
                            throw ex;
                        }
                        logger.error((Object)ex, (Throwable)ex);
                    }
                }
            }
            return loadedLibraryCount;
        }
        catch (Exception ex) {
            try {
                this.destroy();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.nyxletRepositoryMap.clear();
            this.RRDStore.clear();
            throw ex;
        }
    }

    public synchronized int size() {
        return this.nyxletRepositoryMap.size();
    }

    public synchronized void destroy() throws Exception {
        NyxletRepository ndr = NyxletRepository.getStaticInstance();
        for (String key : ndr.keys()) {
            ndr.getNyxlet(key).destroy();
        }
    }
}

