/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.cyclades.engine.CycladesEngine;
import org.cyclades.engine.EngineContext;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.util.MapHelper;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.cyclades.xml.parser.XMLParserException;
import org.cyclades.xml.parser.api.XMLGeneratedObject;
import org.w3c.dom.Node;

public abstract class Nyxlet {
    protected static Logger logger = Logger.getLogger(Nyxlet.class);
    private ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap();
    private String name = null;
    private String rrdString = null;
    private String[] RRDURIToParameterKeyMapping = null;
    private volatile boolean active = true;
    private volatile boolean healthy = true;
    private Properties buildProperties;
    public static final String SERVICE_AGENT = "service-agent";

    public static Nyxlet valueOf(Node xmlNode, ClassLoader classLoader, Properties buildProperties) throws XMLParserException {
        XMLGeneratedObject xmlo = null;
        Nyxlet nyxlet = null;
        try {
            String name = XMLComparitor.getAttributeOrError(xmlNode, "name");
            String nyxletClassName = XMLComparitor.getAttributeOrError(xmlNode, "class");
            nyxlet = (Nyxlet)classLoader.loadClass(nyxletClassName).newInstance();
            String rrdString = XMLComparitor.getAttributeOrNull(xmlNode, "rrd");
            nyxlet.setName(name);
            nyxlet.setBuildProperties(buildProperties);
            Vector<Node> attributeList = XMLComparitor.getMatchingChildNodes(xmlNode, "attribute");
            for (int j = 0; j < attributeList.size(); ++j) {
                String attributeName = XMLComparitor.getAttribute(attributeList.elementAt(j), "name");
                Vector<Node> valueList = XMLComparitor.getMatchingChildNodes(attributeList.elementAt(j), "value");
                String value = null;
                for (int k = 0; k < valueList.size(); ++k) {
                    Node node = valueList.elementAt(k);
                    if (node.getFirstChild() == null) continue;
                    value = node.getFirstChild().getNodeValue();
                }
                if (value == null || value.equals("")) continue;
                nyxlet.setAttribute(attributeName, value);
            }
            nyxlet.init();
            if (rrdString != null) {
                nyxlet.setRRDString(rrdString);
            }
            Nyxlet nyxlet2 = nyxlet;
            return nyxlet2;
        }
        catch (Exception ex) {
            try {
                if (nyxlet != null) {
                    nyxlet.destroy();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new XMLParserException(ex.getMessage(), ex);
        }
        finally {
            if (xmlo != null) {
                xmlo.cleanUp();
            }
        }
    }

    public abstract byte[] process(NyxletSession var1) throws CycladesException;

    public byte[] process(Map<String, List<String>> requestParameters, InputStream inputStream, OutputStream outputStream) throws CycladesException {
        try {
            return this.process(new NyxletSession(requestParameters, inputStream, outputStream));
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
            try {
                return this.handleError(ResponseCodeEnum.GENERAL_ERROR.getCode(), ex);
            }
            catch (CycladesException exx) {
                throw exx;
            }
            catch (Exception exx) {
                throw new CycladesException(exx);
            }
        }
    }

    public abstract void init() throws CycladesException;

    public abstract void destroy() throws CycladesException;

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    public byte[] handleError(short defaultErrorCode, Exception incomingException) throws CycladesException {
        try {
            StringBuilder sb = new StringBuilder();
            String cachedMessage = null;
            if (incomingException instanceof CycladesException) {
                try {
                    cachedMessage = this.getAttribute("error_code" + ((CycladesException)incomingException).getCode());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (cachedMessage != null) {
                    sb.append(cachedMessage);
                    sb.append(((CycladesException)incomingException).getDataString());
                } else if (((CycladesException)incomingException).getFriendlyMessage() != null) {
                    sb.append(((CycladesException)incomingException).getFriendlyMessage());
                    sb.append(((CycladesException)incomingException).getDataString());
                } else {
                    sb.append(incomingException);
                }
            } else {
                sb.append(incomingException);
            }
            return sb.toString().getBytes();
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public Logger getLogger() {
        return logger;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRRDMatch(NyxletSession sessionDelegate) throws CycladesException {
        return false;
    }

    public Map<String, List<String>> getRRDURIParameterMap(NyxletSession nyxletSession) throws Exception {
        String eLabel = "Nyxlet.getRRDURIParameterMap";
        try {
            Map<String, List<String>> returnMap = new HashMap<String, List<String>>();
            if (this.RRDURIToParameterKeyMapping == null) {
                return returnMap;
            }
            String webServiceRequest = nyxletSession.getRequestPathInfo();
            if (webServiceRequest != null && webServiceRequest.length() > 1) {
                returnMap = MapHelper.parameterMapFromURI(webServiceRequest, 1, this.RRDURIToParameterKeyMapping);
            }
            return returnMap;
        }
        catch (Exception e) {
            throw new Exception("Nyxlet.getRRDURIParameterMap" + e);
        }
    }

    public boolean isHealthy() throws CycladesException {
        return false;
    }

    public final boolean getHealth() {
        return this.healthy;
    }

    public final void setHealth(boolean healthy) {
        this.healthy = healthy;
    }

    public String getRRDString() {
        return this.rrdString;
    }

    public void setRRDString(String rrdString) throws Exception {
        String[] uriParts;
        this.rrdString = rrdString;
        String[] fields = rrdString.split("[|]");
        if (fields.length != 3) {
            throw new Exception("Invalid RRD format, should be \"[group]|[uri_part_mapping]|[priority]\"");
        }
        if (!fields[1].isEmpty() && (uriParts = fields[1].split("[/]")).length > 1) {
            this.RRDURIToParameterKeyMapping = Arrays.copyOfRange(uriParts, 1, uriParts.length);
        }
    }

    public static EngineContext getEngineContext() {
        return CycladesEngine.getEngineContext();
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void setActive(boolean active) {
        this.active = active;
    }

    public final void setBuildProperties(Properties buildProperties) {
        this.buildProperties = buildProperties;
    }

    public final Properties getBuildProperties() {
        return this.buildProperties;
    }

    public String getServiceAgentAttribute() {
        return this.attributes.containsKey(SERVICE_AGENT) ? this.attributes.get(SERVICE_AGENT).toString() : "";
    }
}

