/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine;

import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.cyclades.engine.CycladesEngine;
import org.cyclades.engine.MetaTypeEnum;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.adapter.HttpServletRequestAdapter;
import org.cyclades.engine.adapter.HttpServletResponseAdapter;
import org.cyclades.engine.auth.api.AuthDelegate;
import org.cyclades.engine.exception.AuthException;
import org.cyclades.engine.logging.LoggingEnum;
import org.cyclades.engine.nyxlet.templates.xstroma.OrchestrationTypeEnum;
import org.cyclades.engine.util.MapHelper;

public class NyxletSession {
    static Logger logger = Logger.getLogger(NyxletSession.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Object dataObject = null;
    private Object actionObject = null;
    private Object transactionDataObject = null;
    private Boolean rawResponse = null;
    private LoggingEnum userLoggingLevel = null;
    private MetaTypeEnum metaTypeEnum = null;
    private MetaTypeEnum responseMetaTypeEnum = null;
    private Map<Object, Object> mapChannel = new Hashtable<Object, Object>();
    private byte[] portData = null;
    private boolean orchestrationFault = false;
    private String orchestrationFaultMessage;
    private Object authDelegateObject;
    private boolean chainsForward = false;
    private boolean isLastBoolean = true;
    private boolean isRRDRequest = false;
    private OrchestrationTypeEnum orchestrationTypeEnum = OrchestrationTypeEnum.NONE;
    private long durationStart = System.currentTimeMillis();
    private Boolean durationRequested = null;
    private Boolean serviceAgentRequested = null;
    public static final String DATA_PARAMETER = "data";
    public static final String DATA_TYPE_PARAMETER = "data-type";
    public static final String RESPONSE_DATA_TYPE_PARAMETER = "data-out";
    public static final String ACTION_PARAMETER = "action";
    public static final String TRANSACTION_DATA_PARAMETER = "transaction-data";
    public static final String LOG_LEVEL_PARAMETER = "log-level";
    public static final String RAW_RESPONSE_PARAMETER = "raw-response";
    public static final String DURATION_PARAMETER = "duration";
    public static final String SERVICE_AGENT_PARAMETER = "service-agent";

    public NyxletSession(HttpServletRequest request, HttpServletResponse response, InputStream inputStream, OutputStream outputStream) {
        this.request = request;
        this.response = response;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public NyxletSession(Map<String, List<String>> requestParameters, InputStream is, OutputStream os) {
        this.request = new HttpServletRequestAdapter(new HashMap<String, String>(), MapHelper.arrayParameterMapFromParameterMap(requestParameters), new HashMap<String, Object>(), is);
        this.response = new HttpServletResponseAdapter(os);
        this.inputStream = is;
        this.outputStream = os;
    }

    private void loadDataObject() throws Exception {
        String eLabel = "NyxletSession.loadDataObject: ";
        try {
            String meta = this.request.getParameter(DATA_PARAMETER);
            if (meta == null && this.inputStream != null) {
                meta = new String(ByteStreams.toByteArray((InputStream)this.inputStream));
            }
            if (meta != null && !meta.isEmpty()) {
                this.dataObject = this.getMetaTypeEnum().createObjectFromMeta(meta);
            }
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.loadDataObject: " + e);
        }
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Map<String, List<String>> getParameterMap() {
        HashMap parameterMap = Maps.newHashMap();
        Enumeration names = this.request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            parameterMap.put(name, Arrays.asList(this.request.getParameterValues(name)));
        }
        return parameterMap;
    }

    public void setResponseContentType(String type) {
        this.response.setContentType(type);
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public void setResponseStatus(int status) {
        this.response.setStatus(status);
    }

    public String getRequestPathInfo() {
        return this.request.getPathInfo();
    }

    public Object getDataObject() throws Exception {
        String eLabel = "NyxletSession.getDataObject: ";
        try {
            if (this.dataObject == null) {
                this.loadDataObject();
            }
            return this.dataObject;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getDataObject: " + e);
        }
    }

    public void setDataObject(Object dataObject) throws Exception {
        this.dataObject = dataObject;
        this.metaTypeEnum = MetaTypeEnum.detectMetaTypeEnum(dataObject);
    }

    public boolean hasData() {
        return this.request.getParameter(DATA_PARAMETER) != null;
    }

    public MetaTypeEnum getMetaTypeEnum() throws Exception {
        String eLabel = "NyxletSession.getMetaTypeEnum: ";
        try {
            if (this.metaTypeEnum == null) {
                String type = this.request.getParameter(DATA_TYPE_PARAMETER);
                this.metaTypeEnum = type != null ? Enum.valueOf(MetaTypeEnum.class, type.toUpperCase()) : MetaTypeEnum.JSON;
            }
            return this.metaTypeEnum;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getMetaTypeEnum: Invalid data type: " + e);
        }
    }

    public MetaTypeEnum getResponseMetaTypeEnum() throws Exception {
        String eLabel = "NyxletSession.getResponseMetaTypeEnum: ";
        try {
            if (this.responseMetaTypeEnum == null) {
                String type = this.request.getParameter(RESPONSE_DATA_TYPE_PARAMETER);
                this.responseMetaTypeEnum = type != null ? Enum.valueOf(MetaTypeEnum.class, type.toUpperCase()) : this.getMetaTypeEnum();
            }
            return this.responseMetaTypeEnum;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getResponseMetaTypeEnum: Invalid data type: " + e);
        }
    }

    public String getDataContentType() throws Exception {
        String eLabel = "NyxletSession.getDataContentType: ";
        try {
            return this.getResponseMetaTypeEnum().getContentType();
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getDataContentType: " + e);
        }
    }

    public Object getActionObject() throws Exception {
        String eLabel = "NyxletSession.getActionObject: ";
        try {
            if (this.actionObject == null) {
                this.actionObject = this.request.getParameter(ACTION_PARAMETER);
            }
            return this.actionObject;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getActionObject: " + e);
        }
    }

    public String getActionString() throws Exception {
        String eLabel = "NyxletSession.getActionString: ";
        try {
            Object action = this.getActionObject();
            return action == null ? null : action.toString();
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getActionString: " + e);
        }
    }

    public void setActionObject(Object actionObject) {
        this.actionObject = actionObject;
    }

    public Object getTransactionDataObject() throws Exception {
        String eLabel = "NyxletSession.getTransactionDataObject: ";
        try {
            if (this.transactionDataObject == null) {
                this.transactionDataObject = this.request.getParameter(TRANSACTION_DATA_PARAMETER);
            }
            return this.transactionDataObject;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getTransactionDataObject: " + e);
        }
    }

    public String getTransactionDataString() throws Exception {
        String eLabel = "NyxletSession.getTransactionDataString: ";
        try {
            Object transdata = this.getTransactionDataObject();
            return transdata == null ? null : transdata.toString();
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getTransactionDataString: " + e);
        }
    }

    public void setTransactionDataObject(Object transactionDataObject) {
        this.transactionDataObject = transactionDataObject;
    }

    public boolean rawResponseRequested() throws Exception {
        String eLabel = "NyxletSession.rawResponseRequested: ";
        try {
            if (this.rawResponse == null) {
                String rawResponseString = this.request.getParameter(RAW_RESPONSE_PARAMETER);
                this.rawResponse = rawResponseString != null && (rawResponseString.isEmpty() || rawResponseString.equalsIgnoreCase("true")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            return this.rawResponse;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.rawResponseRequested: " + e);
        }
    }

    public void setRawResponseRequested(boolean rawResponse) {
        this.rawResponse = rawResponse;
    }

    public LoggingEnum getUserLoggingLevel() throws Exception {
        String eLabel = "NyxletSession.getUserLoggingLevel: ";
        try {
            if (this.userLoggingLevel == null) {
                String level = this.request.getParameter(LOG_LEVEL_PARAMETER);
                this.userLoggingLevel = level == null ? null : Enum.valueOf(LoggingEnum.class, level.toUpperCase());
            }
            return this.userLoggingLevel;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getUserLoggingLevel: " + e);
        }
    }

    public void setUserLoggingLevel(LoggingEnum userLoggingLevel) {
        this.userLoggingLevel = userLoggingLevel;
    }

    public boolean durationRequested() throws Exception {
        String eLabel = "NyxletSession.durationRequested: ";
        try {
            if (this.durationRequested == null) {
                String rawResponseString = this.request.getParameter(DURATION_PARAMETER);
                this.durationRequested = rawResponseString != null && (rawResponseString.isEmpty() || rawResponseString.equalsIgnoreCase("true")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            return this.durationRequested;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.durationRequested: " + e);
        }
    }

    public void setDurationRequested(Boolean durationRequested) {
        this.durationRequested = durationRequested;
    }

    public boolean serviceAgentRequested() throws Exception {
        String eLabel = "NyxletSession.serviceAgentRequested: ";
        try {
            if (this.serviceAgentRequested == null) {
                String rawResponseString = this.request.getParameter(SERVICE_AGENT_PARAMETER);
                this.serviceAgentRequested = rawResponseString != null && (rawResponseString.isEmpty() || rawResponseString.equalsIgnoreCase("true")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            return this.serviceAgentRequested;
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.serviceAgentRequested: " + e);
        }
    }

    public void setServiceAgentRequested(Boolean serviceAgentRequested) {
        this.serviceAgentRequested = serviceAgentRequested;
    }

    public void putMapChannelObject(Object key, Object value) throws Exception {
        String eLabel = "NyxletSession.putMapChannelObject: ";
        try {
            this.mapChannel.put(key, value);
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.putMapChannelObject: " + e);
        }
    }

    public Object getMapChannelObject(Object key) throws Exception {
        String eLabel = "NyxletSession.getMapChannelObject: ";
        try {
            return this.mapChannel.get(key);
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.getMapChannelObject: " + e);
        }
    }

    public boolean containsMapChannelKey(Object key) throws Exception {
        String eLabel = "NyxletSession.containsMapChannelKey: ";
        try {
            return this.mapChannel.containsKey(key);
        }
        catch (Exception e) {
            throw new Exception("NyxletSession.containsMapChannelKey: " + e);
        }
    }

    public void setMapChannel(Map<Object, Object> map) {
        this.mapChannel = map;
    }

    public Map<Object, Object> getMapChannel() {
        return this.mapChannel;
    }

    public void raiseOrchestrationFault(String orchestrationFaultMessage) {
        this.orchestrationFault = true;
        this.orchestrationFaultMessage = orchestrationFaultMessage;
    }

    public void clearOrchestrationFault() {
        this.orchestrationFault = false;
        this.orchestrationFaultMessage = "";
    }

    public boolean orchestrationFaultRaised() {
        return this.orchestrationFault;
    }

    public String getOrchestrationFaultMessage() {
        return this.orchestrationFaultMessage == null ? "" : this.orchestrationFaultMessage;
    }

    public Object auth(Map authAttributeMap, Object authMetaObject, boolean force) throws Exception {
        String eLabel = "NyxletSession.auth: ";
        try {
            if (this.authDelegateObject == null || force) {
                AuthDelegate authDelegate = CycladesEngine.getEngineContext().getAuthDelegate();
                if (authDelegate == null) {
                    throw new AuthException("No AutheDelegate defined!", ResponseCodeEnum.NO_AUTH_DELEGATE.getCode());
                }
                this.authDelegateObject = authDelegate.auth(authAttributeMap, authMetaObject);
            }
            return this.authDelegateObject;
        }
        catch (AuthException e) {
            this.authDelegateObject = null;
            throw e;
        }
        catch (Exception e) {
            this.authDelegateObject = null;
            throw new Exception("NyxletSession.auth: " + e, e);
        }
    }

    public void setAuthDelegateObject(Object authDelegateObject) {
        this.authDelegateObject = authDelegateObject;
    }

    public Object getAuthDelegateObject() {
        return this.authDelegateObject;
    }

    public void setPortData(byte[] port) {
        this.portData = port;
    }

    public byte[] getPortData() {
        return this.portData;
    }

    public NyxletSession setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public NyxletSession setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public boolean chainsForward() {
        return this.chainsForward;
    }

    public void setChainsForward(boolean chainsForward) {
        this.chainsForward = chainsForward;
    }

    public boolean isLast() {
        return this.isLastBoolean;
    }

    public void setIsLast(boolean isLastBoolean) {
        this.isLastBoolean = isLastBoolean;
    }

    public boolean isRRDRequest() {
        return this.isRRDRequest;
    }

    public void setRRDRequest(boolean isRRDRequest) {
        this.isRRDRequest = isRRDRequest;
    }

    public void setOrchestrationTypeEnum(OrchestrationTypeEnum orchestrationTypeEnum) {
        this.orchestrationTypeEnum = orchestrationTypeEnum;
    }

    public OrchestrationTypeEnum getOrchestrationTypeEnum() {
        return this.orchestrationTypeEnum;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.durationStart;
    }

    public long getDurationStart() {
        return this.durationStart;
    }

    public void resetDuration() {
        this.durationStart = System.currentTimeMillis();
    }
}

