/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.engine;

import com.google.common.base.Strings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.cyclades.engine.EngineContext;
import org.cyclades.engine.NyxletSession;
import org.cyclades.engine.ResponseCodeEnum;
import org.cyclades.engine.api.InitializationDelegate;
import org.cyclades.engine.api.Nyxlet;
import org.cyclades.engine.auth.api.AuthDelegate;
import org.cyclades.engine.exception.CycladesException;
import org.cyclades.engine.nyxlet.NyxletRepository;
import org.cyclades.io.ResourceRequestUtils;

public class CycladesEngine {
    static Logger logger = Logger.getLogger(CycladesEngine.class);
    private List<InitializationDelegate> initializationDelegates = new ArrayList<InitializationDelegate>();
    private static EngineContext engineContext;
    private long nyxletLoadStamp;
    private static final String STROMA_ENABLED = "STROMA";
    private static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    private static final String CONTENT_TYPE = "CONTENT-TYPE";
    private static final String RESTFUL_REQUEST_DISPATCH = "RRD";

    public CycladesEngine(ServletConfig servletConfig, String applicationBaseDirectory) throws CycladesException {
        boolean minimizeMemoryFootprint = false;
        int debugMode = 0;
        try {
            AuthDelegate authDelegate;
            String tempString = servletConfig.getInitParameter("initializationDelegates");
            if (tempString != null) {
                for (String delegateClassName : tempString.split("[,]")) {
                    InitializationDelegate initializationDelegate = (InitializationDelegate)Class.forName(delegateClassName.trim()).newInstance();
                    initializationDelegate.initialize(servletConfig);
                    this.initializationDelegates.add(initializationDelegate);
                }
            } else {
                logger.info((Object)"No InitializationDelegates specified");
            }
            tempString = servletConfig.getInitParameter("authDelegate");
            if (tempString != null) {
                authDelegate = (AuthDelegate)Class.forName(tempString).newInstance();
                authDelegate.initialize(servletConfig);
            } else {
                authDelegate = null;
                logger.info((Object)"No InitializationDelegate specified");
            }
            String minimizeMemoryFootprintFlag = servletConfig.getInitParameter("minimizeMemoryFootprint");
            if (minimizeMemoryFootprintFlag != null) {
                minimizeMemoryFootprint = minimizeMemoryFootprintFlag.toLowerCase().equals("true");
            }
            logger.debug((Object)("minimizeMemoryFootprint: " + minimizeMemoryFootprint));
            String debugModeString = servletConfig.getInitParameter("debugMode");
            if (debugModeString == null) {
                throw new Exception("Config parameter debugMode came back null.");
            }
            debugMode = Integer.parseInt(debugModeString);
            logger.debug((Object)("Debug Mode:[" + debugMode + "]"));
            engineContext = new EngineContext(authDelegate, servletConfig, applicationBaseDirectory, minimizeMemoryFootprint, debugMode);
            this.loadNyxletRepository(null);
        }
        catch (CycladesException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CycladesException(ex.getMessage(), ex);
        }
    }

    public String loadNyxletRepository(String nyxletDirOverride) throws CycladesException {
        try {
            String classLoaderStrategyString = engineContext.getServletConfig().getInitParameter("classLoaderStrategy");
            if (classLoaderStrategyString == null) {
                throw new Exception("Config parameter classLoaderStrategy came back null.");
            }
            if (!classLoaderStrategyString.equalsIgnoreCase("isolated") && !classLoaderStrategyString.equalsIgnoreCase("collective")) {
                throw new Exception("Config parameter classLoaderStrategy invalid: " + classLoaderStrategyString);
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Class Loader strategy:[" + classLoaderStrategyString + "]"));
            }
            return this.loadNyxletRepository(classLoaderStrategyString.equalsIgnoreCase("isolated"), nyxletDirOverride);
        }
        catch (Exception ex) {
            throw new CycladesException(ex.getMessage(), ex);
        }
    }

    public String loadNyxletRepository(boolean isolatedClassLoader, String nyxletDirOverride) throws CycladesException {
        StringBuilder sb = new StringBuilder("<CENTER>");
        try {
            String nyxletDirectoriesString;
            String string = nyxletDirectoriesString = nyxletDirOverride == null ? engineContext.getServletConfig().getInitParameter("nyxletDirectories") : nyxletDirOverride;
            if (nyxletDirectoriesString == null) {
                sb.append("Config parameter ").append("nyxletDirectories").append(" came back null. Nyxlets will not be loaded");
            } else {
                String[] nyxletDirectories = nyxletDirectoriesString.split("[,]");
                for (int i = 0; i < nyxletDirectories.length; ++i) {
                    nyxletDirectories[i] = engineContext.getCanonicalEngineDirectoryPath(nyxletDirectories[i].trim());
                }
                engineContext.setNyxletDirectories(nyxletDirectories);
                int loaded = NyxletRepository.getStaticInstance().reloadNyxletFiles(nyxletDirectories, true, isolatedClassLoader);
                sb.append("Nyxlets have been loaded from source directories: ").append(nyxletDirectoriesString).append("<BR>Number of Nyxlets loaded: ").append(loaded);
            }
            String temp = engineContext.getServletConfig().getInitParameter("nyxletRegistry");
            temp = temp == null ? null : new String(ResourceRequestUtils.getData(engineContext.getCanonicalEngineDirectoryPath(temp), null));
            engineContext.setNyxletTargets(temp);
            this.nyxletLoadStamp = System.currentTimeMillis();
            sb.append("</CENTER><BR>").append(this.listNyxlets());
            String finalString = sb.toString();
            logger.debug((Object)finalString);
            return finalString;
        }
        catch (CycladesException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CycladesException(ex.getMessage(), ex);
        }
    }

    public String listNyxlets() throws CycladesException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<CENTER><table border=\"1\">");
            sb.append("<tr><th>Nyxlet Name</th><th>RESTful Request Dispatch Setting</th><th>Active</th></tr>");
            Set<String> keySet = NyxletRepository.getStaticInstance().keys();
            int i = 0;
            for (String key : keySet) {
                ++i;
                Nyxlet nyxlet = NyxletRepository.getStaticInstance().getNyxlet(key);
                String active = nyxlet.isActive() ? "true" : "<p style=\"color:red\">false</p>";
                sb.append("<tr><td>").append(nyxlet.getName()).append("</td><td>").append(nyxlet.getRRDString());
                sb.append("</td><td>").append(active).append("</td></tr>");
            }
            sb.append("</table></CENTER><BR><CENTER>Nyxlets Loaded: ").append(i).append(" @ ").append(new Date(this.nyxletLoadStamp)).append("</CENTER>");
            return sb.toString();
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public void listNyxletsBuildInfo(StringBuilder sb) throws CycladesException {
        try {
            sb.append("<BR><CENTER><H2>Nyxlet Build Information</CENTER><BR>");
            Set<String> keySet = NyxletRepository.getStaticInstance().keys();
            sb.append("<CENTER><table border=\"1\">");
            sb.append("<tr><th>Property Name</th><th>PropertyValue</th></tr>");
            for (String key : keySet) {
                this.listNyxletBuildInfo(NyxletRepository.getStaticInstance().getNyxlet(key), sb);
            }
            sb.append("</table></CENTER></H2>");
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    private void listNyxletBuildInfo(Nyxlet nyxlet, StringBuilder sb) throws CycladesException {
        try {
            sb.append("<tr><th COLSPAN=\"2\">").append(nyxlet.getName()).append("</th></tr>");
            for (Map.Entry<Object, Object> entry : nyxlet.getBuildProperties().entrySet()) {
                sb.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(entry.getValue()).append("</td></tr>");
            }
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public String systemHealthCheck() throws CycladesException {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("<CENTER><table border=\"1\">");
            sb.append("<tr><th>Nyxlet Name</th><th>RESTful Request Dispatch Setting</th><th>Healthy</th><th>Active</th></tr>");
            Set<String> keySet = NyxletRepository.getStaticInstance().keys();
            int i = 0;
            for (String key : keySet) {
                boolean isHealthy;
                ++i;
                Nyxlet nyxlet = NyxletRepository.getStaticInstance().getNyxlet(key);
                try {
                    isHealthy = nyxlet.isHealthy();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    isHealthy = false;
                }
                nyxlet.setHealth(isHealthy);
                String healthString = isHealthy ? "true" : "<p style=\"color:red\">false</p>";
                String active = nyxlet.isActive() ? "true" : "<p style=\"color:red\">false</p>";
                sb.append("<tr><td>").append(nyxlet.getName()).append("</td><td>").append(nyxlet.getRRDString());
                sb.append("</td><td>").append(healthString).append("</td><td>").append(active).append("</td></tr>");
            }
            sb.append("</table></CENTER><BR><CENTER>Nyxlets Loaded: ").append(i).append(" @ ").append(new Date(this.nyxletLoadStamp)).append("</CENTER>");
            return sb.toString();
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public String getSystemHealth() throws CycladesException {
        try {
            Set<String> keySet = NyxletRepository.getStaticInstance().keys();
            int unhealthy = 0;
            int inactive = 0;
            for (String key : keySet) {
                Nyxlet nyxlet = NyxletRepository.getStaticInstance().getNyxlet(key);
                if (!nyxlet.getHealth()) {
                    ++unhealthy;
                }
                if (nyxlet.isActive()) continue;
                ++inactive;
            }
            return "unhealthy:[" + unhealthy + "] inactive:[" + inactive + "]";
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public int numNyxlets() throws CycladesException {
        try {
            return NyxletRepository.getStaticInstance().size();
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public void destroy() throws CycladesException {
        try {
            NyxletRepository.getStaticInstance().destroy();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        for (InitializationDelegate initializationDelegate : this.initializationDelegates) {
            try {
                initializationDelegate.destroy();
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        try {
            AuthDelegate authDelegate = engineContext.getAuthDelegate();
            if (authDelegate != null) {
                authDelegate.destroy();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws CycladesException {
        FilterInputStream dis = null;
        DataOutputStream dos = null;
        try {
            String nyxletDelegateKey = null;
            if (!Strings.nullToEmpty((String)request.getHeader(CONTENT_TYPE)).trim().equalsIgnoreCase(FORM_ENCODED) || Strings.nullToEmpty((String)request.getHeader(STROMA_ENABLED)).trim().equalsIgnoreCase("true")) {
                dis = new DataInputStream((InputStream)request.getInputStream());
            }
            dos = new DataOutputStream((OutputStream)response.getOutputStream());
            Nyxlet nyxlet = null;
            byte[] commandCollectiveResponse = null;
            NyxletSession sessionDelegate = new NyxletSession(request, response, dis, dos);
            String rrd = request.getHeader(RESTFUL_REQUEST_DISPATCH);
            if (rrd == null) {
                rrd = request.getParameter(RESTFUL_REQUEST_DISPATCH.toLowerCase());
            }
            if (sessionDelegate.getActionString() == null) {
                sessionDelegate.setActionObject(sessionDelegate.getRequestMethod());
            }
            if (rrd != null) {
                nyxletDelegateKey = "RRD: " + rrd;
                nyxlet = NyxletRepository.getStaticInstance().getNyxletRRD(rrd, sessionDelegate);
                sessionDelegate.setRRDRequest(true);
            } else {
                String webServiceRequest = Strings.nullToEmpty((String)request.getPathInfo()).trim();
                if (webServiceRequest.length() == 0) {
                    throw new Exception("Invalid engine request URI, no data for service dispatching");
                }
                String[] URIParts = webServiceRequest.split("/");
                if (URIParts.length < 2) {
                    throw new Exception("Bad web service request URI:[" + webServiceRequest + "]");
                }
                nyxletDelegateKey = URIParts[1];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Servicing URL Services request for:" + nyxletDelegateKey));
                }
                nyxlet = NyxletRepository.getStaticInstance().getNyxlet(nyxletDelegateKey);
            }
            if (nyxlet == null) {
                this.writeError(dos, ResponseCodeEnum.SERVICE_NOT_FOUND.getCode(), "Unknown service Nyxlet module: " + nyxletDelegateKey, response);
                return;
            }
            String serviceAgent = nyxlet.getServiceAgentAttribute();
            if (serviceAgent != null && !serviceAgent.isEmpty()) {
                response.setHeader("service-agent", serviceAgent);
            }
            if ((commandCollectiveResponse = nyxlet.process(sessionDelegate)) == null) {
                return;
            }
            dos.write(commandCollectiveResponse);
            return;
        }
        catch (CycladesException ex) {
            try {
                this.writeError(dos, ex.getCode(), this.buildErrorMessage(ex), response);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            logger.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            try {
                this.writeError(dos, ResponseCodeEnum.GENERAL_ERROR.getCode(), ex.getMessage(), response);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            logger.error((Object)ex);
            throw new CycladesException(ex);
        }
        finally {
            try {
                dos.flush();
            }
            catch (Exception ignore) {}
            try {
                dos.close();
            }
            catch (Exception ignore) {}
            try {
                dis.close();
            }
            catch (Exception ignore) {}
        }
    }

    private String buildErrorMessage(CycladesException e) throws CycladesException {
        try {
            StringBuilder errorStringBuilder = new StringBuilder();
            String mappedMessage = null;
            if (mappedMessage != null) {
                return errorStringBuilder.append(mappedMessage).append(e.getDataString()).toString();
            }
            if (e.getFriendlyMessage() != null) {
                return errorStringBuilder.append(e.getFriendlyMessage()).append(e.getDataString()).toString();
            }
            return errorStringBuilder.append(e.getMessage()).toString();
        }
        catch (Exception ex) {
            throw new CycladesException("" + e + ex);
        }
    }

    private void writeError(DataOutputStream dos, short status, String msg, HttpServletResponse response) throws CycladesException {
        try {
            response.setStatus(500);
            dos.writeShort(-1);
            dos.writeShort(status);
            dos.writeUTF(msg);
        }
        catch (Exception ex) {
            throw new CycladesException(ex);
        }
    }

    public static EngineContext getEngineContext() {
        return engineContext;
    }

    public long getNyxletLoadStamp() {
        return this.nyxletLoadStamp;
    }
}

