package com.crabshue.commons.validations.path.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.crabshue.commons.validations.path.validators.FilePathValidator;

/**
 * Annotation used to validate a file
 * <p>
 * It checks that the object is a file, exists and can be accessed in the defined modes.
 */
@Constraint(validatedBy = FilePathValidator.class)
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ValidFilePath {

    PathAccessMode[] accessModes() default {PathAccessMode.READ, PathAccessMode.WRITE};

    String message() default "The file ${validatedValue} is not valid";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
