package com.crabshue.commons.validations.file.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import com.crabshue.commons.validations.file.validators.FileValidator;

/**
 * Annotation used to validate a file
 * <p>
 * It checks that the object is a file, exists and can be accessed in the defined modes.
 */
@Constraint(validatedBy = FileValidator.class)
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ValidFile {

    AccessMode[] accessModes() default {AccessMode.READ, AccessMode.WRITE};

    String message() default "The file ${validatedValue} is not valid";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
