/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.json.jsonpath;

import com.crabshue.commons.exceptions.ApplicationException;
import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.json.jsonpath.exceptions.JsonPathErrorContext;
import com.crabshue.commons.json.jsonpath.exceptions.JsonPathErrorType;
import com.crabshue.commons.json.serialization.exceptions.JsonErrorType;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(JsonPathEvaluator.class);
    private DocumentContext jsonObject;
    private String jsonPath;

    public static JsonPathEvaluator of(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked @NonNull but is null");
        }
        JsonPathEvaluator ret = new JsonPathEvaluator();
        ret.jsonObject = JsonPath.parse((String)json);
        return ret;
    }

    public static JsonPathEvaluator of(@NonNull InputStream json) {
        if (json == null) {
            throw new NullPointerException("json is marked @NonNull but is null");
        }
        JsonPathEvaluator ret = new JsonPathEvaluator();
        ret.jsonObject = JsonPath.parse((InputStream)json);
        return ret;
    }

    public static JsonPathEvaluator of(@NonNull File json) {
        if (json == null) {
            throw new NullPointerException("json is marked @NonNull but is null");
        }
        JsonPathEvaluator ret = new JsonPathEvaluator();
        try {
            ret.jsonObject = JsonPath.parse((File)json);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)JsonErrorType.JSON_PARSING_ERROR, (Throwable)e).addContextValue((ErrorContext)JsonPathErrorContext.JSON_FILE, (Object)json);
        }
        return ret;
    }

    public static JsonPathEvaluator of(@NonNull URL json) {
        if (json == null) {
            throw new NullPointerException("json is marked @NonNull but is null");
        }
        JsonPathEvaluator ret = new JsonPathEvaluator();
        try {
            ret.jsonObject = JsonPath.parse((URL)json);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)JsonErrorType.JSON_PARSING_ERROR, (Throwable)e).addContextValue((ErrorContext)JsonPathErrorContext.JSON_URL, (Object)json);
        }
        return ret;
    }

    public JsonPathEvaluator withJsonPath(@NonNull String jsonPath) {
        if (jsonPath == null) {
            throw new NullPointerException("jsonPath is marked @NonNull but is null");
        }
        this.jsonPath = jsonPath;
        return this;
    }

    public <T> T evaluate() {
        try {
            Object ret = this.jsonObject.read(this.jsonPath, new Predicate[0]);
            logger.info("Json path evaluated [{}] : [{}]", (Object)this.jsonPath, ret);
            return (T)ret;
        }
        catch (JsonPathException e) {
            throw new ApplicationException((ErrorType)JsonPathErrorType.JSON_PATH_EVALUATION_ERROR, (Throwable)e).addContextValue((ErrorContext)JsonPathErrorContext.JSON, (Object)this.jsonObject).addContextValue((ErrorContext)JsonPathErrorContext.JSON_PATH, (Object)this.jsonPath);
        }
    }

    public <T> T evaluate(Class<T> clazz) {
        try {
            Object ret = this.jsonObject.read(this.jsonPath, clazz, new Predicate[0]);
            logger.info("Json path evaluated [{}] : [{}]", (Object)this.jsonPath, ret);
            return (T)ret;
        }
        catch (JsonPathException e) {
            throw new ApplicationException((ErrorType)JsonPathErrorType.JSON_PATH_EVALUATION_ERROR, (Throwable)e).addContextValue((ErrorContext)JsonPathErrorContext.JSON, (Object)this.jsonObject).addContextValue((ErrorContext)JsonPathErrorContext.JSON_PATH, (Object)this.jsonPath);
        }
    }

    public <T> Optional<T> evaluateOptional() {
        try {
            Object ret = this.jsonObject.read(this.jsonPath, new Predicate[0]);
            logger.info("Json path evaluated [{}] : [{}]", (Object)this.jsonPath, ret);
            return Optional.ofNullable(ret);
        }
        catch (PathNotFoundException e) {
            logger.warn("No result found for JSON path [{}]", (Object)this.jsonPath);
            return Optional.empty();
        }
        catch (JsonPathException e) {
            throw new ApplicationException((ErrorType)JsonPathErrorType.JSON_PATH_EVALUATION_ERROR, (Throwable)e).addContextValue((ErrorContext)JsonPathErrorContext.JSON, (Object)this.jsonObject).addContextValue((ErrorContext)JsonPathErrorContext.JSON_PATH, (Object)this.jsonPath);
        }
    }
}

