/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.rich.html.renderer;

import com.contentful.java.cda.rich.CDARichNode;
import com.contentful.rich.core.Processor;
import com.contentful.rich.html.HtmlContext;
import com.contentful.rich.html.renderer.TagRenderer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class TagWithArgumentsRenderer
extends TagRenderer {
    private final ArgumentsProvider provider;

    @Nonnull
    public static Map<String, String> mapifyArguments(String ... args) {
        HashMap<String, String> result = new HashMap<String, String>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            String key = args[i];
            String value = args[i + 1];
            result.put(key, value);
        }
        return result;
    }

    public TagWithArgumentsRenderer(Processor<HtmlContext, String> processor, String tag, ArgumentsProvider provider) {
        super(processor, tag);
        this.provider = provider;
    }

    @Override
    @Nonnull
    protected String startTag(@Nonnull CDARichNode node) {
        return "<" + this.tag + " " + this.stringifyArgumentMap(this.provider.provide(node)) + ">\n";
    }

    String stringifyArgumentMap(Map<String, String> arguments) {
        StringBuilder builder = new StringBuilder();
        for (String key : arguments.keySet()) {
            builder.append(key).append("=").append('\"').append(arguments.get(key)).append('\"');
        }
        return builder.toString();
    }

    public static interface ArgumentsProvider {
        public Map<String, String> provide(CDARichNode var1);
    }
}

