/*
 * Decompiled with CFR 0.152.
 */
package com.contentful.rich.html.renderer;

import com.contentful.java.cda.rich.CDARichBlock;
import com.contentful.java.cda.rich.CDARichHyperLink;
import com.contentful.java.cda.rich.CDARichNode;
import com.contentful.rich.core.Context;
import com.contentful.rich.core.Processor;
import com.contentful.rich.core.Renderer;
import com.contentful.rich.html.HtmlContext;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TagRenderer
implements Renderer<HtmlContext, String> {
    private final Processor<HtmlContext, String> processor;
    String tag;

    public TagRenderer(Processor<HtmlContext, String> processor, String tag) {
        this.processor = processor;
        this.tag = tag;
    }

    @Nullable
    public String render(@Nonnull HtmlContext context, @Nonnull CDARichNode node) {
        StringBuilder result = new StringBuilder(this.startTag(node));
        if (node instanceof CDARichBlock) {
            for (CDARichNode item : ((CDARichBlock)node).getContent()) {
                String itemResult = (String)this.processor.process((Context)context, item);
                if (itemResult != null) {
                    if (itemResult.contains("\n")) {
                        for (String line : itemResult.split("\n")) {
                            result.append(context.getIndentation()).append(line).append("\n");
                        }
                        continue;
                    }
                    result.append(context.getIndentation()).append(itemResult).append("\n");
                    continue;
                }
                this.appendErrorNode(context, result, item);
            }
        }
        return result.append(this.endTag(node)).toString();
    }

    private void appendErrorNode(@Nonnull HtmlContext context, StringBuilder result, CDARichNode item) {
        result.append(context.getIndentation()).append("<!-- ").append("no processor accepts '").append(this.createNodeName(item)).append("', found at path '").append(context.getPath().stream().map(x -> this.createNodeName((CDARichNode)x) + "[" + this.getIndexInParent(context, (CDARichNode)x) + "]").collect(Collectors.joining(" > "))).append("'. Please add a corresponding renderer using ").append("'HtmlRenderer.addRenderer(...)'. -->\n");
    }

    private String createNodeName(CDARichNode node) {
        if (node instanceof CDARichHyperLink && ((CDARichHyperLink)node).getData() != null) {
            CDARichHyperLink link = (CDARichHyperLink)node;
            return String.format(Locale.getDefault(), "%s<%s>", link.getClass().getSimpleName(), link.getData().getClass().getSimpleName());
        }
        return node.getClass().getSimpleName();
    }

    private int getIndexInParent(@Nonnull HtmlContext context, CDARichNode x) {
        int currentIndex = context.getPath().indexOf(x);
        if (currentIndex > 0) {
            return ((CDARichBlock)context.getPath().get(currentIndex - 1)).getContent().indexOf(x);
        }
        return 0;
    }

    @Nonnull
    protected String startTag(@Nonnull CDARichNode node) {
        return "<" + this.tag + ">\n";
    }

    @Nonnull
    protected String endTag(@Nonnull CDARichNode node) {
        return "</" + this.tag + ">\n";
    }
}

