/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.util;

import java.util.concurrent.locks.LockSupport;
import org.cojen.tupl.util.Latch;

public final class LatchCondition {
    Node mHead;
    Node mTail;

    public boolean isEmpty() {
        return this.mHead == null;
    }

    public int await(Latch latch, long nanosTimeout, long nanosEnd) {
        return this.await(latch, new Node(), nanosTimeout, nanosEnd);
    }

    public int awaitShared(Latch latch, long nanosTimeout, long nanosEnd) {
        return this.await(latch, new Shared(), nanosTimeout, nanosEnd);
    }

    private int await(Latch latch, Node node, long nanosTimeout, long nanosEnd) {
        node.mWaiter = Thread.currentThread();
        Node tail = this.mTail;
        if (tail == null) {
            this.mHead = node;
        } else {
            tail.mNext = node;
            node.mPrev = tail;
        }
        this.mTail = node;
        if (nanosTimeout < 0L) {
            int state;
            do {
                latch.releaseExclusive();
                LockSupport.park();
                latch.acquireExclusive();
            } while ((state = node.resumed(this)) == 0);
            return state;
        }
        do {
            latch.releaseExclusive();
            LockSupport.parkNanos(nanosTimeout);
            latch.acquireExclusive();
            int state = node.resumed(this);
            if (state == 0) continue;
            return state;
        } while (nanosTimeout != 0L && (nanosTimeout = nanosEnd - System.nanoTime()) > 0L);
        node.remove(this);
        return 0;
    }

    public void signal() {
        Node head = this.mHead;
        if (head != null) {
            head.signal();
        }
    }

    public boolean signalNext() {
        Node head = this.mHead;
        if (head == null) {
            return false;
        }
        head.signal();
        return true;
    }

    public void signalAll() {
        Node node = this.mHead;
        while (node != null) {
            node.signal();
            node = node.mNext;
        }
    }

    public void signalShared() {
        Node head = this.mHead;
        if (head instanceof Shared) {
            head.signal();
        }
    }

    public boolean signalNextShared() {
        Node head = this.mHead;
        if (head == null) {
            return false;
        }
        if (head instanceof Shared) {
            head.signal();
        }
        return true;
    }

    public void clear() {
        Node node = this.mHead;
        while (node != null) {
            Thread waiter = node.mWaiter;
            if (waiter != null) {
                waiter.interrupt();
            }
            node.mPrev = null;
            Node next = node.mNext;
            node.mNext = null;
            node = next;
        }
        this.mHead = null;
        this.mTail = null;
    }

    static final class Shared
    extends Node {
        Shared() {
        }
    }

    static class Node {
        Thread mWaiter;
        Node mPrev;
        Node mNext;

        Node() {
        }

        final int resumed(LatchCondition queue) {
            Thread thread = this.mWaiter;
            if (thread == null) {
                this.remove(queue);
                return 1;
            }
            if (thread.isInterrupted()) {
                Thread.interrupted();
                this.remove(queue);
                return -1;
            }
            return 0;
        }

        final void signal() {
            LockSupport.unpark(this.mWaiter);
            this.mWaiter = null;
        }

        final void remove(LatchCondition queue) {
            Node prev = this.mPrev;
            Node next = this.mNext;
            if (prev == null) {
                queue.mHead = next;
                if (queue.mHead == null) {
                    queue.mTail = null;
                } else {
                    next.mPrev = null;
                }
            } else {
                prev.mNext = next;
                if (prev.mNext == null) {
                    queue.mTail = prev;
                } else {
                    next.mPrev = prev;
                }
                this.mPrev = null;
            }
            this.mNext = null;
        }
    }
}

