/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.PosixFileIO;

final class PosixMapping
extends Mapping {
    private final DirectAccess mDirectAccess = new DirectAccess();
    private final long mAddr;
    private final int mSize;

    PosixMapping(int fd, boolean readOnly, long position, int size) throws IOException {
        int prot = readOnly ? 1 : 3;
        int flags = 1;
        this.mAddr = PosixFileIO.mmapFd(size, prot, flags, fd, position);
        this.mSize = size;
    }

    @Override
    void read(int start, byte[] b, int off, int len) {
        this.mDirectAccess.prepare(this.mAddr + (long)start, len).get(b, off, len);
    }

    @Override
    void read(int start, ByteBuffer dst) {
        dst.put(this.mDirectAccess.prepare(this.mAddr + (long)start, dst.remaining()));
    }

    @Override
    void write(int start, byte[] b, int off, int len) {
        this.mDirectAccess.prepare(this.mAddr + (long)start, len).put(b, off, len);
    }

    @Override
    void write(int start, ByteBuffer src) {
        this.mDirectAccess.prepare(this.mAddr + (long)start, src.remaining()).put(src);
    }

    @Override
    void sync(boolean metadata) throws IOException {
        PosixFileIO.msyncAddr(this.mAddr, this.mSize);
    }

    @Override
    public void close() throws IOException {
        PosixFileIO.munmapAddr(this.mAddr, this.mSize);
    }
}

