/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import org.cojen.tupl.io.JavaFileIO;
import org.cojen.tupl.io.MappedPageArray;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PosixFileIO;

class PosixMappedPageArray
extends MappedPageArray {
    private final File mFile;
    private final EnumSet<OpenOption> mOptions;
    private final int mFileDescriptor;
    private volatile boolean mEmpty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PosixMappedPageArray(int pageSize, long pageCount, File file, EnumSet<OpenOption> options) throws IOException {
        super(pageSize, pageCount, options);
        long ptr;
        long fileLen;
        int fd;
        this.mFile = file;
        this.mOptions = options;
        if (file == null) {
            int prot = 3;
            int flags = 1 | (Platform.isMac() ? 4096 : 32);
            this.setMappingPtr(PosixFileIO.mmapFd((long)pageSize * pageCount, prot, flags, -1, 0L));
            this.mFileDescriptor = -1;
            this.mEmpty = true;
            return;
        }
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            fd = PosixFileIO.openFd(file, options);
            try {
                fileLen = PosixFileIO.lseekEndFd(fd, 0L);
                PosixFileIO.lseekSetFd(fd, 0L);
            }
            catch (IOException e) {
                try {
                    PosixFileIO.closeFd(fd);
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
        }
        try (JavaFileIO fio = new JavaFileIO(file, options, 1, false);){
            fileLen = fio.length();
            fd = PosixFileIO.openFd(file, options);
        }
        this.mEmpty = fileLen == 0L;
        long mappingSize = (long)pageSize * pageCount;
        if (fileLen < mappingSize) {
            if (options.contains((Object)OpenOption.READ_ONLY)) {
                throw new IOException("File is too short: " + fileLen + " < " + mappingSize);
            }
            try {
                PosixFileIO.ftruncateFd(fd, mappingSize);
            }
            catch (IOException e) {
                try {
                    PosixFileIO.closeFd(fd);
                }
                catch (IOException e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
        }
        int prot = 3;
        int flags = 1;
        try {
            ptr = PosixFileIO.mmapFd(mappingSize, prot, flags, fd, 0L);
        }
        catch (IOException e) {
            try {
                PosixFileIO.closeFd(fd);
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        this.mFileDescriptor = fd;
        this.setMappingPtr(ptr);
    }

    @Override
    public long getPageCount() {
        return this.mEmpty ? 0L : super.getPageCount();
    }

    @Override
    public void setPageCount(long count) {
        this.mEmpty = count == 0L;
    }

    @Override
    MappedPageArray doOpen() throws IOException {
        boolean empty = this.mEmpty;
        PosixMappedPageArray pa = new PosixMappedPageArray(this.pageSize(), super.getPageCount(), this.mFile, this.mOptions);
        pa.mEmpty = empty;
        return pa;
    }

    @Override
    void doSync(long mappingPtr, boolean metadata) throws IOException {
        if (this.mFileDescriptor != -1) {
            PosixFileIO.msyncAddr(mappingPtr, super.getPageCount() * (long)this.pageSize());
            if (metadata) {
                PosixFileIO.fsyncFd(this.mFileDescriptor);
            }
        }
        this.mEmpty = false;
    }

    @Override
    void doSyncPage(long mappingPtr, long index) throws IOException {
        int pageSize = this.pageSize();
        PosixFileIO.msyncAddr(mappingPtr + index * (long)pageSize, pageSize);
        this.mEmpty = false;
    }

    @Override
    void doClose(long mappingPtr) throws IOException {
        PosixFileIO.munmap(mappingPtr, super.getPageCount() * (long)this.pageSize());
        if (this.mFileDescriptor != -1) {
            PosixFileIO.closeFd(this.mFileDescriptor);
        }
    }
}

