/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.EnumSet;
import org.cojen.tupl.io.AbstractFileIO;
import org.cojen.tupl.io.JavaFileIO;
import org.cojen.tupl.io.Mapping;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PosixMapping;
import org.cojen.tupl.util.Latch;

final class PosixFileIO
extends AbstractFileIO {
    private static final int REOPEN_NON_DURABLE = 1;
    private static final int REOPEN_SYNC_IO = 2;
    private final File mFile;
    private final int mReopenOptions;
    private final Latch mAccessLatch;
    private final ThreadLocal<BufRef> mBufRef;
    private int mFileDescriptor;

    PosixFileIO(File file, EnumSet<OpenOption> options) throws IOException {
        super(options);
        this.mFile = file;
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            this.mReopenOptions = 1;
        } else {
            int n = this.mReopenOptions = options.contains((Object)OpenOption.SYNC_IO) ? 2 : 0;
            if (options.contains((Object)OpenOption.CREATE)) {
                new JavaFileIO(file, options, 1, false).close();
            }
        }
        this.mAccessLatch = new Latch();
        this.mAccessLatch.acquireExclusive();
        try {
            this.mFileDescriptor = PosixFileIO.openFd(file, options);
        }
        finally {
            this.mAccessLatch.releaseExclusive();
        }
        this.mBufRef = new ThreadLocal();
        if (options.contains((Object)OpenOption.MAPPED)) {
            this.map();
        }
        if (options.contains((Object)OpenOption.CREATE)) {
            PosixFileIO.dirSync(file);
        }
    }

    @Override
    protected long doLength() throws IOException {
        this.mAccessLatch.acquireShared();
        try {
            long l = PosixFileIO.lseekEndFd(this.fd(), 0L);
            return l;
        }
        finally {
            this.mAccessLatch.releaseShared();
        }
    }

    @Override
    protected void doSetLength(long length) throws IOException {
        this.mAccessLatch.acquireShared();
        try {
            PosixFileIO.ftruncateFd(this.fd(), length);
        }
        finally {
            this.mAccessLatch.releaseShared();
        }
    }

    @Override
    protected void doRead(long pos, byte[] buf, int offset, int length) throws IOException {
        BufRef ref = this.bufRef(length);
        this.doRead(pos, ref.mPointer, length);
        ByteBuffer bb = ref.mBuffer;
        bb.position(0);
        bb.get(buf, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead(long pos, long ptr, int length) throws IOException {
        this.mAccessLatch.acquireShared();
        try {
            PosixFileIO.preadFd(this.fd(), ptr, length, pos);
        }
        finally {
            this.mAccessLatch.releaseShared();
        }
    }

    @Override
    protected void doWrite(long pos, byte[] buf, int offset, int length) throws IOException {
        BufRef ref = this.bufRef(length);
        ByteBuffer bb = ref.mBuffer;
        bb.position(0);
        bb.put(buf, offset, length);
        this.doWrite(pos, ref.mPointer, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWrite(long pos, long ptr, int length) throws IOException {
        this.mAccessLatch.acquireShared();
        try {
            PosixFileIO.pwriteFd(this.fd(), ptr, length, pos);
        }
        finally {
            this.mAccessLatch.releaseShared();
        }
    }

    @Override
    protected Mapping openMapping(boolean readOnly, long pos, int size) throws IOException {
        return new PosixMapping(this.mFileDescriptor, readOnly, pos, size);
    }

    @Override
    protected void reopen() throws IOException {
        this.mAccessLatch.acquireShared();
        try {
            PosixFileIO.closeFd(this.fd());
            EnumSet<OpenOption> options = EnumSet.noneOf(OpenOption.class);
            if (this.isReadOnly()) {
                options.add(OpenOption.READ_ONLY);
            }
            if ((this.mReopenOptions & 2) != 0) {
                options.add(OpenOption.SYNC_IO);
            }
            if ((this.mReopenOptions & 1) != 0) {
                options.add(OpenOption.NON_DURABLE);
            }
            this.mFileDescriptor = PosixFileIO.openFd(this.mFile, options);
        }
        finally {
            this.mAccessLatch.releaseShared();
        }
    }

    @Override
    protected void doSync(boolean metadata) throws IOException {
        this.mAccessLatch.acquireShared();
        try {
            int fd = this.fd();
            if (metadata) {
                PosixFileIO.fsyncFd(fd);
            } else {
                PosixFileIO.fdatasyncFd(fd);
            }
        }
        finally {
            this.mAccessLatch.releaseShared();
        }
    }

    @Override
    public void close() throws IOException {
        this.close(null);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        int fd;
        this.mAccessLatch.acquireExclusive();
        try {
            fd = this.mFileDescriptor;
            if (fd == 0) {
                return;
            }
            this.mCause = cause;
            this.mFileDescriptor = 0;
        }
        finally {
            this.mAccessLatch.releaseExclusive();
        }
        IOException ex = null;
        try {
            this.unmap(false);
        }
        catch (IOException e) {
            ex = e;
        }
        try {
            PosixFileIO.closeFd(fd);
        }
        catch (IOException e) {
            if (ex != null) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private BufRef bufRef(int size) {
        BufRef ref = this.mBufRef.get();
        if (ref == null || ref.mBuffer.capacity() < size) {
            ref = new BufRef(ByteBuffer.allocateDirect(size));
            this.mBufRef.set(ref);
        }
        return ref;
    }

    private int fd() throws IOException {
        int fd = this.mFileDescriptor;
        if (fd == 0) {
            ClosedChannelException ex = new ClosedChannelException();
            ex.initCause(this.mCause);
            throw ex;
        }
        return fd;
    }

    static int openFd(File file, EnumSet<OpenOption> options) throws IOException {
        int fd;
        int flags = 0;
        if (!options.contains((Object)OpenOption.READ_ONLY)) {
            flags |= 2;
        }
        if (options.contains((Object)OpenOption.NON_DURABLE)) {
            if (options.contains((Object)OpenOption.CREATE)) {
                flags |= 0x40;
            }
            int mode = 384;
            fd = RT.shm_open(file.getPath(), flags, mode);
        } else {
            if (options.contains((Object)OpenOption.SYNC_IO)) {
                flags |= 0x1000;
            }
            fd = PosixFileIO.open(file.getPath(), flags);
        }
        if (fd == -1) {
            throw PosixFileIO.lastErrorToException();
        }
        return fd;
    }

    static long lseekSetFd(int fd, long fileOffset) throws IOException {
        return PosixFileIO.lseekFd(fd, fileOffset, 0);
    }

    static long lseekCurFd(int fd, long fileOffset) throws IOException {
        return PosixFileIO.lseekFd(fd, fileOffset, 1);
    }

    static long lseekEndFd(int fd, long fileOffset) throws IOException {
        return PosixFileIO.lseekFd(fd, fileOffset, 2);
    }

    static long lseekFd(int fd, long fileOffset, int whence) throws IOException {
        long result = PosixFileIO.lseek(fd, fileOffset, whence);
        if (result == -1L) {
            throw PosixFileIO.lastErrorToException();
        }
        return result;
    }

    static void preadFd(int fd, long bufPtr, int length, long fileOffset) throws IOException {
        while (true) {
            int amt;
            if ((amt = PosixFileIO.pread(fd, bufPtr, length, fileOffset)) <= 0) {
                if (amt < 0) {
                    throw PosixFileIO.lastErrorToException();
                }
                if (length > 0) {
                    throw new EOFException("Attempt to read past end of file: " + fileOffset);
                }
                return;
            }
            if ((length -= amt) <= 0) {
                return;
            }
            bufPtr += (long)amt;
            fileOffset += (long)amt;
        }
    }

    static void pwriteFd(int fd, long bufPtr, int length, long fileOffset) throws IOException {
        while (true) {
            int amt;
            if ((amt = PosixFileIO.pwrite(fd, bufPtr, length, fileOffset)) < 0) {
                throw PosixFileIO.lastErrorToException();
            }
            if ((length -= amt) <= 0) {
                return;
            }
            bufPtr += (long)amt;
            fileOffset += (long)amt;
        }
    }

    static void ftruncateFd(int fd, long length) throws IOException {
        if (PosixFileIO.ftruncate(fd, length) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void fsyncFd(int fd) throws IOException {
        int result = Platform.isMac() ? PosixFileIO.fcntl(fd, 51) : PosixFileIO.fsync(fd);
        if (result == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void fdatasyncFd(int fd) throws IOException {
        int result = Platform.isMac() ? PosixFileIO.fcntl(fd, 51) : PosixFileIO.fdatasync(fd);
        if (result == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void closeFd(int fd) throws IOException {
        if (PosixFileIO.close(fd) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static long mmapFd(long length, int prot, int flags, int fd, long offset) throws IOException {
        long ptr = PosixFileIO.mmap(0L, length, prot, flags, fd, offset);
        if (ptr == -1L) {
            throw PosixFileIO.lastErrorToException();
        }
        return ptr;
    }

    static void msyncAddr(long addr, long length) throws IOException {
        if (PosixFileIO.msync(addr, length, 4) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static void munmapAddr(long addr, long length) throws IOException {
        if (PosixFileIO.munmap(addr, length) == -1) {
            throw PosixFileIO.lastErrorToException();
        }
    }

    static IOException lastErrorToException() {
        return new IOException(PosixFileIO.errorMessage(Native.getLastError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String errorMessage(int errnum) {
        int bufLen = 200;
        long bufPtr = Native.malloc((long)200L);
        if (bufPtr != 0L) {
            try {
                long result = PosixFileIO.strerror_r(errnum, bufPtr, 200);
                if (result != -1L && result != 22L && result != 34L) {
                    String string = new Pointer(result == 0L ? bufPtr : result).getString(0L);
                    return string;
                }
            }
            finally {
                Native.free((long)bufPtr);
            }
        }
        return "Error " + errnum;
    }

    static native long strerror_r(int var0, long var1, int var3);

    static native int open(String var0, int var1);

    static native long lseek(int var0, long var1, int var3);

    static native int pread(int var0, long var1, int var3, long var4);

    static native int pwrite(int var0, long var1, int var3, long var4);

    static native int ftruncate(int var0, long var1);

    static native int fcntl(int var0, int var1);

    static native int fsync(int var0);

    static native int fdatasync(int var0);

    static native int close(int var0);

    static native long mmap(long var0, long var2, int var4, int var5, int var6, long var7);

    static native int msync(long var0, long var2, int var4);

    static native int munmap(long var0, long var2);

    static {
        Native.register((String)Platform.C_LIBRARY_NAME);
    }

    static class RT {
        RT() {
        }

        static native int shm_open(String var0, int var1, int var2);

        static {
            Native.register((String)"rt");
        }
    }

    static class BufRef {
        final ByteBuffer mBuffer;
        final long mPointer;

        BufRef(ByteBuffer buffer) {
            this.mBuffer = buffer;
            this.mPointer = Pointer.nativeValue((Pointer)Native.getDirectBufferPointer((Buffer)buffer));
        }
    }
}

