/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.io;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class DirectAccess {
    private static final Field cDirectAddress;
    private static final Field cDirectCapacity;
    private static final Constructor<?> cDirectCtor;
    private static final ThreadLocal<ByteBuffer> cLocalBuffer;
    private static final ThreadLocal<ByteBuffer> cLocalBuffer2;
    private final ThreadLocal<ByteBuffer> mLocalBuffer;

    public DirectAccess() {
        if (!DirectAccess.isSupported()) {
            throw new UnsupportedOperationException();
        }
        this.mLocalBuffer = new ThreadLocal();
    }

    public ByteBuffer prepare(long ptr, int length) {
        return DirectAccess.ref(this.mLocalBuffer, ptr, length);
    }

    public static boolean isSupported() {
        return cDirectCtor != null;
    }

    public static ByteBuffer ref(long ptr, int length) {
        return DirectAccess.ref(cLocalBuffer, ptr, length);
    }

    public static ByteBuffer ref2(long ptr, int length) {
        return DirectAccess.ref(cLocalBuffer2, ptr, length);
    }

    private static ByteBuffer ref(ThreadLocal<ByteBuffer> local, long ptr, int length) {
        if (local == null) {
            throw new UnsupportedOperationException();
        }
        ByteBuffer bb = local.get();
        try {
            if (bb == null) {
                bb = (ByteBuffer)cDirectCtor.newInstance(ptr, length);
                local.set(bb);
            } else {
                cDirectAddress.setLong(bb, ptr);
                cDirectCapacity.setInt(bb, length);
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        bb.position(0).limit(length);
        return bb;
    }

    public static void unref(ByteBuffer bb) {
        bb.position(0).limit(0);
        try {
            cDirectCapacity.setInt(bb, 0);
            cDirectAddress.setLong(bb, 0L);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        ThreadLocal local2;
        ThreadLocal local;
        Constructor<?> ctor;
        Field capField;
        Field addrField;
        try {
            addrField = Buffer.class.getDeclaredField("address");
            addrField.setAccessible(true);
            capField = Buffer.class.getDeclaredField("capacity");
            capField.setAccessible(true);
            Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
            ctor = clazz.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            ctor.setAccessible(true);
            local = new ThreadLocal();
            local2 = new ThreadLocal();
        }
        catch (Exception e) {
            addrField = null;
            capField = null;
            ctor = null;
            local = null;
            local2 = null;
        }
        cDirectAddress = addrField;
        cDirectCapacity = capField;
        cDirectCtor = ctor;
        cLocalBuffer = local;
        cLocalBuffer2 = local2;
    }
}

