/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.EOFException;
import java.io.IOException;
import org.cojen.tupl.DataIn;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.RedoDecoder;
import org.cojen.tupl._RedoLog;

final class _RedoLogDecoder
extends RedoDecoder {
    private final _RedoLog mLog;
    private final DataIn mIn;
    private final EventListener mListener;

    _RedoLogDecoder(_RedoLog log, DataIn in, EventListener listener) {
        super(true, 0L);
        this.mLog = log;
        this.mIn = in;
        this.mListener = listener;
    }

    @Override
    DataIn in() {
        return this.mIn;
    }

    @Override
    boolean verifyTerminator(DataIn in) throws IOException {
        try {
            if (in.readIntLE() == this.mLog.nextTermRnd()) {
                return true;
            }
            if (this.mListener != null) {
                this.mListener.notify(EventType.RECOVERY_REDO_LOG_CORRUPTION, "Invalid message terminator", new Object[0]);
            }
            return false;
        }
        catch (EOFException e) {
            if (this.mListener != null) {
                this.mListener.notify(EventType.RECOVERY_REDO_LOG_CORRUPTION, "Unexpected end of file", new Object[0]);
            }
            return false;
        }
    }
}

