/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._Node;
import org.cojen.tupl._PageDb;
import org.cojen.tupl.util.Latch;

final class _NodeDirtyList
extends Latch {
    private _Node mFirstDirty;
    private _Node mLastDirty;
    private _Node mFlushNext;

    _NodeDirtyList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(_Node node, byte cachedState) {
        this.acquireExclusive();
        try {
            node.mCachedState = cachedState;
            _Node next = node.mNextDirty;
            _Node prev = node.mPrevDirty;
            if (next != null) {
                next.mPrevDirty = prev;
                if (next.mPrevDirty == null) {
                    this.mFirstDirty = next;
                } else {
                    prev.mNextDirty = next;
                }
                node.mNextDirty = null;
                node.mPrevDirty = this.mLastDirty;
                this.mLastDirty.mNextDirty = node;
            } else if (prev == null) {
                _Node last = this.mLastDirty;
                if (last == node) {
                    return;
                }
                if (last == null) {
                    this.mFirstDirty = node;
                } else {
                    node.mPrevDirty = last;
                    last.mNextDirty = node;
                }
            }
            this.mLastDirty = node;
            if (this.mFlushNext == node) {
                this.mFlushNext = next;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void swapIfDirty(_Node oldNode, _Node newNode) {
        this.acquireExclusive();
        try {
            _Node prev;
            _Node next = oldNode.mNextDirty;
            if (next != null) {
                newNode.mNextDirty = next;
                next.mPrevDirty = newNode;
                oldNode.mNextDirty = null;
            }
            if ((prev = oldNode.mPrevDirty) != null) {
                newNode.mPrevDirty = prev;
                prev.mNextDirty = newNode;
                oldNode.mPrevDirty = null;
            }
            if (oldNode == this.mFirstDirty) {
                this.mFirstDirty = newNode;
            }
            if (oldNode == this.mLastDirty) {
                this.mLastDirty = newNode;
            }
            if (oldNode == this.mFlushNext) {
                this.mFlushNext = newNode;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(_PageDb pageDb, int dirtyState) throws IOException {
        this.acquireExclusive();
        this.mFlushNext = this.mFirstDirty;
        this.releaseExclusive();
        while (true) {
            byte state;
            _Node node;
            this.acquireExclusive();
            try {
                node = this.mFlushNext;
                if (node == null) {
                    return;
                }
                state = node.mCachedState;
                this.mFlushNext = node.mNextDirty;
            }
            finally {
                this.releaseExclusive();
            }
            if (state == dirtyState) {
                node.acquireExclusive();
                state = node.mCachedState;
                if (state != dirtyState) {
                    node.releaseExclusive();
                    continue;
                }
            } else {
                if (state == 0) continue;
                return;
            }
            this.acquireExclusive();
            try {
                _Node next = node.mNextDirty;
                _Node prev = node.mPrevDirty;
                if (next != null) {
                    next.mPrevDirty = prev;
                    node.mNextDirty = null;
                } else if (this.mLastDirty == node) {
                    this.mLastDirty = prev;
                }
                if (prev != null) {
                    prev.mNextDirty = next;
                    node.mPrevDirty = null;
                } else if (this.mFirstDirty == node) {
                    this.mFirstDirty = next;
                }
            }
            finally {
                this.releaseExclusive();
            }
            node.downgrade();
            try {
                node.write(pageDb);
                node.mCachedState = 0;
                continue;
            }
            finally {
                node.releaseShared();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(_LocalDatabase db) {
        this.acquireExclusive();
        try {
            _Node node = this.mFirstDirty;
            this.mFlushNext = null;
            this.mFirstDirty = null;
            this.mLastDirty = null;
            while (node != null) {
                node.delete(db);
                _Node next = node.mNextDirty;
                node.mPrevDirty = null;
                node.mNextDirty = null;
                node = next;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }
}

