/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.DirectPageOps;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LHashTable;
import org.cojen.tupl.Utils;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.WriteFailureException;
import org.cojen.tupl._CursorFrame;
import org.cojen.tupl._DatabaseAccess;
import org.cojen.tupl._LocalDatabase;
import org.cojen.tupl._LocalTransaction;
import org.cojen.tupl._NodeUsageList;
import org.cojen.tupl._PageDb;
import org.cojen.tupl._Split;
import org.cojen.tupl._Tree;
import org.cojen.tupl._TreeCursor;
import org.cojen.tupl.util.Latch;

final class _Node
extends Latch
implements _DatabaseAccess {
    static final byte CACHED_CLEAN = 0;
    static final byte CACHED_DIRTY_0 = 2;
    static final byte CACHED_DIRTY_1 = 3;
    static final byte TYPE_NONE = 0;
    static final byte TYPE_UNDO_LOG = 64;
    static final byte TYPE_TN_IN = 100;
    static final byte TYPE_TN_BIN = 116;
    static final byte TYPE_TN_LEAF = -128;
    static final byte LOW_EXTREMITY = 2;
    static final byte HIGH_EXTREMITY = 8;
    static final int TN_HEADER_SIZE = 12;
    private static final int CLOSED_ID = -1;
    static final int ENTRY_FRAGMENTED = 64;
    final _NodeUsageList mUsageList;
    _Node mMoreUsed;
    _Node mLessUsed;
    _Node mNextDirty;
    _Node mPrevDirty;
    long mPage;
    volatile long mId;
    byte mCachedState;
    _Node mNodeMapNext;
    volatile transient _CursorFrame mLastCursorFrame;
    transient _Split mSplit;
    static final int OPTION_PARENT_RELEASE_SHARED = 1;
    static final int OPTION_PARENT_RELEASE_EXCLUSIVE = 2;
    static final int OPTION_CHILD_ACQUIRE_EXCLUSIVE = 4;
    private static final int SMALL_KEY_LIMIT = 128;

    _Node(_NodeUsageList usageList, long page) {
        this.mUsageList = usageList;
        this.mPage = page;
    }

    private _Node(long id) {
        super(Integer.MIN_VALUE);
        this.mUsageList = null;
        this.mId = id;
    }

    void delete(_LocalDatabase db) {
        this.acquireExclusive();
        try {
            this.doDelete(db);
        }
        finally {
            this.releaseExclusive();
        }
    }

    void doDelete(_LocalDatabase db) {
        if (db.mFullyMapped) {
            this.closeRoot();
            return;
        }
        long page = this.mPage;
        if (page != DirectPageOps.p_closedTreePage()) {
            DirectPageOps.p_delete(page);
            this.closeRoot();
        }
    }

    @Override
    public _LocalDatabase getDatabase() {
        return this.mUsageList.mDatabase;
    }

    void asEmptyRoot() {
        this.mId = 0L;
        this.mCachedState = 0;
        this.type((byte)-118);
        this.clearEntries();
    }

    void asTrimmedRoot() {
        this.type((byte)-118);
        this.clearEntries();
    }

    void closeRoot() {
        this.mId = -1L;
        this.mCachedState = 0;
        this.mPage = DirectPageOps.p_closedTreePage();
        this.readFields();
    }

    _Node cloneNode() {
        _Node newNode = new _Node(this.mUsageList, this.mPage);
        newNode.mId = this.mId;
        newNode.mCachedState = this.mCachedState;
        return newNode;
    }

    private void clearEntries() {
        this.garbage(0);
        this.leftSegTail(12);
        int pageSize = this.pageSize(this.mPage);
        this.rightSegTail(pageSize - 1);
        this.searchVecStart(12 + (pageSize - 12 >> 1) & 0xFFFFFFFE);
        this.searchVecEnd(this.searchVecStart() - 2);
    }

    void used() {
        this.mUsageList.used(this);
    }

    void unused() {
        this.mUsageList.unused(this);
    }

    void makeEvictable() {
        this.mUsageList.makeEvictable(this);
    }

    void makeEvictableNow() {
        this.mUsageList.makeEvictableNow(this);
    }

    void makeUnevictable() {
        this.mUsageList.makeUnevictable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    _Node loadChild(_LocalDatabase db, long childId, int options) throws IOException {
        _Node childNode;
        _Node lock = new _Node(childId);
        try {
            while ((childNode = db.nodeMapPutIfAbsent(lock)) != null) {
                if ((options & 4) == 0) {
                    childNode.acquireShared();
                    if (childId == childNode.mId) {
                        _Node _Node2 = childNode;
                        return _Node2;
                    }
                    childNode.releaseShared();
                    continue;
                }
                childNode.acquireExclusive();
                if (childId == childNode.mId) {
                    _Node _Node3 = childNode;
                    return _Node3;
                }
                childNode.releaseExclusive();
            }
        }
        finally {
            if ((options & 1) != 0) {
                this.releaseShared();
            } else if ((options & 2) != 0) {
                this.releaseExclusive();
            }
        }
        try {
            try {
                childNode = db.allocLatchedNode(childId);
                childNode.mId = childId;
            }
            catch (Throwable e) {
                db.nodeMapRemove(lock);
                throw e;
            }
            db.nodeMapReplace(lock, childNode);
            try {
                childNode.read(db, childId);
            }
            catch (Throwable e) {
                db.nodeMapRemove(childNode);
                childNode.mId = 0L;
                childNode.type((byte)0);
                childNode.releaseExclusive();
                throw e;
            }
            if ((options & 4) == 0) {
                childNode.downgrade();
            }
            _Node _Node4 = childNode;
            return _Node4;
        }
        catch (Throwable e) {
            if ((options & 3) == 0) {
                this.releaseEither();
            }
            throw e;
        }
        finally {
            lock.mId = 0L;
            lock.releaseExclusive();
        }
    }

    private _Node tryLatchChildNotSplit(int childPos) throws IOException {
        long childId = this.retrieveChildRefId(childPos);
        _LocalDatabase db = this.getDatabase();
        _Node childNode = db.nodeMapGet(childId);
        if (childNode != null) {
            if (!childNode.tryAcquireExclusive()) {
                return null;
            }
            if (childId != childNode.mId) {
                childNode.releaseExclusive();
            } else {
                if (childNode.mSplit == null) {
                    return childNode;
                }
                childNode.releaseExclusive();
                return null;
            }
        }
        return this.loadChild(db, childId, 4);
    }

    void finishSplitRoot() throws IOException {
        _Node right;
        _Node left;
        long newRootPage;
        _LocalDatabase db = this.mUsageList.mDatabase;
        _Node child = db.allocDirtyNode();
        db.nodeMapPut(child);
        if (db.mFullyMapped) {
            newRootPage = this.mPage;
            DirectPageOps.p_copy(newRootPage, 0, child.mPage, 0, db.pageSize());
        } else {
            newRootPage = child.mPage;
            child.mPage = this.mPage;
        }
        _Split split = this.mSplit;
        _Node sibling = this.rebindSplitFrames(split);
        this.mSplit = null;
        _CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            _CursorFrame prev = frame.mPrevCousin;
            frame.rebind(child, frame.mNodePos);
            frame = prev;
        }
        if (split.mSplitRight) {
            left = child;
            right = sibling;
        } else {
            left = sibling;
            right = child;
        }
        int leftSegTail = split.copySplitKeyToParent(newRootPage, 12);
        int searchVecStart = this.pageSize(newRootPage) - (this.pageSize(newRootPage) - leftSegTail + 18 >> 1 & 0xFFFFFFFE);
        DirectPageOps.p_shortPutLE(newRootPage, searchVecStart, 12);
        DirectPageOps.p_longPutLE(newRootPage, searchVecStart + 2, left.mId);
        DirectPageOps.p_longPutLE(newRootPage, searchVecStart + 2 + 8, right.mId);
        int newType = this.isLeaf() ? 126 : 110;
        this.mPage = newRootPage;
        DirectPageOps.p_intPutLE(newRootPage, 0, newType & 0xFF);
        this.leftSegTail(leftSegTail);
        this.rightSegTail(this.pageSize(newRootPage) - 1);
        this.searchVecStart(searchVecStart);
        this.searchVecEnd(searchVecStart);
        _CursorFrame lock = new _CursorFrame();
        this.addParentFrames(lock, left, 0);
        this.addParentFrames(lock, right, 2);
        child.releaseExclusive();
        sibling.releaseExclusive();
        sibling.makeEvictable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParentFrames(_CursorFrame lock, _Node child, int pos) {
        _CursorFrame frame = child.mLastCursorFrame;
        while (frame != null) {
            _CursorFrame lockResult = frame.tryLock(lock);
            if (lockResult != null) {
                try {
                    _CursorFrame parentFrame = frame.mParentFrame;
                    if (parentFrame == null) {
                        parentFrame = new _CursorFrame();
                        parentFrame.bind(this, pos);
                        frame.mParentFrame = parentFrame;
                    } else {
                        parentFrame.rebind(this, pos);
                    }
                }
                finally {
                    frame.unlock(lockResult);
                }
            }
            frame = frame.mPrevCousin;
        }
    }

    void read(_LocalDatabase db, long id) throws IOException {
        db.readNode(this, id);
        try {
            this.readFields();
        }
        catch (IllegalStateException e) {
            throw new CorruptDatabaseException(e.getMessage());
        }
    }

    private void readFields() throws IllegalStateException {
        long page = this.mPage;
        byte type = DirectPageOps.p_byteGet(page, 0);
        if (type != 64 && (type = (byte)(type & 0xFFFFFFF5)) >= 0 && type != 100 && type != 116) {
            throw new IllegalStateException("Unknown node type: " + type + ", id: " + this.mId);
        }
        if (DirectPageOps.p_byteGet(page, 1) != 0) {
            throw new IllegalStateException("Illegal reserved byte in node: " + DirectPageOps.p_byteGet(page, 1));
        }
    }

    void write(_PageDb db) throws WriteFailureException {
        long page = this.prepareWrite();
        try {
            db.writePage(this.mId, page);
        }
        catch (IOException e) {
            throw new WriteFailureException(e);
        }
    }

    private long prepareWrite() {
        if (this.mSplit != null) {
            throw new AssertionError((Object)"Cannot write partially split node");
        }
        long page = this.mPage;
        return page;
    }

    boolean evict(_LocalDatabase db) throws IOException {
        if (this.mLastCursorFrame != null || this.mSplit != null) {
            this.releaseExclusive();
            return false;
        }
        try {
            long id = this.mId;
            if (id > 0L) {
                _PageDb pageDb = db.mPageDb;
                if (this.mCachedState == 0) {
                    pageDb.cachePage(id, this.mPage);
                } else {
                    long page = this.prepareWrite();
                    long newPage = pageDb.evictPage(id, page);
                    if (newPage != page) {
                        this.mPage = newPage;
                    }
                    this.mCachedState = 0;
                }
                db.nodeMapRemove(this, Long.hashCode(id));
                this.mId = 0L;
            }
            return true;
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
    }

    void invalidateCursors() {
        this.invalidateCursors(_Node.createClosedNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCursors(_Node closed) {
        int childPtr;
        int pos = this.isLeaf() ? -1 : 0;
        closed.acquireExclusive();
        try {
            _CursorFrame frame = this.mLastCursorFrame;
            while (frame != null) {
                _CursorFrame prev = frame.mPrevCousin;
                frame.rebind(closed, pos);
                frame = prev;
            }
        }
        finally {
            closed.releaseExclusive();
        }
        if (!this.isInternal()) {
            return;
        }
        _LocalDatabase db = this.mUsageList.mDatabase;
        closed = null;
        int highestPtr = childPtr + (this.highestInternalPos() << 2);
        for (childPtr = this.searchVecEnd() + 2; childPtr <= highestPtr; childPtr += 8) {
            long childId = DirectPageOps.p_uint48GetLE(this.mPage, childPtr);
            _Node child = db.nodeMapGet(childId);
            if (child == null) continue;
            child.acquireExclusive();
            if (childId == child.mId) {
                if (closed == null) {
                    closed = _Node.createClosedNode();
                }
                child.invalidateCursors(closed);
            }
            child.releaseExclusive();
        }
    }

    private static _Node createClosedNode() {
        _Node closed = new _Node(null, DirectPageOps.p_closedTreePage());
        closed.mId = -1L;
        closed.mCachedState = 0;
        closed.readFields();
        return closed;
    }

    private int pageSize(long page) {
        return this.mUsageList.pageSize();
    }

    byte type() {
        return DirectPageOps.p_byteGet(this.mPage, 0);
    }

    void type(byte type) {
        DirectPageOps.p_bytePut(this.mPage, 0, type);
    }

    int garbage() {
        return DirectPageOps.p_ushortGetLE(this.mPage, 2);
    }

    void garbage(int garbage) {
        DirectPageOps.p_shortPutLE(this.mPage, 2, garbage);
    }

    int undoTop() {
        return DirectPageOps.p_ushortGetLE(this.mPage, 2);
    }

    void undoTop(int top) {
        DirectPageOps.p_shortPutLE(this.mPage, 2, top);
    }

    private int leftSegTail() {
        return DirectPageOps.p_ushortGetLE(this.mPage, 4);
    }

    private void leftSegTail(int tail) {
        DirectPageOps.p_shortPutLE(this.mPage, 4, tail);
    }

    private int rightSegTail() {
        return DirectPageOps.p_ushortGetLE(this.mPage, 6);
    }

    private void rightSegTail(int tail) {
        DirectPageOps.p_shortPutLE(this.mPage, 6, tail);
    }

    int searchVecStart() {
        return DirectPageOps.p_ushortGetLE(this.mPage, 8);
    }

    private void searchVecStart(int start) {
        DirectPageOps.p_shortPutLE(this.mPage, 8, start);
    }

    int searchVecEnd() {
        return DirectPageOps.p_ushortGetLE(this.mPage, 10);
    }

    private void searchVecEnd(int end) {
        DirectPageOps.p_shortPutLE(this.mPage, 10, end);
    }

    boolean isLeaf() {
        return this.type() < 0;
    }

    boolean isInternal() {
        return (this.type() & 0xE0) == 96;
    }

    boolean isBottomInternal() {
        return (this.type() & 0xF0) == 112;
    }

    boolean isNonBottomInternal() {
        return (this.type() & 0xF0) == 96;
    }

    int numKeys() {
        return this.searchVecEnd() - this.searchVecStart() + 2 >> 1;
    }

    boolean hasKeys() {
        return this.searchVecEnd() >= this.searchVecStart();
    }

    int highestKeyPos() {
        return this.searchVecEnd() - this.searchVecStart();
    }

    int highestPos() {
        int pos = this.searchVecEnd() - this.searchVecStart();
        if (!this.isLeaf()) {
            pos += 2;
        }
        return pos;
    }

    int highestLeafPos() {
        return this.searchVecEnd() - this.searchVecStart();
    }

    int highestInternalPos() {
        return this.searchVecEnd() - this.searchVecStart() + 2;
    }

    int availableBytes() {
        return this.isLeaf() ? this.availableLeafBytes() : this.availableInternalBytes();
    }

    int availableLeafBytes() {
        return this.garbage() + this.searchVecStart() - this.searchVecEnd() - this.leftSegTail() + this.rightSegTail() + -1;
    }

    int availableInternalBytes() {
        return this.garbage() + 5 * (this.searchVecStart() - this.searchVecEnd()) - this.leftSegTail() + this.rightSegTail() + -17;
    }

    int countNonGhostKeys() {
        long page = this.mPage;
        int count = 0;
        for (int i = this.searchVecStart(); i <= this.searchVecEnd(); i += 2) {
            int loc = DirectPageOps.p_ushortGetLE(page, i);
            if (DirectPageOps.p_byteGet(page, loc + _Node.keyLengthAtLoc(page, loc)) == -1) continue;
            ++count;
        }
        return count;
    }

    boolean shouldLeafMerge() {
        return this.shouldMerge(this.availableLeafBytes());
    }

    boolean shouldInternalMerge() {
        return this.shouldMerge(this.availableInternalBytes());
    }

    boolean shouldMerge(int availBytes) {
        return this.mSplit == null && ((this.type() & 0xA) == 0 && availBytes >= this.pageSize(this.mPage) - 12 >> 1 || !this.hasKeys());
    }

    /*
     * Enabled aggressive block sorting
     */
    int binarySearch(byte[] key) throws IOException {
        long page = this.mPage;
        int keyLen = key.length;
        int lowPos = this.searchVecStart();
        int highPos = this.searchVecEnd();
        int lowMatch = 0;
        int highMatch = 0;
        block0: while (true) {
            int i;
            int compareLen;
            int midPos;
            block12: {
                int minLen;
                int compareLoc;
                block11: {
                    int minLen2;
                    byte[] compareKey;
                    block10: {
                        block9: {
                            block8: {
                                if (lowPos > highPos) {
                                    return ~(lowPos - this.searchVecStart());
                                }
                                midPos = lowPos + highPos >> 1 & 0xFFFFFFFE;
                                compareLoc = DirectPageOps.p_ushortGetLE(page, midPos);
                                if ((compareLen = DirectPageOps.p_byteGet(page, compareLoc++)) < 0) break block8;
                                ++compareLen;
                                break block9;
                            }
                            int header = compareLen;
                            compareLen = (compareLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, compareLoc++);
                            if ((header & 0x40) == 0) break block9;
                            compareKey = this.getDatabase().reconstructKey(page, compareLoc, compareLen);
                            compareLen = compareKey.length;
                            minLen2 = Math.min(compareLen, keyLen);
                            break block10;
                        }
                        minLen = Math.min(compareLen, keyLen);
                        break block11;
                    }
                    for (i = Math.min(lowMatch, highMatch); i < minLen2; ++i) {
                        byte cb = compareKey[i];
                        byte kb = key[i];
                        if (cb == kb) continue;
                        if ((cb & 0xFF) < (kb & 0xFF)) {
                            lowPos = midPos + 2;
                            lowMatch = i;
                            continue block0;
                        }
                        highPos = midPos - 2;
                        highMatch = i;
                        continue block0;
                    }
                    break block12;
                }
                for (i = Math.min(lowMatch, highMatch); i < minLen; ++i) {
                    byte kb;
                    byte cb = DirectPageOps.p_byteGet(page, compareLoc + i);
                    if (cb == (kb = key[i])) continue;
                    if ((cb & 0xFF) < (kb & 0xFF)) {
                        lowPos = midPos + 2;
                        lowMatch = i;
                        continue block0;
                    }
                    highPos = midPos - 2;
                    highMatch = i;
                    continue block0;
                }
            }
            if (compareLen < keyLen) {
                lowPos = midPos + 2;
                lowMatch = i;
                continue;
            }
            if (compareLen <= keyLen) {
                return midPos - this.searchVecStart();
            }
            highPos = midPos - 2;
            highMatch = i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    int binarySearch(byte[] key, int midPos) throws IOException {
        int highPos;
        int lowPos = this.searchVecStart();
        if (lowPos > (highPos = this.searchVecEnd())) {
            return -1;
        }
        if ((midPos += lowPos) > highPos) {
            midPos = highPos;
        }
        long page = this.mPage;
        int keyLen = key.length;
        int lowMatch = 0;
        int highMatch = 0;
        while (true) {
            block12: {
                int i;
                int compareLen;
                block17: {
                    int minLen;
                    int compareLoc;
                    block16: {
                        int minLen2;
                        byte[] compareKey;
                        block15: {
                            block14: {
                                block13: {
                                    compareLoc = DirectPageOps.p_ushortGetLE(page, midPos);
                                    if ((compareLen = DirectPageOps.p_byteGet(page, compareLoc++)) < 0) break block13;
                                    ++compareLen;
                                    break block14;
                                }
                                int header = compareLen;
                                compareLen = (compareLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, compareLoc++);
                                if ((header & 0x40) == 0) break block14;
                                compareKey = this.getDatabase().reconstructKey(page, compareLoc, compareLen);
                                compareLen = compareKey.length;
                                minLen2 = Math.min(compareLen, keyLen);
                                break block15;
                            }
                            minLen = Math.min(compareLen, keyLen);
                            break block16;
                        }
                        for (i = Math.min(lowMatch, highMatch); i < minLen2; ++i) {
                            byte cb = compareKey[i];
                            byte kb = key[i];
                            if (cb == kb) continue;
                            if ((cb & 0xFF) < (kb & 0xFF)) {
                                lowPos = midPos + 2;
                                lowMatch = i;
                                break block12;
                            } else {
                                highPos = midPos - 2;
                                highMatch = i;
                            }
                            break block12;
                        }
                        break block17;
                    }
                    for (i = Math.min(lowMatch, highMatch); i < minLen; ++i) {
                        byte kb;
                        byte cb = DirectPageOps.p_byteGet(page, compareLoc + i);
                        if (cb == (kb = key[i])) continue;
                        if ((cb & 0xFF) < (kb & 0xFF)) {
                            lowPos = midPos + 2;
                            lowMatch = i;
                            break block12;
                        } else {
                            highPos = midPos - 2;
                            highMatch = i;
                        }
                        break block12;
                    }
                }
                if (compareLen < keyLen) {
                    lowPos = midPos + 2;
                    lowMatch = i;
                } else {
                    if (compareLen <= keyLen) return midPos - this.searchVecStart();
                    highPos = midPos - 2;
                    highMatch = i;
                }
            }
            if (lowPos > highPos) {
                return ~(lowPos - this.searchVecStart());
            }
            midPos = lowPos + highPos >> 1 & 0xFFFFFFFE;
        }
    }

    static int internalPos(int pos) {
        return pos < 0 ? ~pos : pos + 2;
    }

    int compareKey(int pos, byte[] rightKey) throws IOException {
        int keyLen;
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        if ((keyLen = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                byte[] leftKey = this.getDatabase().reconstructKey(page, loc, keyLen);
                return Utils.compareUnsigned(leftKey, 0, leftKey.length, rightKey, 0, rightKey.length);
            }
        }
        return DirectPageOps.p_compareKeysPageToArray(page, loc, keyLen, rightKey, 0, rightKey.length);
    }

    void retrieveKeyStats(int pos, long[] stats) throws IOException {
        int keyLen;
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        if ((keyLen = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                this.getDatabase().reconstruct(page, loc, keyLen, stats);
                return;
            }
        }
        stats[0] = keyLen;
        stats[1] = 0L;
    }

    byte[] retrieveKey(int pos) throws IOException {
        long page = this.mPage;
        return _Node.retrieveKeyAtLoc(this, page, DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos));
    }

    byte[] retrieveKeyAtLoc(long page, int loc) throws IOException {
        return _Node.retrieveKeyAtLoc(this, page, loc);
    }

    static byte[] retrieveKeyAtLoc(_DatabaseAccess dbAccess, long page, int loc) throws IOException {
        int keyLen;
        if ((keyLen = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                return dbAccess.getDatabase().reconstructKey(page, loc, keyLen);
            }
        }
        byte[] key = new byte[keyLen];
        DirectPageOps.p_copyToArray(page, loc, key, 0, keyLen);
        return key;
    }

    private boolean retrieveActualKeyAtLoc(long page, int loc, byte[][] akeyRef) throws IOException {
        int keyLen;
        boolean result = true;
        if ((keyLen = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
            result = (header & 0x40) == 0;
        }
        byte[] akey = new byte[keyLen];
        DirectPageOps.p_copyToArray(page, loc, akey, 0, keyLen);
        akeyRef[0] = akey;
        return result;
    }

    byte[] retrieveKeyCmp(int pos, byte[] limitKey, int limitMode) throws IOException {
        int keyLen;
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        if ((keyLen = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                byte[] key = this.getDatabase().reconstructKey(page, loc, keyLen);
                int cmp = Utils.compareUnsigned(key, limitKey);
                if (cmp == 0) {
                    return limitKey;
                }
                return (byte[])((cmp ^ limitMode) < 0 ? key : null);
            }
        }
        int cmp = DirectPageOps.p_compareKeysPageToArray(page, loc, keyLen, limitKey, 0, limitKey.length);
        if (cmp == 0) {
            return limitKey;
        }
        if ((cmp ^ limitMode) < 0) {
            byte[] key = new byte[keyLen];
            DirectPageOps.p_copyToArray(page, loc, key, 0, keyLen);
            return key;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    static byte[][] retrieveKeyValueAtLoc(_DatabaseAccess dbAccess, long page, int loc) throws IOException {
        block2: {
            if ((header = DirectPageOps.p_byteGet(page, loc++)) < 0) break block2;
            keyLen = header + 1;
            ** GOTO lbl-1000
        }
        keyLen = (header & 63) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
        if ((header & 64) != 0) {
            key = dbAccess.getDatabase().reconstructKey(page, loc, keyLen);
        } else lbl-1000:
        // 2 sources

        {
            key = new byte[keyLen];
            DirectPageOps.p_copyToArray(page, loc, key, 0, keyLen);
        }
        return new byte[][]{key, _Node.retrieveLeafValueAtLoc(null, page, loc + keyLen)};
    }

    private byte[] midKey(int lowPos, byte[] highKey) throws IOException {
        long lowPage = this.mPage;
        int lowLoc = DirectPageOps.p_ushortGetLE(lowPage, this.searchVecStart() + lowPos);
        byte lowKeyLen = DirectPageOps.p_byteGet(lowPage, lowLoc);
        if (lowKeyLen < 0) {
            return Utils.midKey(this.retrieveKeyAtLoc(lowPage, lowLoc), highKey);
        }
        return DirectPageOps.p_midKeyLowPage(lowPage, lowLoc + 1, lowKeyLen + 1, highKey, 0, highKey.length);
    }

    private byte[] midKey(byte[] lowKey, int highPos) throws IOException {
        long highPage = this.mPage;
        int highLoc = DirectPageOps.p_ushortGetLE(highPage, this.searchVecStart() + highPos);
        byte highKeyLen = DirectPageOps.p_byteGet(highPage, highLoc);
        if (highKeyLen < 0) {
            return Utils.midKey(lowKey, this.retrieveKeyAtLoc(highPage, highLoc));
        }
        return DirectPageOps.p_midKeyHighPage(lowKey, 0, lowKey.length, highPage, highLoc + 1, highKeyLen + 1);
    }

    byte[] midKey(int lowPos, _Node highNode, int highPos) throws IOException {
        long lowPage = this.mPage;
        int lowLoc = DirectPageOps.p_ushortGetLE(lowPage, this.searchVecStart() + lowPos);
        int lowKeyLen = DirectPageOps.p_byteGet(lowPage, lowLoc);
        if (lowKeyLen < 0) {
            return highNode.midKey(this.retrieveKeyAtLoc(lowPage, lowLoc), highPos);
        }
        ++lowLoc;
        ++lowKeyLen;
        long highPage = highNode.mPage;
        int highLoc = DirectPageOps.p_ushortGetLE(highPage, highNode.searchVecStart() + highPos);
        byte highKeyLen = DirectPageOps.p_byteGet(highPage, highLoc);
        if (highKeyLen < 0) {
            byte[] highKey = this.retrieveKeyAtLoc(highPage, highLoc);
            return DirectPageOps.p_midKeyLowPage(lowPage, lowLoc, lowKeyLen, highKey, 0, highKey.length);
        }
        return DirectPageOps.p_midKeyLowHighPage(lowPage, lowLoc, lowKeyLen, highPage, highLoc + 1, highKeyLen + 1);
    }

    byte[] hasLeafValue(int pos) {
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        return DirectPageOps.p_byteGet(page, loc += _Node.keyLengthAtLoc(page, loc)) == -1 ? null : Cursor.NOT_LOADED;
    }

    void retrieveLeafValueStats(int pos, long[] stats) throws IOException {
        int len;
        int header;
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        loc += _Node.keyLengthAtLoc(page, loc);
        if ((header = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            len = header;
        } else {
            if ((header & 0x20) == 0) {
                len = 1 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            } else if (header != -1) {
                len = 1 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            } else {
                stats[0] = 0L;
                stats[1] = 0L;
                return;
            }
            if ((header & 0x40) != 0) {
                this.getDatabase().reconstruct(page, loc, len, stats);
                return;
            }
        }
        stats[0] = len;
        stats[1] = 0L;
    }

    byte[] retrieveLeafValue(int pos) throws IOException {
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        loc += _Node.keyLengthAtLoc(page, loc);
        return _Node.retrieveLeafValueAtLoc(this, page, loc);
    }

    static byte[] retrieveLeafValueAtLoc(_DatabaseAccess dbAccess, long page, int loc) throws IOException {
        int len;
        int header;
        if ((header = DirectPageOps.p_byteGet(page, loc++)) == 0) {
            return Utils.EMPTY_BYTES;
        }
        if (header >= 0) {
            len = header;
        } else {
            if ((header & 0x20) == 0) {
                len = 1 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            } else if (header != -1) {
                len = 1 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            } else {
                return null;
            }
            if ((header & 0x40) != 0) {
                return dbAccess.getDatabase().reconstruct(page, loc, len);
            }
        }
        byte[] value = new byte[len];
        DirectPageOps.p_copyToArray(page, loc, value, 0, len);
        return value;
    }

    /*
     * Unable to fully structure code
     */
    void retrieveLeafEntry(int pos, _TreeCursor cursor) throws IOException {
        block2: {
            page = this.mPage;
            loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
            if ((header = DirectPageOps.p_byteGet(page, loc++)) < 0) break block2;
            keyLen = header + 1;
            ** GOTO lbl-1000
        }
        keyLen = (header & 63) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
        if ((header & 64) != 0) {
            key = this.getDatabase().reconstructKey(page, loc, keyLen);
        } else lbl-1000:
        // 2 sources

        {
            key = new byte[keyLen];
            DirectPageOps.p_copyToArray(page, loc, key, 0, keyLen);
        }
        cursor.mKey = key;
        value = cursor.mKeyOnly != false ? (DirectPageOps.p_byteGet(page, loc) == -1 ? null : Cursor.NOT_LOADED) : _Node.retrieveLeafValueAtLoc(this, page, loc += keyLen);
        cursor.mValue = value;
    }

    boolean isFragmentedLeafValue(int pos) {
        byte header;
        long page = this.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        return ((header = DirectPageOps.p_byteGet(page, loc += _Node.keyLengthAtLoc(page, loc))) & 0xC0) >= 192 & header < -1;
    }

    /*
     * Unable to fully structure code
     */
    void txnDeleteLeafEntry(_LocalTransaction txn, _Tree tree, byte[] key, int keyHash, int pos) throws IOException {
        block8: {
            block7: {
                block6: {
                    block5: {
                        page = this.mPage;
                        loc = entryLoc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
                        loc += _Node.keyLengthAtLoc(page, loc);
                        valueHeaderLoc = loc;
                        if ((header = DirectPageOps.p_byteGet(page, loc++)) < 0) break block5;
                        loc += header;
                        ** GOTO lbl-1000
                    }
                    if ((header & 32) != 0) break block6;
                    loc += 2 + ((header & 31) << 8 | DirectPageOps.p_ubyteGet(page, loc));
                    break block7;
                }
                if (header == -1) break block8;
                loc += 3 + ((header & 15) << 16 | DirectPageOps.p_ubyteGet(page, loc) << 8 | DirectPageOps.p_ubyteGet(page, loc + 1));
            }
            ** if ((header & 64) == 0) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                valueStartLoc = valueHeaderLoc + 2 + ((header & 32) >> 5);
                tree.mDatabase.fragmentedTrash().add((_LocalTransaction)txn, (long)tree.mId, (long)page, (int)entryLoc, (int)(valueHeaderLoc - entryLoc), (int)valueStartLoc, (int)(loc - valueStartLoc));
                ** GOTO lbl22
            }
lbl-1000:
            // 2 sources

            {
                txn.pushUndoStore(tree.mId, (byte)21, page, entryLoc, loc - entryLoc);
            }
        }
        tree.mLockManager.ghosted(tree, key, keyHash);
        DirectPageOps.p_bytePut(page, valueHeaderLoc, -1);
        this.garbage(this.garbage() + loc - valueHeaderLoc - 1);
        if (txn.mDurabilityMode != DurabilityMode.NO_REDO) {
            txn.redoStore(tree.mId, key, null);
        }
    }

    void txnPreUpdateLeafEntry(_LocalTransaction txn, _Tree tree, byte[] key, int pos) throws IOException {
        int loc;
        int entryLoc;
        long page;
        block5: {
            byte header;
            int valueHeaderLoc;
            block7: {
                block6: {
                    block4: {
                        page = this.mPage;
                        loc = entryLoc = DirectPageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
                        loc += _Node.keyLengthAtLoc(page, loc);
                        valueHeaderLoc = loc;
                        if ((header = DirectPageOps.p_byteGet(page, loc++)) < 0) break block4;
                        loc += header;
                        break block5;
                    }
                    if ((header & 0x20) != 0) break block6;
                    loc += 2 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc));
                    break block7;
                }
                if (header == -1) break block5;
                loc += 3 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc) << 8 | DirectPageOps.p_ubyteGet(page, loc + 1));
            }
            if ((header & 0x40) != 0) {
                int valueStartLoc = valueHeaderLoc + 2 + ((header & 0x20) >> 5);
                tree.mDatabase.fragmentedTrash().add(txn, tree.mId, page, entryLoc, valueHeaderLoc - entryLoc, valueStartLoc, loc - valueStartLoc);
                DirectPageOps.p_bytePut(page, valueHeaderLoc, header & 0xFFFFFFBF);
                return;
            }
        }
        txn.pushUndoStore(tree.mId, (byte)20, page, entryLoc, loc - entryLoc);
    }

    long retrieveChildRefId(int pos) {
        return DirectPageOps.p_uint48GetLE(this.mPage, this.searchVecEnd() + 2 + (pos << 2));
    }

    int retrieveChildEntryCount(int pos) {
        return DirectPageOps.p_ushortGetLE(this.mPage, this.searchVecEnd() + 8 + (pos << 2)) - 1;
    }

    void storeChildEntryCount(int pos, int count) {
        if (count < 65535) {
            DirectPageOps.p_shortPutLE(this.mPage, this.searchVecEnd() + 8 + (pos << 2), count + 1);
        }
    }

    static int leafEntryLengthAtLoc(long page, int entryLoc) {
        byte header;
        int loc = entryLoc + _Node.keyLengthAtLoc(page, entryLoc);
        if ((header = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
            loc += header;
        } else if ((header & 0x20) == 0) {
            loc += 2 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc));
        } else if (header != -1) {
            loc += 3 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc) << 8 | DirectPageOps.p_ubyteGet(page, loc + 1));
        }
        return loc - entryLoc;
    }

    static int keyLengthAtLoc(long page, int keyLoc) {
        int header = DirectPageOps.p_byteGet(page, keyLoc);
        return (header >= 0 ? header : (header & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, keyLoc + 1)) + 2;
    }

    void insertLeafEntry(_CursorFrame frame, _Tree tree, int pos, byte[] okey, byte[] value) throws IOException {
        byte[] akey = okey;
        int encodedKeyLen = _Node.calculateAllowedKeyLength(tree, okey);
        if (encodedKeyLen < 0) {
            akey = tree.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int vfrag;
            int encodedLen = encodedKeyLen + _Node.calculateLeafValueLength(value);
            if (encodedLen <= tree.mMaxEntrySize) {
                vfrag = 0;
            } else {
                _LocalDatabase db = tree.mDatabase;
                if ((value = db.fragment(value, value.length, db.mMaxFragmentedEntrySize - encodedKeyLen)) == null) {
                    throw new AssertionError();
                }
                encodedLen = encodedKeyLen + _Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
            try {
                int entryLoc = this.createLeafEntry(frame, tree, pos, encodedLen);
                if (entryLoc < 0) {
                    this.splitLeafAndCreateEntry(tree, okey, akey, vfrag, value, encodedLen, pos, true);
                } else {
                    this.copyToLeafEntry(okey, akey, vfrag, value, entryLoc);
                }
            }
            catch (Throwable e) {
                if (vfrag == 64) {
                    this.cleanupFragments(e, value);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                this.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    void insertBlankLeafEntry(_CursorFrame frame, _Tree tree, int pos, byte[] okey, long vlength) throws IOException {
        byte[] akey = okey;
        int encodedKeyLen = _Node.calculateAllowedKeyLength(tree, okey);
        if (encodedKeyLen < 0) {
            akey = tree.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int encodedLen;
            byte[] value;
            int vfrag;
            long longEncodedLen = (long)encodedKeyLen + _Node.calculateLeafValueLength(vlength);
            if (longEncodedLen <= (long)tree.mMaxEntrySize) {
                vfrag = 0;
                value = new byte[(int)vlength];
                encodedLen = (int)longEncodedLen;
            } else {
                _LocalDatabase db = tree.mDatabase;
                value = db.fragment(null, vlength, db.mMaxFragmentedEntrySize - encodedKeyLen);
                if (value == null) {
                    throw new AssertionError();
                }
                encodedLen = encodedKeyLen + _Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
            try {
                int entryLoc = this.createLeafEntry(frame, tree, pos, encodedLen);
                if (entryLoc < 0) {
                    this.splitLeafAndCreateEntry(tree, okey, akey, vfrag, value, encodedLen, pos, true);
                } else {
                    this.copyToLeafEntry(okey, akey, vfrag, value, entryLoc);
                }
            }
            catch (Throwable e) {
                if (vfrag == 64) {
                    this.cleanupFragments(e, value);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                this.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    void insertFragmentedLeafEntry(_CursorFrame frame, _Tree tree, int pos, byte[] okey, byte[] value) throws IOException {
        byte[] akey = okey;
        int encodedKeyLen = _Node.calculateAllowedKeyLength(tree, okey);
        if (encodedKeyLen < 0) {
            akey = tree.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int encodedLen = encodedKeyLen + _Node.calculateFragmentedValueLength(value);
            int entryLoc = this.createLeafEntry(frame, tree, pos, encodedLen);
            if (entryLoc < 0) {
                this.splitLeafAndCreateEntry(tree, okey, akey, 64, value, encodedLen, pos, true);
            } else {
                this.copyToLeafEntry(okey, akey, 64, value, entryLoc);
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                this.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    private void panic(Throwable cause) {
        try {
            this.getDatabase().close(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupFragments(Throwable cause, byte[] fragmented) {
        if (fragmented != null) {
            long copy = DirectPageOps.p_transfer(fragmented);
            try {
                this.getDatabase().deleteFragments(copy, 0, fragmented.length);
            }
            catch (Throwable e) {
                cause.addSuppressed(e);
                this.panic(cause);
            }
            finally {
                DirectPageOps.p_delete(copy);
            }
        }
    }

    int createLeafEntry(_CursorFrame frame, _Tree tree, int pos, int encodedLen) {
        int entryLoc;
        long page;
        block10: {
            int newSearchVecStart;
            int remaining;
            int searchVecEnd;
            int searchVecStart;
            block13: {
                int max;
                int rightSpace;
                int leftSpace;
                block15: {
                    block14: {
                        int result;
                        block18: {
                            _CursorFrame parentFrame;
                            block16: {
                                int result2;
                                block17: {
                                    block11: {
                                        block12: {
                                            block8: {
                                                block9: {
                                                    searchVecStart = this.searchVecStart();
                                                    searchVecEnd = this.searchVecEnd();
                                                    leftSpace = searchVecStart - this.leftSegTail();
                                                    rightSpace = this.rightSegTail() - searchVecEnd - 1;
                                                    page = this.mPage;
                                                    if (pos >= searchVecEnd - searchVecStart + 2 >> 1) break block8;
                                                    if ((leftSpace -= 2) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block9;
                                                    DirectPageOps.p_copy(page, searchVecStart, page, searchVecStart -= 2, pos);
                                                    pos += searchVecStart;
                                                    this.searchVecStart(searchVecStart);
                                                    break block10;
                                                }
                                                leftSpace += 2;
                                                break block11;
                                            }
                                            if ((rightSpace -= 2) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block12;
                                            DirectPageOps.p_copy(page, pos += searchVecStart, page, pos + 2, (searchVecEnd += 2) - pos);
                                            this.searchVecEnd(searchVecEnd);
                                            break block10;
                                        }
                                        rightSpace += 2;
                                    }
                                    remaining = leftSpace + rightSpace - encodedLen - 2;
                                    if (this.garbage() <= remaining) break block13;
                                    if (this.garbage() + remaining >= 0) break block14;
                                    if (frame == null || (parentFrame = frame.mParentFrame) == null) break block15;
                                    if ((this.mId & 1L) != 0L) break block16;
                                    result2 = this.tryRebalanceLeafLeft(tree, parentFrame, pos, encodedLen, -remaining);
                                    if (result2 != 0) break block17;
                                    result2 = this.tryRebalanceLeafRight(tree, parentFrame, pos, encodedLen, -remaining);
                                    if (result2 == 0) break block15;
                                    if (result2 > 0) {
                                        return result2;
                                    }
                                    break block14;
                                }
                                if (result2 > 0) {
                                    return result2;
                                }
                                pos += result2;
                                break block14;
                            }
                            result = this.tryRebalanceLeafRight(tree, parentFrame, pos, encodedLen, -remaining);
                            if (result != 0) break block18;
                            result = this.tryRebalanceLeafLeft(tree, parentFrame, pos, encodedLen, -remaining);
                            if (result == 0) break block15;
                            if (result > 0) {
                                return result;
                            }
                            pos += result;
                            break block14;
                        }
                        if (result > 0) {
                            return result;
                        }
                    }
                    return this.compactLeaf(encodedLen, pos, true);
                }
                return (max = this.garbage() + leftSpace + rightSpace - 6) <= 0 ? -1 : ~max;
            }
            int vecLen = searchVecEnd - searchVecStart + 2;
            if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                newSearchVecStart = this.rightSegTail() - vecLen + -1 - (remaining >> 1) & 0xFFFFFFFE;
                entryLoc = this.leftSegTail();
                this.leftSegTail(entryLoc + encodedLen);
            } else if ((this.leftSegTail() & 1) == 0) {
                newSearchVecStart = this.leftSegTail() + (remaining >> 1 & 0xFFFFFFFE);
                entryLoc = this.rightSegTail() - encodedLen + 1;
                this.rightSegTail(entryLoc - 1);
            } else {
                return this.compactLeaf(encodedLen, pos, true);
            }
            DirectPageOps.p_copies(page, searchVecStart, newSearchVecStart, pos, searchVecStart + pos, newSearchVecStart + pos + 2, vecLen - pos);
            pos += newSearchVecStart;
            this.searchVecStart(newSearchVecStart);
            this.searchVecEnd(newSearchVecStart + vecLen);
        }
        DirectPageOps.p_shortPutLE(page, pos, entryLoc);
        return entryLoc;
    }

    /*
     * Unable to fully structure code
     */
    private int tryRebalanceLeafLeft(_Tree tree, _CursorFrame parentFrame, int pos, int insertLen, int minAmount) {
        block23: {
            block22: {
                block21: {
                    rightPage = this.mPage;
                    moveAmount = 0;
                    insertLoc = 0;
                    insertSlack = 0x7FFFFFFF;
                    searchVecEnd = searchVecLoc + pos - 2;
                    for (searchVecLoc = this.searchVecStart(); searchVecLoc < searchVecEnd; searchVecLoc += 2) {
                        entryLoc = DirectPageOps.p_ushortGetLE(rightPage, searchVecLoc);
                        encodedLen = _Node.leafEntryLengthAtLoc(rightPage, entryLoc);
                        slack = encodedLen - insertLen;
                        if (slack >= 0 && slack < insertSlack) {
                            insertLoc = entryLoc;
                            insertSlack = slack;
                        }
                        if ((moveAmount += encodedLen + 2) < minAmount || insertLoc == 0) {
                            continue;
                        }
                        break block21;
                    }
                    return 0;
                }
                lastSearchVecLoc = searchVecLoc + 2;
                parent = parentFrame.tryAcquireExclusive();
                if (parent == null) {
                    return 0;
                }
                childPos = parentFrame.mNodePos;
                if (childPos <= 0 || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    left = parent.tryLatchChildNotSplit(childPos - 2);
                }
                catch (IOException e) {
                    return 0;
                }
                if (left == null) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    leftAvail = left.availableLeafBytes();
                    if (leftAvail < moveAmount || (newKeyLen = _Node.calculateAllowedKeyLength(tree, newKey = this.midKey((highPos = lastSearchVecLoc - this.searchVecStart()) - 2, this, highPos))) <= 0 || (parentKeyGrowth = newKeyLen - _Node.keyLengthAtLoc(parentPage = parent.mPage, parentKeyLoc = DirectPageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos - 2))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) break block22;
                    break block23;
                }
                catch (IOException leftAvail) {
                    // empty catch block
                }
            }
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        try {
            if (tree.mDatabase.markDirty(tree, left)) {
                parent.updateChildRefId(childPos - 2, left.mId);
            }
        }
        catch (IOException e) {
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        if (parentKeyGrowth <= 0) {
            _Node.encodeNormalKey(newKey, parentPage, parentKeyLoc);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKey(childPos - 2, parentKeyGrowth, newKey, newKeyLen);
        }
        garbageAccum = 0;
        lastPos = lastSearchVecLoc - searchVecLoc;
        for (searchVecLoc = this.searchVecStart(); searchVecLoc < lastSearchVecLoc; searchVecLoc += 2) {
            entryLoc = DirectPageOps.p_ushortGetLE(rightPage, searchVecLoc);
            encodedLen = _Node.leafEntryLengthAtLoc(rightPage, entryLoc);
            leftEntryLoc = left.createLeafEntry(null, tree, left.highestLeafPos() + 2, encodedLen);
            DirectPageOps.p_copy(rightPage, entryLoc, left.mPage, leftEntryLoc, encodedLen);
            garbageAccum += encodedLen;
        }
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecStart(lastSearchVecLoc);
        leftEndPos = left.highestLeafPos() + 2;
        frame = this.mLastCursorFrame;
        while (frame != null) {
            prev = frame.mPrevCousin;
            framePos = frame.mNodePos;
            mask = framePos >> 31;
            newPos = (framePos ^ mask) - lastPos;
            v0 = newPos < 0;
            if (!(newPos == 0 & mask != 0)) ** GOTO lbl-1000
            frameKey = frame.mNotFoundKey;
            if (frame.mNotFoundKey != null && Utils.compareUnsigned(frameKey, newKey) < 0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (v0 | v1) {
                frame.rebind(left, leftEndPos + newPos ^ mask);
                frame.adjustParentPosition(-2);
            } else {
                frame.mNodePos = newPos ^ mask;
            }
            frame = prev;
        }
        left.releaseExclusive();
        parent.releaseExclusive();
        this.garbage(this.garbage() - insertLen);
        searchVecStart = this.searchVecStart();
        DirectPageOps.p_copy(rightPage, searchVecStart, rightPage, searchVecStart -= 2, pos -= lastPos);
        this.searchVecStart(searchVecStart);
        DirectPageOps.p_shortPutLE(rightPage, searchVecStart + pos, insertLoc);
        return insertLoc;
    }

    /*
     * Unable to fully structure code
     */
    private int tryRebalanceLeafRight(_Tree tree, _CursorFrame parentFrame, int pos, int insertLen, int minAmount) {
        block23: {
            block22: {
                block21: {
                    leftPage = this.mPage;
                    moveAmount = 0;
                    insertLoc = 0;
                    insertSlack = 0x7FFFFFFF;
                    searchVecStart = this.searchVecStart() + pos;
                    for (searchVecLoc = this.searchVecEnd(); searchVecLoc > searchVecStart; searchVecLoc -= 2) {
                        entryLoc = DirectPageOps.p_ushortGetLE(leftPage, searchVecLoc);
                        encodedLen = _Node.leafEntryLengthAtLoc(leftPage, entryLoc);
                        slack = encodedLen - insertLen;
                        if (slack >= 0 && slack < insertSlack) {
                            insertLoc = entryLoc;
                            insertSlack = slack;
                        }
                        if ((moveAmount += encodedLen + 2) < minAmount || insertLoc == 0) {
                            continue;
                        }
                        break block21;
                    }
                    return 0;
                }
                firstSearchVecLoc = searchVecLoc;
                parent = parentFrame.tryAcquireExclusive();
                if (parent == null) {
                    return 0;
                }
                childPos = parentFrame.mNodePos;
                if (childPos >= parent.highestInternalPos() || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    right = parent.tryLatchChildNotSplit(childPos + 2);
                }
                catch (IOException e) {
                    return 0;
                }
                if (right == null) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    rightAvail = right.availableLeafBytes();
                    if (rightAvail < moveAmount || (newKeyLen = _Node.calculateAllowedKeyLength(tree, newKey = this.midKey((highPos = firstSearchVecLoc - this.searchVecStart()) - 2, this, highPos))) <= 0 || (parentKeyGrowth = newKeyLen - _Node.keyLengthAtLoc(parentPage = parent.mPage, parentKeyLoc = DirectPageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) break block22;
                    break block23;
                }
                catch (IOException rightAvail) {
                    // empty catch block
                }
            }
            right.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        try {
            if (tree.mDatabase.markDirty(tree, right)) {
                parent.updateChildRefId(childPos + 2, right.mId);
            }
        }
        catch (IOException e) {
            right.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        if (parentKeyGrowth <= 0) {
            _Node.encodeNormalKey(newKey, parentPage, parentKeyLoc);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKey(childPos, parentKeyGrowth, newKey, newKeyLen);
        }
        garbageAccum = 0;
        moved = searchVecLoc - firstSearchVecLoc + 2;
        for (searchVecLoc = this.searchVecEnd(); searchVecLoc >= firstSearchVecLoc; searchVecLoc -= 2) {
            entryLoc = DirectPageOps.p_ushortGetLE(leftPage, searchVecLoc);
            encodedLen = _Node.leafEntryLengthAtLoc(leftPage, entryLoc);
            rightEntryLoc = right.createLeafEntry(null, tree, 0, encodedLen);
            DirectPageOps.p_copy(leftPage, entryLoc, right.mPage, rightEntryLoc, encodedLen);
            garbageAccum += encodedLen;
        }
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecEnd(firstSearchVecLoc - 2);
        frame = right.mLastCursorFrame;
        while (frame != null) {
            framePos = frame.mNodePos;
            mask = framePos >> 31;
            frame.mNodePos = (framePos ^ mask) + moved ^ mask;
            frame = frame.mPrevCousin;
        }
        leftEndPos = firstSearchVecLoc - this.searchVecStart();
        frame = this.mLastCursorFrame;
        while (frame != null) {
            prev = frame.mPrevCousin;
            framePos = frame.mNodePos;
            mask = framePos >> 31;
            newPos = (framePos ^ mask) - leftEndPos;
            v0 = newPos >= 0;
            if (newPos != 0 | mask == 0) ** GOTO lbl-1000
            frameKey = frame.mNotFoundKey;
            if (frame.mNotFoundKey != null && Utils.compareUnsigned(frameKey, newKey) >= 0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (v0 & v1) {
                frame.rebind(right, newPos ^ mask);
                frame.adjustParentPosition(2);
            }
            frame = prev;
        }
        right.releaseExclusive();
        parent.releaseExclusive();
        this.garbage(this.garbage() - insertLen);
        newSearchVecEnd = this.searchVecEnd() + 2;
        DirectPageOps.p_copy(leftPage, pos += this.searchVecStart(), leftPage, pos + 2, newSearchVecEnd - pos);
        this.searchVecEnd(newSearchVecEnd);
        DirectPageOps.p_shortPutLE(leftPage, pos, insertLoc);
        return insertLoc;
    }

    void insertSplitChildRef(_CursorFrame frame, _Tree tree, int keyPos, _Node splitChild) throws IOException {
        _Split split = splitChild.mSplit;
        _Node newChild = splitChild.rebindSplitFrames(split);
        try {
            _Node rightChild;
            splitChild.mSplit = null;
            int newChildPos = keyPos >> 1;
            if (split.mSplitRight) {
                rightChild = newChild;
                ++newChildPos;
            } else {
                rightChild = splitChild;
            }
            _CursorFrame f = this.mLastCursorFrame;
            while (f != null) {
                int fPos = f.mNodePos;
                if (fPos > keyPos) {
                    f.mNodePos = fPos + 2;
                }
                f = f.mPrevCousin;
            }
            _CursorFrame childFrame = rightChild.mLastCursorFrame;
            while (childFrame != null) {
                childFrame.adjustParentPosition(2);
                childFrame = childFrame.mPrevCousin;
            }
            InResult result = new InResult();
            try {
                this.createInternalEntry(frame, result, tree, keyPos, split.splitKeyEncodedLength(), newChildPos << 3, true);
            }
            catch (Throwable e) {
                this.panic(e);
                throw e;
            }
            DirectPageOps.p_longPutLE(result.mPage, result.mNewChildLoc, newChild.mId);
            int entryLoc = result.mEntryLoc;
            if (entryLoc < 0) {
                this.mSplit.setKey(split);
            } else {
                split.copySplitKeyToParent(result.mPage, entryLoc);
            }
        }
        catch (Throwable e) {
            splitChild.releaseExclusive();
            newChild.releaseExclusive();
            this.releaseExclusive();
            throw e;
        }
        splitChild.releaseExclusive();
        newChild.releaseExclusive();
        try {
            newChild.makeEvictable();
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
    }

    private void createInternalEntry(_CursorFrame frame, InResult result, _Tree tree, int keyPos, int encodedLen, int newChildPos, boolean allowSplit) throws IOException {
        int entryLoc;
        long page;
        block10: {
            int newSearchVecStart;
            int remaining;
            int searchVecEnd;
            int searchVecStart;
            block13: {
                block15: {
                    block14: {
                        _CursorFrame parentFrame;
                        block16: {
                            int adjust;
                            block17: {
                                int rightSpace;
                                int leftSpace;
                                block11: {
                                    block12: {
                                        block8: {
                                            block9: {
                                                searchVecStart = this.searchVecStart();
                                                searchVecEnd = this.searchVecEnd();
                                                leftSpace = searchVecStart - this.leftSegTail();
                                                rightSpace = this.rightSegTail() - searchVecEnd - (searchVecEnd - searchVecStart << 2) - 17;
                                                page = this.mPage;
                                                if (newChildPos >= 3 * (searchVecEnd - searchVecStart + 2) + keyPos + 8 >> 1) break block8;
                                                if ((leftSpace -= 10) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block9;
                                                DirectPageOps.p_copy(page, searchVecStart, page, searchVecStart - 10, keyPos);
                                                DirectPageOps.p_copy(page, searchVecStart + keyPos, page, searchVecStart + keyPos - 8, searchVecEnd - searchVecStart + 2 - keyPos + newChildPos);
                                                this.searchVecStart(searchVecStart -= 10);
                                                keyPos += searchVecStart;
                                                this.searchVecEnd(searchVecEnd -= 8);
                                                newChildPos += searchVecEnd + 2;
                                                break block10;
                                            }
                                            leftSpace += 10;
                                            break block11;
                                        }
                                        if ((leftSpace -= 2) < 0 || (rightSpace -= 8) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block12;
                                        DirectPageOps.p_copy(page, searchVecStart, page, searchVecStart -= 2, keyPos);
                                        this.searchVecStart(searchVecStart);
                                        keyPos += searchVecStart;
                                        DirectPageOps.p_copy(page, searchVecEnd + newChildPos + 2, page, searchVecEnd + newChildPos + 10, (searchVecEnd - searchVecStart << 2) + 8 - newChildPos);
                                        newChildPos += searchVecEnd + 2;
                                        break block10;
                                    }
                                    leftSpace += 2;
                                    rightSpace += 8;
                                }
                                remaining = leftSpace + rightSpace - encodedLen - 10;
                                if (this.garbage() <= remaining) break block13;
                                if (this.garbage() + remaining >= 0) break block14;
                                if (frame == null || (parentFrame = frame.mParentFrame) == null) break block15;
                                if ((this.mId & 1L) != 0L) break block16;
                                adjust = this.tryRebalanceInternalLeft(tree, parentFrame, keyPos, -remaining);
                                if (adjust != 0) break block17;
                                if (this.tryRebalanceInternalRight(tree, parentFrame, keyPos, -remaining)) break block14;
                                break block15;
                            }
                            keyPos -= adjust;
                            newChildPos -= adjust << 2;
                            break block14;
                        }
                        if (this.tryRebalanceInternalRight(tree, parentFrame, keyPos, -remaining)) break block14;
                        int adjust = this.tryRebalanceInternalLeft(tree, parentFrame, keyPos, -remaining);
                        if (adjust == 0) break block15;
                        keyPos -= adjust;
                        newChildPos -= adjust << 2;
                    }
                    this.compactInternal(result, encodedLen, keyPos, newChildPos);
                    return;
                }
                if (!allowSplit) {
                    throw new AssertionError((Object)"_Split not allowed");
                }
                this.splitInternal(result, tree, encodedLen, keyPos, newChildPos);
                return;
            }
            int vecLen = searchVecEnd - searchVecStart + 2;
            int childIdsLen = (vecLen << 2) + 8;
            if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                newSearchVecStart = this.rightSegTail() - vecLen - childIdsLen + -9 - (remaining >> 1) & 0xFFFFFFFE;
                entryLoc = this.leftSegTail();
                this.leftSegTail(entryLoc + encodedLen);
            } else if ((this.leftSegTail() & 1) == 0) {
                newSearchVecStart = this.leftSegTail() + (remaining >> 1 & 0xFFFFFFFE);
                entryLoc = this.rightSegTail() - encodedLen + 1;
                this.rightSegTail(entryLoc - 1);
            } else {
                this.compactInternal(result, encodedLen, keyPos, newChildPos);
                return;
            }
            int newSearchVecEnd = newSearchVecStart + vecLen;
            DirectPageOps.p_copies(page, searchVecStart, newSearchVecStart, keyPos, searchVecStart + keyPos, newSearchVecStart + keyPos + 2, vecLen - keyPos + newChildPos, searchVecEnd + 2 + newChildPos, newSearchVecEnd + 10 + newChildPos, childIdsLen - newChildPos);
            keyPos += newSearchVecStart;
            newChildPos += newSearchVecEnd + 2;
            this.searchVecStart(newSearchVecStart);
            this.searchVecEnd(newSearchVecEnd);
        }
        DirectPageOps.p_shortPutLE(page, keyPos, entryLoc);
        result.mPage = page;
        result.mNewChildLoc = newChildPos;
        result.mEntryLoc = entryLoc;
    }

    private int tryRebalanceInternalLeft(_Tree tree, _CursorFrame parentFrame, int keyPos, int minAmount) {
        int searchVecLoc;
        int parentKeyLoc;
        int parentKeyLen;
        int searchKeyLoc;
        int searchKeyLen;
        int parentKeyGrowth;
        _Node left;
        int lastSearchVecLoc;
        int leftGrowth;
        long rightPage;
        long parentPage;
        int childPos;
        _Node parent;
        block18: {
            int searchVecLoc2;
            parent = parentFrame.tryAcquireExclusive();
            if (parent == null) {
                return 0;
            }
            childPos = parentFrame.mNodePos;
            if (childPos <= 0 || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                parent.releaseExclusive();
                return 0;
            }
            parentPage = parent.mPage;
            rightPage = this.mPage;
            int rightShrink = 0;
            leftGrowth = 0;
            int searchVecEnd = searchVecLoc2 + keyPos - 2;
            for (searchVecLoc2 = this.searchVecStart(); searchVecLoc2 < searchVecEnd; searchVecLoc2 += 2) {
                int keyLoc = DirectPageOps.p_ushortGetLE(rightPage, searchVecLoc2);
                int len = _Node.keyLengthAtLoc(rightPage, keyLoc) + 10;
                leftGrowth += len;
                if ((rightShrink += len) < minAmount) continue;
                lastSearchVecLoc = searchVecLoc2;
                leftGrowth -= len;
                keyLoc = DirectPageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos - 2);
                leftGrowth += _Node.keyLengthAtLoc(parentPage, keyLoc) + 10;
                break block18;
            }
            parent.releaseExclusive();
            return 0;
        }
        try {
            left = parent.tryLatchChildNotSplit(childPos - 2);
        }
        catch (IOException e) {
            return 0;
        }
        if (left == null) {
            parent.releaseExclusive();
            return 0;
        }
        int leftAvail = left.availableInternalBytes();
        if (leftAvail < leftGrowth || (parentKeyGrowth = (searchKeyLen = _Node.keyLengthAtLoc(rightPage, searchKeyLoc = DirectPageOps.p_ushortGetLE(rightPage, lastSearchVecLoc))) - (parentKeyLen = _Node.keyLengthAtLoc(parentPage, parentKeyLoc = DirectPageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos - 2)))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) {
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        try {
            if (tree.mDatabase.markDirty(tree, left)) {
                parent.updateChildRefId(childPos - 2, left.mId);
            }
        }
        catch (IOException e) {
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        int garbageAccum = searchKeyLen;
        int moved = lastSearchVecLoc - searchVecLoc + 2;
        try {
            int pos = left.highestInternalPos();
            InResult result = new InResult();
            left.createInternalEntry(null, result, tree, pos, parentKeyLen, pos + 2 << 2, false);
            DirectPageOps.p_copy(parentPage, parentKeyLoc, left.mPage, result.mEntryLoc, parentKeyLen);
            for (searchVecLoc = this.searchVecStart(); searchVecLoc < lastSearchVecLoc; searchVecLoc += 2) {
                int keyLoc = DirectPageOps.p_ushortGetLE(rightPage, searchVecLoc);
                int encodedLen = _Node.keyLengthAtLoc(rightPage, keyLoc);
                pos = left.highestInternalPos();
                left.createInternalEntry(null, result, tree, pos, encodedLen, pos + 2 << 2, false);
                DirectPageOps.p_copy(rightPage, keyLoc, left.mPage, result.mEntryLoc, encodedLen);
                garbageAccum += encodedLen;
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
        if (parentKeyGrowth <= 0) {
            DirectPageOps.p_copy(rightPage, searchKeyLoc, parentPage, parentKeyLoc, searchKeyLen);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKeyEncoded(childPos - 2, parentKeyGrowth, rightPage, searchKeyLoc, searchKeyLen);
        }
        int start = this.searchVecEnd() + 2;
        int len = moved << 2;
        int end = left.searchVecEnd();
        end = end + (end - left.searchVecStart() << 2) + 18 - len;
        DirectPageOps.p_copy(rightPage, start, left.mPage, end, len);
        DirectPageOps.p_copy(rightPage, start + len, rightPage, start, start - lastSearchVecLoc << 2);
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecStart(lastSearchVecLoc + 2);
        int leftEndPos = left.highestInternalPos() + 2;
        _CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            _CursorFrame prev = frame.mPrevCousin;
            int framePos = frame.mNodePos;
            int newPos = framePos - moved;
            if (newPos < 0) {
                frame.rebind(left, leftEndPos + newPos);
                frame.adjustParentPosition(-2);
            } else {
                frame.mNodePos = newPos;
            }
            frame = prev;
        }
        left.releaseExclusive();
        parent.releaseExclusive();
        return moved;
    }

    private boolean tryRebalanceInternalRight(_Tree tree, _CursorFrame parentFrame, int keyPos, int minAmount) {
        int searchVecLoc;
        int parentKeyLoc;
        int parentKeyLen;
        int searchKeyLoc;
        int searchKeyLen;
        int parentKeyGrowth;
        _Node right;
        int firstSearchVecLoc;
        int rightGrowth;
        long leftPage;
        long parentPage;
        int childPos;
        _Node parent;
        block18: {
            parent = parentFrame.tryAcquireExclusive();
            if (parent == null) {
                return false;
            }
            childPos = parentFrame.mNodePos;
            if (childPos >= parent.highestInternalPos() || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                parent.releaseExclusive();
                return false;
            }
            parentPage = parent.mPage;
            leftPage = this.mPage;
            int leftShrink = 0;
            rightGrowth = 0;
            int searchVecStart = this.searchVecStart() + keyPos;
            for (int searchVecLoc2 = this.searchVecEnd(); searchVecLoc2 > searchVecStart; searchVecLoc2 -= 2) {
                int keyLoc = DirectPageOps.p_ushortGetLE(leftPage, searchVecLoc2);
                int len = _Node.keyLengthAtLoc(leftPage, keyLoc) + 10;
                rightGrowth += len;
                if ((leftShrink += len) < minAmount) continue;
                firstSearchVecLoc = searchVecLoc2;
                rightGrowth -= len;
                keyLoc = DirectPageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos);
                rightGrowth += _Node.keyLengthAtLoc(parentPage, keyLoc) + 10;
                break block18;
            }
            parent.releaseExclusive();
            return false;
        }
        try {
            right = parent.tryLatchChildNotSplit(childPos + 2);
        }
        catch (IOException e) {
            return false;
        }
        if (right == null) {
            parent.releaseExclusive();
            return false;
        }
        int rightAvail = right.availableInternalBytes();
        if (rightAvail < rightGrowth || (parentKeyGrowth = (searchKeyLen = _Node.keyLengthAtLoc(leftPage, searchKeyLoc = DirectPageOps.p_ushortGetLE(leftPage, firstSearchVecLoc))) - (parentKeyLen = _Node.keyLengthAtLoc(parentPage, parentKeyLoc = DirectPageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos)))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) {
            right.releaseExclusive();
            parent.releaseExclusive();
            return false;
        }
        try {
            if (tree.mDatabase.markDirty(tree, right)) {
                parent.updateChildRefId(childPos + 2, right.mId);
            }
        }
        catch (IOException e) {
            right.releaseExclusive();
            parent.releaseExclusive();
            return false;
        }
        int garbageAccum = searchKeyLen;
        int moved = searchVecLoc - firstSearchVecLoc + 2;
        try {
            InResult result = new InResult();
            right.createInternalEntry(null, result, tree, 0, parentKeyLen, 0, false);
            DirectPageOps.p_copy(parentPage, parentKeyLoc, right.mPage, result.mEntryLoc, parentKeyLen);
            for (searchVecLoc = this.searchVecEnd(); searchVecLoc > firstSearchVecLoc; searchVecLoc -= 2) {
                int keyLoc = DirectPageOps.p_ushortGetLE(leftPage, searchVecLoc);
                int encodedLen = _Node.keyLengthAtLoc(leftPage, keyLoc);
                right.createInternalEntry(null, result, tree, 0, encodedLen, 0, false);
                DirectPageOps.p_copy(leftPage, keyLoc, right.mPage, result.mEntryLoc, encodedLen);
                garbageAccum += encodedLen;
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
        if (parentKeyGrowth <= 0) {
            DirectPageOps.p_copy(leftPage, searchKeyLoc, parentPage, parentKeyLoc, searchKeyLen);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKeyEncoded(childPos, parentKeyGrowth, leftPage, searchKeyLoc, searchKeyLen);
        }
        int start = this.searchVecEnd() + 2;
        int len = (start - this.searchVecStart() << 2) + 8 - (moved << 2);
        DirectPageOps.p_copy(leftPage, start, leftPage, start - moved, len);
        DirectPageOps.p_copy(leftPage, start + len, right.mPage, right.searchVecEnd() + 2, moved << 2);
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecEnd(firstSearchVecLoc - 2);
        _CursorFrame frame = right.mLastCursorFrame;
        while (frame != null) {
            frame.mNodePos += moved;
            frame = frame.mPrevCousin;
        }
        int adjust = firstSearchVecLoc - this.searchVecStart() + 4;
        _CursorFrame frame2 = this.mLastCursorFrame;
        while (frame2 != null) {
            _CursorFrame prev = frame2.mPrevCousin;
            int newPos = frame2.mNodePos - adjust;
            if (newPos >= 0) {
                frame2.rebind(right, newPos);
                frame2.adjustParentPosition(2);
            }
            frame2 = prev;
        }
        right.releaseExclusive();
        parent.releaseExclusive();
        return true;
    }

    private _Node rebindSplitFrames(_Split split) {
        _Node sibling = split.latchSiblingEx();
        try {
            _CursorFrame frame = this.mLastCursorFrame;
            while (frame != null) {
                _CursorFrame prev = frame.mPrevCousin;
                split.rebindFrame(frame, sibling);
                frame = prev;
            }
            return sibling;
        }
        catch (Throwable e) {
            sibling.releaseExclusive();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    void updateLeafValue(_CursorFrame frame, _Tree tree, int pos, int vfrag, byte[] value) throws IOException {
        block28: {
            block29: {
                page = this.mPage;
                searchVecStart = this.searchVecStart();
                start = loc = DirectPageOps.p_ushortGetLE(page, searchVecStart + pos);
                loc += _Node.keyLengthAtLoc(page, loc);
                valueHeaderLoc = loc;
                if ((len = DirectPageOps.p_byteGet(page, loc++)) >= 0) break block28;
                if ((len & 32) != 0) break block29;
                header = len;
                len = 1 + ((len & 31) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
                ** GOTO lbl17
            }
            if (len == -1) {
                len = 0;
            } else {
                header = len;
                len = 1 + ((len & 15) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
lbl17:
                // 2 sources

                if ((header & 64) != 0) {
                    tree.mDatabase.deleteFragments(page, loc, len);
                    if (vfrag == 0) {
                        DirectPageOps.p_bytePut(page, valueHeaderLoc, header & -65);
                    }
                }
            }
        }
        if ((valueLen = value.length) <= len) {
            if (valueLen == len) {
                if (valueLen == 0) {
                    DirectPageOps.p_bytePut(page, valueHeaderLoc, 0);
                } else {
                    DirectPageOps.p_copyFromArray(value, 0, page, loc, valueLen);
                    if (vfrag != 0) {
                        DirectPageOps.p_bytePut(page, valueHeaderLoc, DirectPageOps.p_byteGet(page, valueHeaderLoc) | vfrag);
                    }
                }
            } else {
                this.garbage(this.garbage() + loc + len - _Node.copyToLeafValue(page, vfrag, value, valueHeaderLoc) - valueLen);
            }
            return;
        }
        keyLen = valueHeaderLoc - start;
        garbage = this.garbage() + loc + len - start;
        searchVecEnd = this.searchVecEnd();
        leftSpace = searchVecStart - this.leftSegTail();
        rightSpace = this.rightSegTail() - searchVecEnd - 1;
        vfragOriginal = vfrag;
        if (vfrag != 0) {
            encodedLen = keyLen + _Node.calculateFragmentedValueLength(value);
        } else {
            encodedLen = keyLen + _Node.calculateLeafValueLength(value);
            if (encodedLen > tree.mMaxEntrySize) {
                db = tree.mDatabase;
                if ((value = db.fragment(value, value.length, db.mMaxFragmentedEntrySize - keyLen)) == null) {
                    throw new AssertionError();
                }
                encodedLen = keyLen + _Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
        }
        try {
            entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace);
            if (entryLoc >= 0) {
                pos += searchVecStart;
            } else {
                remaining = leftSpace + rightSpace - encodedLen;
                if (garbage > remaining) {
                    akeyRef = new byte[1][];
                    loc = DirectPageOps.p_ushortGetLE(page, searchVecStart + pos);
                    isOriginal = this.retrieveActualKeyAtLoc(page, loc, akeyRef);
                    akey = akeyRef[0];
                    if (garbage + remaining < 0) {
                        if (this.mSplit == null) {
                            okey = isOriginal != false ? akey : _Node.retrieveKeyAtLoc(this, page, loc);
                            this.splitLeafAndCreateEntry(tree, okey, akey, vfrag, value, encodedLen, pos, false);
                            return;
                        }
                        if (vfrag != 0) {
                            throw new DatabaseException("Fragmented entry doesn't fit");
                        }
                        db = tree.mDatabase;
                        max = Math.min(db.mMaxFragmentedEntrySize, garbage + leftSpace + rightSpace);
                        if ((value = db.fragment(value, value.length, max)) == null) {
                            throw new AssertionError();
                        }
                        encodedLen = keyLen + _Node.calculateFragmentedValueLength(value);
                        vfrag = 64;
                    }
                    this.garbage(garbage);
                    entryLoc = this.compactLeaf(encodedLen, pos, false);
                    page = this.mPage;
                    entryLoc = isOriginal != false ? _Node.encodeNormalKey(akey, page, entryLoc) : _Node.encodeFragmentedKey(akey, page, entryLoc);
                    _Node.copyToLeafValue(page, vfrag, value, entryLoc);
                    return;
                }
                vecLen = searchVecEnd - searchVecStart + 2;
                if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                    newSearchVecStart = this.rightSegTail() - vecLen + 1 - (remaining >> 1) & -2;
                    entryLoc = this.leftSegTail();
                    this.leftSegTail(entryLoc + encodedLen);
                } else if ((this.leftSegTail() & 1) == 0) {
                    newSearchVecStart = this.leftSegTail() + (remaining >> 1 & -2);
                    entryLoc = this.rightSegTail() - encodedLen + 1;
                    this.rightSegTail(entryLoc - 1);
                } else {
                    akeyRef = new byte[1][];
                    loc = DirectPageOps.p_ushortGetLE(page, searchVecStart + pos);
                    isOriginal = this.retrieveActualKeyAtLoc(page, loc, akeyRef);
                    akey = akeyRef[0];
                    this.garbage(garbage);
                    entryLoc = this.compactLeaf(encodedLen, pos, false);
                    page = this.mPage;
                    entryLoc = isOriginal != false ? _Node.encodeNormalKey(akey, page, entryLoc) : _Node.encodeFragmentedKey(akey, page, entryLoc);
                    _Node.copyToLeafValue(page, vfrag, value, entryLoc);
                    return;
                }
                DirectPageOps.p_copy(page, searchVecStart, page, newSearchVecStart, vecLen);
                pos += newSearchVecStart;
                this.searchVecStart(newSearchVecStart);
                this.searchVecEnd(newSearchVecStart + vecLen - 2);
            }
        }
        catch (Throwable e) {
            if (vfrag == 64 && vfragOriginal != 64) {
                this.cleanupFragments(e, value);
            }
            throw e;
        }
        DirectPageOps.p_copy(page, start, page, entryLoc, keyLen);
        _Node.copyToLeafValue(page, vfrag, value, entryLoc + keyLen);
        DirectPageOps.p_shortPutLE(page, pos, entryLoc);
        this.garbage(garbage);
    }

    void updateInternalKey(int pos, int growth, byte[] key, int encodedLen) {
        int entryLoc = this.doUpdateInternalKey(pos, growth, encodedLen);
        _Node.encodeNormalKey(key, this.mPage, entryLoc);
    }

    void updateInternalKeyEncoded(int pos, int growth, long key, int keyStart, int encodedLen) {
        int entryLoc = this.doUpdateInternalKey(pos, growth, encodedLen);
        DirectPageOps.p_copy(key, keyStart, this.mPage, entryLoc, encodedLen);
    }

    /*
     * Unable to fully structure code
     */
    int doUpdateInternalKey(int pos, int growth, int encodedLen) {
        block6: {
            block7: {
                block5: {
                    garbage = this.garbage() + encodedLen - growth;
                    searchVecStart = this.searchVecStart();
                    searchVecEnd = this.searchVecEnd();
                    leftSpace = searchVecStart - this.leftSegTail();
                    entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace = this.rightSegTail() - searchVecEnd - (searchVecEnd - searchVecStart << 2) - 17);
                    if (entryLoc < 0) break block5;
                    pos += searchVecStart;
                    break block6;
                }
                remaining = leftSpace + rightSpace - encodedLen;
                if (garbage <= remaining) break block7;
                if (garbage + remaining < 0) {
                    throw new AssertionError();
                }
                ** GOTO lbl-1000
            }
            vecLen = searchVecEnd - searchVecStart + 2;
            childIdsLen = (vecLen << 2) + 8;
            if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                newSearchVecStart = this.rightSegTail() - vecLen - childIdsLen + 1 - (remaining >> 1) & -2;
                entryLoc = this.leftSegTail();
                this.leftSegTail(entryLoc + encodedLen);
            } else {
                if ((this.leftSegTail() & 1) != 0) lbl-1000:
                // 2 sources

                {
                    this.garbage(garbage);
                    result = new InResult();
                    this.compactInternal(result, encodedLen, pos, -2147483648);
                    return result.mEntryLoc;
                }
                newSearchVecStart = this.leftSegTail() + (remaining >> 1 & -2);
                entryLoc = this.rightSegTail() - encodedLen + 1;
                this.rightSegTail(entryLoc - 1);
            }
            page = this.mPage;
            DirectPageOps.p_copy(page, searchVecStart, page, newSearchVecStart, vecLen + childIdsLen);
            pos += newSearchVecStart;
            this.searchVecStart(newSearchVecStart);
            this.searchVecEnd(newSearchVecStart + vecLen - 2);
        }
        DirectPageOps.p_shortPutLE(this.mPage, pos, entryLoc);
        this.garbage(garbage);
        return entryLoc;
    }

    void updateChildRefId(int pos, long id) {
        DirectPageOps.p_longPutLE(this.mPage, this.searchVecEnd() + 2 + (pos << 2), id);
    }

    void deleteLeafEntry(int pos) throws IOException {
        int loc;
        int entryLoc;
        block8: {
            int len;
            byte header;
            long page;
            block10: {
                block9: {
                    block7: {
                        int keyLen;
                        page = this.mPage;
                        int searchVecStart = this.searchVecStart();
                        loc = entryLoc = DirectPageOps.p_ushortGetLE(page, searchVecStart + pos);
                        if ((keyLen = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
                            loc += keyLen + 1;
                        } else {
                            int header2 = keyLen;
                            keyLen = (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
                            if ((header2 & 0x40) != 0) {
                                this.getDatabase().deleteFragments(page, loc, keyLen);
                            }
                            loc += keyLen;
                        }
                        header = DirectPageOps.p_byteGet(page, loc++);
                        if (header < 0) break block7;
                        loc += header;
                        break block8;
                    }
                    if ((header & 0x20) != 0) break block9;
                    len = 1 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
                    break block10;
                }
                if (header == -1) break block8;
                len = 1 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            }
            if ((header & 0x40) != 0) {
                this.getDatabase().deleteFragments(page, loc, len);
            }
            loc += len;
        }
        this.doDeleteLeafEntry(pos, loc - entryLoc);
    }

    void doDeleteLeafEntry(int pos, int entryLen) {
        this.garbage(this.garbage() + entryLen);
        long page = this.mPage;
        int searchVecStart = this.searchVecStart();
        int searchVecEnd = this.searchVecEnd();
        if (pos < searchVecEnd - searchVecStart + 2 >> 1) {
            DirectPageOps.p_copy(page, searchVecStart, page, searchVecStart += 2, pos);
            this.searchVecStart(searchVecStart);
        } else {
            DirectPageOps.p_copy(page, (pos += searchVecStart) + 2, page, pos, searchVecEnd - pos);
            this.searchVecEnd(searchVecEnd - 2);
        }
    }

    static void moveLeafToLeftAndDelete(_Tree tree, _Node leftNode, _Node rightNode) throws IOException {
        tree.mDatabase.prepareToDelete(rightNode);
        long rightPage = rightNode.mPage;
        int searchVecEnd = rightNode.searchVecEnd();
        int leftEndPos = leftNode.highestLeafPos() + 2;
        for (int searchVecStart = rightNode.searchVecStart(); searchVecStart <= searchVecEnd; searchVecStart += 2) {
            int entryLoc = DirectPageOps.p_ushortGetLE(rightPage, searchVecStart);
            int encodedLen = _Node.leafEntryLengthAtLoc(rightPage, entryLoc);
            int leftEntryLoc = leftNode.createLeafEntry(null, tree, leftNode.highestLeafPos() + 2, encodedLen);
            DirectPageOps.p_copy(rightPage, entryLoc, leftNode.mPage, leftEntryLoc, encodedLen);
        }
        _CursorFrame frame = rightNode.mLastCursorFrame;
        while (frame != null) {
            int framePos;
            _CursorFrame prev = frame.mPrevCousin;
            frame.rebind(leftNode, framePos + ((framePos = frame.mNodePos) < 0 ? -leftEndPos : leftEndPos));
            frame = prev;
        }
        leftNode.type((byte)(leftNode.type() | rightNode.type() & 8));
        tree.mDatabase.deleteNode(rightNode);
    }

    static void moveInternalToLeftAndDelete(_Tree tree, _Node leftNode, _Node rightNode, long parentPage, int parentLoc, int parentLen) throws IOException {
        tree.mDatabase.prepareToDelete(rightNode);
        int leftEndPos = leftNode.highestInternalPos();
        InResult result = new InResult();
        leftNode.createInternalEntry(null, result, tree, leftEndPos, parentLen, (leftEndPos += 2) << 2, false);
        long rightPage = rightNode.mPage;
        int rightChildIdsLoc = rightNode.searchVecEnd() + 2;
        DirectPageOps.p_copy(rightPage, rightChildIdsLoc, result.mPage, result.mNewChildLoc, 8);
        rightChildIdsLoc += 8;
        DirectPageOps.p_copy(parentPage, parentLoc, result.mPage, result.mEntryLoc, parentLen);
        int searchVecEnd = rightNode.searchVecEnd();
        for (int searchVecStart = rightNode.searchVecStart(); searchVecStart <= searchVecEnd; searchVecStart += 2) {
            int entryLoc = DirectPageOps.p_ushortGetLE(rightPage, searchVecStart);
            int encodedLen = _Node.keyLengthAtLoc(rightPage, entryLoc);
            int pos = leftNode.highestInternalPos();
            leftNode.createInternalEntry(null, result, tree, pos, encodedLen, pos + 2 << 2, false);
            DirectPageOps.p_copy(rightPage, rightChildIdsLoc, result.mPage, result.mNewChildLoc, 8);
            rightChildIdsLoc += 8;
            DirectPageOps.p_copy(rightPage, entryLoc, result.mPage, result.mEntryLoc, encodedLen);
        }
        _CursorFrame frame = rightNode.mLastCursorFrame;
        while (frame != null) {
            _CursorFrame prev = frame.mPrevCousin;
            int framePos = frame.mNodePos;
            frame.rebind(leftNode, leftEndPos + framePos);
            frame = prev;
        }
        leftNode.type((byte)(leftNode.type() | rightNode.type() & 8));
        tree.mDatabase.deleteNode(rightNode);
    }

    void deleteRightChildRef(int childPos) {
        _CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            int framePos = frame.mNodePos;
            if (framePos >= childPos) {
                frame.mNodePos = framePos - 2;
            }
            frame = frame.mPrevCousin;
        }
        this.deleteChildRef(childPos);
    }

    void deleteLeftChildRef(int childPos) {
        _CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            int framePos = frame.mNodePos;
            if (framePos > childPos) {
                frame.mNodePos = framePos - 2;
            }
            frame = frame.mPrevCousin;
        }
        this.deleteChildRef(childPos);
    }

    private void deleteChildRef(int childPos) {
        long page = this.mPage;
        int keyPos = childPos == 0 ? 0 : childPos - 2;
        int searchVecStart = this.searchVecStart();
        int entryLoc = DirectPageOps.p_ushortGetLE(page, searchVecStart + keyPos);
        this.garbage(this.garbage() + _Node.keyLengthAtLoc(page, entryLoc));
        int searchVecEnd = this.searchVecEnd();
        if ((childPos <<= 2) < 3 * (searchVecEnd - searchVecStart) + keyPos + 8 >> 1) {
            DirectPageOps.p_copy(page, searchVecStart + keyPos + 2, page, searchVecStart + keyPos + 10, searchVecEnd - searchVecStart - keyPos + childPos);
            DirectPageOps.p_copy(page, searchVecStart, page, searchVecStart += 10, keyPos);
            this.searchVecEnd(searchVecEnd + 8);
        } else {
            DirectPageOps.p_copy(page, searchVecEnd + childPos + 10, page, searchVecEnd + childPos + 2, (searchVecEnd - searchVecStart << 2) + 8 - childPos);
            DirectPageOps.p_copy(page, searchVecStart, page, searchVecStart += 2, keyPos);
        }
        this.searchVecStart(searchVecStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rootDelete(_Tree tree, _Node child) throws IOException {
        try {
            tree.mDatabase.prepareToDelete(child);
            try {
                this.doRootDelete(tree, child);
            }
            catch (Throwable e) {
                child.releaseExclusive();
                throw e;
            }
            tree.mDatabase.deleteNode(child);
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void doRootDelete(_Tree tree, _Node child) throws IOException {
        long oldRootPage = this.mPage;
        byte oldRootType = this.type();
        if (tree.mDatabase.mFullyMapped) {
            DirectPageOps.p_copy(child.mPage, 0, oldRootPage, 0, tree.mDatabase.pageSize());
            oldRootPage = child.mPage;
        } else {
            this.mPage = child.mPage;
        }
        _CursorFrame lock = new _CursorFrame();
        _CursorFrame childLastFrame = child.lockLastFrame(lock);
        _CursorFrame thisLastFrame = this.lockLastFrame(lock);
        if (!_CursorFrame.cLastUpdater.compareAndSet(this, thisLastFrame, childLastFrame)) {
            throw new AssertionError();
        }
        if (!_CursorFrame.cLastUpdater.compareAndSet(child, childLastFrame, thisLastFrame)) {
            throw new AssertionError();
        }
        this.fixFrameBindings(lock, childLastFrame);
        child.fixFrameBindings(lock, thisLastFrame);
        child.mPage = oldRootPage;
        child.type(oldRootType);
        child.clearEntries();
        DirectPageOps.p_longPutLE(oldRootPage, child.searchVecEnd() + 2, this.mId);
    }

    private _CursorFrame lockLastFrame(_CursorFrame lock) {
        _CursorFrame f = this.mLastCursorFrame;
        while (f != null) {
            if (f.tryLock(lock) != null) {
                return f;
            }
            f = f.mPrevCousin;
        }
        throw new AssertionError();
    }

    private void fixFrameBindings(_CursorFrame lock, _CursorFrame frame) {
        _CursorFrame lockResult = frame;
        while (true) {
            _Node existing;
            if ((existing = frame.mNode) != null) {
                if (existing == this) {
                    throw new AssertionError();
                }
                frame.mNode = this;
            }
            _CursorFrame prev = frame.tryLockPrevious(lock);
            frame.unlock(lockResult);
            if (prev == null) {
                return;
            }
            lockResult = frame;
            frame = prev;
        }
    }

    private static int calculateAllowedKeyLength(_Tree tree, byte[] key) {
        int len = key.length - 1;
        if ((len & 0xFFFFFF80) == 0) {
            return len + 2;
        }
        return ++len > tree.mMaxKeySize ? -1 : len + 2;
    }

    static int calculateKeyLength(byte[] key) {
        int len;
        return len + (((len = key.length - 1) & 0xFFFFFF80) == 0 ? 2 : 3);
    }

    private static int calculateLeafValueLength(byte[] value) {
        int len;
        return len + ((len = value.length) <= 127 ? 1 : (len <= 8192 ? 2 : 3));
    }

    private static long calculateLeafValueLength(long vlength) {
        return vlength + (long)(vlength <= 127L ? 1 : (vlength <= 8192L ? 2 : 3));
    }

    private static int calculateFragmentedValueLength(byte[] value) {
        return _Node.calculateFragmentedValueLength(value.length);
    }

    static int calculateFragmentedValueLength(int vlength) {
        return vlength + (vlength <= 8192 ? 2 : 3);
    }

    static int encodeNormalKey(byte[] key, long page, int pageLoc) {
        int keyLen = key.length;
        if (keyLen <= 128 && keyLen > 0) {
            DirectPageOps.p_bytePut(page, pageLoc++, keyLen - 1);
        } else {
            DirectPageOps.p_bytePut(page, pageLoc++, 0x80 | keyLen >> 8);
            DirectPageOps.p_bytePut(page, pageLoc++, keyLen);
        }
        DirectPageOps.p_copyFromArray(key, 0, page, pageLoc, keyLen);
        return pageLoc + keyLen;
    }

    static int encodeFragmentedKey(byte[] key, long page, int pageLoc) {
        int keyLen = key.length;
        DirectPageOps.p_bytePut(page, pageLoc++, 0xC0 | keyLen >> 8);
        DirectPageOps.p_bytePut(page, pageLoc++, keyLen);
        DirectPageOps.p_copyFromArray(key, 0, page, pageLoc, keyLen);
        return pageLoc + keyLen;
    }

    private int allocPageEntry(int encodedLen, int leftSpace, int rightSpace) {
        int entryLoc;
        if (encodedLen <= leftSpace && leftSpace >= rightSpace) {
            entryLoc = this.leftSegTail();
            this.leftSegTail(entryLoc + encodedLen);
        } else if (encodedLen <= rightSpace) {
            entryLoc = this.rightSegTail() - encodedLen + 1;
            this.rightSegTail(entryLoc - 1);
        } else {
            return -1;
        }
        return entryLoc;
    }

    private void copyToLeafEntry(byte[] okey, byte[] akey, int vfrag, byte[] value, int entryLoc) {
        long page = this.mPage;
        int vloc = okey == akey ? _Node.encodeNormalKey(akey, page, entryLoc) : _Node.encodeFragmentedKey(akey, page, entryLoc);
        _Node.copyToLeafValue(page, vfrag, value, vloc);
    }

    private static int copyToLeafValue(long page, int vfrag, byte[] value, int vloc) {
        int vlen = value.length;
        vloc = _Node.encodeLeafValueHeader(page, vfrag, vlen, vloc);
        DirectPageOps.p_copyFromArray(value, 0, page, vloc, vlen);
        return vloc;
    }

    static int encodeLeafValueHeader(long page, int vfrag, int vlen, int vloc) {
        if (vlen <= 127 && vfrag == 0) {
            DirectPageOps.p_bytePut(page, vloc++, vlen);
        } else if (--vlen <= 8192) {
            DirectPageOps.p_bytePut(page, vloc++, 0x80 | vfrag | vlen >> 8);
            DirectPageOps.p_bytePut(page, vloc++, vlen);
        } else {
            DirectPageOps.p_bytePut(page, vloc++, 0xA0 | vfrag | vlen >> 16);
            DirectPageOps.p_bytePut(page, vloc++, vlen >> 8);
            DirectPageOps.p_bytePut(page, vloc++, vlen);
        }
        return vloc;
    }

    private int compactLeaf(int encodedLen, int pos, boolean forInsert) {
        long page = this.mPage;
        int searchVecLoc = this.searchVecStart();
        int newSearchVecSize = this.searchVecEnd() - searchVecLoc + 2;
        if (forInsert) {
            newSearchVecSize += 2;
        }
        pos += searchVecLoc;
        int searchVecCap = this.garbage() + this.rightSegTail() + 1 - this.leftSegTail() - encodedLen;
        int newSearchVecStart = this.pageSize(page) - (searchVecCap + newSearchVecSize >> 1 & 0xFFFFFFFE);
        int destLoc = 12;
        int newSearchVecLoc = newSearchVecStart;
        int newLoc = 0;
        int searchVecEnd = this.searchVecEnd();
        _LocalDatabase db = this.getDatabase();
        long dest = db.removeSparePage();
        DirectPageOps.p_intPutLE(dest, 0, this.type() & 0xFF);
        while (searchVecLoc <= searchVecEnd) {
            block8: {
                block7: {
                    if (searchVecLoc != pos) break block7;
                    newLoc = newSearchVecLoc;
                    if (!forInsert) break block8;
                    newSearchVecLoc += 2;
                }
                DirectPageOps.p_shortPutLE(dest, newSearchVecLoc, destLoc);
                int sourceLoc = DirectPageOps.p_ushortGetLE(page, searchVecLoc);
                int len = _Node.leafEntryLengthAtLoc(page, sourceLoc);
                DirectPageOps.p_copy(page, sourceLoc, dest, destLoc, len);
                destLoc += len;
            }
            searchVecLoc += 2;
            newSearchVecLoc += 2;
        }
        if (db.mFullyMapped) {
            DirectPageOps.p_copy(dest, 0, page, 0, this.pageSize(page));
            db.addSparePage(dest);
            dest = page;
        } else {
            db.addSparePage(page);
            this.mPage = dest;
        }
        DirectPageOps.p_shortPutLE(dest, newLoc == 0 ? newSearchVecLoc : newLoc, destLoc);
        this.leftSegTail(destLoc + encodedLen);
        this.rightSegTail(this.pageSize(dest) - 1);
        this.searchVecStart(newSearchVecStart);
        this.searchVecEnd(newSearchVecStart + newSearchVecSize - 2);
        return destLoc;
    }

    private void cleanupSplit(Throwable cause, _Node newNode, _Split split) {
        if (split != null) {
            this.cleanupFragments(cause, split.fragmentedKey());
        }
        try {
            this.getDatabase().deleteNode(newNode);
        }
        catch (Throwable e) {
            cause.addSuppressed(e);
            this.panic(cause);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void splitLeafAndCreateEntry(_Tree tree, byte[] okey, byte[] akey, int vfrag, byte[] value, int encodedLen, int pos, boolean forInsert) throws IOException {
        block27: {
            block23: {
                if (this.mSplit != null) {
                    throw new AssertionError((Object)"_Node is already split");
                }
                page = this.mPage;
                if (page == DirectPageOps.p_closedTreePage()) {
                    throw new ClosedIndexException();
                }
                newNode = tree.mDatabase.allocDirtyNode(1);
                tree.mDatabase.nodeMapPut(newNode);
                newPage = newNode.mPage;
                DirectPageOps.p_intPutLE(newPage, 0, 0);
                if (forInsert && pos == 0) {
                    split = null;
                    try {
                        split = this.newSplitLeft(newNode);
                        this.setSplitKey(tree, split, this.midKey(okey, 0));
                    }
                    catch (Throwable e) {
                        this.cleanupSplit(e, newNode, split);
                        throw e;
                    }
                    this.mSplit = split;
                    newNode.leftSegTail(12);
                    newNode.searchVecStart(12);
                    newNode.searchVecEnd(12);
                    destLoc = this.pageSize(newPage) - encodedLen;
                    newNode.copyToLeafEntry(okey, akey, vfrag, value, destLoc);
                    DirectPageOps.p_shortPutLE(newPage, 12, destLoc);
                    newNode.rightSegTail(destLoc - 1);
                    newNode.releaseExclusive();
                    return;
                }
                searchVecStart = this.searchVecStart();
                searchVecEnd = this.searchVecEnd();
                if (forInsert && (pos += searchVecStart) == searchVecEnd + 2) {
                    split = null;
                    try {
                        split = this.newSplitRight(newNode);
                        this.setSplitKey(tree, split, this.midKey(pos - searchVecStart - 2, okey));
                    }
                    catch (Throwable e) {
                        this.cleanupSplit(e, newNode, split);
                        throw e;
                    }
                    this.mSplit = split;
                    newNode.rightSegTail(this.pageSize(newPage) - 1);
                    newSearchVecStart = this.pageSize(newPage) - 2;
                    newNode.searchVecStart(newSearchVecStart);
                    newNode.searchVecEnd(newSearchVecStart);
                    newNode.copyToLeafEntry(okey, akey, vfrag, value, 12);
                    DirectPageOps.p_shortPutLE(newPage, this.pageSize(newPage) - 2, 12);
                    newNode.leftSegTail(12 + encodedLen);
                    newNode.releaseExclusive();
                    return;
                }
                avail = this.availableLeafBytes();
                garbageAccum = 0;
                newLoc = 0;
                newAvail = this.pageSize(newPage) - 12;
                if (pos - searchVecStart >= searchVecEnd - pos) break block23;
                destLoc = this.pageSize(newPage);
                newSearchVecLoc = 12;
                searchVecLoc = searchVecStart;
                while (newAvail > avail) {
                    block26: {
                        block24: {
                            block25: {
                                entryLoc = DirectPageOps.p_ushortGetLE(page, searchVecLoc);
                                entryLen = _Node.leafEntryLengthAtLoc(page, entryLoc);
                                if (searchVecLoc != pos) break block24;
                                if ((newAvail -= encodedLen + 2) < 0) break;
                                newLoc = newSearchVecLoc;
                                if (!forInsert) break block25;
                                newSearchVecLoc += 2;
                                if (newAvail <= avail) {
                                    break;
                                }
                                break block24;
                            }
                            garbageAccum += entryLen;
                            avail += entryLen;
                            break block26;
                        }
                        if ((newAvail -= entryLen + 2) < 0) break;
                        DirectPageOps.p_copy(page, entryLoc, newPage, destLoc -= entryLen, entryLen);
                        DirectPageOps.p_shortPutLE(newPage, newSearchVecLoc, destLoc);
                        garbageAccum += entryLen;
                        avail += entryLen + 2;
                    }
                    searchVecLoc += 2;
                    newSearchVecLoc += 2;
                }
                newNode.leftSegTail(12);
                newNode.searchVecStart(12);
                newNode.searchVecEnd(newSearchVecLoc - 2);
                originalStart = this.searchVecStart();
                originalGarbage = this.garbage();
                this.searchVecStart(searchVecLoc);
                this.garbage(originalGarbage + garbageAccum);
                split = null;
                fv = null;
                try {
                    split = this.newSplitLeft(newNode);
                    if (newLoc == 0) {
                        fv = this.storeIntoSplitLeaf(tree, okey, akey, vfrag, value, encodedLen, forInsert);
                    } else {
                        newNode.copyToLeafEntry(okey, akey, vfrag, value, destLoc -= encodedLen);
                        DirectPageOps.p_shortPutLE(newPage, newLoc, destLoc);
                    }
                    this.setSplitKey(tree, split, newNode.midKey(newNode.highestKeyPos(), this, 0));
                    newNode.rightSegTail(destLoc - 1);
                    newNode.releaseExclusive();
                }
                catch (Throwable e) {
                    this.searchVecStart(originalStart);
                    this.garbage(originalGarbage);
                    this.cleanupFragments(e, fv);
                    this.cleanupSplit(e, newNode, split);
                    throw e;
                }
                this.mSplit = split;
                break block27;
            }
            destLoc = 12;
            newSearchVecLoc = this.pageSize(newPage) - 2;
            searchVecLoc = searchVecEnd;
            while (newAvail > avail) {
                block28: {
                    entryLoc = DirectPageOps.p_ushortGetLE(page, searchVecLoc);
                    entryLen = _Node.leafEntryLengthAtLoc(page, entryLoc);
                    if (!forInsert) break block28;
                    if (searchVecLoc + 2 == pos) {
                        if ((newAvail -= encodedLen + 2) < 0) break;
                        newLoc = newSearchVecLoc;
                        newSearchVecLoc -= 2;
                        if (newAvail <= avail) {
                            break;
                        }
                    }
                    ** GOTO lbl-1000
                }
                if (searchVecLoc == pos) {
                    if ((newAvail -= encodedLen + 2) < 0) break;
                    newLoc = newSearchVecLoc;
                    garbageAccum += entryLen;
                    avail += entryLen;
                } else lbl-1000:
                // 2 sources

                {
                    if ((newAvail -= entryLen + 2) < 0) break;
                    DirectPageOps.p_copy(page, entryLoc, newPage, destLoc, entryLen);
                    DirectPageOps.p_shortPutLE(newPage, newSearchVecLoc, destLoc);
                    destLoc += entryLen;
                    garbageAccum += entryLen;
                    avail += entryLen + 2;
                }
                searchVecLoc -= 2;
                newSearchVecLoc -= 2;
            }
            newNode.rightSegTail(this.pageSize(newPage) - 1);
            newNode.searchVecStart(newSearchVecLoc + 2);
            newNode.searchVecEnd(this.pageSize(newPage) - 2);
            originalEnd = this.searchVecEnd();
            originalGarbage = this.garbage();
            this.searchVecEnd(searchVecLoc);
            this.garbage(originalGarbage + garbageAccum);
            split = null;
            fv = null;
            try {
                split = this.newSplitRight(newNode);
                if (newLoc == 0) {
                    fv = this.storeIntoSplitLeaf(tree, okey, akey, vfrag, value, encodedLen, forInsert);
                } else {
                    newNode.copyToLeafEntry(okey, akey, vfrag, value, destLoc);
                    DirectPageOps.p_shortPutLE(newPage, newLoc, destLoc);
                    destLoc += encodedLen;
                }
                this.setSplitKey(tree, split, this.midKey(this.highestKeyPos(), newNode, 0));
                newNode.leftSegTail(destLoc);
                newNode.releaseExclusive();
            }
            catch (Throwable e) {
                this.searchVecEnd(originalEnd);
                this.garbage(originalGarbage);
                this.cleanupFragments(e, fv);
                this.cleanupSplit(e, newNode, split);
                throw e;
            }
            this.mSplit = split;
        }
    }

    private byte[] storeIntoSplitLeaf(_Tree tree, byte[] okey, byte[] akey, int vfrag, byte[] value, int encodedLen, boolean forInsert) throws IOException {
        int pos = this.binarySearch(okey);
        if (forInsert) {
            if (pos >= 0) {
                throw new AssertionError((Object)"Key exists");
            }
            int entryLoc = this.createLeafEntry(null, tree, ~pos, encodedLen);
            byte[] result = null;
            while (entryLoc < 0) {
                int encodedKeyLen;
                if (vfrag != 0) {
                    throw new DatabaseException("Fragmented entry doesn't fit");
                }
                _LocalDatabase db = tree.mDatabase;
                int max = Math.min(~entryLoc, db.mMaxFragmentedEntrySize);
                if ((value = db.fragment(value, value.length, max - (encodedKeyLen = _Node.calculateKeyLength(akey)))) == null) {
                    throw new AssertionError();
                }
                result = value;
                vfrag = 64;
                encodedLen = encodedKeyLen + _Node.calculateFragmentedValueLength(value);
                entryLoc = this.createLeafEntry(null, tree, ~pos, encodedLen);
            }
            this.copyToLeafEntry(okey, akey, vfrag, value, entryLoc);
            return result;
        }
        if (pos < 0) {
            throw new AssertionError((Object)"Key not found");
        }
        this.updateLeafValue(null, tree, pos, vfrag, value);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitInternal(InResult result, _Tree tree, int encodedLen, int keyPos, int newChildPos) throws IOException {
        int newKeyLoc;
        int garbageAccum;
        _Split split;
        long newPage;
        block34: {
            int searchVecLoc;
            int newSearchVecLoc;
            int destLoc;
            _Node newNode;
            if (this.mSplit != null) {
                throw new AssertionError((Object)"_Node is already split");
            }
            _LocalDatabase db = this.getDatabase();
            try {
                newNode = db.allocDirtyNode(1);
            }
            catch (DatabaseFullException e) {
                db.capacityLimitOverride(-1L);
                try {
                    newNode = db.allocDirtyNode(1);
                }
                finally {
                    db.capacityLimitOverride(0L);
                }
            }
            db.nodeMapPut(newNode);
            newPage = newNode.mPage;
            DirectPageOps.p_intPutLE(newPage, 0, 0);
            long page = this.mPage;
            int searchVecStart = this.searchVecStart();
            int searchVecEnd = this.searchVecEnd();
            if (searchVecEnd - searchVecStart == 2 && keyPos == 2) {
                _Split split2;
                try {
                    split2 = this.newSplitLeft(newNode);
                }
                catch (Throwable e) {
                    this.cleanupSplit(e, newNode, null);
                    throw e;
                }
                result.mEntryLoc = -1;
                int leftKeyLoc = DirectPageOps.p_ushortGetLE(page, searchVecStart);
                int leftKeyLen = _Node.keyLengthAtLoc(page, leftKeyLoc);
                DirectPageOps.p_copy(page, leftKeyLoc, newPage, 12, leftKeyLen);
                int leftSearchVecStart = this.pageSize(newPage) - 18;
                DirectPageOps.p_shortPutLE(newPage, leftSearchVecStart, 12);
                if (newChildPos == 8) {
                    result.mPage = newPage;
                    result.mNewChildLoc = leftSearchVecStart + 10;
                } else {
                    if (newChildPos != 16) {
                        throw new AssertionError();
                    }
                    result.mPage = page;
                    result.mNewChildLoc = searchVecEnd + 10;
                }
                DirectPageOps.p_copy(page, searchVecEnd + 2, newPage, leftSearchVecStart + 2, newChildPos);
                newNode.leftSegTail(12 + leftKeyLen);
                newNode.rightSegTail(leftSearchVecStart + 17);
                newNode.searchVecStart(leftSearchVecStart);
                newNode.searchVecEnd(leftSearchVecStart);
                newNode.releaseExclusive();
                DirectPageOps.p_copy(page, searchVecEnd, page, searchVecEnd + 8, 2);
                int newSearchVecStart = searchVecEnd + 8;
                this.searchVecStart(newSearchVecStart);
                this.searchVecEnd(newSearchVecStart);
                this.garbage(this.garbage() + leftKeyLen);
                this.mSplit = split2;
                return;
            }
            result.mPage = newPage;
            int keyLoc = keyPos + searchVecStart;
            int splitSide = keyPos < searchVecEnd - searchVecStart - keyPos ? -1 : 1;
            split = null;
            block11: while (true) {
                boolean full;
                int sizeChange;
                int entryLen;
                int entryLoc;
                garbageAccum = 0;
                newKeyLoc = 0;
                int size = 5 * (searchVecEnd - searchVecStart) + 17 + this.leftSegTail() + this.pageSize(page) - this.rightSegTail() - this.garbage();
                int newSize = 12;
                size -= 8;
                newSize += 8;
                if (splitSide < 0) {
                    destLoc = this.pageSize(newPage);
                    newSearchVecLoc = 12;
                    searchVecLoc = searchVecStart;
                    while (true) {
                        if (searchVecLoc == keyLoc) {
                            newKeyLoc = newSearchVecLoc;
                            newSearchVecLoc += 2;
                            if ((newSize += encodedLen + 10) > this.pageSize(newPage)) {
                                if (splitSide == -1) {
                                    splitSide = 2;
                                    continue block11;
                                }
                                throw new AssertionError();
                            }
                        }
                        entryLoc = DirectPageOps.p_ushortGetLE(page, searchVecLoc);
                        entryLen = _Node.keyLengthAtLoc(page, entryLoc);
                        sizeChange = entryLen + 10;
                        searchVecLoc += 2;
                        garbageAccum += entryLen;
                        full = (size -= sizeChange) < 12 | (newSize += sizeChange) > this.pageSize(newPage);
                        if (full || newSize >= size) {
                            if (newKeyLoc != 0) {
                                try {
                                    split = this.newSplitLeft(newNode);
                                    this.setSplitKey(tree, split, this.retrieveKeyAtLoc(page, entryLoc));
                                    break;
                                }
                                catch (Throwable e) {
                                    this.cleanupSplit(e, newNode, split);
                                    throw e;
                                }
                            }
                            if (splitSide == -1) {
                                splitSide = 2;
                                continue block11;
                            }
                            if (full || splitSide != -2) {
                                throw new AssertionError();
                            }
                        }
                        DirectPageOps.p_copy(page, entryLoc, newPage, destLoc -= entryLen, entryLen);
                        DirectPageOps.p_shortPutLE(newPage, newSearchVecLoc, destLoc);
                        newSearchVecLoc += 2;
                    }
                    result.mEntryLoc = destLoc - encodedLen;
                    DirectPageOps.p_copy(page, searchVecEnd + 2, newPage, newSearchVecLoc, newChildPos);
                    result.mNewChildLoc = newSearchVecLoc + newChildPos;
                    int tailChildIdsLen = (searchVecLoc - searchVecStart << 2) - newChildPos;
                    DirectPageOps.p_copy(page, searchVecEnd + 2 + newChildPos, newPage, newSearchVecLoc + newChildPos + 8, tailChildIdsLen);
                    newNode.leftSegTail(12);
                    newNode.rightSegTail(destLoc - encodedLen - 1);
                    newNode.searchVecStart(12);
                    newNode.searchVecEnd(newSearchVecLoc - 2);
                    newNode.releaseExclusive();
                    int shift = searchVecLoc - searchVecStart << 2;
                    int len = searchVecEnd - searchVecLoc + 2;
                    int newSearchVecStart = searchVecLoc + shift;
                    DirectPageOps.p_copy(page, searchVecLoc, page, newSearchVecStart, len);
                    this.searchVecStart(newSearchVecStart);
                    this.searchVecEnd(searchVecEnd + shift);
                    break block34;
                }
                destLoc = 12;
                newSearchVecLoc = this.pageSize(newPage);
                searchVecLoc = searchVecEnd + 2;
                while (true) {
                    if (searchVecLoc == keyLoc) {
                        newKeyLoc = newSearchVecLoc -= 2;
                        if ((newSize += encodedLen + 10) > this.pageSize(newPage)) {
                            if (splitSide == 1) {
                                splitSide = -2;
                                continue block11;
                            }
                            throw new AssertionError();
                        }
                    }
                    entryLoc = DirectPageOps.p_ushortGetLE(page, searchVecLoc -= 2);
                    entryLen = _Node.keyLengthAtLoc(page, entryLoc);
                    sizeChange = entryLen + 10;
                    garbageAccum += entryLen;
                    full = (size -= sizeChange) < 12 | (newSize += sizeChange) > this.pageSize(newPage);
                    if (full || newSize >= size) {
                        if (newKeyLoc != 0) {
                            try {
                                split = this.newSplitRight(newNode);
                                this.setSplitKey(tree, split, this.retrieveKeyAtLoc(page, entryLoc));
                                break block11;
                            }
                            catch (Throwable e) {
                                this.cleanupSplit(e, newNode, split);
                                throw e;
                            }
                        }
                        if (splitSide == 1) {
                            splitSide = -2;
                            continue block11;
                        }
                        if (full || splitSide != 2) {
                            throw new AssertionError();
                        }
                    }
                    DirectPageOps.p_copy(page, entryLoc, newPage, destLoc, entryLen);
                    DirectPageOps.p_shortPutLE(newPage, newSearchVecLoc -= 2, destLoc);
                    destLoc += entryLen;
                }
                break;
            }
            result.mEntryLoc = destLoc;
            int newVecLen = this.pageSize(page) - newSearchVecLoc;
            int highestLoc = this.pageSize(newPage) - 5 * newVecLen - 8;
            int midLoc = destLoc + encodedLen + highestLoc + 1 >> 1 & 0xFFFFFFFE;
            DirectPageOps.p_copy(newPage, newSearchVecLoc, newPage, midLoc, newVecLen);
            newKeyLoc -= newSearchVecLoc - midLoc;
            newSearchVecLoc = midLoc;
            int newSearchVecEnd = newSearchVecLoc + newVecLen - 2;
            int headChildIdsLen = newChildPos - (searchVecLoc - searchVecStart + 2 << 2);
            int newDestLoc = newSearchVecEnd + 2;
            DirectPageOps.p_copy(page, searchVecEnd + 2 + newChildPos - headChildIdsLen, newPage, newDestLoc, headChildIdsLen);
            result.mNewChildLoc = newDestLoc += headChildIdsLen;
            int tailChildIdsLen = (searchVecEnd - searchVecStart << 2) + 16 - newChildPos;
            DirectPageOps.p_copy(page, searchVecEnd + 2 + newChildPos, newPage, newDestLoc + 8, tailChildIdsLen);
            newNode.leftSegTail(destLoc + encodedLen);
            newNode.rightSegTail(this.pageSize(newPage) - 1);
            newNode.searchVecStart(newSearchVecLoc);
            newNode.searchVecEnd(newSearchVecEnd);
            newNode.releaseExclusive();
            int len = searchVecLoc - searchVecStart;
            int newSearchVecStart = searchVecEnd + 2 - len;
            DirectPageOps.p_copy(page, searchVecStart, page, newSearchVecStart, len);
            this.searchVecStart(newSearchVecStart);
        }
        this.garbage(this.garbage() + garbageAccum);
        this.mSplit = split;
        DirectPageOps.p_shortPutLE(newPage, newKeyLoc, result.mEntryLoc);
    }

    private void setSplitKey(_Tree tree, _Split split, byte[] fullKey) throws IOException {
        byte[] actualKey = fullKey;
        if (_Node.calculateAllowedKeyLength(tree, fullKey) < 0) {
            actualKey = tree.fragmentKey(fullKey);
        }
        split.setKey(fullKey, actualKey);
    }

    private void compactInternal(InResult result, int encodedLen, int keyPos, int childPos) {
        long page = this.mPage;
        int searchVecLoc = this.searchVecStart();
        keyPos += searchVecLoc;
        int newSearchVecSize = this.searchVecEnd() - searchVecLoc + 4 + (childPos >> 30);
        int searchVecCap = this.garbage() + this.rightSegTail() + 1 - this.leftSegTail() - encodedLen;
        int newSearchVecStart = this.pageSize(page) - (searchVecCap + newSearchVecSize + (newSearchVecSize + 2 << 2) >> 1 & 0xFFFFFFFE);
        int destLoc = 12;
        int newSearchVecLoc = newSearchVecStart;
        int newLoc = 0;
        int searchVecEnd = this.searchVecEnd();
        _LocalDatabase db = this.getDatabase();
        long dest = db.removeSparePage();
        DirectPageOps.p_intPutLE(dest, 0, this.type() & 0xFF);
        while (searchVecLoc <= searchVecEnd) {
            block11: {
                block10: {
                    if (searchVecLoc != keyPos) break block10;
                    newLoc = newSearchVecLoc;
                    if (childPos < 0) break block11;
                    newSearchVecLoc += 2;
                }
                DirectPageOps.p_shortPutLE(dest, newSearchVecLoc, destLoc);
                int sourceLoc = DirectPageOps.p_ushortGetLE(page, searchVecLoc);
                int len = _Node.keyLengthAtLoc(page, sourceLoc);
                DirectPageOps.p_copy(page, sourceLoc, dest, destLoc, len);
                destLoc += len;
            }
            searchVecLoc += 2;
            newSearchVecLoc += 2;
        }
        if (childPos >= 0) {
            if (newLoc == 0) {
                newLoc = newSearchVecLoc;
                newSearchVecLoc += 2;
            }
            DirectPageOps.p_copy(page, this.searchVecEnd() + 2, dest, newSearchVecLoc, childPos);
            DirectPageOps.p_copy(page, this.searchVecEnd() + 2 + childPos, dest, newSearchVecLoc + childPos + 8, (newSearchVecSize << 2) - childPos);
        } else {
            if (newLoc == 0) {
                newLoc = newSearchVecLoc;
            }
            DirectPageOps.p_copy(page, this.searchVecEnd() + 2, dest, newSearchVecLoc, (newSearchVecSize << 2) + 8);
        }
        if (db.mFullyMapped) {
            DirectPageOps.p_copy(dest, 0, page, 0, this.pageSize(page));
            db.addSparePage(dest);
            dest = page;
        } else {
            db.addSparePage(page);
            this.mPage = dest;
        }
        DirectPageOps.p_shortPutLE(dest, newLoc, destLoc);
        this.leftSegTail(destLoc + encodedLen);
        this.rightSegTail(this.pageSize(dest) - 1);
        this.searchVecStart(newSearchVecStart);
        this.searchVecEnd(newSearchVecLoc - 2);
        result.mPage = dest;
        result.mNewChildLoc = newSearchVecLoc + childPos;
        result.mEntryLoc = destLoc;
    }

    private _Split newSplitLeft(_Node newNode) {
        _Split split = new _Split(false, newNode);
        newNode.type((byte)(this.type() & 0xFFFFFFF7));
        this.type((byte)(this.type() & 0xFFFFFFFD));
        return split;
    }

    private _Split newSplitRight(_Node newNode) {
        _Split split = new _Split(true, newNode);
        newNode.type((byte)(this.type() & 0xFFFFFFFD));
        this.type((byte)(this.type() & 0xFFFFFFF7));
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long countCursors() {
        if (this.tryAcquireExclusive()) {
            long count = 0L;
            try {
                _CursorFrame frame = this.mLastCursorFrame;
                while (frame != null) {
                    ++count;
                    frame = frame.mPrevCousin;
                }
            }
            finally {
                this.releaseExclusive();
            }
            return count;
        }
        this.acquireShared();
        try {
            _CursorFrame lockResult;
            _CursorFrame frame = this.mLastCursorFrame;
            if (frame == null) {
                long l = 0L;
                return l;
            }
            _CursorFrame lock = new _CursorFrame();
            while ((lockResult = frame.tryLock(lock)) == null) {
                frame = frame.mPrevCousin;
                if (frame != null) continue;
                long l = 0L;
                return l;
            }
            long count = 1L;
            while (true) {
                _CursorFrame prev = frame.tryLockPrevious(lock);
                frame.unlock(lockResult);
                if (prev == null) {
                    long l = count;
                    return l;
                }
                ++count;
                lockResult = frame;
                frame = prev;
            }
        }
        finally {
            this.releaseShared();
        }
    }

    @Override
    public String toString() {
        String prefix;
        switch (this.type()) {
            case 64: {
                return "UndoNode: {id=" + this.mId + ", cachedState=" + this.mCachedState + ", topEntry=" + this.garbage() + ", lowerNodeId=" + DirectPageOps.p_longGetLE(this.mPage, 4) + ", latchState=" + super.toString() + '}';
            }
            case 100: 
            case 102: 
            case 108: 
            case 110: {
                prefix = "Internal";
                break;
            }
            case 116: 
            case 118: 
            case 124: 
            case 126: {
                prefix = "BottomInternal";
                break;
            }
            default: {
                if (!this.isLeaf()) {
                    return "_Node: {id=" + this.mId + ", cachedState=" + this.mCachedState + ", latchState=" + super.toString() + '}';
                }
            }
            case -128: {
                prefix = "Leaf";
            }
        }
        return prefix + "_Node: {id=" + this.mId + ", cachedState=" + this.mCachedState + ", isSplit=" + (this.mSplit != null) + ", availableBytes=" + this.availableBytes() + ", extremity=0b" + Integer.toString(this.type() & 0xA, 2) + ", latchState=" + super.toString() + '}';
    }

    boolean verifyTreeNode(int level, VerificationObserver observer) {
        int type = this.type() & 0xFFFFFFF5;
        if (type != 100 && type != 116 && !this.isLeaf()) {
            return this.verifyFailed(level, observer, "Not a tree node: " + type);
        }
        long page = this.mPage;
        if (this.leftSegTail() < 12) {
            return this.verifyFailed(level, observer, "Left segment tail: " + this.leftSegTail());
        }
        if (this.searchVecStart() < this.leftSegTail()) {
            return this.verifyFailed(level, observer, "Search vector start: " + this.searchVecStart());
        }
        if (this.searchVecEnd() < this.searchVecStart() - 2) {
            return this.verifyFailed(level, observer, "Search vector end: " + this.searchVecEnd());
        }
        if (this.rightSegTail() < this.searchVecEnd() || this.rightSegTail() > this.pageSize(page) - 1) {
            return this.verifyFailed(level, observer, "Right segment tail: " + this.rightSegTail());
        }
        if (!this.isLeaf()) {
            int childIdsStart = this.searchVecEnd() + 2;
            int childIdsEnd = childIdsStart + (childIdsStart - this.searchVecStart() << 2) + 8;
            if (childIdsEnd > this.rightSegTail() + 1) {
                return this.verifyFailed(level, observer, "Child ids end: " + childIdsEnd);
            }
            LHashTable.Int childIds = new LHashTable.Int(512);
            for (int i = childIdsStart; i < childIdsEnd; i += 8) {
                long childId = DirectPageOps.p_uint48GetLE(page, i);
                if (childId < 0L || childId == 0L || childId == 1L) {
                    return this.verifyFailed(level, observer, "Illegal child id: " + childId);
                }
                LHashTable.IntEntry e = (LHashTable.IntEntry)childIds.insert(childId);
                if (e.value != 0) {
                    return this.verifyFailed(level, observer, "Duplicate child id: " + childId);
                }
                e.value = 1;
            }
        }
        int used = 12 + this.rightSegTail() + 1 - this.leftSegTail();
        int largeValueCount = 0;
        int lastKeyLoc = 0;
        int lastKeyLen = 0;
        for (int i = this.searchVecStart(); i <= this.searchVecEnd(); i += 2) {
            int len;
            int result;
            int keyLen;
            int loc = DirectPageOps.p_ushortGetLE(page, i);
            if (loc < 12 || loc >= this.pageSize(page) || loc >= this.leftSegTail() && loc <= this.rightSegTail()) {
                return this.verifyFailed(level, observer, "Entry location: " + loc);
            }
            used = this.isLeaf() ? (used += _Node.leafEntryLengthAtLoc(page, loc)) : (used += _Node.keyLengthAtLoc(page, loc));
            try {
                keyLen = DirectPageOps.p_byteGet(page, loc++);
                keyLen = keyLen >= 0 ? keyLen + 1 : (keyLen & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
            }
            catch (IndexOutOfBoundsException e) {
                return this.verifyFailed(level, observer, "Key location out of bounds");
            }
            if (loc + keyLen > this.pageSize(page)) {
                return this.verifyFailed(level, observer, "Key end location: " + (loc + keyLen));
            }
            if (lastKeyLoc != 0 && (result = DirectPageOps.p_compareKeysPageToPage(page, lastKeyLoc, lastKeyLen, page, loc, keyLen)) >= 0) {
                return this.verifyFailed(level, observer, "Key order: " + result);
            }
            lastKeyLoc = loc;
            lastKeyLoc = keyLen;
            if (!this.isLeaf()) continue;
            try {
                loc += keyLen;
                int header = DirectPageOps.p_byteGet(page, loc++);
                if (header >= 0) {
                    len = header;
                } else {
                    if ((header & 0x20) == 0) {
                        len = 1 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
                    } else {
                        if (header == -1) continue;
                        len = 1 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
                    }
                    if ((header & 0x40) != 0) {
                        ++largeValueCount;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                return this.verifyFailed(level, observer, "Value location out of bounds");
            }
            if (loc + len <= this.pageSize(page)) continue;
            return this.verifyFailed(level, observer, "Value end location: " + (loc + len));
        }
        int garbage = this.pageSize(page) - used;
        if (this.garbage() != garbage) {
            return this.verifyFailed(level, observer, "Garbage: " + this.garbage() + " != " + garbage);
        }
        int entryCount = this.numKeys();
        int freeBytes = this.availableBytes();
        long id = this.mId;
        this.releaseShared();
        return observer.indexNodePassed(id, level, entryCount, freeBytes, largeValueCount);
    }

    private boolean verifyFailed(int level, VerificationObserver observer, String message) {
        long id = this.mId;
        this.releaseShared();
        observer.failed = true;
        return observer.indexNodeFailed(id, level, message);
    }

    static final class InResult {
        long mPage;
        int mNewChildLoc;
        int mEntryLoc;

        InResult() {
        }
    }
}

