/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.IntegerRef;

class Utils
extends org.cojen.tupl.io.Utils {
    static final byte[] EMPTY_BYTES = new byte[0];
    private static int cSeedMix = new Random().nextInt();

    Utils() {
    }

    static long toNanos(long timeout, TimeUnit unit) {
        return timeout < 0L ? -1L : (timeout == 0L ? 0L : ((timeout = unit.toNanos(timeout)) < 0L ? 0L : timeout));
    }

    static int roundUpPower2(int i) {
        --i;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        return (i | i >> 16) + 1;
    }

    static int randomSeed() {
        int seed = Long.hashCode(Thread.currentThread().getId()) ^ cSeedMix;
        while (seed == 0) {
            seed = new Random().nextInt();
        }
        cSeedMix = Utils.nextRandom(seed);
        return seed;
    }

    static int nextRandom(int seed) {
        seed ^= seed << 13;
        seed ^= seed >>> 17;
        seed ^= seed << 5;
        return seed;
    }

    static long scramble(long v) {
        v = (v << 21) - v - 1L;
        v ^= v >>> 24;
        v = v + (v << 3) + (v << 8);
        v ^= v >>> 14;
        v = v + (v << 2) + (v << 4);
        v ^= v >>> 28;
        return v + (v << 31);
    }

    static TimeUnit inferUnit(TimeUnit unit, long value) {
        if (value != 0L && value - (value /= 1000L) * 1000L == 0L) {
            unit = TimeUnit.MICROSECONDS;
            if (value - (value /= 1000L) * 1000L == 0L) {
                unit = TimeUnit.MILLISECONDS;
                if (value - (value /= 1000L) * 1000L == 0L) {
                    unit = TimeUnit.SECONDS;
                    if (value - (value /= 60L) * 60L == 0L) {
                        unit = TimeUnit.MINUTES;
                        if (value - (value /= 60L) * 60L == 0L) {
                            unit = TimeUnit.HOURS;
                            if (value - value / 24L * 24L == 0L) {
                                unit = TimeUnit.DAYS;
                            }
                        }
                    }
                }
            }
        }
        return unit;
    }

    static String timeoutMessage(long nanosTimeout, DatabaseException ex) {
        if (nanosTimeout == 0L) {
            return "Never waited";
        }
        if (nanosTimeout < 0L) {
            return "Infinite wait";
        }
        StringBuilder b = new StringBuilder("Waited ");
        Utils.appendTimeout(b, ex.getTimeout(), ex.getUnit());
        return b.toString();
    }

    static void appendTimeout(StringBuilder b, long timeout, TimeUnit unit) {
        if (timeout == 0L) {
            b.append('0');
        } else if (timeout < 0L) {
            b.append("infinite");
        } else {
            b.append(timeout);
            b.append(' ');
            String unitStr = unit.toString().toLowerCase();
            if (timeout == 1L) {
                unitStr = unitStr.substring(0, unitStr.length() - 1);
            }
            b.append(unitStr);
        }
    }

    static byte[] cloneArray(byte[] bytes) {
        return bytes == null || bytes.length == 0 ? bytes : (byte[])bytes.clone();
    }

    static void arrayCopyOrFill(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        if (src == null) {
            Arrays.fill(dest, destPos, destPos + length, (byte)0);
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }

    static byte[] midKey(byte[] low, byte[] high) {
        return Utils.midKey(low, 0, low.length, high, 0, high.length);
    }

    static byte[] midKey(byte[] low, int lowOff, int lowLen, byte[] high, int highOff, int highLen) {
        for (int i = 0; i < lowLen; ++i) {
            byte lo = low[lowOff + i];
            byte hi = high[highOff + i];
            if (lo == hi) continue;
            byte[] mid = new byte[i + 1];
            System.arraycopy(low, lowOff, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        System.arraycopy(high, highOff, mid, 0, mid.length);
        return mid;
    }

    public static int decodeUnsignedVarInt(byte[] b, int offset) {
        byte v = b[offset];
        if (v >= 0) {
            return v;
        }
        switch (v >> 4 & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return 128 + ((v & 0x3F) << 8 | b[offset + 1] & 0xFF);
            }
            case 4: 
            case 5: {
                return 16512 + ((v & 0x1F) << 16 | (b[++offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
            }
            case 6: {
                return 2113664 + ((v & 0xF) << 24 | (b[++offset] & 0xFF) << 16 | (b[++offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
            }
        }
        return 270549120 + (b[++offset] << 24 | (b[++offset] & 0xFF) << 16 | (b[++offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
    }

    public static int decodeUnsignedVarInt(byte[] b, int start, int end) throws EOFException {
        if (start >= end) {
            throw new EOFException();
        }
        byte v = b[start];
        if (v >= 0) {
            return v;
        }
        switch (v >> 4 & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if (++start >= end) {
                    throw new EOFException();
                }
                return 128 + ((v & 0x3F) << 8 | b[start] & 0xFF);
            }
            case 4: 
            case 5: {
                if (start + 2 >= end) {
                    throw new EOFException();
                }
                return 16512 + ((v & 0x1F) << 16 | (b[++start] & 0xFF) << 8 | b[start + 1] & 0xFF);
            }
            case 6: {
                if (start + 3 >= end) {
                    throw new EOFException();
                }
                return 2113664 + ((v & 0xF) << 24 | (b[++start] & 0xFF) << 16 | (b[++start] & 0xFF) << 8 | b[start + 1] & 0xFF);
            }
        }
        if (start + 4 >= end) {
            throw new EOFException();
        }
        return 270549120 + (b[++start] << 24 | (b[++start] & 0xFF) << 16 | (b[++start] & 0xFF) << 8 | b[start + 1] & 0xFF);
    }

    public static int decodeSignedVarInt(byte[] b, int offset) {
        int v = Utils.decodeUnsignedVarInt(b, offset);
        return (v & 1) != 0 ? ~(v >> 1) | Integer.MIN_VALUE : v >>> 1;
    }

    public static long decodeSignedVarLong(byte[] b, IntegerRef offsetRef) {
        long v = Utils.decodeUnsignedVarLong(b, offsetRef);
        return (v & 1L) != 0L ? v >> 1 ^ 0xFFFFFFFFFFFFFFFFL | Integer.MIN_VALUE : v >>> 1;
    }

    public static long decodeUnsignedVarLong(byte[] b, IntegerRef offsetRef) {
        long decoded;
        byte val;
        int offset = offsetRef.get();
        if ((val = b[offset++]) >= 0) {
            offsetRef.set(offset);
            return val;
        }
        block0 : switch (val >> 4 & 7) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                decoded = 128L + (long)((val & 0x3F) << 8 | b[offset++] & 0xFF);
                break;
            }
            case 4: 
            case 5: {
                decoded = 16512L + (long)((val & 0x1F) << 16 | (b[offset++] & 0xFF) << 8 | b[offset++] & 0xFF);
                break;
            }
            case 6: {
                decoded = 2113664L + (long)((val & 0xF) << 24 | (b[offset++] & 0xFF) << 16 | (b[offset++] & 0xFF) << 8 | b[offset++] & 0xFF);
                break;
            }
            default: {
                switch (val & 0xF) {
                    default: {
                        decoded = 270549120L + (((long)val & 7L) << 32 | (long)(b[offset++] & 0xFF) << 24 | (long)(b[offset++] & 0xFF) << 16 | (long)(b[offset++] & 0xFF) << 8 | (long)(b[offset++] & 0xFF));
                        break block0;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        decoded = 34630287488L + (((long)val & 3L) << 40 | (long)(b[offset++] & 0xFF) << 32 | (long)(b[offset++] & 0xFF) << 24 | (long)(b[offset++] & 0xFF) << 16 | (long)(b[offset++] & 0xFF) << 8 | (long)(b[offset++] & 0xFF));
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        decoded = 4432676798592L + (((long)val & 1L) << 48 | (long)(b[offset++] & 0xFF) << 40 | (long)(b[offset++] & 0xFF) << 32 | (long)(b[offset++] & 0xFF) << 24 | (long)(b[offset++] & 0xFF) << 16 | (long)(b[offset++] & 0xFF) << 8 | (long)(b[offset++] & 0xFF));
                        break block0;
                    }
                    case 14: {
                        decoded = 567382630219904L + ((long)(b[offset++] & 0xFF) << 48 | (long)(b[offset++] & 0xFF) << 40 | (long)(b[offset++] & 0xFF) << 32 | (long)(b[offset++] & 0xFF) << 24 | (long)(b[offset++] & 0xFF) << 16 | (long)(b[offset++] & 0xFF) << 8 | (long)(b[offset++] & 0xFF));
                        break block0;
                    }
                    case 15: 
                }
                decoded = 72624976668147840L + ((long)b[offset++] << 56 | (long)(b[offset++] & 0xFF) << 48 | (long)(b[offset++] & 0xFF) << 40 | (long)(b[offset++] & 0xFF) << 32 | (long)(b[offset++] & 0xFF) << 24 | (long)(b[offset++] & 0xFF) << 16 | (long)(b[offset++] & 0xFF) << 8 | (long)(b[offset++] & 0xFF));
            }
        }
        offsetRef.set(offset);
        return decoded;
    }

    public static int calcUnsignedVarIntLength(int v) {
        if (v < 128) {
            return v < 0 ? 5 : 1;
        }
        if ((v -= 128) < 16384) {
            return 2;
        }
        if ((v -= 16384) < 0x200000) {
            return 3;
        }
        if ((v -= 0x200000) < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static int encodeUnsignedVarInt(byte[] b, int offset, int v) {
        if (v < 128) {
            if (v < 0) {
                b[offset++] = -1;
                b[offset++] = (byte)((v -= 270549120) >> 24);
                b[offset++] = (byte)(v >> 16);
                b[offset++] = (byte)(v >> 8);
            }
        } else if ((v -= 128) < 16384) {
            b[offset++] = (byte)(0x80 | v >> 8);
        } else {
            if ((v -= 16384) < 0x200000) {
                b[offset++] = (byte)(0xC0 | v >> 16);
            } else {
                if ((v -= 0x200000) < 0x10000000) {
                    b[offset++] = (byte)(0xE0 | v >> 24);
                } else {
                    b[offset++] = -16;
                    b[offset++] = (byte)((v -= 0x10000000) >> 24);
                }
                b[offset++] = (byte)(v >> 16);
            }
            b[offset++] = (byte)(v >> 8);
        }
        b[offset++] = (byte)v;
        return offset;
    }

    public static int encodeSignedVarInt(byte[] b, int offset, int v) {
        v = v < 0 ? ~v << 1 | 1 : (v <<= 1);
        return Utils.encodeUnsignedVarInt(b, offset, v);
    }

    public static int encodeSignedVarLong(byte[] b, int offset, long v) {
        v = v < 0L ? (v ^ 0xFFFFFFFFFFFFFFFFL) << 1 | 1L : (v <<= 1);
        return Utils.encodeUnsignedVarLong(b, offset, v);
    }

    public static int calcUnsignedVarLongLength(long v) {
        if (v < 128L) {
            return v < 0L ? 9 : 1;
        }
        if ((v -= 128L) < 16384L) {
            return 2;
        }
        if ((v -= 16384L) < 0x200000L) {
            return 3;
        }
        if ((v -= 0x200000L) < 0x10000000L) {
            return 4;
        }
        if ((v -= 0x10000000L) < 0x800000000L) {
            return 5;
        }
        if ((v -= 0x800000000L) < 0x40000000000L) {
            return 6;
        }
        if ((v -= 0x40000000000L) < 0x2000000000000L) {
            return 7;
        }
        if ((v -= 0x2000000000000L) < 0x100000000000000L) {
            return 8;
        }
        return 9;
    }

    public static int encodeUnsignedVarLong(byte[] b, int offset, long v) {
        if (v < 128L) {
            if (v < 0L) {
                b[offset++] = -1;
                b[offset++] = (byte)((v -= 72624976668147840L) >> 56);
                b[offset++] = (byte)(v >> 48);
                b[offset++] = (byte)(v >> 40);
                b[offset++] = (byte)(v >> 32);
                b[offset++] = (byte)(v >> 24);
                b[offset++] = (byte)(v >> 16);
                b[offset++] = (byte)(v >> 8);
            }
        } else if ((v -= 128L) < 16384L) {
            b[offset++] = (byte)(0x80 | (int)(v >> 8));
        } else {
            if ((v -= 16384L) < 0x200000L) {
                b[offset++] = (byte)(0xC0 | (int)(v >> 16));
            } else {
                if ((v -= 0x200000L) < 0x10000000L) {
                    b[offset++] = (byte)(0xE0 | (int)(v >> 24));
                } else {
                    if ((v -= 0x10000000L) < 0x800000000L) {
                        b[offset++] = (byte)(0xF0 | (int)(v >> 32));
                    } else {
                        if ((v -= 0x800000000L) < 0x40000000000L) {
                            b[offset++] = (byte)(0xF8 | (int)(v >> 40));
                        } else {
                            if ((v -= 0x40000000000L) < 0x2000000000000L) {
                                b[offset++] = (byte)(0xFC | (int)(v >> 48));
                            } else {
                                if ((v -= 0x2000000000000L) < 0x100000000000000L) {
                                    b[offset++] = (byte)(0xFE | (int)(v >> 56));
                                } else {
                                    b[offset++] = -1;
                                    b[offset++] = (byte)((v -= 0x100000000000000L) >> 56);
                                }
                                b[offset++] = (byte)(v >> 48);
                            }
                            b[offset++] = (byte)(v >> 40);
                        }
                        b[offset++] = (byte)(v >> 32);
                    }
                    b[offset++] = (byte)(v >> 24);
                }
                b[offset++] = (byte)(v >> 16);
            }
            b[offset++] = (byte)(v >> 8);
        }
        b[offset++] = (byte)v;
        return offset;
    }

    public static byte[] decrementReverseUnsignedVar(byte[] b, int offset) {
        int len = Utils.decodeReverseUnsignedLength(b, offset);
        Utils.decrement(b, offset, offset + len);
        if (len != Utils.decodeReverseUnsignedLength(b, offset)) {
            byte[] copy = new byte[b.length + 1];
            System.arraycopy(b, 0, copy, 0, b.length);
            copy[copy.length - 1] = -1;
            b = copy;
        }
        return b;
    }

    private static int decodeReverseUnsignedLength(byte[] b, int offset) {
        int h;
        int g = 23;
        while ((h = Integer.numberOfLeadingZeros(b[offset] & 0xFF)) == 32) {
            g -= 8;
            ++offset;
        }
        return h - g;
    }

    public static String toHex(byte[] key) {
        return key == null ? "null" : Utils.toHex(key, 0, key.length);
    }

    public static String toHex(byte[] key, int offset, int length) {
        if (key == null) {
            return "null";
        }
        char[] chars = new char[length << 1];
        int end = offset + length;
        int ci = 0;
        for (int bi = offset; bi < end; ++bi) {
            int b = key[bi] & 0xFF;
            chars[ci++] = Utils.toHexChar(b >> 4);
            chars[ci++] = Utils.toHexChar(b & 0xF);
        }
        return new String(chars);
    }

    private static char toHexChar(int b) {
        return (char)(b < 10 ? 48 + b : 97 + b - 10);
    }

    public static String toHexDump(byte[] b) {
        return Utils.toHexDump(b, 0, b.length);
    }

    public static String toHexDump(byte[] b, int offset, int length) {
        StringBuilder bob = new StringBuilder();
        for (int i = 0; i < length; i += 16) {
            int pos;
            int j;
            if (i > 0) {
                bob.append('\n');
            }
            String prefix = "0000000".concat(Integer.toHexString(i));
            prefix = prefix.substring(prefix.length() - 8);
            bob.append(prefix);
            bob.append(": ");
            for (j = 0; j < 16; j += 2) {
                pos = i + j;
                if (pos >= length - 1) {
                    if (pos >= length) {
                        bob.append("     ");
                        continue;
                    }
                    int v = b[offset + pos] & 0xFF;
                    if (v < 16) {
                        bob.append('0');
                    }
                    bob.append(Integer.toHexString(v));
                    bob.append("   ");
                    continue;
                }
                String pair = "000".concat(Integer.toHexString(Utils.decodeUnsignedShortBE(b, offset + pos)));
                pair = pair.substring(pair.length() - 4);
                bob.append(pair);
                bob.append(' ');
            }
            bob.append(' ');
            for (j = 0; j < 16 && (pos = i + j) < length; ++j) {
                char c = (char)(b[offset + pos] & 0xFF);
                bob.append(Character.isISOControl(c) ? (char)'.' : (char)c);
            }
        }
        return bob.toString();
    }

    static void deleteNumberedFiles(File baseFile, String pattern) throws IOException {
        Utils.deleteNumberedFiles(baseFile, pattern, 0L);
    }

    static void deleteNumberedFiles(File baseFile, String pattern, long min) throws IOException {
        String prefix = baseFile.getName() + pattern;
        for (File file : baseFile.getParentFile().listFiles()) {
            long num;
            String name = file.getName();
            if (!name.startsWith(prefix)) continue;
            String suffix = name.substring(prefix.length());
            try {
                num = Long.parseLong(suffix);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (num < min) continue;
            file.delete();
        }
    }
}

