/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.cojen.tupl.BoundedView;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.CompactionObserver;
import org.cojen.tupl.CursorFrame;
import org.cojen.tupl.Filter;
import org.cojen.tupl.Index;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockManager;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Locker;
import org.cojen.tupl.Node;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.RedoWriter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.TreeCursor;
import org.cojen.tupl.UnmodifiableView;
import org.cojen.tupl.Utils;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.View;
import org.cojen.tupl.ViewUtils;

class Tree
implements View,
Index {
    static final int REGISTRY_ID = 0;
    static final int REGISTRY_KEY_MAP_ID = 1;
    static final int FRAGMENTED_TRASH_ID = 3;
    static final int MAX_RESERVED_ID = 255;
    final LocalDatabase mDatabase;
    final LockManager mLockManager;
    final long mId;
    final byte[] mIdBytes;
    volatile byte[] mName;
    final Node mRoot;
    final int mMaxKeySize;
    final int mMaxEntrySize;

    static boolean isInternal(long id) {
        return (id & 0xFFFFFFFFFFFFFF00L) == 0L;
    }

    Tree(LocalDatabase db, long id, byte[] idBytes, byte[] name, Node root) {
        this.mDatabase = db;
        this.mLockManager = db.mLockManager;
        this.mId = id;
        this.mIdBytes = idBytes;
        this.mName = name;
        this.mRoot = root;
        int pageSize = db.pageSize();
        this.mMaxKeySize = Math.min(16383, (pageSize >> 1) - 22);
        this.mMaxEntrySize = (pageSize - 12) * 3 >> 2;
    }

    final int pageSize() {
        return this.mDatabase.pageSize();
    }

    public final String toString() {
        return ViewUtils.toString(this);
    }

    @Override
    public final Ordering getOrdering() {
        return Ordering.ASCENDING;
    }

    @Override
    public final long getId() {
        return this.mId;
    }

    @Override
    public final byte[] getName() {
        return Utils.cloneArray(this.mName);
    }

    @Override
    public final String getNameString() {
        byte[] name = this.mName;
        if (name == null) {
            return null;
        }
        try {
            return new String(name, "UTF-8");
        }
        catch (IOException e) {
            return new String(name);
        }
    }

    @Override
    public TreeCursor newCursor(Transaction txn) {
        return new TreeCursor(this, txn);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final byte[] load(Transaction txn, byte[] key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        TreeCursor cursor = new TreeCursor(this, txn);
        cursor.autoload(false);
        cursor.findAndStore(key, value);
    }

    @Override
    public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        return new TreeCursor(this, txn).findAndStore(key, value);
    }

    @Override
    public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        TreeCursor cursor = new TreeCursor(this, txn);
        cursor.autoload(false);
        return cursor.findAndModify(key, TreeCursor.MODIFY_INSERT, value);
    }

    @Override
    public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        TreeCursor cursor = new TreeCursor(this, txn);
        cursor.autoload(false);
        return cursor.findAndModify(key, TreeCursor.MODIFY_REPLACE, value);
    }

    @Override
    public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        return new TreeCursor(this, txn).findAndModify(key, oldValue, newValue);
    }

    @Override
    public final LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException {
        return this.check(txn).lockShared(this.mId, key);
    }

    @Override
    public final LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException {
        return this.check(txn).lockUpgradable(this.mId, key);
    }

    @Override
    public final LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException {
        return this.check(txn).lockExclusive(this.mId, key);
    }

    @Override
    public final LockResult lockCheck(Transaction txn, byte[] key) {
        return this.check(txn).lockCheck(this.mId, key);
    }

    @Override
    public View viewGe(byte[] key) {
        return BoundedView.viewGe(this, key);
    }

    @Override
    public View viewGt(byte[] key) {
        return BoundedView.viewGt(this, key);
    }

    @Override
    public View viewLe(byte[] key) {
        return BoundedView.viewLe(this, key);
    }

    @Override
    public View viewLt(byte[] key) {
        return BoundedView.viewLt(this, key);
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        return BoundedView.viewPrefix(this, prefix, trim);
    }

    @Override
    public final boolean isUnmodifiable() {
        return this.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evict(Transaction txn, byte[] lowKey, byte[] highKey, Filter evictionFilter, boolean autoload) throws IOException {
        long length = 0L;
        TreeCursor cursor = new TreeCursor(this, txn);
        cursor.autoload(autoload);
        try {
            byte[] endKey = cursor.randomNode(lowKey, highKey);
            if (endKey == null) {
                long l = length;
                return l;
            }
            if (lowKey != null) {
                if (Utils.compareUnsigned(lowKey, endKey) > 0) {
                    long l = length;
                    return l;
                }
                if (cursor.compareKeyTo(lowKey) < 0) {
                    cursor.findNearby(lowKey);
                }
            }
            if (highKey != null && Utils.compareUnsigned(highKey, endKey) <= 0) {
                endKey = highKey;
            }
            long[] stats = new long[2];
            while (cursor.key() != null) {
                byte[] key = cursor.key();
                byte[] value = cursor.value();
                if (value != null) {
                    cursor.valueStats(stats);
                    if (stats[0] > 0L && (evictionFilter == null || evictionFilter.isAllowed(key, value))) {
                        length += (long)key.length + stats[0];
                        cursor.store(null);
                    }
                }
                cursor.nextLe(endKey);
            }
        }
        finally {
            cursor.reset();
        }
        return length;
    }

    @Override
    public Index.Stats analyze(byte[] lowKey, byte[] highKey) throws IOException {
        TreeCursor cursor = new TreeCursor(this, Transaction.BOGUS);
        try {
            cursor.autoload(false);
            cursor.random(lowKey, highKey);
            return cursor.key() == null ? new Index.Stats(0.0, 0.0, 0.0, 0.0, 0.0) : cursor.analyze();
        }
        catch (Throwable e) {
            cursor.reset();
            throw e;
        }
    }

    final Index observableView() {
        return Tree.isInternal(this.mId) ? new UnmodifiableView(this) : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean compactTree(Index view, long highestNodeId, CompactionObserver observer) throws IOException {
        try {
            if (!observer.indexBegin(view)) {
                return false;
            }
        }
        catch (Throwable e) {
            Utils.uncaught(e);
            return false;
        }
        TreeCursor cursor = new TreeCursor(this, Transaction.BOGUS);
        try {
            cursor.autoload(false);
            cursor.find(Utils.EMPTY_BYTES);
            if (!cursor.compact(highestNodeId, observer)) {
                boolean bl = false;
                return bl;
            }
            if (!observer.indexComplete(view)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            cursor.reset();
        }
    }

    @Override
    public final boolean verify(VerificationObserver observer) throws IOException {
        if (observer == null) {
            observer = new VerificationObserver();
        }
        Index view = this.observableView();
        observer.failed = false;
        this.verifyTree(view, observer);
        boolean passed = !observer.failed;
        observer.indexComplete(view, passed, null);
        return passed;
    }

    final boolean verifyTree(Index view, VerificationObserver observer) throws IOException {
        TreeCursor cursor = new TreeCursor(this, Transaction.BOGUS);
        try {
            cursor.autoload(false);
            cursor.first();
            int height = cursor.height();
            if (!observer.indexBegin(view, height)) {
                cursor.reset();
                return false;
            }
            if (!cursor.verify(height, observer)) {
                cursor.reset();
                return false;
            }
            cursor.reset();
        }
        catch (Throwable e) {
            observer.failed = true;
            throw e;
        }
        return true;
    }

    @Override
    public final void close() throws IOException {
        this.close(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Node close(boolean forDelete, boolean rootLatched) throws IOException {
        Node root = this.mRoot;
        if (!rootLatched) {
            root.acquireExclusive();
        }
        try {
            if (root.mPage == PageOps.p_closedTreePage()) {
                Node node = null;
                return node;
            }
            if (Tree.isInternal(this.mId)) {
                throw new IllegalStateException("Cannot close an internal index");
            }
            if (root.hasKeys()) {
                root.releaseExclusive();
                this.mDatabase.commitLock().acquireExclusive();
                try {
                    root.acquireExclusive();
                    if (root.mPage == PageOps.p_closedTreePage()) {
                        Node node = null;
                        return node;
                    }
                    root.invalidateCursors();
                }
                finally {
                    this.mDatabase.commitLock().releaseExclusive();
                }
            } else {
                root.invalidateCursors();
            }
            Node newRoot = root.cloneNode();
            this.mDatabase.swapIfDirty(root, newRoot);
            if (root.mId > 0L) {
                this.mDatabase.nodeMapRemove(root);
            }
            root.closeRoot();
            if (forDelete) {
                this.mDatabase.treeClosed(this);
                Node node = newRoot;
                return node;
            }
            newRoot.acquireShared();
            try {
                this.mDatabase.treeClosed(this);
                newRoot.makeEvictableNow();
                if (newRoot.mId > 0L) {
                    this.mDatabase.nodeMapPut(newRoot);
                }
            }
            finally {
                newRoot.releaseShared();
            }
            Node node = null;
            return node;
        }
        finally {
            if (!rootLatched) {
                root.releaseExclusive();
            }
        }
    }

    @Override
    public final boolean isClosed() {
        Node root = this.mRoot;
        root.acquireShared();
        boolean closed = root.mPage == PageOps.p_closedTreePage();
        root.releaseShared();
        return closed;
    }

    @Override
    public final void drop() throws IOException {
        this.drop(true).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Runnable drop(boolean mustBeEmpty) throws IOException {
        Node root = this.mRoot;
        root.acquireExclusive();
        try {
            if (root.mPage == PageOps.p_closedTreePage()) {
                throw new ClosedIndexException();
            }
            if (mustBeEmpty && (!root.isLeaf() || root.hasKeys())) {
                throw new IllegalStateException("Cannot drop a non-empty index");
            }
            if (Tree.isInternal(this.mId)) {
                throw new IllegalStateException("Cannot close an internal index");
            }
            Runnable runnable = this.mDatabase.deleteTree(this);
            return runnable;
        }
        finally {
            root.releaseExclusive();
        }
    }

    final void deleteAll() throws IOException {
        new TreeCursor(this, Transaction.BOGUS).deleteAll();
    }

    final void traverseLoaded(NodeVisitor visitor) throws IOException {
        CursorFrame frame;
        Node node = this.mRoot;
        node.acquireExclusive();
        if (node.mSplit != null) {
            frame = new CursorFrame();
            frame.bind(node, 0);
            try {
                node = this.finishSplit(frame, node);
            }
            catch (Throwable e) {
                CursorFrame.popAll(frame);
                throw e;
            }
        }
        frame = null;
        int pos = 0;
        block6: while (true) {
            if (node.isInternal()) {
                int highestPos = node.highestInternalPos();
                while (pos <= highestPos) {
                    long childId = node.retrieveChildRefId(pos);
                    Node child = this.mDatabase.nodeMapGet(childId);
                    if (child != null) {
                        child.acquireExclusive();
                        if (childId != child.mId) {
                            child.releaseExclusive();
                        } else {
                            frame = new CursorFrame(frame);
                            frame.bind(node, pos);
                            node.releaseExclusive();
                            node = child;
                            pos = 0;
                            continue block6;
                        }
                    }
                    pos += 2;
                }
            }
            try {
                visitor.visit(node);
            }
            catch (Throwable e) {
                CursorFrame.popAll(frame);
                throw e;
            }
            if (frame == null) {
                return;
            }
            node = frame.acquireExclusive();
            if (node.mSplit != null) {
                try {
                    node = this.finishSplit(frame, node);
                }
                catch (Throwable e) {
                    CursorFrame.popAll(frame);
                    throw e;
                }
            }
            pos = frame.mNodePos;
            frame = frame.pop();
            pos += 2;
        }
    }

    final void writeCachePrimer(DataOutput dout) throws IOException {
        this.traverseLoaded(node -> {
            byte[] midKey;
            block8: {
                try {
                    if (!node.isLeaf()) {
                        return;
                    }
                    int numKeys = node.numKeys();
                    if (numKeys > 1) {
                        int highPos = numKeys & 0xFFFFFFFE;
                        midKey = node.midKey(highPos - 2, node, highPos);
                        break block8;
                    }
                    if (numKeys == 1) {
                        midKey = node.retrieveKey(0);
                        break block8;
                    }
                    return;
                }
                finally {
                    node.releaseExclusive();
                }
            }
            if (midKey.length < 65535) {
                dout.writeShort(midKey.length);
                dout.write(midKey);
            }
        });
        dout.writeShort(65535);
    }

    final void applyCachePrimer(DataInput din) throws IOException {
        new Primer(din).run();
    }

    static final void skipCachePrimer(DataInput din) throws IOException {
        int len;
        while ((len = din.readUnsignedShort()) != 65535) {
            int amt;
            while (len > 0 && (amt = din.skipBytes(len)) > 0) {
                len -= amt;
            }
        }
    }

    final boolean allowStoredCounts() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void append(byte[] key, byte[] value, CursorFrame frame) throws IOException {
        try {
            CommitLock commitLock = this.mDatabase.commitLock();
            commitLock.acquireShared();
            Node node = this.latchDirty(frame);
            try {
                node.insertLeafEntry(frame, this, frame.mNodePos, key, value);
                frame.mNodePos += 2;
                while (node.mSplit != null) {
                    if (node == this.mRoot) {
                        node.finishSplitRoot();
                        break;
                    }
                    Node childNode = node;
                    frame = frame.mParentFrame;
                    node = frame.mNode;
                    node.acquireExclusive();
                    node.insertSplitChildRef(frame, this, frame.mNodePos, childNode);
                }
            }
            finally {
                node.releaseExclusive();
                commitLock.releaseShared();
            }
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this.mDatabase, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node latchDirty(CursorFrame frame) throws IOException {
        Node node;
        block8: {
            LocalDatabase db = this.mDatabase;
            node = frame.mNode;
            node.acquireExclusive();
            if (db.shouldMarkDirty(node)) {
                CursorFrame parentFrame = frame.mParentFrame;
                try {
                    if (parentFrame == null) {
                        db.doMarkDirty(this, node);
                        break block8;
                    }
                    Node parentNode = this.latchDirty(parentFrame);
                    try {
                        if (db.markDirty(this, node)) {
                            parentNode.updateChildRefId(parentFrame.mNodePos, node.mId);
                        }
                    }
                    finally {
                        parentNode.releaseExclusive();
                    }
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
            }
        }
        return node;
    }

    final Node finishSplit(CursorFrame frame, Node node) throws IOException {
        block3: while (true) {
            if (node == this.mRoot) {
                try {
                    node.finishSplitRoot();
                }
                finally {
                    node.releaseExclusive();
                }
                return frame.acquireExclusive();
            }
            CursorFrame parentFrame = frame.mParentFrame;
            node.releaseExclusive();
            Node parentNode = parentFrame.acquireExclusive();
            while (true) {
                if (parentNode.mSplit != null) {
                    parentNode = this.finishSplit(parentFrame, parentNode);
                }
                node = frame.acquireExclusive();
                if (node.mSplit == null) {
                    parentNode.releaseExclusive();
                    return node;
                }
                if (node == this.mRoot) {
                    parentNode.releaseExclusive();
                    continue block3;
                }
                parentNode.insertSplitChildRef(parentFrame, this, parentFrame.mNodePos, node);
            }
            break;
        }
    }

    final LocalTransaction check(Transaction txn) throws IllegalArgumentException {
        if (txn instanceof LocalTransaction) {
            LocalTransaction local = (LocalTransaction)txn;
            LocalDatabase txnDb = local.mDatabase;
            if (txnDb == this.mDatabase || txnDb == null) {
                return local;
            }
        }
        if (txn != null) {
            throw new IllegalArgumentException("Transaction belongs to a different database");
        }
        return null;
    }

    final boolean isLockAvailable(Locker locker, byte[] key, int hash) {
        return this.mLockManager.isAvailable(locker, this.mId, key, hash);
    }

    final Locker lockSharedLocal(byte[] key, int hash) throws LockFailureException {
        return this.mLockManager.lockSharedLocal(this.mId, key, hash);
    }

    final Locker lockExclusiveLocal(byte[] key, int hash) throws LockFailureException {
        return this.mLockManager.lockExclusiveLocal(this.mId, key, hash);
    }

    final long redoStore(byte[] key, byte[] value) throws IOException {
        RedoWriter redo = this.mDatabase.mRedoWriter;
        return redo == null ? 0L : redo.store(this.mId, key, value, this.mDatabase.mDurabilityMode);
    }

    final long redoStoreNoLock(byte[] key, byte[] value) throws IOException {
        RedoWriter redo = this.mDatabase.mRedoWriter;
        return redo == null ? 0L : redo.storeNoLock(this.mId, key, value, this.mDatabase.mDurabilityMode);
    }

    final void txnCommitSync(LocalTransaction txn, long commitPos) throws IOException {
        this.mDatabase.mRedoWriter.txnCommitSync(txn, commitPos);
    }

    final boolean markDirty(Node node) throws IOException {
        return this.mDatabase.markDirty(this, node);
    }

    final byte[] fragmentKey(byte[] key) throws IOException {
        return this.mDatabase.fragment(key, key.length, this.mMaxKeySize);
    }

    private class Primer {
        private final DataInput mDin;
        private final int mTaskLimit;
        private int mTaskCount;
        private boolean mFinished;
        private IOException mEx;

        Primer(DataInput din) {
            this.mDin = din;
            this.mTaskLimit = Runtime.getRuntime().availableProcessors() * 8;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() throws IOException {
            Primer primer = this;
            synchronized (primer) {
                ++this.mTaskCount;
            }
            this.prime();
            primer = this;
            synchronized (primer) {
                while (true) {
                    if (this.mEx != null) {
                        throw this.mEx;
                    }
                    if (this.mTaskCount <= 0) break;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        void prime() {
            try {
                TreeCursor c = Tree.this.newCursor(Transaction.BOGUS);
                try {
                    Primer primer;
                    c.autoload(false);
                    while (true) {
                        byte[] key;
                        block32: {
                            primer = this;
                            // MONITORENTER : primer
                            if (this.mFinished) {
                                // MONITOREXIT : primer
                                c.reset();
                                return;
                            }
                            int len = this.mDin.readUnsignedShort();
                            if (len == 65535) {
                                this.mFinished = true;
                                // MONITOREXIT : primer
                                c.reset();
                                return;
                            }
                            key = new byte[len];
                            this.mDin.readFully(key);
                            if (this.mTaskCount < this.mTaskLimit) {
                                Task task;
                                try {
                                    task = new Task();
                                }
                                catch (Throwable e) {
                                    break block32;
                                }
                                ++this.mTaskCount;
                                task.start();
                            }
                        }
                        // MONITOREXIT : primer
                        c.findNearby(key);
                        continue;
                        break;
                    }
                    catch (IOException e) {
                        primer = this;
                        // MONITORENTER : primer
                        if (this.mEx == null) {
                            this.mEx = e;
                        }
                        // MONITOREXIT : primer
                        return;
                    }
                }
                finally {
                    c.reset();
                }
            }
            finally {
                Primer primer = this;
            }
        }

        class Task
        extends Thread {
            Task() {
            }

            @Override
            public void run() {
                Primer.this.prime();
            }
        }
    }

    @FunctionalInterface
    static interface NodeVisitor {
        public void visit(Node var1) throws IOException;
    }
}

