/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.LocalDatabase;
import org.cojen.tupl.Node;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.TempFileManager;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Tree;
import org.cojen.tupl.Utils;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.util.Latch;

final class SnapshotPageArray
extends PageArray {
    private final PageArray mSource;
    private final PageArray mRawSource;
    private final PageCache mCache;
    private volatile Object mSnapshots;

    SnapshotPageArray(PageArray source, PageArray rawSource, PageCache cache) {
        super(source.pageSize());
        this.mSource = source;
        this.mRawSource = rawSource;
        this.mCache = cache;
    }

    @Override
    public boolean isReadOnly() {
        return this.mSource.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long getPageCount() throws IOException {
        return this.mSource.getPageCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPageCount(long count) throws IOException {
        SnapshotPageArray snapshotPageArray = this;
        synchronized (snapshotPageArray) {
            if (this.mSnapshots == null) {
                this.mSource.setPageCount(count);
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public long getPageCountLimit() throws IOException {
        return this.mSource.getPageCountLimit();
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        PageCache cache = this.mCache;
        if (cache == null || !cache.remove(index, dst, offset, length)) {
            this.mSource.readPage(index, dst, offset, length);
        }
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        PageCache cache = this.mCache;
        if (cache == null || !cache.remove(index, dstPtr, offset, length)) {
            this.mSource.readPage(index, dstPtr, offset, length);
        }
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        this.preWritePage(index);
        this.cachePage(index, src, offset);
        this.mSource.writePage(index, src, offset);
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        this.preWritePage(index);
        this.cachePage(index, srcPtr, offset);
        this.mSource.writePage(index, srcPtr, offset);
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        this.preWritePage(index);
        this.cachePage(index, buf, 0);
        return this.mSource.evictPage(index, buf);
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        this.preWritePage(index);
        this.cachePage(index, bufPtr, 0);
        return this.mSource.evictPage(index, bufPtr);
    }

    private void preWritePage(long index) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        Object obj = this.mSnapshots;
        if (obj != null) {
            if (obj instanceof SnapshotImpl) {
                ((SnapshotImpl)obj).capture(index);
            } else {
                for (SnapshotImpl snapshot : (SnapshotImpl[])obj) {
                    snapshot.capture(index);
                }
            }
        }
    }

    @Override
    public void cachePage(long index, byte[] src, int offset) {
        PageCache cache = this.mCache;
        if (cache != null) {
            cache.add(index, src, offset, true);
        }
    }

    @Override
    public void cachePage(long index, long srcPtr, int offset) {
        PageCache cache = this.mCache;
        if (cache != null) {
            cache.add(index, srcPtr, offset, true);
        }
    }

    @Override
    public void uncachePage(long index) {
        PageCache cache = this.mCache;
        if (cache != null) {
            cache.remove(index, PageOps.p_null(), 0, 0);
        }
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        if (this.mCache != null) {
            throw new IllegalStateException();
        }
        return this.mSource.directPagePointer(index);
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        this.preCopyPage(dstIndex);
        return this.mSource.copyPage(srcIndex, dstIndex);
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        this.preCopyPage(dstIndex);
        return this.mSource.copyPageFromPointer(srcPointer, dstIndex);
    }

    private void preCopyPage(long dstIndex) throws IOException {
        if (this.mCache != null) {
            throw new IllegalStateException();
        }
        if (dstIndex < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(dstIndex));
        }
        Object obj = this.mSnapshots;
        if (obj != null) {
            if (obj instanceof SnapshotImpl) {
                ((SnapshotImpl)obj).capture(dstIndex);
            } else {
                for (SnapshotImpl snapshot : (SnapshotImpl[])obj) {
                    snapshot.capture(dstIndex);
                }
            }
        }
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mSource.sync(metadata);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        if (this.mCache != null) {
            this.mCache.close();
        }
        this.mSource.close(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot beginSnapshot(LocalDatabase db, long pageCount, long redoPos) throws IOException {
        pageCount = Math.min(pageCount, this.getPageCount());
        LocalDatabase nodeCache = db;
        PageArray rawSource = this.mRawSource;
        if (rawSource != this.mSource) {
            nodeCache = null;
        }
        TempFileManager tfm = db.mTempFileManager;
        SnapshotImpl snapshot = new SnapshotImpl(tfm, pageCount, redoPos, nodeCache, rawSource);
        SnapshotPageArray snapshotPageArray = this;
        synchronized (snapshotPageArray) {
            Object obj = this.mSnapshots;
            if (obj == null) {
                this.mSnapshots = snapshot;
            } else if (obj instanceof SnapshotImpl[]) {
                SnapshotImpl[] snapshots = (SnapshotImpl[])obj;
                SnapshotImpl[] newSnapshots = new SnapshotImpl[snapshots.length + 1];
                System.arraycopy(snapshots, 0, newSnapshots, 0, snapshots.length);
                newSnapshots[newSnapshots.length - 1] = snapshot;
                this.mSnapshots = newSnapshots;
            } else {
                this.mSnapshots = new SnapshotImpl[]{(SnapshotImpl)obj, snapshot};
            }
        }
        return snapshot;
    }

    synchronized void unregister(SnapshotImpl snapshot) {
        int pos;
        SnapshotImpl[] snapshots;
        block8: {
            Object obj = this.mSnapshots;
            if (obj == snapshot) {
                this.mSnapshots = null;
                return;
            }
            if (!(obj instanceof SnapshotImpl[])) {
                return;
            }
            snapshots = (SnapshotImpl[])obj;
            if (snapshots.length == 2) {
                if (snapshots[0] == snapshot) {
                    this.mSnapshots = snapshots[1];
                } else if (snapshots[1] == snapshot) {
                    this.mSnapshots = snapshots[0];
                }
                return;
            }
            for (pos = 0; pos < snapshots.length; ++pos) {
                if (snapshots[pos] != snapshot) {
                    continue;
                }
                break block8;
            }
            return;
        }
        SnapshotImpl[] newSnapshots = new SnapshotImpl[snapshots.length - 1];
        System.arraycopy(snapshots, 0, newSnapshots, 0, pos);
        System.arraycopy(snapshots, pos + 1, newSnapshots, pos, newSnapshots.length - pos);
        this.mSnapshots = newSnapshots;
    }

    class SnapshotImpl
    implements CauseCloseable,
    Snapshot {
        private final LocalDatabase mNodeCache;
        private final PageArray mRawPageArray;
        private final TempFileManager mTempFileManager;
        private final long mSnapshotPageCount;
        private final long mSnapshotRedoPosition;
        private final Tree mPageCopyIndex;
        private final File mTempFile;
        private final Object mSnapshotLock;
        private final Latch mCaptureLatch;
        private final byte[] mCaptureBufferArray;
        private final byte[] mCaptureBuffer;
        private volatile long mProgress;
        private long mWriteInProgress;
        private long mCaptureInProgress;
        private volatile boolean mClosed;
        private Throwable mAbortCause;

        SnapshotImpl(TempFileManager tfm, long pageCount, long redoPos, LocalDatabase nodeCache, PageArray rawPageArray) throws IOException {
            this.mNodeCache = nodeCache;
            this.mRawPageArray = rawPageArray;
            this.mTempFileManager = tfm;
            this.mSnapshotPageCount = pageCount;
            this.mSnapshotRedoPosition = redoPos;
            int pageSize = SnapshotPageArray.this.pageSize();
            DatabaseConfig config = new DatabaseConfig().pageSize(pageSize).minCacheSize(pageSize * 100);
            this.mPageCopyIndex = LocalDatabase.openTemp(tfm, config);
            this.mTempFile = config.mBaseFile;
            this.mSnapshotLock = new Object();
            this.mCaptureLatch = new Latch();
            this.mCaptureBufferArray = new byte[pageSize];
            this.mCaptureBuffer = PageOps.p_transfer(this.mCaptureBufferArray);
            this.mProgress = -2L;
            this.mWriteInProgress = -2L;
            this.mCaptureInProgress = -1L;
        }

        @Override
        public long length() {
            return this.mSnapshotPageCount * (long)SnapshotPageArray.this.pageSize();
        }

        @Override
        public long position() {
            return this.mSnapshotRedoPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTo(OutputStream out) throws IOException {
            Object object = this.mSnapshotLock;
            synchronized (object) {
                if (this.mProgress > -2L) {
                    throw new IllegalStateException("Snapshot already started");
                }
                if (this.mClosed) {
                    throw this.aborted(this.mAbortCause);
                }
                this.mProgress = -1L;
                this.mWriteInProgress = -1L;
            }
            byte[] pageBufferArray = new byte[SnapshotPageArray.this.pageSize()];
            byte[] pageBuffer = PageOps.p_transfer(pageBufferArray);
            Cursor c = null;
            try {
                LocalDatabase cache = this.mNodeCache;
                byte[] key = new byte[8];
                long count = this.mSnapshotPageCount;
                long index = 0L;
                while (index < count) {
                    Object object2 = this.mSnapshotLock;
                    synchronized (object2) {
                        while (true) {
                            if (this.mClosed) {
                                throw this.aborted(this.mAbortCause);
                            }
                            if (index != this.mCaptureInProgress) break;
                            try {
                                this.mSnapshotLock.wait();
                            }
                            catch (InterruptedException e) {
                                throw new InterruptedIOException();
                            }
                        }
                        this.mWriteInProgress = index;
                    }
                    if (c == null) {
                        c = this.mPageCopyIndex.newCursor(Transaction.BOGUS);
                        c.find(key);
                    } else {
                        c.findNearby(key);
                    }
                    byte[] value = c.value();
                    if (value != null) {
                        c.store(null);
                    } else {
                        block29: {
                            block28: {
                                Node node;
                                if (cache != null && (node = cache.nodeMapGet(index)) != null && node.tryAcquireShared()) {
                                    try {
                                        if (node.mId != index || node.mCachedState != 0) break block28;
                                        PageOps.p_copy(node.mPage, 0, pageBuffer, 0, SnapshotPageArray.this.pageSize());
                                        break block29;
                                    }
                                    finally {
                                        node.releaseShared();
                                    }
                                }
                            }
                            this.mRawPageArray.readPage(index, pageBuffer);
                        }
                        value = PageOps.p_copyIfNotArray(pageBuffer, pageBufferArray);
                    }
                    Object object3 = this.mSnapshotLock;
                    synchronized (object3) {
                        this.mProgress = index++;
                        this.mSnapshotLock.notifyAll();
                    }
                    out.write(value);
                    Utils.increment(key, 0, 8);
                }
            }
            finally {
                PageOps.p_delete(pageBuffer);
                if (c != null) {
                    c.reset();
                }
                this.close();
            }
        }

        /*
         * Exception decompiling
         */
        void capture(long index) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void close() throws IOException {
            this.close(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(Throwable cause) throws IOException {
            if (this.mClosed) {
                return;
            }
            Object object = this.mSnapshotLock;
            synchronized (object) {
                if (this.mClosed) {
                    return;
                }
                PageOps.p_delete(this.mCaptureBuffer);
                this.mProgress = -1L;
                this.mWriteInProgress = -1L;
                this.mCaptureInProgress = -1L;
                this.mAbortCause = cause;
                this.mClosed = true;
                this.mSnapshotLock.notifyAll();
            }
            SnapshotPageArray.this.unregister(this);
            Utils.closeQuietly(null, this.mPageCopyIndex.mDatabase);
            this.mTempFileManager.deleteTempFile(this.mTempFile);
        }

        private void abort(Throwable e) {
            try {
                this.close(e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private IOException aborted(Throwable cause) {
            return new IOException("Snapshot closed", cause);
        }
    }
}

