/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.GeneralSecurityException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.cojen.tupl.Crypto;
import org.cojen.tupl.DataIn;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.RedoLogDecoder;
import org.cojen.tupl.RedoVisitor;
import org.cojen.tupl.RedoWriter;
import org.cojen.tupl.Utils;
import org.cojen.tupl.WriteFailureException;
import org.cojen.tupl.io.FileFactory;
import org.cojen.tupl.io.FileIO;

final class RedoLog
extends RedoWriter {
    private static final long MAGIC_NUMBER = 431399725605778814L;
    private static final int ENCODING_VERSION = 20130106;
    private final Crypto mCrypto;
    private final File mBaseFile;
    private final FileFactory mFileFactory;
    private final boolean mReplayMode;
    private long mLogId;
    private long mPosition;
    private OutputStream mOut;
    private volatile FileChannel mChannel;
    private int mTermRndSeed;
    private long mNextLogId;
    private long mNextPosition;
    private OutputStream mNextOut;
    private FileChannel mNextChannel;
    private int mNextTermRndSeed;
    private volatile OutputStream mOldOut;
    private volatile FileChannel mOldChannel;
    private long mDeleteLogId;

    RedoLog(DatabaseConfig config, long logId, long redoPos) throws IOException {
        this(config.mCrypto, config.mBaseFile, config.mFileFactory, logId, redoPos, true);
    }

    RedoLog(DatabaseConfig config, RedoLog replayed) throws IOException {
        this(config.mCrypto, config.mBaseFile, config.mFileFactory, replayed.mLogId, replayed.mPosition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RedoLog(Crypto crypto, File baseFile, FileFactory factory, long logId, long redoPos, boolean replay) throws IOException {
        super(4096, 0L);
        this.mCrypto = crypto;
        this.mBaseFile = baseFile;
        this.mFileFactory = factory;
        this.mReplayMode = replay;
        RedoLog redoLog = this;
        synchronized (redoLog) {
            this.mLogId = logId;
            this.mPosition = redoPos;
            if (!replay) {
                this.openNextFile(logId);
                this.applyNextFile();
                this.mDeleteLogId = logId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Set<File> replay(RedoVisitor visitor, EventListener listener, EventType type, String message) throws IOException {
        if (!this.mReplayMode || this.mBaseFile == null) {
            throw new IllegalStateException();
        }
        try {
            LinkedHashSet<File> files;
            block14: {
                boolean finished;
                files = new LinkedHashSet<File>(2);
                do {
                    InputStream in;
                    File file = RedoLog.fileFor(this.mBaseFile, this.mLogId);
                    try {
                        in = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        break block14;
                    }
                    try {
                        if (this.mCrypto != null) {
                            try {
                                in = this.mCrypto.newDecryptingStream(this.mLogId, in);
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new DatabaseException(e);
                            }
                        }
                        if (listener != null) {
                            listener.notify(type, message, this.mLogId);
                        }
                        files.add(file);
                        DataIn.Stream din = new DataIn.Stream(this.mPosition, in);
                        finished = this.replay(din, visitor, listener);
                        this.mPosition = din.mPos;
                    }
                    finally {
                        Utils.closeQuietly(null, in);
                    }
                    ++this.mLogId;
                } while (finished);
                Utils.deleteNumberedFiles(this.mBaseFile, ".redo.", this.mLogId);
            }
            return files;
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCause);
        }
    }

    static void deleteOldFile(File baseFile, long logId) {
        RedoLog.fileFor(baseFile, logId).delete();
    }

    private void openNextFile(long logId) throws IOException {
        OutputStream nextOut;
        FileChannel nextChannel;
        byte[] header = new byte[24];
        File file = RedoLog.fileFor(this.mBaseFile, logId);
        if (file.exists() && file.length() > (long)header.length) {
            throw new FileNotFoundException("Log file already exists: " + file.getPath());
        }
        if (this.mFileFactory != null) {
            this.mFileFactory.createFile(file);
        }
        FileOutputStream fout = null;
        int nextTermRndSeed = Utils.randomSeed();
        try {
            fout = new FileOutputStream(file);
            nextChannel = fout.getChannel();
            if (this.mCrypto == null) {
                nextOut = fout;
            } else {
                try {
                    nextOut = this.mCrypto.newEncryptingStream(logId, fout);
                }
                catch (GeneralSecurityException e) {
                    throw new DatabaseException(e);
                }
            }
            int offset = 0;
            Utils.encodeLongLE(header, offset, 431399725605778814L);
            Utils.encodeIntLE(header, offset += 8, 20130106);
            Utils.encodeLongLE(header, offset += 4, logId);
            Utils.encodeIntLE(header, offset += 8, nextTermRndSeed);
            if ((offset += 4) != header.length) {
                throw new AssertionError();
            }
            nextOut.write(header);
            FileIO.dirSync(file);
        }
        catch (IOException e) {
            Utils.closeQuietly(null, fout);
            file.delete();
            throw new WriteFailureException(e);
        }
        this.mNextLogId = logId;
        this.mNextOut = nextOut;
        this.mNextChannel = nextChannel;
        this.mNextTermRndSeed = nextTermRndSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNextFile() throws IOException {
        FileChannel oldChannel;
        OutputStream oldOut;
        RedoLog redoLog = this;
        synchronized (redoLog) {
            oldOut = this.mOut;
            oldChannel = this.mChannel;
            if (oldOut != null) {
                this.endFile();
            }
            this.mNextPosition = this.mPosition;
            this.mOut = this.mNextOut;
            this.mChannel = this.mNextChannel;
            this.mTermRndSeed = this.mNextTermRndSeed;
            this.mLogId = this.mNextLogId;
            this.mNextOut = null;
            this.mNextChannel = null;
            this.timestamp();
            this.reset();
        }
        Utils.closeQuietly(null, this.mOldOut);
        this.mOldOut = oldOut;
        this.mOldChannel = oldChannel;
    }

    private static File fileFor(File base, long logId) {
        return base == null ? null : new File(base.getPath() + ".redo." + logId);
    }

    @Override
    public final long encoding() {
        return 0L;
    }

    @Override
    public final RedoWriter txnRedoWriter() {
        return this;
    }

    @Override
    boolean isOpen() {
        FileChannel channel = this.mChannel;
        return channel != null && channel.isOpen();
    }

    @Override
    boolean shouldCheckpoint(long size) {
        try {
            FileChannel channel = this.mChannel;
            return channel != null && channel.size() >= size;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void checkpointPrepare() throws IOException {
        long logId;
        if (this.mReplayMode) {
            throw new IllegalStateException();
        }
        RedoLog redoLog = this;
        synchronized (redoLog) {
            logId = this.mLogId;
        }
        this.openNextFile(logId + 1L);
    }

    @Override
    void checkpointSwitch() throws IOException {
        this.applyNextFile();
    }

    @Override
    long checkpointNumber() {
        return this.mNextLogId;
    }

    @Override
    long checkpointPosition() {
        return this.mNextPosition;
    }

    @Override
    long checkpointTransactionId() {
        return 0L;
    }

    @Override
    void checkpointAborted() {
        if (this.mNextOut != null) {
            Utils.closeQuietly(null, this.mNextOut);
            this.mNextOut = null;
        }
    }

    @Override
    void checkpointStarted() throws IOException {
    }

    @Override
    void checkpointFlushed() throws IOException {
    }

    @Override
    void checkpointFinished() throws IOException {
        long id;
        this.mOldChannel = null;
        Utils.closeQuietly(null, this.mOldOut);
        for (id = this.mDeleteLogId; id < this.mNextLogId; ++id) {
            RedoLog.deleteOldFile(this.mBaseFile, id);
        }
        this.mDeleteLogId = id;
    }

    @Override
    void write(byte[] buffer, int len) throws IOException {
        try {
            this.mOut.write(buffer, 0, len);
            this.mPosition += (long)len;
        }
        catch (IOException e) {
            throw new WriteFailureException(e);
        }
    }

    @Override
    long writeCommit(byte[] buffer, int len) throws IOException {
        try {
            long pos = this.mPosition + (long)len;
            this.mOut.write(buffer, 0, len);
            this.mPosition = pos;
            return pos;
        }
        catch (IOException e) {
            throw new WriteFailureException(e);
        }
    }

    @Override
    void force(boolean metadata) throws IOException {
        FileChannel channel;
        FileChannel oldChannel = this.mOldChannel;
        if (oldChannel != null) {
            try {
                oldChannel.force(true);
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
            this.mOldChannel = null;
        }
        if ((channel = this.mChannel) != null) {
            try {
                channel.force(metadata);
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    @Override
    void forceAndClose() throws IOException {
        FileChannel channel = this.mChannel;
        if (channel != null) {
            try {
                channel.force(true);
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    @Override
    void writeTerminator() throws IOException {
        this.writeIntLE(this.nextTermRnd());
    }

    int nextTermRnd() {
        this.mTermRndSeed = Utils.nextRandom(this.mTermRndSeed);
        return this.mTermRndSeed;
    }

    private boolean replay(DataIn in, RedoVisitor visitor, EventListener listener) throws IOException {
        try {
            long magic = in.readLongLE();
            if (magic != 431399725605778814L) {
                if (magic == 0L) {
                    return false;
                }
                throw new DatabaseException("Incorrect magic number in redo log file");
            }
        }
        catch (EOFException e) {
            return false;
        }
        int version = in.readIntLE();
        if (version != 20130106) {
            throw new DatabaseException("Unsupported redo log encoding version: " + version);
        }
        long id = in.readLongLE();
        if (id != this.mLogId) {
            throw new DatabaseException("Expected redo log identifier of " + this.mLogId + ", but actual is: " + id);
        }
        this.mTermRndSeed = in.readIntLE();
        try {
            return new RedoLogDecoder(this, in, listener).run(visitor);
        }
        catch (EOFException e) {
            if (listener != null) {
                listener.notify(EventType.RECOVERY_REDO_LOG_CORRUPTION, "Unexpected end of file", new Object[0]);
            }
            return false;
        }
    }
}

