/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.DataIn;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.RedoVisitor;

abstract class RedoDecoder {
    private final boolean mLenient;
    long mTxnId;

    RedoDecoder(boolean lenient, long initialTxnId) {
        this.mLenient = lenient;
        this.mTxnId = initialTxnId;
    }

    boolean run(RedoVisitor visitor) throws IOException {
        block30: while (true) {
            byte[] message;
            byte[] key;
            long indexId;
            long txnId;
            DataIn in;
            int op;
            if ((op = (in = this.in()).read()) < 0) {
                return true;
            }
            switch (op &= 0xFF) {
                case 0: {
                    if (this.mLenient) {
                        return true;
                    }
                }
                default: {
                    throw new DatabaseException("Unknown redo log operation: " + op + " at " + (in.mPos - 1L));
                }
                case 1: {
                    if (!this.verifyTerminator(in)) {
                        return false;
                    }
                    this.mTxnId = 0L;
                    if (visitor.reset()) continue block30;
                    return false;
                }
                case 2: {
                    long ts = in.readLongLE();
                    if (this.verifyTerminator(in) && visitor.timestamp(ts)) continue block30;
                    return false;
                }
                case 3: {
                    long ts = in.readLongLE();
                    if (this.verifyTerminator(in) && visitor.shutdown(ts)) continue block30;
                    return false;
                }
                case 4: {
                    long ts = in.readLongLE();
                    if (this.verifyTerminator(in) && visitor.close(ts)) continue block30;
                    return false;
                }
                case 5: {
                    long ts = in.readLongLE();
                    if (this.verifyTerminator(in) && visitor.endFile(ts)) continue block30;
                    return false;
                }
                case 6: {
                    in.readLongLE();
                    if (this.verifyTerminator(in)) continue block30;
                    return false;
                }
                case 24: {
                    txnId = this.readTxnId(in);
                    if (this.verifyTerminator(in) && visitor.txnEnter(txnId)) continue block30;
                    return false;
                }
                case 25: {
                    txnId = this.readTxnId(in);
                    if (this.verifyTerminator(in) && visitor.txnRollback(txnId)) continue block30;
                    return false;
                }
                case 26: {
                    txnId = this.readTxnId(in);
                    if (this.verifyTerminator(in) && visitor.txnRollbackFinal(txnId)) continue block30;
                    return false;
                }
                case 27: {
                    txnId = this.readTxnId(in);
                    if (this.verifyTerminator(in) && visitor.txnCommit(txnId)) continue block30;
                    return false;
                }
                case 28: {
                    txnId = this.readTxnId(in);
                    if (this.verifyTerminator(in) && visitor.txnCommitFinal(txnId)) continue block30;
                    return false;
                }
                case 16: {
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    byte[] value = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.store(indexId, key, value)) continue block30;
                    return false;
                }
                case 17: {
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    byte[] value = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.storeNoLock(indexId, key, value)) continue block30;
                    return false;
                }
                case 18: {
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.store(indexId, key, null)) continue block30;
                    return false;
                }
                case 19: {
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.storeNoLock(indexId, key, null)) continue block30;
                    return false;
                }
                case 21: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    byte[] newName = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.renameIndex(txnId, indexId, newName)) continue block30;
                    return false;
                }
                case 22: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    if (this.verifyTerminator(in) && visitor.deleteIndex(txnId, indexId)) continue block30;
                    return false;
                }
                case 32: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    byte[] value = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnEnter(txnId) && visitor.txnStore(txnId, indexId, key, value)) continue block30;
                    return false;
                }
                case 33: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    byte[] value = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnStore(txnId, indexId, key, value)) continue block30;
                    return false;
                }
                case 34: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    byte[] value = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnStore(txnId, indexId, key, value) && visitor.txnCommit(txnId)) continue block30;
                    return false;
                }
                case 35: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    byte[] value = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnStoreCommitFinal(txnId, indexId, key, value)) continue block30;
                    return false;
                }
                case 36: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnEnter(txnId) && visitor.txnStore(txnId, indexId, key, null)) continue block30;
                    return false;
                }
                case 37: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnStore(txnId, indexId, key, null)) continue block30;
                    return false;
                }
                case 38: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnStore(txnId, indexId, key, null) && visitor.txnCommitFinal(txnId)) continue block30;
                    return false;
                }
                case 39: {
                    txnId = this.readTxnId(in);
                    indexId = in.readLongLE();
                    key = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnStoreCommitFinal(txnId, indexId, key, null)) continue block30;
                    return false;
                }
                case 128: {
                    txnId = this.readTxnId(in);
                    message = in.readBytes();
                    if (this.verifyTerminator(in) && visitor.txnCustom(txnId, message)) continue block30;
                    return false;
                }
                case 129: 
            }
            txnId = this.readTxnId(in);
            indexId = in.readLongLE();
            key = in.readBytes();
            message = in.readBytes();
            if (!this.verifyTerminator(in) || !visitor.txnCustomLock(txnId, message, indexId, key)) break;
        }
        return false;
    }

    long readTxnId(DataIn in) throws IOException {
        return this.mTxnId += in.readSignedVarLong();
    }

    abstract DataIn in();

    abstract boolean verifyTerminator(DataIn var1) throws IOException;
}

