/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import org.cojen.tupl.PageOps;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;

final class PagePool
extends Latch {
    private final transient LatchCondition mQueue = new LatchCondition();
    private final byte[][] mPool;
    private int mPos;

    PagePool(int pageSize, int poolSize) {
        byte[][] pool = PageOps.p_allocArray(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            pool[i] = PageOps.p_calloc(pageSize);
        }
        this.mPool = pool;
        this.mPos = poolSize;
    }

    byte[] remove() {
        this.acquireExclusive();
        try {
            int pos;
            while ((pos = this.mPos) == 0) {
                this.mQueue.await(this, -1L, 0L);
            }
            this.mPos = pos - 1;
            byte[] byArray = this.mPool[this.mPos];
            return byArray;
        }
        finally {
            this.releaseExclusive();
        }
    }

    void add(byte[] page) {
        this.acquireExclusive();
        try {
            int pos = this.mPos;
            this.mPool[pos] = page;
            this.mPos = pos + 1;
            this.mQueue.signal();
        }
        finally {
            this.releaseExclusive();
        }
    }

    void delete() {
        this.acquireExclusive();
        try {
            for (int i = 0; i < this.mPos; ++i) {
                byte[] page = this.mPool[i];
                this.mPool[i] = PageOps.p_null();
                PageOps.p_delete(page);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }
}

