/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.cojen.tupl.IntegerRef;
import org.cojen.tupl.Utils;

final class PageOps {
    static final int NODE_OVERHEAD = 100;
    private static final byte[] CLOSED_TREE_PAGE;

    PageOps() {
    }

    static byte[] p_null() {
        return null;
    }

    static byte[] p_closedTreePage() {
        return CLOSED_TREE_PAGE;
    }

    static byte[] p_alloc(int size) {
        return new byte[size];
    }

    static byte[] p_calloc(int size) {
        return new byte[size];
    }

    static byte[][] p_allocArray(int size) {
        return new byte[size][];
    }

    static void p_delete(byte[] page) {
    }

    static Object p_arenaAlloc(int pageSize, long pageCount) throws IOException {
        return null;
    }

    static void p_arenaDelete(Object arena) throws IOException {
        if (arena != null) {
            throw new IllegalArgumentException();
        }
    }

    static byte[] p_calloc(Object arena, int size) {
        return PageOps.p_calloc(size);
    }

    static byte[] p_clone(byte[] page, int length) {
        return (byte[])page.clone();
    }

    static byte[] p_transfer(byte[] array) {
        return array;
    }

    static byte[] p_transferTo(byte[] array, byte[] page) {
        return array;
    }

    static byte p_byteGet(byte[] page, int index) {
        return page[index];
    }

    static int p_ubyteGet(byte[] page, int index) {
        return page[index] & 0xFF;
    }

    static void p_bytePut(byte[] page, int index, byte v) {
        page[index] = v;
    }

    static void p_bytePut(byte[] page, int index, int v) {
        page[index] = (byte)v;
    }

    static int p_ushortGetLE(byte[] page, int index) {
        return Utils.decodeUnsignedShortLE(page, index);
    }

    static void p_shortPutLE(byte[] page, int index, int v) {
        Utils.encodeShortLE(page, index, v);
    }

    static int p_intGetLE(byte[] page, int index) {
        return Utils.decodeIntLE(page, index);
    }

    static void p_intPutLE(byte[] page, int index, int v) {
        Utils.encodeIntLE(page, index, v);
    }

    static int p_uintGetVar(byte[] page, int index) {
        return Utils.decodeUnsignedVarInt(page, index);
    }

    static int p_uintPutVar(byte[] page, int index, int v) {
        return Utils.encodeUnsignedVarInt(page, index, v);
    }

    static int p_uintVarSize(int v) {
        return Utils.calcUnsignedVarIntLength(v);
    }

    static long p_uint48GetLE(byte[] page, int index) {
        return Utils.decodeUnsignedInt48LE(page, index);
    }

    static void p_int48PutLE(byte[] page, int index, long v) {
        Utils.encodeInt48LE(page, index, v);
    }

    static long p_longGetLE(byte[] page, int index) {
        return Utils.decodeLongLE(page, index);
    }

    static void p_longPutLE(byte[] page, int index, long v) {
        Utils.encodeLongLE(page, index, v);
    }

    static long p_longGetBE(byte[] page, int index) {
        return Utils.decodeLongBE(page, index);
    }

    static void p_longPutBE(byte[] page, int index, long v) {
        Utils.encodeLongBE(page, index, v);
    }

    static long p_ulongGetVar(byte[] page, IntegerRef ref) {
        return Utils.decodeUnsignedVarLong(page, ref);
    }

    static int p_ulongPutVar(byte[] page, int index, long v) {
        return Utils.encodeUnsignedVarLong(page, index, v);
    }

    static int p_ulongVarSize(long v) {
        return Utils.calcUnsignedVarLongLength(v);
    }

    static void p_clear(byte[] page, int fromIndex, int toIndex) {
        Arrays.fill(page, fromIndex, toIndex, (byte)0);
    }

    static byte[] p_copyIfNotArray(byte[] page, byte[] array) {
        return page;
    }

    static void p_copyFromArray(byte[] src, int srcStart, byte[] dstPage, int dstStart, int len) {
        System.arraycopy(src, srcStart, dstPage, dstStart, len);
    }

    static void p_copyToArray(byte[] srcPage, int srcStart, byte[] dst, int dstStart, int len) {
        System.arraycopy(srcPage, srcStart, dst, dstStart, len);
    }

    static void p_copyFromBB(ByteBuffer src, byte[] dstPage, int dstStart, int len) {
        src.get(dstPage, dstStart, len);
    }

    static void p_copyToBB(byte[] srcPage, int srcStart, ByteBuffer dst, int len) {
        dst.put(srcPage, srcStart, len);
    }

    static void p_copy(byte[] srcPage, int srcStart, byte[] dstPage, int dstStart, int len) {
        System.arraycopy(srcPage, srcStart, dstPage, dstStart, len);
    }

    static void p_copies(byte[] page, int start1, int dest1, int length1, int start2, int dest2, int length2) {
        if (dest1 < start1) {
            PageOps.p_copy(page, start1, page, dest1, length1);
            PageOps.p_copy(page, start2, page, dest2, length2);
        } else {
            PageOps.p_copy(page, start2, page, dest2, length2);
            PageOps.p_copy(page, start1, page, dest1, length1);
        }
    }

    static void p_copies(byte[] page, int start1, int dest1, int length1, int start2, int dest2, int length2, int start3, int dest3, int length3) {
        if (dest1 < start1) {
            PageOps.p_copy(page, start1, page, dest1, length1);
            PageOps.p_copies(page, start2, dest2, length2, start3, dest3, length3);
        } else {
            PageOps.p_copies(page, start2, dest2, length2, start3, dest3, length3);
            PageOps.p_copy(page, start1, page, dest1, length1);
        }
    }

    static int p_compareKeysPageToArray(byte[] apage, int aoff, int alen, byte[] b, int boff, int blen) {
        return Utils.compareUnsigned(apage, aoff, alen, b, boff, blen);
    }

    static int p_compareKeysPageToPage(byte[] apage, int aoff, int alen, byte[] bpage, int boff, int blen) {
        return Utils.compareUnsigned(apage, aoff, alen, bpage, boff, blen);
    }

    static byte[] p_midKeyLowPage(byte[] lowPage, int lowOff, int lowLen, byte[] high, int highOff, int highLen) {
        return Utils.midKey(lowPage, lowOff, lowLen, high, highOff, highLen);
    }

    static byte[] p_midKeyHighPage(byte[] low, int lowOff, int lowLen, byte[] highPage, int highOff, int highLen) {
        return Utils.midKey(low, lowOff, lowLen, highPage, highOff, highLen);
    }

    static byte[] p_midKeyLowHighPage(byte[] lowPage, int lowOff, int lowLen, byte[] highPage, int highOff, int highLen) {
        return Utils.midKey(lowPage, lowOff, lowLen, highPage, highOff, highLen);
    }

    static int p_crc32(byte[] srcPage, int srcStart, int len) {
        CRC32 crc = new CRC32();
        crc.update(srcPage, srcStart, len);
        return (int)crc.getValue();
    }

    static {
        byte[] closed = new byte[12];
        closed[0] = -118;
        PageOps.p_shortPutLE(closed, 4, 12);
        PageOps.p_shortPutLE(closed, 6, 11);
        PageOps.p_shortPutLE(closed, 8, 12);
        PageOps.p_shortPutLE(closed, 10, 10);
        CLOSED_TREE_PAGE = closed;
    }
}

