/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.cojen.tupl.CacheExhaustedException;
import org.cojen.tupl.Checkpointer;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.CommitLock;
import org.cojen.tupl.CompactionObserver;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Crypto;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Database;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.DurablePageDb;
import org.cojen.tupl.EventListener;
import org.cojen.tupl.EventType;
import org.cojen.tupl.FragmentedTrash;
import org.cojen.tupl.Index;
import org.cojen.tupl.KeyComparator;
import org.cojen.tupl.LHashTable;
import org.cojen.tupl.LargeKeyException;
import org.cojen.tupl.LargeValueException;
import org.cojen.tupl.LocalTransaction;
import org.cojen.tupl.LockManager;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockedFile;
import org.cojen.tupl.Node;
import org.cojen.tupl.NodeDirtyList;
import org.cojen.tupl.NodeUsageList;
import org.cojen.tupl.NonPageDb;
import org.cojen.tupl.PageCache;
import org.cojen.tupl.PageDb;
import org.cojen.tupl.PageOps;
import org.cojen.tupl.PagePool;
import org.cojen.tupl.RedoLog;
import org.cojen.tupl.RedoLogApplier;
import org.cojen.tupl.RedoWriter;
import org.cojen.tupl.ReplRedoController;
import org.cojen.tupl.ReplRedoEngine;
import org.cojen.tupl.ReplRedoWriter;
import org.cojen.tupl.SafeEventListener;
import org.cojen.tupl.ShutdownHook;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.TempFileManager;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Tree;
import org.cojen.tupl.TreeCursor;
import org.cojen.tupl.TreeRef;
import org.cojen.tupl.TxnTree;
import org.cojen.tupl.UndoLog;
import org.cojen.tupl.Utils;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.View;
import org.cojen.tupl.ext.ReplicationManager;
import org.cojen.tupl.ext.TransactionHandler;
import org.cojen.tupl.io.FileFactory;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.util.Latch;

final class LocalDatabase
implements Database {
    private static final int DEFAULT_CACHED_NODES = 1000;
    private static final int MIN_CACHED_NODES = 5;
    private static final long PRIMER_MAGIC_NUMBER = 4943712973215968399L;
    private static final String INFO_FILE_SUFFIX = ".info";
    private static final String LOCK_FILE_SUFFIX = ".lock";
    static final String PRIMER_FILE_SUFFIX = ".primer";
    static final String REDO_FILE_SUFFIX = ".redo.";
    private static final int ENCODING_VERSION = 20130112;
    private static final int I_ENCODING_VERSION = 0;
    private static final int I_ROOT_PAGE_ID = 4;
    private static final int I_MASTER_UNDO_LOG_PAGE_ID = 12;
    private static final int I_TRANSACTION_ID = 20;
    private static final int I_CHECKPOINT_NUMBER = 28;
    private static final int I_REDO_TXN_ID = 36;
    private static final int I_REDO_POSITION = 44;
    private static final int I_REPL_ENCODING = 52;
    private static final int HEADER_SIZE = 60;
    private static final int DEFAULT_PAGE_SIZE = 4096;
    private static final int MINIMUM_PAGE_SIZE = 512;
    private static final int MAXIMUM_PAGE_SIZE = 65536;
    private static final int OPEN_REGULAR = 0;
    private static final int OPEN_DESTROY = 1;
    private static final int OPEN_TEMP = 2;
    final EventListener mEventListener;
    final TransactionHandler mCustomTxnHandler;
    private final File mBaseFile;
    private final LockedFile mLockFile;
    final DurabilityMode mDurabilityMode;
    final long mDefaultLockTimeoutNanos;
    final LockManager mLockManager;
    final RedoWriter mRedoWriter;
    final PageDb mPageDb;
    final int mPageSize;
    private final PagePool mSparePagePool;
    private final Object mArena;
    private final NodeUsageList[] mUsageLists;
    private final CommitLock mCommitLock;
    private byte mCommitState;
    private volatile byte mInitialReadState = 0;
    private byte[] mCommitHeader = PageOps.p_null();
    private UndoLog mCommitMasterUndoLog;
    private volatile int mCheckpointFlushState = -1;
    private static final int CHECKPOINT_FLUSH_PREPARE = -2;
    private static final int CHECKPOINT_NOT_FLUSHING = -1;
    private final Tree mRegistry;
    static final byte KEY_TYPE_INDEX_NAME = 0;
    static final byte KEY_TYPE_INDEX_ID = 1;
    static final byte KEY_TYPE_TREE_ID_MASK = 2;
    static final byte KEY_TYPE_NEXT_TREE_ID = 3;
    static final byte KEY_TYPE_TRASH_ID = 4;
    private final Tree mRegistryKeyMap;
    private final Latch mOpenTreesLatch;
    private final Map<byte[], TreeRef> mOpenTrees;
    private final LHashTable.Obj<TreeRef> mOpenTreesById;
    private final ReferenceQueue<Tree> mOpenTreesRefQueue;
    private final NodeDirtyList mDirtyList;
    private final Node[] mNodeMapTable;
    private final Latch[] mNodeMapLatches;
    final int mMaxFragmentedEntrySize;
    private volatile FragmentedTrash mFragmentedTrash;
    private final long[] mFragmentInodeLevelCaps;
    private final Object mTxnIdLock = new Object();
    private long mTxnId;
    private UndoLog mTopUndoLog;
    private int mUndoLogCount;
    private final ReentrantLock mCheckpointLock = new ReentrantLock(true);
    private long mLastCheckpointNanos;
    private volatile Checkpointer mCheckpointer;
    final TempFileManager mTempFileManager;
    volatile boolean mClosed;
    volatile Throwable mClosedCause;
    private static final AtomicReferenceFieldUpdater<LocalDatabase, Throwable> cClosedCauseUpdater = AtomicReferenceFieldUpdater.newUpdater(LocalDatabase.class, Throwable.class, "mClosedCause");

    private static int nodeCountFromBytes(long bytes, int pageSize) {
        if (bytes <= 0L) {
            return 0;
        }
        if ((bytes += (long)((pageSize += 100) - 1)) <= 0L) {
            return Integer.MAX_VALUE;
        }
        long count = bytes / (long)pageSize;
        return count <= Integer.MAX_VALUE ? (int)count : Integer.MAX_VALUE;
    }

    private static long byteCountFromNodes(int nodes, int pageSize) {
        return (long)nodes * (long)(pageSize + 100);
    }

    static LocalDatabase open(DatabaseConfig config) throws IOException {
        config = config.clone();
        LocalDatabase db = new LocalDatabase(config, 0);
        db.finishInit(config);
        return db;
    }

    static LocalDatabase destroy(DatabaseConfig config) throws IOException {
        config = config.clone();
        if (config.mReadOnly) {
            throw new IllegalArgumentException("Cannot destroy read-only database");
        }
        LocalDatabase db = new LocalDatabase(config, 1);
        db.finishInit(config);
        return db;
    }

    static Tree openTemp(TempFileManager tfm, DatabaseConfig config) throws IOException {
        File file = tfm.createTempFile();
        config.baseFile(file);
        config.dataFile(file);
        config.createFilePath(false);
        config.durabilityMode(DurabilityMode.NO_FLUSH);
        LocalDatabase db = new LocalDatabase(config, 2);
        tfm.register(file, db);
        db.mCheckpointer = new Checkpointer(db, config);
        db.mCheckpointer.start(false);
        return db.mRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private LocalDatabase(DatabaseConfig config, int openMode) throws IOException {
        int minCache;
        int maxCache;
        config.mEventListener = this.mEventListener = SafeEventListener.makeSafe(config.mEventListener);
        this.mCustomTxnHandler = config.mTxnHandler;
        this.mBaseFile = config.mBaseFile;
        File[] dataFiles = config.dataFiles();
        int pageSize = config.mPageSize;
        boolean explicitPageSize = true;
        if (pageSize <= 0) {
            pageSize = 4096;
            config.pageSize(4096);
            explicitPageSize = false;
        } else {
            if (pageSize < 512) {
                throw new IllegalArgumentException("Page size is too small: " + pageSize + " < " + 512);
            }
            if (pageSize > 65536) {
                throw new IllegalArgumentException("Page size is too large: " + pageSize + " > " + 65536);
            }
            if ((pageSize & 1) != 0) {
                throw new IllegalArgumentException("Page size must be even: " + pageSize);
            }
        }
        long minCachedBytes = Math.max(0L, config.mMinCachedBytes);
        long maxCachedBytes = Math.max(0L, config.mMaxCachedBytes);
        if (maxCachedBytes == 0L && (maxCachedBytes = minCachedBytes) == 0L) {
            maxCache = 1000;
            minCache = 1000;
        } else {
            if (minCachedBytes > maxCachedBytes) {
                throw new IllegalArgumentException("Minimum cache size exceeds maximum: " + minCachedBytes + " > " + maxCachedBytes);
            }
            minCache = LocalDatabase.nodeCountFromBytes(minCachedBytes, pageSize);
            maxCache = LocalDatabase.nodeCountFromBytes(maxCachedBytes, pageSize);
            minCache = Math.max(5, minCache);
            maxCache = Math.max(5, maxCache);
        }
        config.mMinCachedBytes = LocalDatabase.byteCountFromNodes(minCache, pageSize);
        config.mMaxCachedBytes = LocalDatabase.byteCountFromNodes(maxCache, pageSize);
        this.mDurabilityMode = config.mDurabilityMode;
        this.mDefaultLockTimeoutNanos = config.mLockTimeoutNanos;
        this.mLockManager = new LockManager(config.mLockUpgradeRule, this.mDefaultLockTimeoutNanos);
        int latches = Utils.roundUpPower2(Runtime.getRuntime().availableProcessors() * 16);
        int capacity = Utils.roundUpPower2(maxCache);
        if (capacity < 0) {
            capacity = 0x40000000;
        }
        this.mNodeMapTable = new Node[capacity];
        this.mNodeMapLatches = new Latch[latches];
        for (int i = 0; i < latches; ++i) {
            this.mNodeMapLatches[i] = new Latch();
        }
        if (this.mBaseFile != null && !config.mReadOnly && config.mMkdirs) {
            FileFactory factory = config.mFileFactory;
            File baseDir = this.mBaseFile.getParentFile();
            boolean baseDirectoriesCreated = factory == null ? baseDir.mkdirs() : factory.createDirectories(baseDir);
            if (!baseDirectoriesCreated && !baseDir.exists()) {
                throw new FileNotFoundException("Could not create directory: " + baseDir);
            }
            if (dataFiles != null) {
                for (File f : dataFiles) {
                    File dataDir = f.getParentFile();
                    boolean bl = factory == null ? dataDir.mkdirs() : factory.createDirectories(dataDir);
                    if (bl || dataDir.exists()) continue;
                    throw new FileNotFoundException("Could not create directory: " + dataDir);
                }
            }
        }
        try {
            Tree tree;
            NodeUsageList[] usageLists;
            if (this.mBaseFile == null || openMode == 2) {
                this.mLockFile = null;
            } else {
                File lockFile = new File(this.mBaseFile.getPath() + LOCK_FILE_SUFFIX);
                FileFactory factory = config.mFileFactory;
                if (factory != null && !config.mReadOnly) {
                    factory.createFile(lockFile);
                }
                this.mLockFile = new LockedFile(lockFile, config.mReadOnly);
            }
            if (openMode == 1) {
                this.deleteRedoLogFiles();
            }
            long cacheInitStart = System.nanoTime();
            PageCache cache = config.pageCache(this.mEventListener);
            if (cache != null) {
                config.mSecondaryCacheSize = cache.capacity();
            }
            if (dataFiles == null) {
                PageArray dataPageArray = config.mDataPageArray;
                if (dataPageArray == null) {
                    this.mPageDb = new NonPageDb(pageSize, cache);
                } else {
                    dataPageArray = dataPageArray.open();
                    Crypto crypto = config.mCrypto;
                    this.mPageDb = DurablePageDb.open(dataPageArray, cache, crypto, openMode == 1);
                }
            } else {
                EnumSet<OpenOption> options = config.createOpenOptions();
                this.mPageDb = DurablePageDb.open(explicitPageSize, pageSize, dataFiles, config.mFileFactory, options, cache, config.mCrypto, openMode == 1);
            }
            pageSize = this.mPageSize = this.mPageDb.pageSize();
            config.pageSize(this.mPageSize);
            config.mDirectPageAccess = false;
            if (this.mBaseFile != null && openMode != 2 && !config.mReadOnly) {
                File infoFile = new File(this.mBaseFile.getPath() + INFO_FILE_SUFFIX);
                FileFactory factory = config.mFileFactory;
                if (factory != null) {
                    factory.createFile(infoFile);
                }
                try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(infoFile), "UTF-8"));){
                    config.writeInfo(w);
                }
            }
            this.mCommitLock = this.mPageDb.commitLock();
            if (this.mEventListener != null) {
                this.mEventListener.notify(EventType.CACHE_INIT_BEGIN, "Initializing %1$d cached nodes", minCache);
            }
            try {
                void var15_40;
                int stripeSize;
                try {
                    this.mArena = PageOps.p_arenaAlloc(pageSize, minCache);
                }
                catch (IOException e) {
                    OutOfMemoryError oom = new OutOfMemoryError();
                    oom.initCause(e);
                    throw oom;
                }
                int stripes = Utils.roundUpPower2(Runtime.getRuntime().availableProcessors() * 4);
                while (true) {
                    stripeSize = maxCache / stripes;
                    if (stripes <= 1 || stripeSize >= 100) break;
                    stripes >>= 1;
                }
                int rem = maxCache % stripes;
                usageLists = new NodeUsageList[stripes];
                boolean bl = false;
                while (var15_40 < stripes) {
                    int size = stripeSize;
                    if (rem > 0) {
                        ++size;
                        --rem;
                    }
                    usageLists[var15_40] = new NodeUsageList(this, size);
                    ++var15_40;
                }
                stripeSize = minCache / stripes;
                rem = minCache % stripes;
                for (NodeUsageList usageList : usageLists) {
                    int size = stripeSize;
                    if (rem > 0) {
                        ++size;
                        --rem;
                    }
                    usageList.initialize(this.mArena, size);
                }
            }
            catch (OutOfMemoryError e) {
                usageLists = null;
                OutOfMemoryError oom = new OutOfMemoryError("Unable to allocate the minimum required number of cached nodes: " + minCache + " (" + (long)minCache * (long)(pageSize + 100) + " bytes)");
                oom.initCause(e.getCause());
                throw oom;
            }
            this.mUsageLists = usageLists;
            if (this.mEventListener != null) {
                double duration = (double)(System.nanoTime() - cacheInitStart) / 1.0E9;
                this.mEventListener.notify(EventType.CACHE_INIT_COMPLETE, "Cache initialization completed in %1$1.3f seconds", new Object[]{duration, TimeUnit.SECONDS});
            }
            int sparePageCount = Runtime.getRuntime().availableProcessors();
            this.mSparePagePool = new PagePool(this.mPageSize, sparePageCount);
            this.mCommitLock.acquireExclusive();
            try {
                this.mCommitState = (byte)2;
            }
            finally {
                this.mCommitLock.releaseExclusive();
            }
            byte[] header = new byte[60];
            this.mPageDb.readExtraCommitData(header);
            Node rootNode = this.loadRegistryRoot(header, config.mReplManager);
            this.mRegistry = config.mReplManager != null ? new TxnTree(this, 0L, null, null, rootNode) : new Tree(this, 0L, null, null, rootNode);
            this.mOpenTreesLatch = new Latch();
            if (openMode == 2) {
                this.mOpenTrees = Collections.emptyMap();
                this.mOpenTreesById = new LHashTable.Obj(0);
                this.mOpenTreesRefQueue = null;
            } else {
                this.mOpenTrees = new TreeMap<byte[], TreeRef>(KeyComparator.THE);
                this.mOpenTreesById = new LHashTable.Obj(16);
                this.mOpenTreesRefQueue = new ReferenceQueue();
            }
            Object object = this.mTxnIdLock;
            synchronized (object) {
                this.mTxnId = Utils.decodeLongLE(header, 20);
            }
            long l = Utils.decodeLongLE(header, 28);
            long redoPos = Utils.decodeLongLE(header, 44);
            long redoTxnId = Utils.decodeLongLE(header, 36);
            this.mRegistryKeyMap = openMode == 2 ? null : this.openInternalTree(1L, true, config);
            this.mDirtyList = new NodeDirtyList();
            if (openMode != 2 && (tree = this.openInternalTree(3L, false, config)) != null) {
                this.mFragmentedTrash = new FragmentedTrash(tree);
            }
            this.mMaxFragmentedEntrySize = pageSize - 12 - 10 >> 1;
            this.mFragmentInodeLevelCaps = LocalDatabase.calculateInodeLevelCaps(this.mPageSize);
            long recoveryStart = 0L;
            if (this.mBaseFile == null || openMode == 2) {
                this.mRedoWriter = null;
            } else {
                ReplicationManager rm;
                if (this.mEventListener != null) {
                    this.mEventListener.notify(EventType.RECOVERY_BEGIN, "Database recovery begin", new Object[0]);
                    recoveryStart = System.nanoTime();
                }
                LHashTable.Obj<LocalTransaction> txns = new LHashTable.Obj<LocalTransaction>(16);
                long masterNodeId = Utils.decodeLongLE(header, 12);
                if (masterNodeId != 0L) {
                    if (this.mEventListener != null) {
                        this.mEventListener.notify(EventType.RECOVERY_LOAD_UNDO_LOGS, "Loading undo logs", new Object[0]);
                    }
                    UndoLog.recoverMasterUndoLog(this, masterNodeId).recoverTransactions(txns, LockMode.UPGRADABLE_READ, 0L);
                }
                if (this.mCustomTxnHandler != null) {
                    this.mCustomTxnHandler.setCheckpointLock(this, this.mCommitLock.readLock());
                }
                if ((rm = config.mReplManager) != null) {
                    rm.start(redoPos);
                    ReplRedoEngine engine = new ReplRedoEngine(rm, config.mMaxReplicaThreads, this, txns);
                    this.mRedoWriter = engine.initWriter(l);
                    config.mReplRecoveryStartNanos = recoveryStart;
                    config.mReplInitialTxnId = redoTxnId;
                } else {
                    this.applyCachePrimer(config);
                    long logId = l;
                    for (int i2 = 1; i2 <= 2; ++i2) {
                        RedoLog.deleteOldFile(config.mBaseFile, logId - (long)i2);
                    }
                    RedoLog replayLog = new RedoLog(config, logId, redoPos);
                    RedoLogApplier applier = new RedoLogApplier(this, txns);
                    Set<File> redoFiles = replayLog.replay(applier, this.mEventListener, EventType.RECOVERY_APPLY_REDO_LOG, "Applying redo log: %1$d");
                    boolean doCheckpoint = !redoFiles.isEmpty();
                    redoTxnId = applier.mHighestTxnId;
                    if (redoTxnId != 0L) {
                        Iterator<File> iterator = this.mTxnIdLock;
                        synchronized (iterator) {
                            if (this.mTxnId == 0L || redoTxnId - this.mTxnId > 0L) {
                                this.mTxnId = redoTxnId;
                            }
                        }
                    }
                    if (txns.size() > 0) {
                        if (this.mEventListener != null) {
                            this.mEventListener.notify(EventType.RECOVERY_PROCESS_REMAINING, "Processing remaining transactions", new Object[0]);
                        }
                        txns.traverse(entry -> {
                            ((LocalTransaction)entry.value).recoveryCleanup(true);
                            return false;
                        });
                        doCheckpoint = true;
                    }
                    this.mRedoWriter = new RedoLog(config, replayLog);
                    if (doCheckpoint) {
                        this.checkpoint(true, 0L, 0L);
                        for (File file : redoFiles) {
                            file.delete();
                        }
                    }
                    this.emptyAllFragmentedTrash(true);
                    this.recoveryComplete(recoveryStart);
                }
            }
            this.mTempFileManager = this.mBaseFile == null || openMode == 2 ? null : new TempFileManager(this.mBaseFile, config.mFileFactory);
        }
        catch (Throwable e) {
            Utils.closeQuietly(null, this);
            throw e;
        }
    }

    private void finishInit(DatabaseConfig config) throws IOException {
        Tree trashed;
        Checkpointer c;
        if (this.mRedoWriter == null && this.mTempFileManager == null) {
            return;
        }
        this.mCheckpointer = c = new Checkpointer(this, config);
        c.register(this.mRedoWriter);
        c.register(this.mTempFileManager);
        if (this.mRedoWriter instanceof ReplRedoWriter) {
            this.applyCachePrimer(config);
        }
        if (config.mCachePriming && this.mPageDb.isDurable()) {
            c.register(new ShutdownPrimer(this));
        }
        if ((trashed = this.openNextTrashedTree(null)) != null) {
            Thread deletion = new Thread((Runnable)new Deletion(trashed, true, this.mEventListener), "IndexDeletion");
            deletion.setDaemon(true);
            deletion.start();
        }
        boolean initialCheckpoint = false;
        if (this.mRedoWriter instanceof ReplRedoController) {
            ReplRedoController controller = (ReplRedoController)this.mRedoWriter;
            try {
                controller.recover(config.mReplInitialTxnId, config.mEventListener);
            }
            catch (Throwable e) {
                Utils.closeQuietly(null, this, e);
                throw e;
            }
            this.recoveryComplete(config.mReplRecoveryStartNanos);
            initialCheckpoint = true;
        }
        c.start(initialCheckpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCachePrimer(DatabaseConfig config) {
        block21: {
            if (this.mPageDb.isDurable()) {
                File primer = this.primerFile();
                try {
                    if (!config.mCachePriming || !primer.exists()) break block21;
                    if (this.mEventListener != null) {
                        this.mEventListener.notify(EventType.RECOVERY_CACHE_PRIMING, "Cache priming", new Object[0]);
                    }
                    try {
                        FileInputStream fin = new FileInputStream(primer);
                        try (BufferedInputStream bin = new BufferedInputStream(fin);){
                            this.applyCachePrimer(bin);
                        }
                        catch (IOException e) {
                            fin.close();
                            primer.delete();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    primer.delete();
                }
            }
        }
    }

    File primerFile() {
        return new File(this.mBaseFile.getPath() + PRIMER_FILE_SUFFIX);
    }

    private void recoveryComplete(long recoveryStart) {
        if (this.mRedoWriter != null && this.mEventListener != null) {
            double duration = (double)(System.nanoTime() - recoveryStart) / 1.0E9;
            this.mEventListener.notify(EventType.RECOVERY_COMPLETE, "Recovery completed in %1$1.3f seconds", new Object[]{duration, TimeUnit.SECONDS});
        }
    }

    private void deleteRedoLogFiles() throws IOException {
        if (this.mBaseFile != null) {
            Utils.deleteNumberedFiles(this.mBaseFile, REDO_FILE_SUFFIX);
        }
    }

    @Override
    public Index findIndex(byte[] name) throws IOException {
        return this.openIndex((byte[])name.clone(), false);
    }

    @Override
    public Index openIndex(byte[] name) throws IOException {
        return this.openIndex((byte[])name.clone(), true);
    }

    @Override
    public Index indexById(long id) throws IOException {
        return this.indexById(null, id);
    }

    Index indexById(Transaction txn, long id) throws IOException {
        Index index;
        if (Tree.isInternal(id)) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
        this.mCommitLock.acquireShared();
        try {
            index = this.lookupIndexById(id);
            if (index != null) {
                Tree tree = index;
                return tree;
            }
            byte[] idKey = new byte[9];
            idKey[0] = 1;
            Utils.encodeLongBE(idKey, 1, id);
            byte[] name = this.mRegistryKeyMap.load(txn, idKey);
            if (name == null) {
                this.checkClosed();
                Index index2 = null;
                return index2;
            }
            index = this.openIndex(txn, name, false);
        }
        catch (Throwable e) {
            DatabaseException.rethrowIfRecoverable(e);
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            this.mCommitLock.releaseShared();
        }
        if (index == null) {
            throw new DatabaseException("Unable to find index in registry");
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree lookupIndexById(long id) {
        this.mOpenTreesLatch.acquireShared();
        try {
            LHashTable.ObjEntry entry = (LHashTable.ObjEntry)this.mOpenTreesById.get(id);
            Tree tree = entry == null ? null : (Tree)((TreeRef)entry.value).get();
            return tree;
        }
        finally {
            this.mOpenTreesLatch.releaseShared();
        }
    }

    Index anyIndexById(long id) throws IOException {
        return this.anyIndexById(null, id);
    }

    Index anyIndexById(Transaction txn, long id) throws IOException {
        if (id == 1L) {
            return this.mRegistryKeyMap;
        }
        if (id == 3L) {
            return this.fragmentedTrash().mTrash;
        }
        return this.indexById(txn, id);
    }

    @Override
    public void renameIndex(Index index, byte[] newName) throws IOException {
        this.renameIndex(index, (byte[])newName.clone(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameIndex(Index index, byte[] newName, long redoTxnId) throws IOException {
        LocalTransaction txn;
        byte[] newNameKey;
        byte[] oldNameKey;
        byte[] trashIdKey;
        byte[] idKey;
        byte[] oldName;
        Tree tree = this.accessTree(index);
        Node root = tree.mRoot;
        root.acquireExclusive();
        try {
            if (root.mPage == PageOps.p_closedTreePage()) {
                throw new ClosedIndexException();
            }
            if (Tree.isInternal(tree.mId)) {
                throw new IllegalStateException("Cannot rename an internal index");
            }
            oldName = tree.mName;
            if (Arrays.equals(oldName, newName)) {
                return;
            }
            idKey = LocalDatabase.newKey((byte)1, tree.mIdBytes);
            trashIdKey = LocalDatabase.newKey((byte)4, tree.mIdBytes);
            oldNameKey = LocalDatabase.newKey((byte)0, oldName);
            newNameKey = LocalDatabase.newKey((byte)0, newName);
            txn = this.newNoRedoTransaction(redoTxnId);
            try {
                txn.lockExclusive(this.mRegistryKeyMap.mId, idKey);
                txn.lockExclusive(this.mRegistryKeyMap.mId, trashIdKey);
                if (Utils.compareUnsigned(oldNameKey, newNameKey) <= 0) {
                    txn.lockExclusive(this.mRegistryKeyMap.mId, oldNameKey);
                    txn.lockExclusive(this.mRegistryKeyMap.mId, newNameKey);
                } else {
                    txn.lockExclusive(this.mRegistryKeyMap.mId, newNameKey);
                    txn.lockExclusive(this.mRegistryKeyMap.mId, oldNameKey);
                }
            }
            catch (Throwable e) {
                txn.reset();
                throw e;
            }
        }
        finally {
            root.releaseExclusive();
        }
        try {
            RedoWriter redo;
            TreeCursor c = this.mRegistryKeyMap.newCursor(txn);
            try {
                c.autoload(false);
                c.find(trashIdKey);
                if (c.value() != null) {
                    throw new IllegalStateException("Index is deleted");
                }
                c.find(newNameKey);
                if (c.value() != null) {
                    throw new IllegalStateException("New name is used by another index");
                }
                c.store(tree.mIdBytes);
            }
            finally {
                c.reset();
            }
            if (redoTxnId == 0L && (redo = this.txnRedoWriter()) != null) {
                long commitPos;
                this.mCommitLock.acquireShared();
                try {
                    commitPos = redo.renameIndex(txn.txnId(), tree.mId, newName, this.mDurabilityMode.alwaysRedo());
                }
                finally {
                    this.mCommitLock.releaseShared();
                }
                if (commitPos != 0L) {
                    redo.txnCommitSync(txn, commitPos);
                }
            }
            this.mRegistryKeyMap.delete(txn, oldNameKey);
            this.mRegistryKeyMap.store(txn, idKey, newName);
            this.mOpenTreesLatch.acquireExclusive();
            try {
                txn.commit();
                tree.mName = newName;
                this.mOpenTrees.put(newName, this.mOpenTrees.remove(oldName));
            }
            finally {
                this.mOpenTreesLatch.releaseExclusive();
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Throwable e) {
            DatabaseException.rethrowIfRecoverable(e);
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            txn.reset();
        }
    }

    private Tree accessTree(Index index) {
        try {
            Tree tree = (Tree)index;
            if (tree.mDatabase == this) {
                return tree;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Index belongs to a different database");
    }

    @Override
    public Runnable deleteIndex(Index index) throws IOException {
        return this.accessTree(index).drop(false);
    }

    Runnable replicaDeleteTree(long treeId) throws IOException {
        byte[] treeIdBytes = new byte[8];
        Utils.encodeLongBE(treeIdBytes, 0, treeId);
        Tree trashed = this.openTrashedTree(treeIdBytes, false);
        return new Deletion(trashed, false, null);
    }

    Runnable deleteTree(Tree tree) throws IOException {
        Node root = this.moveToTrash(tree, true);
        if (root == null) {
            throw new ClosedIndexException();
        }
        Tree trashed = this.newTreeInstance(tree.mId, tree.mIdBytes, tree.mName, root);
        return new Deletion(trashed, false, null);
    }

    private Tree openNextTrashedTree(byte[] lastIdBytes) throws IOException {
        return this.openTrashedTree(lastIdBytes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree openTrashedTree(byte[] idBytes, boolean next) throws IOException {
        byte[] rootIdBytes;
        byte[] treeIdBytes;
        byte[] name;
        block22: {
            View view = this.mRegistryKeyMap.viewPrefix(new byte[]{4}, 1);
            if (idBytes == null) {
                Cursor c = view.newCursor(Transaction.BOGUS);
                try {
                    c.first();
                    while (c.key() != null) {
                        name = c.value();
                        if (name.length != 0) {
                            name[0] = (byte)(name[0] | 0x80);
                            c.store(name);
                        }
                        c.next();
                    }
                }
                finally {
                    c.reset();
                }
            }
            Cursor c = view.newCursor(Transaction.BOGUS);
            try {
                if (idBytes == null) {
                    c.first();
                } else if (next) {
                    c.findGt(idBytes);
                } else {
                    c.find(idBytes);
                }
                while (true) {
                    if ((treeIdBytes = c.key()) == null) {
                        Tree tree = null;
                        return tree;
                    }
                    rootIdBytes = this.mRegistry.load(Transaction.BOGUS, treeIdBytes);
                    if (rootIdBytes == null) {
                        c.store(null);
                    } else {
                        name = c.value();
                        if (name[0] < 0) {
                            break block22;
                        }
                    }
                    if (!next) break;
                    c.next();
                }
                Tree tree = null;
                return tree;
            }
            finally {
                c.reset();
            }
        }
        long rootId = Utils.decodeLongLE(rootIdBytes, 0);
        if ((name[0] & 0xFFFFFF7F) == 0) {
            name = null;
        } else {
            byte[] actual = new byte[name.length - 1];
            System.arraycopy(name, 1, actual, 0, actual.length);
            name = actual;
        }
        long treeId = Utils.decodeLongBE(treeIdBytes, 0);
        return this.newTreeInstance(treeId, treeIdBytes, name, this.loadTreeRoot(rootId));
    }

    @Override
    public View indexRegistryByName() throws IOException {
        return this.mRegistryKeyMap.viewPrefix(new byte[]{0}, 1).viewUnmodifiable();
    }

    @Override
    public View indexRegistryById() throws IOException {
        return this.mRegistryKeyMap.viewPrefix(new byte[]{1}, 1).viewUnmodifiable();
    }

    @Override
    public Transaction newTransaction() {
        return this.doNewTransaction(this.mDurabilityMode);
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.doNewTransaction(durabilityMode == null ? this.mDurabilityMode : durabilityMode);
    }

    private LocalTransaction doNewTransaction(DurabilityMode durabilityMode) {
        RedoWriter redo = this.txnRedoWriter();
        return new LocalTransaction(this, redo, durabilityMode, LockMode.UPGRADABLE_READ, this.mDefaultLockTimeoutNanos);
    }

    LocalTransaction newAlwaysRedoTransaction() {
        return this.doNewTransaction(this.mDurabilityMode.alwaysRedo());
    }

    LocalTransaction newNoRedoTransaction() {
        RedoWriter redo = this.txnRedoWriter();
        return new LocalTransaction(this, redo, DurabilityMode.NO_REDO, LockMode.UPGRADABLE_READ, -1L);
    }

    LocalTransaction newNoRedoTransaction(long redoTxnId) {
        return redoTxnId == 0L ? this.newNoRedoTransaction() : new LocalTransaction(this, redoTxnId, LockMode.UPGRADABLE_READ, -1L);
    }

    private RedoWriter txnRedoWriter() {
        RedoWriter redo = this.mRedoWriter;
        if (redo != null) {
            redo = redo.txnRedoWriter();
        }
        return redo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(UndoLog undo) {
        Object object = this.mTxnIdLock;
        synchronized (object) {
            UndoLog top = this.mTopUndoLog;
            if (top != null) {
                undo.mPrev = top;
                top.mNext = undo;
            }
            this.mTopUndoLog = undo;
            ++this.mUndoLogCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextTransactionId() {
        RedoWriter redo;
        long txnId;
        Object object = this.mTxnIdLock;
        synchronized (object) {
            ++this.mTxnId;
            txnId = this.mTxnId++;
        }
        if (txnId <= 0L) {
            object = this.mTxnIdLock;
            synchronized (object) {
                txnId = this.mTxnId;
                if (txnId <= 0L) {
                    txnId = 1L;
                    this.mTxnId = 1L;
                }
            }
        }
        if ((redo = this.mRedoWriter) != null) {
            txnId = redo.adjustTransactionId(txnId);
        }
        return txnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(UndoLog log) {
        Object object = this.mTxnIdLock;
        synchronized (object) {
            UndoLog prev = log.mPrev;
            UndoLog next = log.mNext;
            if (prev != null) {
                prev.mNext = next;
                log.mPrev = null;
            }
            if (next != null) {
                next.mPrev = prev;
                log.mNext = null;
            } else if (log == this.mTopUndoLog) {
                this.mTopUndoLog = prev;
            }
            --this.mUndoLogCount;
        }
    }

    @Override
    public long preallocate(long bytes) throws IOException {
        int pageSize;
        long pageCount;
        if (!this.mClosed && this.mPageDb.isDurable() && (pageCount = (bytes + (long)(pageSize = this.mPageSize) - 1L) / (long)pageSize) > 0L) {
            if ((pageCount = this.mPageDb.allocatePages(pageCount)) > 0L) {
                try {
                    this.checkpoint(true, 0L, 0L);
                }
                catch (Throwable e) {
                    DatabaseException.rethrowIfRecoverable(e);
                    Utils.closeQuietly(null, this, e);
                    throw e;
                }
            }
            return pageCount * (long)pageSize;
        }
        return 0L;
    }

    @Override
    public void capacityLimit(long bytes) {
        this.mPageDb.pageLimit(bytes < 0L ? -1L : bytes / (long)this.mPageSize);
    }

    @Override
    public long capacityLimit() {
        long pageLimit = this.mPageDb.pageLimit();
        return pageLimit < 0L ? -1L : pageLimit * (long)this.mPageSize;
    }

    @Override
    public void capacityLimitOverride(long bytes) {
        this.mPageDb.pageLimitOverride(bytes < 0L ? -1L : bytes / (long)this.mPageSize);
    }

    @Override
    public Snapshot beginSnapshot() throws IOException {
        if (!this.mPageDb.isDurable()) {
            throw new UnsupportedOperationException("Snapshot only allowed for durable databases");
        }
        this.checkClosed();
        DurablePageDb pageDb = (DurablePageDb)this.mPageDb;
        return pageDb.beginSnapshot(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database restoreFromSnapshot(DatabaseConfig config, InputStream in) throws IOException {
        PageDb restored;
        File[] dataFiles = (config = config.clone()).dataFiles();
        if (dataFiles == null) {
            PageArray dataPageArray = config.mDataPageArray;
            if (dataPageArray == null) {
                throw new UnsupportedOperationException("Restore only allowed for durable databases");
            }
            dataPageArray = dataPageArray.open();
            dataPageArray.setPageCount(0L);
            Utils.deleteNumberedFiles(config.mBaseFile, REDO_FILE_SUFFIX);
            restored = DurablePageDb.restoreFromSnapshot(dataPageArray, null, config.mCrypto, in);
        } else {
            if (!config.mReadOnly) {
                for (File f : dataFiles) {
                    f.delete();
                    if (!config.mMkdirs) continue;
                    f.getParentFile().mkdirs();
                }
            }
            FileFactory factory = config.mFileFactory;
            EnumSet<OpenOption> options = config.createOpenOptions();
            Utils.deleteNumberedFiles(config.mBaseFile, REDO_FILE_SUFFIX);
            int pageSize = config.mPageSize;
            if (pageSize <= 0) {
                pageSize = 4096;
            }
            restored = DurablePageDb.restoreFromSnapshot(pageSize, dataFiles, factory, options, null, config.mCrypto, in);
        }
        try {
            restored.close();
        }
        finally {
            restored.delete();
        }
        return Database.open(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCachePrimer(OutputStream out) throws IOException {
        TreeRef[] openTrees;
        if (!this.mPageDb.isDurable()) {
            throw new UnsupportedOperationException("Cache priming only allowed for durable databases");
        }
        out = ((DurablePageDb)this.mPageDb).encrypt(out);
        this.mOpenTreesLatch.acquireShared();
        try {
            openTrees = new TreeRef[this.mOpenTrees.size()];
            int i = 0;
            for (TreeRef treeRef : this.mOpenTrees.values()) {
                openTrees[i++] = treeRef;
            }
        }
        finally {
            this.mOpenTreesLatch.releaseShared();
        }
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeLong(4943712973215968399L);
        for (TreeRef treeRef : openTrees) {
            Tree tree = (Tree)treeRef.get();
            if (tree == null || Tree.isInternal(tree.mId)) continue;
            byte[] name = tree.mName;
            dout.writeInt(name.length);
            dout.write(name);
            tree.writeCachePrimer(dout);
        }
        dout.writeInt(-1);
    }

    @Override
    public void applyCachePrimer(InputStream in) throws IOException {
        int len;
        if (!this.mPageDb.isDurable()) {
            throw new UnsupportedOperationException("Cache priming only allowed for durable databases");
        }
        DataInput din = (in = ((DurablePageDb)this.mPageDb).decrypt(in)) instanceof DataInput ? (DataInput)((Object)in) : new DataInputStream(in);
        long magic = din.readLong();
        if (magic != 4943712973215968399L) {
            throw new DatabaseException("Wrong cache primer magic number: " + magic);
        }
        while ((len = din.readInt()) >= 0) {
            byte[] name = new byte[len];
            din.readFully(name);
            Index ix = this.openIndex(name, false);
            if (ix instanceof Tree) {
                ((Tree)ix).applyCachePrimer(din);
                continue;
            }
            Tree.skipCachePrimer(din);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database.Stats stats() {
        Database.Stats stats = new Database.Stats();
        stats.pageSize = this.mPageSize;
        this.mCommitLock.acquireShared();
        try {
            long cursorCount = 0L;
            this.mOpenTreesLatch.acquireShared();
            try {
                stats.openIndexes = this.mOpenTrees.size();
                for (TreeRef treeRef : this.mOpenTrees.values()) {
                    Tree tree = (Tree)treeRef.get();
                    if (tree == null) continue;
                    cursorCount += tree.mRoot.countCursors();
                }
            }
            finally {
                this.mOpenTreesLatch.releaseShared();
            }
            stats.cursorCount = cursorCount;
            PageDb.Stats pstats = this.mPageDb.stats();
            stats.freePages = pstats.freePages;
            stats.totalPages = pstats.totalPages;
            stats.lockCount = this.mLockManager.numLocksHeld();
            Object object = this.mTxnIdLock;
            synchronized (object) {
                stats.txnCount = this.mUndoLogCount;
                stats.txnsCreated = this.mTxnId;
            }
        }
        finally {
            this.mCommitLock.releaseShared();
        }
        for (NodeUsageList nodeUsageList : this.mUsageLists) {
            stats.cachedPages += (long)nodeUsageList.size();
        }
        if (!this.mPageDb.isDurable() && stats.totalPages == 0L) {
            stats.totalPages = stats.cachedPages;
        }
        return stats;
    }

    @Override
    public void flush() throws IOException {
        if (!this.mClosed && this.mRedoWriter != null) {
            this.mRedoWriter.flush();
        }
    }

    @Override
    public void sync() throws IOException {
        if (!this.mClosed && this.mRedoWriter != null) {
            this.mRedoWriter.flushSync(false);
        }
    }

    @Override
    public void checkpoint() throws IOException {
        if (!this.mClosed && this.mPageDb.isDurable()) {
            try {
                this.checkpoint(false, 0L, 0L);
            }
            catch (Throwable e) {
                DatabaseException.rethrowIfRecoverable(e);
                Utils.closeQuietly(null, this, e);
                throw e;
            }
        }
    }

    @Override
    public void suspendCheckpoints() {
        Checkpointer c = this.mCheckpointer;
        if (c != null) {
            c.suspend();
        }
    }

    @Override
    public void resumeCheckpoints() {
        Checkpointer c = this.mCheckpointer;
        if (c != null) {
            c.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compactFile(CompactionObserver observer, double target) throws IOException {
        long targetPageCount;
        if (target < 0.0 || target > 1.0) {
            throw new IllegalArgumentException("Illegal compaction target: " + target);
        }
        if (target == 0.0) {
            return true;
        }
        this.mCheckpointLock.lock();
        try {
            PageDb.Stats stats = this.mPageDb.stats();
            long usedPages = stats.totalPages - stats.freePages;
            targetPageCount = Math.max(usedPages, (long)((double)usedPages / target));
            long freed = stats.totalPages - targetPageCount;
            long reserve = (freed *= (long)Utils.calcUnsignedVarLongLength(stats.totalPages << 1)) / (long)(this.mPageSize - 16);
            if ((targetPageCount += (reserve += 6L)) >= stats.totalPages && targetPageCount >= this.mPageDb.pageCount()) {
                boolean bl = true;
                return bl;
            }
            if (!this.mPageDb.compactionStart(targetPageCount)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mCheckpointLock.unlock();
        }
        if (!this.mPageDb.compactionScanFreeList()) {
            this.mCheckpointLock.lock();
            try {
                this.mPageDb.compactionEnd();
            }
            finally {
                this.mCheckpointLock.unlock();
            }
            return false;
        }
        this.checkpoint();
        if (observer == null) {
            observer = new CompactionObserver();
        }
        long highestNodeId = targetPageCount - 1L;
        CompactionObserver fobserver = observer;
        boolean completed = this.scanAllIndexes(tree -> tree.compactTree(tree.observableView(), highestNodeId, fobserver));
        this.checkpoint(true, 0L, 0L);
        if (completed && this.mPageDb.compactionScanFreeList() && !this.mPageDb.compactionVerify() && this.mPageDb.compactionScanFreeList()) {
            this.checkpoint(true, 0L, 0L);
        }
        this.mCheckpointLock.lock();
        try {
            this.checkpoint(true, 0L, 0L);
            if (completed &= this.mPageDb.compactionEnd()) {
                boolean bl = this.mPageDb.truncatePages();
                return bl;
            }
        }
        finally {
            this.mCheckpointLock.unlock();
        }
        return false;
    }

    @Override
    public boolean verify(VerificationObserver observer) throws IOException {
        if (observer == null) {
            observer = new VerificationObserver();
        }
        boolean[] passedRef = new boolean[]{true};
        VerificationObserver fobserver = observer;
        this.scanAllIndexes(tree -> {
            Index view = tree.observableView();
            fobserver.failed = false;
            boolean keepGoing = tree.verifyTree(view, fobserver);
            passedRef[0] = passedRef[0] & !fobserver.failed;
            if (keepGoing) {
                keepGoing = fobserver.indexComplete(view, !fobserver.failed, null);
            }
            return keepGoing;
        });
        return passedRef[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanAllIndexes(ScanVisitor visitor) throws IOException {
        if (!visitor.apply(this.mRegistry)) {
            return false;
        }
        if (!visitor.apply(this.mRegistryKeyMap)) {
            return false;
        }
        FragmentedTrash trash = this.mFragmentedTrash;
        if (trash != null && !visitor.apply(trash.mTrash)) {
            return false;
        }
        Cursor all = this.indexRegistryByName().newCursor(null);
        try {
            all.first();
            while (all.key() != null) {
                long id = Utils.decodeLongBE(all.value(), 0);
                Tree index = this.lookupIndexById(id);
                if (index != null) {
                    if (!visitor.apply(index)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    index = (Tree)this.indexById(id);
                    boolean keepGoing = visitor.apply(index);
                    try {
                        index.close();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (!keepGoing) {
                        boolean bl = false;
                        return bl;
                    }
                }
                all.next();
            }
        }
        finally {
            all.reset();
        }
        return true;
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.close(cause, false);
    }

    @Override
    public void shutdown() throws IOException {
        this.close(null, this.mPageDb.isDurable());
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Throwable cause, boolean shutdown) throws IOException {
        if (this.mClosed) {
            return;
        }
        if (cause != null && cClosedCauseUpdater.compareAndSet(this, null, cause)) {
            Throwable rootCause = Utils.rootCause(cause);
            if (this.mEventListener == null) {
                Utils.uncaught(rootCause);
            } else {
                this.mEventListener.notify(EventType.PANIC_UNHANDLED_EXCEPTION, "Closing database due to unhandled exception: %1$s", rootCause);
            }
        }
        Thread ct = null;
        boolean lockedCheckpointer = false;
        try {
            Checkpointer c = this.mCheckpointer;
            if (shutdown) {
                this.mCheckpointLock.lock();
                lockedCheckpointer = true;
                if (!this.mClosed) {
                    this.checkpoint(true, 0L, 0L);
                    if (c != null) {
                        ct = c.close();
                    }
                }
            } else {
                if (c != null) {
                    ct = c.close();
                }
                if (this.mCheckpointLock.tryLock()) {
                    lockedCheckpointer = true;
                } else if (cause == null && !(this.mRedoWriter instanceof ReplRedoController)) {
                    this.mCheckpointLock.lock();
                    lockedCheckpointer = true;
                }
            }
            this.mClosed = true;
        }
        finally {
            if (ct != null) {
                ct.interrupt();
            }
            if (lockedCheckpointer) {
                this.mCheckpointLock.unlock();
                if (ct != null) {
                    try {
                        ct.join();
                    }
                    catch (InterruptedException c) {}
                }
            }
        }
        try {
            CommitLock lock;
            this.mCheckpointer = null;
            if (this.mOpenTrees != null) {
                ArrayList trees;
                this.mOpenTreesLatch.acquireExclusive();
                try {
                    trees = new ArrayList(this.mOpenTreesById.size());
                    this.mOpenTreesById.traverse(entry -> {
                        trees.add(entry.value);
                        return true;
                    });
                    this.mOpenTrees.clear();
                }
                finally {
                    this.mOpenTreesLatch.releaseExclusive();
                }
                for (TreeRef ref : trees) {
                    Tree tree = (Tree)ref.get();
                    if (tree == null) continue;
                    tree.close();
                }
            }
            if ((lock = this.mCommitLock) != null) {
                lock.acquireExclusive();
            }
            try {
                if (this.mUsageLists != null) {
                    for (NodeUsageList usageList : this.mUsageLists) {
                        if (usageList == null) continue;
                        usageList.delete();
                    }
                }
                if (this.mDirtyList != null) {
                    this.mDirtyList.delete(this);
                }
                Object object = this.mTxnIdLock;
                synchronized (object) {
                    UndoLog log = this.mTopUndoLog;
                    while (log != null) {
                        log.delete();
                        log = log.mPrev;
                    }
                    this.mTopUndoLog = null;
                }
                this.nodeMapDeleteAll();
                IOException ex = null;
                ex = Utils.closeQuietly(ex, this.mRedoWriter, cause);
                ex = Utils.closeQuietly(ex, this.mPageDb, cause);
                ex = Utils.closeQuietly(ex, this.mTempFileManager, cause);
                if (shutdown && this.mBaseFile != null) {
                    this.deleteRedoLogFiles();
                    new File(this.mBaseFile.getPath() + INFO_FILE_SUFFIX).delete();
                    ex = Utils.closeQuietly(ex, this.mLockFile, cause);
                    new File(this.mBaseFile.getPath() + LOCK_FILE_SUFFIX).delete();
                } else {
                    ex = Utils.closeQuietly(ex, this.mLockFile, cause);
                }
                if (this.mLockManager != null) {
                    this.mLockManager.close();
                }
                if (ex != null) {
                    throw ex;
                }
            }
            finally {
                if (lock != null) {
                    lock.releaseExclusive();
                }
            }
        }
        finally {
            if (this.mPageDb != null) {
                this.mPageDb.delete();
            }
            if (this.mSparePagePool != null) {
                this.mSparePagePool.delete();
            }
            PageOps.p_delete(this.mCommitHeader);
            PageOps.p_arenaDelete(this.mArena);
        }
    }

    void checkClosed() throws DatabaseException {
        if (this.mClosed) {
            String message = "Closed";
            Throwable cause = this.mClosedCause;
            if (cause != null) {
                message = message + "; " + Utils.rootCause(cause);
            }
            throw new DatabaseException(message, cause);
        }
    }

    void treeClosed(Tree tree) {
        this.mOpenTreesLatch.acquireExclusive();
        try {
            TreeRef ref = this.mOpenTreesById.getValue(tree.mId);
            if (ref != null && ref.get() == tree) {
                ref.clear();
                this.mOpenTrees.remove(tree.mName);
                this.mOpenTreesById.remove(tree.mId);
            }
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node moveToTrash(Tree tree, boolean rootLatched) throws IOException {
        byte[] idKey = LocalDatabase.newKey((byte)1, tree.mIdBytes);
        byte[] trashIdKey = LocalDatabase.newKey((byte)4, tree.mIdBytes);
        LocalTransaction txn = this.newAlwaysRedoTransaction();
        try {
            if (this.mRegistryKeyMap.load(txn, trashIdKey) != null) {
                Node node = null;
                return node;
            }
            byte[] treeName = this.mRegistryKeyMap.exchange(txn, idKey, null);
            if (treeName == null) {
                this.mRegistryKeyMap.store(txn, trashIdKey, new byte[1]);
            } else {
                byte[] nameKey = LocalDatabase.newKey((byte)0, treeName);
                this.mRegistryKeyMap.remove(txn, nameKey, tree.mIdBytes);
                nameKey[0] = 1;
                this.mRegistryKeyMap.store(txn, trashIdKey, nameKey);
            }
            RedoWriter redo = this.txnRedoWriter();
            if (redo != null) {
                long commitPos;
                this.mCommitLock.acquireShared();
                try {
                    commitPos = redo.deleteIndex(txn.txnId(), tree.mId, this.mDurabilityMode.alwaysRedo());
                }
                finally {
                    this.mCommitLock.releaseShared();
                }
                if (commitPos != 0L) {
                    redo.txnCommitSync(txn, commitPos);
                }
            }
            txn.commit();
        }
        catch (Throwable e) {
            DatabaseException.rethrowIfRecoverable(e);
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            txn.reset();
        }
        return tree.close(true, rootLatched);
    }

    void removeFromTrash(Tree tree, Node root) throws IOException {
        byte[] trashIdKey = LocalDatabase.newKey((byte)4, tree.mIdBytes);
        this.mCommitLock.acquireShared();
        try {
            if (root != null) {
                root.acquireExclusive();
                this.deleteNode(root);
            }
            this.mRegistryKeyMap.delete(Transaction.BOGUS, trashIdKey);
            this.mRegistry.delete(Transaction.BOGUS, tree.mIdBytes);
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(this, e);
        }
        finally {
            this.mCommitLock.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node loadTreeRoot(long rootId) throws IOException {
        Node rootNode;
        block12: {
            if (rootId != 0L && (rootNode = this.nodeMapGet(rootId)) != null) {
                rootNode.acquireShared();
                try {
                    if (rootId == rootNode.mId) {
                        rootNode.makeUnevictable();
                        Node node = rootNode;
                        return node;
                    }
                }
                finally {
                    rootNode.releaseShared();
                }
            }
            rootNode = this.allocLatchedNode(rootId, 1);
            try {
                if (rootId == 0L) {
                    rootNode.asEmptyRoot();
                    break block12;
                }
                try {
                    rootNode.read(this, rootId);
                }
                catch (IOException e) {
                    rootNode.makeEvictableNow();
                    throw e;
                }
                this.nodeMapPut(rootNode);
            }
            finally {
                rootNode.releaseExclusive();
            }
        }
        return rootNode;
    }

    private Node loadRegistryRoot(byte[] header, ReplicationManager rm) throws IOException {
        long rootId;
        int version = Utils.decodeIntLE(header, 0);
        if (version == 0) {
            rootId = 0L;
            this.mInitialReadState = (byte)2;
        } else {
            if (version != 20130112) {
                throw new CorruptDatabaseException("Unknown encoding version: " + version);
            }
            long replEncoding = Utils.decodeLongLE(header, 52);
            if (rm == null) {
                if (replEncoding != 0L) {
                    throw new DatabaseException("Database must be configured with a replication manager, identified by: " + replEncoding);
                }
            } else {
                if (replEncoding == 0L) {
                    throw new DatabaseException("Database was created initially without a replication manager");
                }
                long expectedReplEncoding = rm.encoding();
                if (replEncoding != expectedReplEncoding) {
                    throw new DatabaseException("Database was created initially with a different replication manager, identified by: " + replEncoding);
                }
            }
            rootId = Utils.decodeLongLE(header, 4);
        }
        return this.loadTreeRoot(rootId);
    }

    private Tree openInternalTree(long treeId, boolean create) throws IOException {
        return this.openInternalTree(treeId, create, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree openInternalTree(long treeId, boolean create, DatabaseConfig config) throws IOException {
        this.mCommitLock.acquireShared();
        try {
            long rootId;
            byte[] treeIdBytes = new byte[8];
            Utils.encodeLongBE(treeIdBytes, 0, treeId);
            byte[] rootIdBytes = this.mRegistry.load(Transaction.BOGUS, treeIdBytes);
            if (rootIdBytes != null) {
                rootId = Utils.decodeLongLE(rootIdBytes, 0);
            } else {
                if (!create) {
                    Tree tree = null;
                    return tree;
                }
                rootId = 0L;
            }
            Node root = this.loadTreeRoot(rootId);
            if (config != null && config.mReplManager != null) {
                TxnTree txnTree = new TxnTree(this, treeId, treeIdBytes, null, root);
                return txnTree;
            }
            Tree tree = this.newTreeInstance(treeId, treeIdBytes, null, root);
            return tree;
        }
        finally {
            this.mCommitLock.releaseShared();
        }
    }

    private Index openIndex(byte[] name, boolean create) throws IOException {
        return this.openIndex(null, name, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Index openIndex(Transaction lookupTxn, byte[] name, boolean create) throws IOException {
        this.checkClosed();
        Tree tree = this.quickFindIndex(name);
        if (tree != null) {
            return tree;
        }
        this.mCommitLock.acquireShared();
        try {
            Tree tree2;
            long treeId;
            byte[] idKey;
            this.cleanupUnreferencedTrees();
            byte[] nameKey = LocalDatabase.newKey((byte)0, name);
            byte[] treeIdBytes = this.mRegistryKeyMap.load(lookupTxn, nameKey);
            if (treeIdBytes != null) {
                idKey = null;
                treeId = Utils.decodeLongBE(treeIdBytes, 0);
            } else {
                Transaction createTxn;
                block44: {
                    if (!create) {
                        Index index = null;
                        return index;
                    }
                    if (lookupTxn != null) {
                        throw new AssertionError();
                    }
                    createTxn = null;
                    this.mOpenTreesLatch.acquireExclusive();
                    try {
                        treeIdBytes = this.mRegistryKeyMap.load(null, nameKey);
                        if (treeIdBytes != null) {
                            idKey = null;
                            treeId = Utils.decodeLongBE(treeIdBytes, 0);
                            break block44;
                        }
                        treeIdBytes = new byte[8];
                        boolean critical = true;
                        try {
                            do {
                                critical = false;
                                treeId = this.nextTreeId();
                                Utils.encodeLongBE(treeIdBytes, 0, treeId);
                                critical = true;
                            } while (!this.mRegistry.insert(Transaction.BOGUS, treeIdBytes, Utils.EMPTY_BYTES));
                            critical = false;
                            try {
                                idKey = LocalDatabase.newKey((byte)1, treeIdBytes);
                                createTxn = this.mRedoWriter instanceof ReplRedoController ? this.newTransaction(DurabilityMode.SYNC) : this.newAlwaysRedoTransaction();
                                if (!this.mRegistryKeyMap.insert(createTxn, idKey, name)) {
                                    throw new DatabaseException("Unable to insert index id");
                                }
                                if (!this.mRegistryKeyMap.insert(createTxn, nameKey, treeIdBytes)) {
                                    throw new DatabaseException("Unable to insert index name");
                                }
                            }
                            catch (Throwable e) {
                                critical = true;
                                try {
                                    if (createTxn != null) {
                                        createTxn.reset();
                                    }
                                    this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                                    critical = false;
                                }
                                catch (Throwable e2) {
                                    e.addSuppressed(e2);
                                }
                                throw e;
                            }
                        }
                        catch (Throwable e) {
                            if (!critical) {
                                DatabaseException.rethrowIfRecoverable(e);
                            }
                            throw Utils.closeOnFailure(this, e);
                        }
                    }
                    finally {
                        this.mOpenTreesLatch.releaseExclusive();
                    }
                }
                if (createTxn != null) {
                    try {
                        createTxn.commit();
                    }
                    catch (Throwable e) {
                        try {
                            createTxn.reset();
                            this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                        }
                        catch (Throwable e2) {
                            e.addSuppressed(e2);
                            throw Utils.closeOnFailure(this, e);
                        }
                        DatabaseException.rethrowIfRecoverable(e);
                        throw Utils.closeOnFailure(this, e);
                    }
                }
            }
            LocalTransaction txn = this.newNoRedoTransaction();
            try {
                byte[] rootIdBytes = this.mRegistry.load(txn, treeIdBytes);
                tree = this.quickFindIndex(name);
                if (tree != null) {
                    Tree e2 = tree;
                    return e2;
                }
                long rootId = rootIdBytes == null || rootIdBytes.length == 0 ? 0L : Utils.decodeLongLE(rootIdBytes, 0);
                tree = this.newTreeInstance(treeId, treeIdBytes, name, this.loadTreeRoot(rootId));
                TreeRef treeRef = new TreeRef(tree, this.mOpenTreesRefQueue);
                this.mOpenTreesLatch.acquireExclusive();
                try {
                    this.mOpenTrees.put(name, treeRef);
                    ((LHashTable.ObjEntry)this.mOpenTreesById.insert((long)treeId)).value = treeRef;
                }
                finally {
                    this.mOpenTreesLatch.releaseExclusive();
                }
                tree2 = tree;
            }
            catch (Throwable e) {
                if (idKey != null) {
                    try {
                        this.mRegistryKeyMap.delete(null, idKey);
                        this.mRegistryKeyMap.delete(null, nameKey);
                        this.mRegistry.delete(Transaction.BOGUS, treeIdBytes);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                throw e;
            }
            finally {
                txn.reset();
            }
            return tree2;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.mCommitLock.releaseShared();
        }
    }

    private Tree newTreeInstance(long id, byte[] idBytes, byte[] name, Node root) {
        if (this.mRedoWriter instanceof ReplRedoWriter) {
            return new TxnTree(this, id, idBytes, name, root);
        }
        return new Tree(this, id, idBytes, name, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextTreeId() throws IOException {
        LocalTransaction txn = this.newAlwaysRedoTransaction();
        try {
            long treeId;
            byte[] key = new byte[]{2};
            byte[] treeIdMaskBytes = this.mRegistryKeyMap.load(txn, key);
            if (treeIdMaskBytes == null) {
                treeIdMaskBytes = new byte[8];
                new Random().nextBytes(treeIdMaskBytes);
                this.mRegistryKeyMap.store(txn, key, treeIdMaskBytes);
            }
            long treeIdMask = Utils.decodeLongLE(treeIdMaskBytes, 0);
            key = new byte[]{3};
            byte[] nextTreeIdBytes = this.mRegistryKeyMap.load(txn, key);
            if (nextTreeIdBytes == null) {
                nextTreeIdBytes = new byte[8];
            }
            long nextTreeId = Utils.decodeLongLE(nextTreeIdBytes, 0);
            while (Tree.isInternal(treeId = Utils.scramble(nextTreeId++ ^ treeIdMask))) {
            }
            Utils.encodeLongLE(nextTreeIdBytes, 0, nextTreeId);
            this.mRegistryKeyMap.store(txn, key, nextTreeIdBytes);
            txn.commit();
            long l = treeId;
            return l;
        }
        finally {
            txn.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tree quickFindIndex(byte[] name) throws IOException {
        TreeRef treeRef;
        this.mOpenTreesLatch.acquireShared();
        try {
            treeRef = this.mOpenTrees.get(name);
            if (treeRef == null) {
                Tree tree = null;
                return tree;
            }
            Tree tree = (Tree)treeRef.get();
            if (tree != null) {
                Tree tree2 = tree;
                return tree2;
            }
        }
        finally {
            this.mOpenTreesLatch.releaseShared();
        }
        this.cleanupUnreferencedTree(treeRef);
        return null;
    }

    private void cleanupUnreferencedTrees() throws IOException {
        block4: {
            ReferenceQueue<Tree> queue = this.mOpenTreesRefQueue;
            if (queue == null) {
                return;
            }
            try {
                Reference<Tree> ref;
                while ((ref = queue.poll()) != null) {
                    if (!(ref instanceof TreeRef)) continue;
                    this.cleanupUnreferencedTree((TreeRef)ref);
                }
            }
            catch (Exception e) {
                if (this.mClosed) break block4;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUnreferencedTree(TreeRef ref) throws IOException {
        Node root = ref.mRoot;
        root.acquireShared();
        try {
            this.mOpenTreesLatch.acquireExclusive();
            try {
                LHashTable.ObjEntry entry = (LHashTable.ObjEntry)this.mOpenTreesById.get(ref.mId);
                if (entry == null || entry.value != ref) {
                    return;
                }
                this.mOpenTrees.remove(ref.mName);
                this.mOpenTreesById.remove(ref.mId);
                root.makeEvictableNow();
                if (root.mId != 0L) {
                    this.nodeMapPut(root);
                }
            }
            finally {
                this.mOpenTreesLatch.releaseExclusive();
            }
        }
        finally {
            root.releaseShared();
        }
    }

    private static byte[] newKey(byte type, byte[] payload) {
        byte[] key = new byte[1 + payload.length];
        key[0] = type;
        System.arraycopy(payload, 0, key, 1, payload.length);
        return key;
    }

    int pageSize() {
        return this.mPageSize;
    }

    private int pageSize(byte[] page) {
        return page.length;
    }

    CommitLock commitLock() {
        return this.mCommitLock;
    }

    Node nodeMapGet(long nodeId) {
        return this.nodeMapGet(nodeId, Long.hashCode(nodeId));
    }

    Node nodeMapGet(long nodeId, int hash) {
        Node[] table = this.mNodeMapTable;
        Node node = table[hash & table.length - 1];
        if (node != null) {
            int limit = 100;
            do {
                if (node.mId != nodeId) continue;
                return node;
            } while ((node = node.mNodeMapNext) != null && --limit != 0);
        }
        Latch[] latches = this.mNodeMapLatches;
        Latch latch = latches[hash & latches.length - 1];
        latch.acquireShared();
        node = table[hash & table.length - 1];
        while (node != null) {
            if (node.mId == nodeId) {
                latch.releaseShared();
                return node;
            }
            node = node.mNodeMapNext;
        }
        latch.releaseShared();
        return null;
    }

    void nodeMapPut(Node node) {
        this.nodeMapPut(node, Long.hashCode(node.mId));
    }

    void nodeMapPut(Node node, int hash) {
        Latch[] latches = this.mNodeMapLatches;
        Latch latch = latches[hash & latches.length - 1];
        latch.acquireExclusive();
        Node[] table = this.mNodeMapTable;
        int index = hash & table.length - 1;
        Node e = table[index];
        while (e != null) {
            if (e == node) {
                latch.releaseExclusive();
                return;
            }
            if (e.mId == node.mId) {
                latch.releaseExclusive();
                throw new AssertionError((Object)("Already in NodeMap: " + node + ", " + e + ", " + hash));
            }
            e = e.mNodeMapNext;
        }
        node.mNodeMapNext = table[index];
        table[index] = node;
        latch.releaseExclusive();
    }

    Node nodeMapPutIfAbsent(Node node) {
        int hash = Long.hashCode(node.mId);
        Latch[] latches = this.mNodeMapLatches;
        Latch latch = latches[hash & latches.length - 1];
        latch.acquireExclusive();
        Node[] table = this.mNodeMapTable;
        int index = hash & table.length - 1;
        Node e = table[index];
        while (e != null) {
            if (e.mId == node.mId) {
                latch.releaseExclusive();
                return e;
            }
            e = e.mNodeMapNext;
        }
        node.mNodeMapNext = table[index];
        table[index] = node;
        latch.releaseExclusive();
        return null;
    }

    void nodeMapReplace(Node oldNode, Node newNode) {
        int hash = Long.hashCode(oldNode.mId);
        Latch[] latches = this.mNodeMapLatches;
        Latch latch = latches[hash & latches.length - 1];
        latch.acquireExclusive();
        newNode.mNodeMapNext = oldNode.mNodeMapNext;
        Node[] table = this.mNodeMapTable;
        int index = hash & table.length - 1;
        Node e = table[index];
        if (e == oldNode) {
            table[index] = newNode;
        } else {
            while (e != null) {
                Node next = e.mNodeMapNext;
                if (next == oldNode) {
                    e.mNodeMapNext = newNode;
                    break;
                }
                e = next;
            }
        }
        oldNode.mNodeMapNext = null;
        latch.releaseExclusive();
    }

    void nodeMapRemove(Node node) {
        this.nodeMapRemove(node, Long.hashCode(node.mId));
    }

    void nodeMapRemove(Node node, int hash) {
        Latch[] latches = this.mNodeMapLatches;
        Latch latch = latches[hash & latches.length - 1];
        latch.acquireExclusive();
        Node[] table = this.mNodeMapTable;
        int index = hash & table.length - 1;
        Node e = table[index];
        if (e == node) {
            table[index] = e.mNodeMapNext;
        } else {
            while (e != null) {
                Node next = e.mNodeMapNext;
                if (next == node) {
                    e.mNodeMapNext = next.mNodeMapNext;
                    break;
                }
                e = next;
            }
        }
        node.mNodeMapNext = null;
        latch.releaseExclusive();
    }

    Node nodeMapLoadFragment(long nodeId) throws IOException {
        Node node = this.nodeMapGet(nodeId);
        if (node != null) {
            node.acquireShared();
            if (nodeId == node.mId) {
                node.used();
                return node;
            }
            node.releaseShared();
        }
        node = this.allocLatchedNode(nodeId);
        node.type((byte)32);
        this.readNode(node, nodeId);
        node.downgrade();
        this.nodeMapPut(node);
        return node;
    }

    Node nodeMapLoadFragmentExclusive(long nodeId, boolean read) throws IOException {
        Node node = this.nodeMapGet(nodeId);
        if (node != null) {
            node.acquireExclusive();
            if (nodeId == node.mId) {
                node.used();
                return node;
            }
            node.releaseExclusive();
        }
        node = this.allocLatchedNode(nodeId);
        node.type((byte)32);
        if (read) {
            this.readNode(node, nodeId);
        } else {
            node.mId = nodeId;
        }
        this.nodeMapPut(node);
        return node;
    }

    Node nodeMapGetAndRemove(long nodeId) {
        int hash = Long.hashCode(nodeId);
        Node node = this.nodeMapGet(nodeId, hash);
        if (node != null) {
            node.acquireExclusive();
            if (nodeId != node.mId) {
                node.releaseExclusive();
                node = null;
            } else {
                this.nodeMapRemove(node, hash);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void nodeMapDeleteAll() {
        while (true) {
            for (Latch latch : this.mNodeMapLatches) {
                latch.acquireExclusive();
            }
            try {
                i = this.mNodeMapTable.length;
                while (--i >= 0) {
                    e = this.mNodeMapTable[i];
                    if (e == null) continue;
                    if (!e.tryAcquireExclusive()) ** continue;
                    try {
                        e.doDelete(this);
                    }
                    finally {
                        e.releaseExclusive();
                    }
                    while ((next = e.mNodeMapNext) != null) {
                        e.mNodeMapNext = null;
                        e = next;
                    }
                    this.mNodeMapTable[i] = null;
                }
            }
            finally {
                for (Latch latch : this.mNodeMapLatches) {
                    latch.releaseExclusive();
                }
                continue;
            }
            break;
        }
    }

    Node allocLatchedNode(long anyNodeId) throws IOException {
        return this.allocLatchedNode(anyNodeId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node allocLatchedNode(long anyNodeId, int mode) throws IOException {
        mode |= this.mPageDb.allocMode();
        NodeUsageList[] usageLists = this.mUsageLists;
        int listIx = (int)anyNodeId & usageLists.length - 1;
        IOException fail = null;
        for (int trial = 1; trial <= 3; ++trial) {
            for (int i = 0; i < usageLists.length; ++i) {
                block10: {
                    try {
                        Node node = usageLists[listIx].tryAllocLatchedNode(trial, mode);
                        if (node != null) {
                            return node;
                        }
                    }
                    catch (IOException e) {
                        if (fail != null) break block10;
                        fail = e;
                    }
                }
                if (--listIx >= 0) continue;
                listIx = usageLists.length - 1;
            }
            this.checkClosed();
            this.mCommitLock.acquireShared();
            try {
                this.cleanupUnreferencedTrees();
                continue;
            }
            finally {
                this.mCommitLock.releaseShared();
            }
        }
        if (fail == null && this.mPageDb.isDurable()) {
            throw new CacheExhaustedException();
        }
        if (fail instanceof DatabaseFullException) {
            throw fail;
        }
        throw new DatabaseFullException(fail);
    }

    Node allocDirtyNode() throws IOException {
        return this.allocDirtyNode(0);
    }

    Node allocDirtyNode(int mode) throws IOException {
        Node node = this.mPageDb.allocLatchedNode(this, mode);
        this.mDirtyList.add(node, this.mCommitState);
        return node;
    }

    Node allocDirtyFragmentNode() throws IOException {
        Node node = this.allocDirtyNode();
        this.nodeMapPut(node);
        node.type((byte)32);
        return node;
    }

    boolean shouldMarkDirty(Node node) {
        return node.mCachedState != this.mCommitState && node.mId >= 0L;
    }

    boolean markDirty(Tree tree, Node node) throws IOException {
        if (node.mCachedState == this.mCommitState || node.mId < 0L) {
            return false;
        }
        this.doMarkDirty(tree, node);
        return true;
    }

    boolean markFragmentDirty(Node node) throws IOException {
        if (node.mCachedState == this.mCommitState) {
            return false;
        }
        if (node.mCachedState != 0) {
            node.write(this.mPageDb);
        }
        long newId = this.mPageDb.allocPage();
        long oldId = node.mId;
        if (oldId != 0L) {
            try {
                this.mPageDb.deletePage(oldId);
            }
            catch (Throwable e) {
                try {
                    this.mPageDb.recyclePage(newId);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                    this.close(e);
                }
                throw e;
            }
            this.nodeMapRemove(node, Long.hashCode(oldId));
        }
        this.dirty(node, newId);
        this.nodeMapPut(node);
        return true;
    }

    void markUndoLogDirty(Node node) throws IOException {
        if (node.mCachedState != this.mCommitState) {
            node.write(this.mPageDb);
            long newId = this.mPageDb.allocPage();
            long oldId = node.mId;
            try {
                this.mPageDb.deletePage(oldId);
            }
            catch (Throwable e) {
                try {
                    this.mPageDb.recyclePage(newId);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                    this.close(e);
                }
                throw e;
            }
            this.dirty(node, newId);
        }
    }

    void doMarkDirty(Tree tree, Node node) throws IOException {
        if (node.mCachedState != 0) {
            node.write(this.mPageDb);
        }
        long newId = this.mPageDb.allocPage();
        long oldId = node.mId;
        try {
            if (node == tree.mRoot) {
                this.storeTreeRootId(tree, newId);
            }
        }
        catch (Throwable e) {
            try {
                this.mPageDb.recyclePage(newId);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
                this.close(e);
            }
            throw e;
        }
        try {
            if (oldId != 0L) {
                this.mPageDb.deletePage(oldId);
                this.nodeMapRemove(node, Long.hashCode(oldId));
            }
        }
        catch (Throwable e) {
            try {
                if (node == tree.mRoot) {
                    this.storeTreeRootId(tree, oldId);
                }
                this.mPageDb.recyclePage(newId);
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
                this.close(e);
            }
            throw e;
        }
        this.dirty(node, newId);
        this.nodeMapPut(node);
    }

    private void storeTreeRootId(Tree tree, long id) throws IOException {
        if (tree.mIdBytes != null) {
            byte[] encodedId = new byte[8];
            Utils.encodeLongLE(encodedId, 0, id);
            this.mRegistry.store(Transaction.BOGUS, tree.mIdBytes, encodedId);
        }
    }

    private void dirty(Node node, long newId) throws IOException {
        node.mId = newId;
        this.mDirtyList.add(node, this.mCommitState);
    }

    void swapIfDirty(Node oldNode, Node newNode) {
        this.mDirtyList.swapIfDirty(oldNode, newNode);
    }

    void redirty(Node node) {
        this.mDirtyList.add(node, this.mCommitState);
    }

    void prepareToDelete(Node node) throws IOException {
        if (node.mCachedState == this.mCheckpointFlushState) {
            try {
                node.write(this.mPageDb);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                throw e;
            }
        }
    }

    void deleteNode(Node node) throws IOException {
        this.deleteNode(node, true);
    }

    void deleteNode(Node node, boolean canRecycle) throws IOException {
        try {
            long id = node.mId;
            this.nodeMapRemove(node, Long.hashCode(id));
            try {
                if (canRecycle) {
                    this.deletePage(id, node.mCachedState);
                } else if (id != 0L) {
                    this.mPageDb.deletePage(id);
                }
            }
            catch (Throwable e) {
                try {
                    this.nodeMapPut(node);
                }
                catch (Throwable e2) {
                    e.addSuppressed(e2);
                }
                throw e;
            }
            node.mId = -id;
            node.mCachedState = 0;
        }
        catch (Throwable e) {
            node.releaseExclusive();
            throw e;
        }
        node.unused();
    }

    void deletePage(long id, int cachedState) throws IOException {
        if (id != 0L) {
            if (cachedState == this.mCommitState) {
                this.mPageDb.recyclePage(id);
            } else {
                this.mPageDb.deletePage(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] fragment(byte[] value, long vlength, int max) throws IOException {
        byte[] newValue;
        block40: {
            int header;
            block32: {
                int offset;
                int remainder;
                long pageCount;
                int pageSize;
                block39: {
                    int offset2;
                    byte header2;
                    block36: {
                        int poffset;
                        block37: {
                            block38: {
                                long pointerSpace;
                                block35: {
                                    pageSize = this.mPageSize;
                                    pageCount = vlength / (long)pageSize;
                                    remainder = (int)(vlength % (long)pageSize);
                                    if (vlength >= 65536L) {
                                        max -= 11;
                                    } else {
                                        if (pageCount == 0L && remainder <= max - 5) {
                                            byte[] newValue2 = new byte[5 + (int)vlength];
                                            newValue2[0] = 2;
                                            Utils.encodeShortLE(newValue2, 1, (int)vlength);
                                            Utils.encodeShortLE(newValue2, 3, (int)vlength);
                                            Utils.arrayCopyOrFill(value, 0, newValue2, 5, (int)vlength);
                                            return newValue2;
                                        }
                                        max -= 9;
                                    }
                                    if (max < 0) {
                                        return null;
                                    }
                                    pointerSpace = pageCount * 6L;
                                    if (remainder > max || remainder >= 65536 || pointerSpace > (long)(max + 4 - remainder)) break block35;
                                    int inline = remainder == 0 ? 0 : 2;
                                    header2 = (byte)inline;
                                    if (vlength < 65536L) {
                                        offset2 = 3;
                                    } else if (vlength < 0x100000000L) {
                                        header2 = (byte)(header2 | 4);
                                        offset2 = 5;
                                    } else if (vlength < 0x1000000000000L) {
                                        header2 = (byte)(header2 | 8);
                                        offset2 = 7;
                                    } else {
                                        header2 = (byte)(header2 | 0xC);
                                        offset2 = 9;
                                    }
                                    poffset = offset2 + inline + remainder;
                                    newValue = new byte[poffset + (int)pointerSpace];
                                    if (pageCount <= 0L) break block36;
                                    if (value != null) break block37;
                                    Arrays.fill(newValue, poffset, poffset + (int)pageCount * 6, (byte)0);
                                    break block36;
                                }
                                ++pageCount;
                                pointerSpace += 6L;
                                if (vlength < 65536L) {
                                    header = 0;
                                    offset = 3;
                                } else if (vlength < 0x100000000L) {
                                    header = 4;
                                    offset = 5;
                                } else if (vlength < 0x1000000000000L) {
                                    header = 8;
                                    offset = 7;
                                } else {
                                    header = 12;
                                    offset = 9;
                                }
                                if (pointerSpace > (long)(max + 6)) break block38;
                                newValue = new byte[offset + (int)pointerSpace];
                                if (pageCount <= 0L) break block32;
                                if (value != null) break block39;
                                Arrays.fill(newValue, offset, offset + (int)pageCount * 6, (byte)0);
                                break block32;
                            }
                            header = (byte)(header | 1);
                            newValue = new byte[offset + 6];
                            if (value == null) {
                                Utils.encodeInt48LE(newValue, offset, 0L);
                                break block32;
                            } else {
                                Node inode = this.allocDirtyFragmentNode();
                                Utils.encodeInt48LE(newValue, offset, inode.mId);
                                int levels = this.calculateInodeLevels(vlength);
                                this.writeMultilevelFragments(levels, inode, value, 0, vlength);
                            }
                            break block32;
                        }
                        int voffset = remainder;
                        while (true) {
                            Node node = this.allocDirtyFragmentNode();
                            try {
                                Utils.encodeInt48LE(newValue, poffset, node.mId);
                                PageOps.p_copyFromArray(value, voffset, node.mPage, 0, pageSize);
                                if (pageCount == 1L) {
                                    break;
                                }
                            }
                            finally {
                                node.releaseExclusive();
                            }
                            --pageCount;
                            poffset += 6;
                            voffset += pageSize;
                        }
                    }
                    newValue[0] = header2;
                    if (remainder != 0) {
                        Utils.encodeShortLE(newValue, offset2, remainder);
                        Utils.arrayCopyOrFill(value, 0, newValue, offset2 + 2, remainder);
                    }
                    break block40;
                }
                int voffset = 0;
                while (true) {
                    block34: {
                        Node node = this.allocDirtyFragmentNode();
                        try {
                            Utils.encodeInt48LE(newValue, offset, node.mId);
                            byte[] page = node.mPage;
                            if (pageCount > 1L) {
                                PageOps.p_copyFromArray(value, voffset, page, 0, pageSize);
                                break block34;
                            }
                            PageOps.p_copyFromArray(value, voffset, page, 0, remainder);
                            PageOps.p_clear(page, remainder, this.pageSize(page));
                            break;
                        }
                        finally {
                            node.releaseExclusive();
                        }
                    }
                    --pageCount;
                    offset += 6;
                    voffset += pageSize;
                }
            }
            newValue[0] = header;
        }
        if (vlength < 65536L) {
            Utils.encodeShortLE(newValue, 1, (int)vlength);
            return newValue;
        }
        if (vlength < 0x100000000L) {
            Utils.encodeIntLE(newValue, 1, (int)vlength);
            return newValue;
        }
        if (vlength < 0x1000000000000L) {
            Utils.encodeInt48LE(newValue, 1, vlength);
            return newValue;
        }
        Utils.encodeLongLE(newValue, 1, vlength);
        return newValue;
    }

    int calculateInodeLevels(long vlength) {
        int levels;
        long[] caps = this.mFragmentInodeLevelCaps;
        for (levels = 0; levels < caps.length && vlength > caps[levels]; ++levels) {
        }
        return levels;
    }

    static long decodeFullFragmentedValueLength(int header, byte[] fragmented, int off) {
        switch (header >> 2 & 3) {
            default: {
                return PageOps.p_ushortGetLE(fragmented, off);
            }
            case 1: {
                return (long)PageOps.p_intGetLE(fragmented, off) & 0xFFFFFFFFL;
            }
            case 2: {
                return PageOps.p_uint48GetLE(fragmented, off);
            }
            case 3: 
        }
        return PageOps.p_longGetLE(fragmented, off);
    }

    private void writeMultilevelFragments(int level, Node inode, byte[] value, int voffset, long vlength) throws IOException {
        try {
            byte[] page = inode.mPage;
            long levelCap = this.levelCap(--level);
            int childNodeCount = (int)((vlength + (levelCap - 1L)) / levelCap);
            int poffset = 0;
            for (int i = 0; i < childNodeCount; ++i) {
                Node childNode = this.allocDirtyFragmentNode();
                PageOps.p_int48PutLE(page, poffset, childNode.mId);
                int len = (int)Math.min(levelCap, vlength);
                if (level <= 0) {
                    byte[] childPage = childNode.mPage;
                    PageOps.p_copyFromArray(value, voffset, childPage, 0, len);
                    PageOps.p_clear(childPage, len, this.pageSize(childPage));
                    childNode.releaseExclusive();
                } else {
                    this.writeMultilevelFragments(level, childNode, value, voffset, len);
                }
                vlength -= (long)len;
                voffset += len;
                poffset += 6;
            }
            PageOps.p_clear(page, poffset, this.pageSize(page));
        }
        catch (Throwable e) {
            this.close(e);
            throw e;
        }
        finally {
            inode.releaseExclusive();
        }
    }

    byte[] reconstructKey(byte[] fragmented, int off, int len) throws IOException {
        try {
            return this.reconstruct(fragmented, off, len);
        }
        catch (LargeValueException e) {
            throw new LargeKeyException(e.getLength(), e.getCause());
        }
    }

    byte[] reconstruct(byte[] fragmented, int off, int len) throws IOException {
        return this.reconstruct(fragmented, off, len, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] reconstruct(byte[] fragmented, int off, int len, long[] stats) throws IOException {
        byte[] value;
        long vLen;
        byte header = PageOps.p_byteGet(fragmented, off++);
        --len;
        switch (header >> 2 & 3) {
            default: {
                vLen = PageOps.p_ushortGetLE(fragmented, off);
                break;
            }
            case 1: {
                vLen = PageOps.p_intGetLE(fragmented, off);
                if (vLen >= 0L) break;
                vLen &= 0xFFFFFFFFL;
                if (stats != null) break;
                throw new LargeValueException(vLen);
            }
            case 2: {
                vLen = PageOps.p_uint48GetLE(fragmented, off);
                if (vLen <= Integer.MAX_VALUE || stats != null) break;
                throw new LargeValueException(vLen);
            }
            case 3: {
                vLen = PageOps.p_longGetLE(fragmented, off);
                if (vLen >= 0L && (vLen <= Integer.MAX_VALUE || stats != null)) break;
                throw new LargeValueException(vLen);
            }
        }
        int vLenFieldSize = 2 + (header >> 1 & 6);
        off += vLenFieldSize;
        len -= vLenFieldSize;
        if (stats != null) {
            stats[0] = vLen;
            value = null;
        } else {
            try {
                value = new byte[(int)vLen];
            }
            catch (OutOfMemoryError e) {
                throw new LargeValueException(vLen, (Throwable)e);
            }
        }
        int vOff = 0;
        if ((header & 2) != 0) {
            int inLen = PageOps.p_ushortGetLE(fragmented, off);
            off += 2;
            len -= 2;
            if (value != null) {
                PageOps.p_copyToArray(fragmented, off, value, vOff, inLen);
            }
            off += inLen;
            len -= inLen;
            vOff += inLen;
            vLen -= (long)inLen;
        }
        long pagesRead = 0L;
        if ((header & 1) == 0) {
            while (len >= 6) {
                int pLen;
                long nodeId = PageOps.p_uint48GetLE(fragmented, off);
                off += 6;
                len -= 6;
                if (nodeId == 0L) {
                    pLen = Math.min((int)vLen, this.mPageSize);
                } else {
                    Node node = this.nodeMapLoadFragment(nodeId);
                    ++pagesRead;
                    try {
                        byte[] page = node.mPage;
                        pLen = Math.min((int)vLen, this.pageSize(page));
                        if (value != null) {
                            PageOps.p_copyToArray(page, 0, value, vOff, pLen);
                        }
                    }
                    finally {
                        node.releaseShared();
                    }
                }
                vOff += pLen;
                vLen -= (long)pLen;
            }
        } else {
            long inodeId = PageOps.p_uint48GetLE(fragmented, off);
            if (inodeId != 0L) {
                Node inode = this.nodeMapLoadFragment(inodeId);
                ++pagesRead;
                int levels = this.calculateInodeLevels(vLen);
                pagesRead += this.readMultilevelFragments(levels, inode, value, 0, vLen);
            }
        }
        if (stats != null) {
            stats[1] = pagesRead;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readMultilevelFragments(int level, Node inode, byte[] value, int voffset, long vlength) throws IOException {
        try {
            long pagesRead = 0L;
            byte[] page = inode.mPage;
            long levelCap = this.levelCap(--level);
            int childNodeCount = (int)((vlength + (levelCap - 1L)) / levelCap);
            int poffset = 0;
            for (int i = 0; i < childNodeCount; ++i) {
                long childNodeId = PageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap, vlength);
                if (childNodeId != 0L) {
                    Node childNode = this.nodeMapLoadFragment(childNodeId);
                    ++pagesRead;
                    if (level <= 0) {
                        if (value != null) {
                            PageOps.p_copyToArray(childNode.mPage, 0, value, voffset, len);
                        }
                        childNode.releaseShared();
                    } else {
                        pagesRead += this.readMultilevelFragments(level, childNode, value, voffset, len);
                    }
                }
                vlength -= (long)len;
                voffset += len;
                poffset += 6;
            }
            long l = pagesRead;
            return l;
        }
        finally {
            inode.releaseShared();
        }
    }

    void deleteFragments(byte[] fragmented, int off, int len) throws IOException {
        long vLen;
        byte header = PageOps.p_byteGet(fragmented, off++);
        --len;
        if ((header & 1) == 0) {
            vLen = 0L;
        } else {
            switch (header >> 2 & 3) {
                default: {
                    vLen = PageOps.p_ushortGetLE(fragmented, off);
                    break;
                }
                case 1: {
                    vLen = (long)PageOps.p_intGetLE(fragmented, off) & 0xFFFFFFFFL;
                    break;
                }
                case 2: {
                    vLen = PageOps.p_uint48GetLE(fragmented, off);
                    break;
                }
                case 3: {
                    vLen = PageOps.p_longGetLE(fragmented, off);
                }
            }
        }
        int vLenFieldSize = 2 + (header >> 1 & 6);
        off += vLenFieldSize;
        len -= vLenFieldSize;
        if ((header & 2) != 0) {
            int inLen = 2 + PageOps.p_ushortGetLE(fragmented, off);
            off += inLen;
            len -= inLen;
        }
        if ((header & 1) == 0) {
            while (len >= 6) {
                long nodeId = PageOps.p_uint48GetLE(fragmented, off);
                off += 6;
                len -= 6;
                this.deleteFragment(nodeId);
            }
        } else {
            long inodeId = PageOps.p_uint48GetLE(fragmented, off);
            if (inodeId != 0L) {
                Node inode = this.removeInode(inodeId);
                int levels = this.calculateInodeLevels(vLen);
                this.deleteMultilevelFragments(levels, inode, vLen);
            }
        }
    }

    private void deleteMultilevelFragments(int level, Node inode, long vlength) throws IOException {
        byte[] page = inode.mPage;
        long levelCap = this.levelCap(--level);
        int childNodeCount = (int)((vlength + (levelCap - 1L)) / levelCap);
        long[] childNodeIds = new long[childNodeCount];
        int poffset = 0;
        for (int i = 0; i < childNodeCount; ++i) {
            childNodeIds[i] = PageOps.p_uint48GetLE(page, poffset);
            poffset += 6;
        }
        this.deleteNode(inode);
        if (level <= 0) {
            for (long childNodeId : childNodeIds) {
                this.deleteFragment(childNodeId);
            }
        } else {
            for (long childNodeId : childNodeIds) {
                long len = Math.min(levelCap, vlength);
                if (childNodeId != 0L) {
                    Node childNode = this.removeInode(childNodeId);
                    this.deleteMultilevelFragments(level, childNode, len);
                }
                vlength -= len;
            }
        }
    }

    private Node removeInode(long nodeId) throws IOException {
        Node node = this.nodeMapGetAndRemove(nodeId);
        if (node == null) {
            node = this.allocLatchedNode(nodeId, 1);
            node.type((byte)32);
            this.readNode(node, nodeId);
        }
        return node;
    }

    private void deleteFragment(long nodeId) throws IOException {
        if (nodeId != 0L) {
            Node node = this.nodeMapGetAndRemove(nodeId);
            if (node != null) {
                this.deleteNode(node);
            } else if (this.mInitialReadState != 0) {
                this.mPageDb.recyclePage(nodeId);
            } else {
                this.mPageDb.deletePage(nodeId);
            }
        }
    }

    private static long[] calculateInodeLevelCaps(int pageSize) {
        long[] caps = new long[10];
        long cap = pageSize;
        long scalar = pageSize / 6;
        int i = 0;
        while (i < caps.length) {
            caps[i++] = cap;
            long next = cap * scalar;
            if (next / scalar != cap) {
                caps[i++] = Long.MAX_VALUE;
                break;
            }
            cap = next;
        }
        if (i < caps.length) {
            long[] newCaps = new long[i];
            System.arraycopy(caps, 0, newCaps, 0, i);
            caps = newCaps;
        }
        return caps;
    }

    long levelCap(int level) {
        return this.mFragmentInodeLevelCaps[level];
    }

    void emptyAllFragmentedTrash(boolean checkpoint) throws IOException {
        FragmentedTrash trash = this.mFragmentedTrash;
        if (trash != null && trash.emptyAllTrash(this.mEventListener) && checkpoint) {
            this.checkpoint(false, 0L, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FragmentedTrash fragmentedTrash() throws IOException {
        FragmentedTrash trash = this.mFragmentedTrash;
        if (trash != null) {
            return trash;
        }
        this.mOpenTreesLatch.acquireExclusive();
        try {
            trash = this.mFragmentedTrash;
            if (trash != null) {
                FragmentedTrash fragmentedTrash = trash;
                return fragmentedTrash;
            }
            Tree tree = this.openInternalTree(3L, true);
            FragmentedTrash fragmentedTrash = this.mFragmentedTrash = new FragmentedTrash(tree);
            return fragmentedTrash;
        }
        finally {
            this.mOpenTreesLatch.releaseExclusive();
        }
    }

    byte[] removeSparePage() {
        return this.mSparePagePool.remove();
    }

    void addSparePage(byte[] page) {
        this.mSparePagePool.add(page);
    }

    void readNode(Node node, long id) throws IOException {
        this.mPageDb.readPage(id, node.mPage);
        node.mId = id;
        node.mCachedState = this.mInitialReadState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkpoint(boolean force, long sizeThreshold, long delayThresholdNanos) throws IOException {
        this.mCheckpointLock.lock();
        try {
            long nowNanos;
            Node root;
            block39: {
                if (this.mClosed) {
                    return;
                }
                this.cleanupUnreferencedTrees();
                root = this.mRegistry.mRoot;
                nowNanos = System.nanoTime();
                if (!force) {
                    block38: {
                        if (!(delayThresholdNanos == 0L || delayThresholdNanos > 0L && nowNanos - this.mLastCheckpointNanos >= delayThresholdNanos || this.mRedoWriter == null || this.mRedoWriter.shouldCheckpoint(sizeThreshold))) {
                            this.mRedoWriter.flushSync(true);
                            return;
                        }
                        root.acquireShared();
                        try {
                            if (root.mCachedState == 0) break block38;
                            break block39;
                        }
                        finally {
                            root.releaseShared();
                        }
                    }
                    if (this.mRedoWriter != null) {
                        this.mRedoWriter.flushSync(true);
                    }
                    return;
                }
            }
            this.mLastCheckpointNanos = nowNanos;
            if (this.mEventListener != null) {
                this.mEventListener.notify(EventType.CHECKPOINT_BEGIN, "Checkpoint begin", new Object[0]);
            }
            boolean resume = true;
            byte[] header = this.mCommitHeader;
            UndoLog masterUndoLog = this.mCommitMasterUndoLog;
            if (header == PageOps.p_null()) {
                header = PageOps.p_calloc(this.mPageDb.pageSize());
                resume = false;
                if (masterUndoLog != null) {
                    throw new AssertionError();
                }
            }
            RedoWriter redo = this.mRedoWriter;
            try {
                long masterUndoLogId;
                long txnId;
                long redoTxnId;
                long redoPos;
                long redoNum;
                int hoff = this.mPageDb.extraCommitDataOffset();
                PageOps.p_intPutLE(header, hoff + 0, 20130112);
                if (redo != null) {
                    redo.checkpointPrepare();
                }
                while (true) {
                    this.mCommitLock.acquireExclusive();
                    if (root.tryAcquireShared()) break;
                    this.mCommitLock.releaseExclusive();
                }
                this.mCheckpointFlushState = -2;
                if (!resume) {
                    PageOps.p_longPutLE(header, hoff + 4, root.mId);
                }
                if (redo == null) {
                    redoNum = 0L;
                    redoPos = 0L;
                    redoTxnId = 0L;
                } else {
                    redo.checkpointSwitch();
                    redoNum = redo.checkpointNumber();
                    redoPos = redo.checkpointPosition();
                    redoTxnId = redo.checkpointTransactionId();
                }
                PageOps.p_longPutLE(header, hoff + 28, redoNum);
                PageOps.p_longPutLE(header, hoff + 36, redoTxnId);
                PageOps.p_longPutLE(header, hoff + 44, redoPos);
                PageOps.p_longPutLE(header, hoff + 52, this.mRedoWriter == null ? 0L : this.mRedoWriter.encoding());
                Object object = this.mTxnIdLock;
                synchronized (object) {
                    txnId = this.mTxnId;
                    if (resume) {
                        masterUndoLogId = masterUndoLog == null ? 0L : masterUndoLog.topNodeId();
                    } else {
                        int count = this.mUndoLogCount;
                        if (count == 0) {
                            masterUndoLogId = 0L;
                        } else {
                            masterUndoLog = new UndoLog(this, 0L);
                            byte[] workspace = null;
                            UndoLog log = this.mTopUndoLog;
                            while (log != null) {
                                workspace = log.writeToMaster(masterUndoLog, workspace);
                                log = log.mPrev;
                            }
                            masterUndoLogId = masterUndoLog.topNodeId();
                            if (masterUndoLogId == 0L) {
                                masterUndoLog = null;
                            }
                        }
                        this.mCommitMasterUndoLog = masterUndoLog;
                    }
                }
                PageOps.p_longPutLE(header, hoff + 20, txnId);
                PageOps.p_longPutLE(header, hoff + 12, masterUndoLogId);
                this.mPageDb.commit(resume, header, (resume_, header_) -> this.flush(resume_, header_));
            }
            catch (Throwable e) {
                if (this.mCommitHeader != header) {
                    PageOps.p_delete(header);
                }
                if (this.mCheckpointFlushState == -2) {
                    this.mCheckpointFlushState = -1;
                    root.releaseShared();
                    this.mCommitLock.releaseExclusive();
                    if (redo != null) {
                        redo.checkpointAborted();
                    }
                }
                throw e;
            }
            PageOps.p_delete(this.mCommitHeader);
            this.mCommitHeader = PageOps.p_null();
            this.mCommitMasterUndoLog = null;
            if (masterUndoLog != null) {
                masterUndoLog.truncate(false);
            }
            if (this.mRedoWriter != null) {
                this.mRedoWriter.checkpointFinished();
            }
            if (this.mEventListener != null) {
                double duration = (double)(System.nanoTime() - this.mLastCheckpointNanos) / 1.0E9;
                this.mEventListener.notify(EventType.CHECKPOINT_COMPLETE, "Checkpoint completed in %1$1.3f seconds", new Object[]{duration, TimeUnit.SECONDS});
            }
        }
        finally {
            this.mCheckpointLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean resume, byte[] header) throws IOException {
        Object custom = this.mCustomTxnHandler;
        if (custom != null) {
            custom = this.mCustomTxnHandler.checkpointStart(this);
        }
        int stateToFlush = this.mCommitState;
        if (resume) {
            if (header != this.mCommitHeader) {
                throw new AssertionError();
            }
            stateToFlush ^= 1;
        } else {
            if (this.mInitialReadState != 0) {
                this.mInitialReadState = 0;
            }
            this.mCommitState = (byte)(stateToFlush ^ 1);
            this.mCommitHeader = header;
        }
        this.mCheckpointFlushState = stateToFlush;
        this.mRegistry.mRoot.releaseShared();
        this.mCommitLock.releaseExclusive();
        if (this.mRedoWriter != null) {
            this.mRedoWriter.checkpointStarted();
        }
        if (this.mEventListener != null) {
            this.mEventListener.notify(EventType.CHECKPOINT_FLUSH, "Flushing all dirty nodes", new Object[0]);
        }
        try {
            this.mDirtyList.flush(this.mPageDb, stateToFlush);
            if (this.mRedoWriter != null) {
                this.mRedoWriter.checkpointFlushed();
            }
            if (this.mCustomTxnHandler != null) {
                this.mCustomTxnHandler.checkpointFinish(this, custom);
            }
        }
        finally {
            this.mCheckpointFlushState = -1;
        }
    }

    static long readRedoPosition(byte[] header, int offset) {
        return PageOps.p_longGetLE(header, offset + 44);
    }

    @FunctionalInterface
    static interface ScanVisitor {
        public boolean apply(Tree var1) throws IOException;
    }

    private class Deletion
    implements Runnable {
        private Tree mTrashed;
        private final boolean mResumed;
        private final EventListener mListener;

        Deletion(Tree trashed, boolean resumed, EventListener listener) {
            this.mTrashed = trashed;
            this.mResumed = resumed;
            this.mListener = listener;
        }

        @Override
        public synchronized void run() {
            while (this.mTrashed != null) {
                this.delete();
            }
        }

        private void delete() {
            if (this.mListener != null) {
                this.mListener.notify(EventType.DELETION_BEGIN, "Index deletion " + (this.mResumed ? "resumed" : "begin") + ": %1$d, name: %2$s", this.mTrashed.getId(), this.mTrashed.getNameString());
            }
            byte[] idBytes = this.mTrashed.mIdBytes;
            try {
                long start = System.nanoTime();
                this.mTrashed.deleteAll();
                Node root = this.mTrashed.close(true, false);
                LocalDatabase.this.removeFromTrash(this.mTrashed, root);
                if (this.mListener != null) {
                    double duration = (double)(System.nanoTime() - start) / 1.0E9;
                    this.mListener.notify(EventType.DELETION_COMPLETE, "Index deletion complete: %1$d, name: %2$s, duration: %3$1.3f seconds", this.mTrashed.getId(), this.mTrashed.getNameString(), duration);
                }
                this.mTrashed = null;
            }
            catch (IOException e) {
                if (!(LocalDatabase.this.mClosed && LocalDatabase.this.mClosedCause == null || this.mListener == null)) {
                    this.mListener.notify(EventType.DELETION_FAILED, "Index deletion failed: %1$d, name: %2$s, exception: %3$s", this.mTrashed.getId(), this.mTrashed.getNameString(), Utils.rootCause(e));
                }
                Utils.closeQuietly(null, this.mTrashed);
                return;
            }
            if (this.mResumed) {
                try {
                    this.mTrashed = LocalDatabase.this.openNextTrashedTree(idBytes);
                }
                catch (IOException e) {
                    if (!(LocalDatabase.this.mClosed && LocalDatabase.this.mClosedCause == null || this.mListener == null)) {
                        this.mListener.notify(EventType.DELETION_FAILED, "Unable to resume deletion: %1$s", Utils.rootCause(e));
                    }
                    return;
                }
            }
        }
    }

    static class ShutdownPrimer
    implements ShutdownHook {
        private final WeakReference<LocalDatabase> mDatabaseRef;

        ShutdownPrimer(LocalDatabase db) {
            this.mDatabaseRef = new WeakReference<LocalDatabase>(db);
        }

        @Override
        public void shutdown() {
            LocalDatabase db = (LocalDatabase)this.mDatabaseRef.get();
            if (db == null) {
                return;
            }
            File primer = db.primerFile();
            try {
                FileOutputStream fout = new FileOutputStream(primer);
                try (BufferedOutputStream bout = new BufferedOutputStream(fout);){
                    db.createCachePrimer(bout);
                }
                catch (IOException e) {
                    fout.close();
                    primer.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

