/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import org.cojen.tupl.Filter;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Utils;
import org.cojen.tupl.VerificationObserver;
import org.cojen.tupl.View;

public interface Index
extends View,
Closeable {
    public long getId();

    public byte[] getName();

    public String getNameString();

    public long evict(Transaction var1, byte[] var2, byte[] var3, Filter var4, boolean var5) throws IOException;

    public Stats analyze(byte[] var1, byte[] var2) throws IOException;

    public boolean verify(VerificationObserver var1) throws IOException;

    @Override
    public void close() throws IOException;

    public boolean isClosed();

    public void drop() throws IOException;

    public static class Stats
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = 3L;
        public double entryCount;
        public double keyBytes;
        public double valueBytes;
        public double freeBytes;
        public double totalBytes;

        public Stats(double entryCount, double keyBytes, double valueBytes, double freeBytes, double totalBytes) {
            this.entryCount = entryCount;
            this.keyBytes = keyBytes;
            this.valueBytes = valueBytes;
            this.freeBytes = freeBytes;
            this.totalBytes = totalBytes;
        }

        public double entryCount() {
            return this.entryCount;
        }

        public double keyBytes() {
            return this.keyBytes;
        }

        public double valueBytes() {
            return this.valueBytes;
        }

        public double freeBytes() {
            return this.freeBytes;
        }

        public double totalBytes() {
            return this.totalBytes;
        }

        public Stats add(Stats augend) {
            return new Stats(this.entryCount + augend.entryCount, this.keyBytes + augend.keyBytes, this.valueBytes + augend.valueBytes, this.freeBytes + augend.freeBytes, this.totalBytes + augend.totalBytes);
        }

        public Stats subtract(Stats subtrahend) {
            return new Stats(this.entryCount - subtrahend.entryCount, this.keyBytes - subtrahend.keyBytes, this.valueBytes - subtrahend.valueBytes, this.freeBytes - subtrahend.freeBytes, this.totalBytes - subtrahend.totalBytes);
        }

        public Stats divide(double scalar) {
            return new Stats(this.entryCount / scalar, this.keyBytes / scalar, this.valueBytes / scalar, this.freeBytes / scalar, this.totalBytes / scalar);
        }

        public Stats round() {
            return new Stats(Math.round(this.entryCount), Math.round(this.keyBytes), Math.round(this.valueBytes), Math.round(this.freeBytes), Math.round(this.totalBytes));
        }

        public Stats divideAndRound(double scalar) {
            return new Stats(Math.round(this.entryCount / scalar), Math.round(this.keyBytes / scalar), Math.round(this.valueBytes / scalar), Math.round(this.freeBytes / scalar), Math.round(this.totalBytes / scalar));
        }

        public Stats clone() {
            try {
                return (Stats)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw Utils.rethrow(e);
            }
        }

        public int hashCode() {
            long hash = Double.doubleToLongBits(this.entryCount);
            hash = hash * 31L + Double.doubleToLongBits(this.keyBytes);
            hash = hash * 31L + Double.doubleToLongBits(this.valueBytes);
            hash = hash * 31L + Double.doubleToLongBits(this.freeBytes);
            hash = hash * 31L + Double.doubleToLongBits(this.totalBytes);
            return (int)Utils.scramble(hash);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj.getClass() == Stats.class) {
                Stats other = (Stats)obj;
                return this.entryCount == other.entryCount && this.keyBytes == other.keyBytes && this.valueBytes == other.valueBytes && this.freeBytes == other.freeBytes && this.totalBytes == other.totalBytes;
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Index.Stats {");
            boolean any = false;
            any = Stats.append(b, any, "entryCount", this.entryCount);
            any = Stats.append(b, any, "keyBytes", this.keyBytes);
            any = Stats.append(b, any, "valueBytes", this.valueBytes);
            any = Stats.append(b, any, "freeBytes", this.freeBytes);
            any = Stats.append(b, any, "totalBytes", this.totalBytes);
            b.append('}');
            return b.toString();
        }

        private static boolean append(StringBuilder b, boolean any, String name, double value) {
            if (!Double.isNaN(value)) {
                if (any) {
                    b.append(", ");
                }
                b.append(name).append('=');
                long v = (long)value;
                if ((double)v == value) {
                    b.append(v);
                } else {
                    b.append(value);
                }
                any = true;
            }
            return any;
        }
    }
}

